/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server.packageimport;

import java.io.File;
import java.util.Vector;
import java.util.logging.Logger;
import org.adl.samplerte.server.packageimport.ManifestHandler;
import org.adl.samplerte.server.packageimport.ManifestMap;
import org.adl.samplerte.server.packageimport.parsers.dom.DOMTreeUtility;
import org.adl.samplerte.util.UnZipHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LMSImportHandler {
    private Document mDocument;
    private ManifestHandler mManifestHandler;
    private Logger mLogger;

    public LMSImportHandler() {
        this.mManifestHandler = new ManifestHandler();
    }

    public LMSImportHandler(Document iDoc) {
        this.mLogger = Logger.getLogger("org.adl.util.debug.samplerte");
        this.mLogger.entering("LMSImportHandler", "LMSImportHandler()");
        this.mDocument = iDoc;
        this.mManifestHandler = new ManifestHandler();
        this.mLogger.exiting("LMSImportHandler", "LMSImportHandler()");
    }

    public Document getDocument() {
        return this.mDocument;
    }

    public Node getRootNode() {
        return this.mDocument.getDocumentElement();
    }

    public String getXMLBaseValue(Node iNode) {
        Attr baseAttr;
        this.mLogger.entering("LMSImportHandler", "getXMLBaseValue()");
        String result = new String();
        if (iNode != null && (baseAttr = DOMTreeUtility.getAttribute(iNode, "base")) != null) {
            result = baseAttr.getValue();
            DOMTreeUtility.removeAttribute(iNode, "xml:base");
        }
        this.mLogger.exiting("LMSImportHandler", "getXMLBaseValue()");
        return result;
    }

    public void applyXMLBase(Node iManifestNode) {
        this.mLogger.entering("LMSImportHandler", "applyXMLBase()");
        String x = new String();
        String y = new String();
        String currentNodeName = new String();
        String currentHrefValue = new String();
        Attr currentHrefAttr = null;
        String fileNodeName = new String();
        String fileHrefValue = new String();
        x = this.getXMLBaseValue(iManifestNode);
        Node resourcesNode = DOMTreeUtility.getNode(iManifestNode, "resources");
        String resourcesBase = this.getXMLBaseValue(resourcesNode);
        if (!(x.equals("") || resourcesBase.equals("") || x.endsWith("/"))) {
            x = x + "/";
        }
        x = x + resourcesBase;
        NodeList resourceList = resourcesNode.getChildNodes();
        if (resourceList != null) {
            String resourceBase = new String();
            for (int i = 0; i < resourceList.getLength(); ++i) {
                NodeList fileList;
                Node currentNode = resourceList.item(i);
                currentNodeName = currentNode.getLocalName();
                if (!currentNodeName.equals("resource")) continue;
                resourceBase = this.getXMLBaseValue(currentNode);
                y = !x.equals("") && !resourceBase.equals("") && !x.endsWith("/") ? x + "/" + resourceBase : x + resourceBase;
                currentHrefAttr = DOMTreeUtility.getAttribute(currentNode, "href");
                if (currentHrefAttr != null) {
                    currentHrefValue = currentHrefAttr.getValue();
                    if (!(y.equals("") || currentHrefValue.equals("") || y.endsWith("/"))) {
                        currentHrefAttr.setValue(y + "/" + currentHrefValue);
                    } else {
                        currentHrefAttr.setValue(y + currentHrefValue);
                    }
                }
                if ((fileList = currentNode.getChildNodes()) == null) continue;
                for (int j = 0; j < fileList.getLength(); ++j) {
                    Node currentFileNode = fileList.item(j);
                    fileNodeName = currentFileNode.getLocalName();
                    if (!fileNodeName.equals("file")) continue;
                    Attr fileHrefAttr = DOMTreeUtility.getAttribute(currentFileNode, "href");
                    fileHrefValue = fileHrefAttr.getValue();
                    if (!(y.equals("") || fileHrefValue.equals("") || y.endsWith("/"))) {
                        fileHrefAttr.setValue(y + "/" + fileHrefValue);
                        continue;
                    }
                    fileHrefAttr.setValue(y + fileHrefValue);
                }
            }
        }
        this.mLogger.exiting("LMSImportHandler", "applyXMLBase()");
    }

    public Vector getItems(Node iItem) {
        this.mLogger.entering("LMSImportHandler", "getItems()");
        Vector result = new Vector();
        Vector itemList = new Vector();
        Node currentItem = null;
        if (iItem != null) {
            itemList = DOMTreeUtility.getNodes(iItem, "item");
        }
        result.addAll(itemList);
        for (int itemCount = 0; itemCount < itemList.size(); ++itemCount) {
            currentItem = (Node)itemList.elementAt(itemCount);
            result.addAll(this.getItems(currentItem));
        }
        this.mLogger.exiting("LMSImportHandler", "getItems()");
        return result;
    }

    public Vector getItemsInManifest(Node iManifest) {
        this.mLogger.entering("LMSImportHandler", "getItemsInManifest()");
        Node organizationsNode = null;
        Vector organizationList = new Vector();
        Vector itemList = new Vector();
        Vector<Node> resultList = new Vector<Node>();
        Node currentOrg = null;
        Node currentItem = null;
        organizationsNode = DOMTreeUtility.getNode(iManifest, "organizations");
        if (organizationsNode != null) {
            organizationList = DOMTreeUtility.getNodes(organizationsNode, "organization");
        }
        for (int orgCount = 0; orgCount < organizationList.size(); ++orgCount) {
            currentOrg = (Node)organizationList.elementAt(orgCount);
            itemList = DOMTreeUtility.getNodes(currentOrg, "item");
            for (int itemCount = 0; itemCount < itemList.size(); ++itemCount) {
                currentItem = (Node)itemList.elementAt(itemCount);
                resultList.addElement(currentItem);
                resultList.addAll(this.getItems(currentItem));
            }
        }
        this.mLogger.exiting("LMSImportHandler", "getItemsInManifest()");
        return resultList;
    }

    public Node getItemWithID(String iItemID) {
        this.mLogger.entering("LMSImportHandler", "getItemsWithID()");
        Element manifestNode = this.mDocument.getDocumentElement();
        Vector manifestList = this.getAllManifests(manifestNode);
        Node currentItem = null;
        Node currentManifest = null;
        Node theNode = null;
        String currentItemID = new String();
        Vector itemList = new Vector();
        boolean isFound = false;
        itemList = this.getItemsInManifest(manifestNode);
        for (int itemCount = 0; itemCount < itemList.size(); ++itemCount) {
            currentItem = (Node)itemList.elementAt(itemCount);
            if (currentItem == null || !(currentItemID = DOMTreeUtility.getAttributeValue(currentItem, "identifier")).equalsIgnoreCase(iItemID)) continue;
            theNode = currentItem;
            isFound = true;
        }
        if (!isFound) {
            block1: for (int manCount = 0; manCount < manifestList.size(); ++manCount) {
                currentManifest = (Node)manifestList.elementAt(manCount);
                if (currentManifest == null) continue;
                itemList = this.getItemsInManifest(currentManifest);
                for (int count = 0; count < itemList.size(); ++count) {
                    currentItem = (Node)itemList.elementAt(count);
                    if (currentItem == null || !(currentItemID = DOMTreeUtility.getAttributeValue(currentItem, "identifier")).equalsIgnoreCase(iItemID)) continue;
                    theNode = currentItem;
                    isFound = true;
                    continue block1;
                }
            }
        }
        this.mLogger.exiting("LMSImportHandler", "getItemWithID()");
        return theNode;
    }

    public Vector getAllResources(Node iManifest) {
        this.mLogger.entering("LMSImportHandler", "getAllResources()");
        Vector resourceList = new Vector();
        Vector manifestList = new Vector();
        Node resourcesNode = DOMTreeUtility.getNode(iManifest, "resources");
        resourceList = DOMTreeUtility.getNodes(resourcesNode, "resource");
        manifestList = DOMTreeUtility.getNodes(iManifest, "manifest");
        Node currentManifest = null;
        for (int i = 0; i < manifestList.size(); ++i) {
            currentManifest = (Node)manifestList.elementAt(i);
            resourceList.addAll(this.getAllResources(currentManifest));
        }
        this.mLogger.exiting("LMSImportHandler", "getAllResources()");
        return resourceList;
    }

    public Vector getAllManifests(Node iManifest) {
        this.mLogger.entering("LMSImportHandler", "getAllManifests()");
        Vector resultList = new Vector();
        Vector manifestList = new Vector();
        Node currentManifest = null;
        if (iManifest != null) {
            manifestList = DOMTreeUtility.getNodes(iManifest, "manifest");
            resultList = new Vector(manifestList);
        }
        for (int manifestCount = 0; manifestCount < manifestList.size(); ++manifestCount) {
            currentManifest = (Node)manifestList.elementAt(manifestCount);
            resultList.addAll(this.getAllManifests(currentManifest));
        }
        this.mLogger.exiting("LMSImportHandler", "getAllManifests()");
        return resultList;
    }

    public Node getNodeWithID(Node iManifest, String iID) {
        this.mLogger.entering("LMSImportHandler", "getNodeWithID()");
        boolean isFound = false;
        Node theNode = null;
        Node currentManifest = null;
        Node currentResource = null;
        Vector allManifests = this.getAllManifests(iManifest);
        int j = 0;
        String manifestID = new String();
        String resourceID = new String();
        for (int i = 0; i < allManifests.size() && !isFound; ++i) {
            currentManifest = (Node)allManifests.elementAt(i);
            manifestID = DOMTreeUtility.getAttributeValue(currentManifest, "identifier");
            if (!manifestID.equalsIgnoreCase(iID)) continue;
            isFound = true;
            theNode = (Node)allManifests.elementAt(i);
            break;
        }
        if (!isFound) {
            Vector allResources = this.getAllResources(iManifest);
            while (j < allResources.size() && !isFound) {
                currentResource = (Node)allResources.elementAt(j);
                resourceID = DOMTreeUtility.getAttributeValue(currentResource, "identifier");
                if (resourceID.equalsIgnoreCase(iID)) {
                    isFound = true;
                    theNode = (Node)allResources.elementAt(j);
                    break;
                }
                ++j;
            }
        }
        this.mLogger.exiting("LMSImportHandler", "getNodeWithID()");
        return theNode;
    }

    public void processManifestMap(ManifestMap iManifestMap, Node iManifestNode) {
        this.mLogger.entering("LMSImportHandler", "processManifestMap()");
        boolean isInResources = false;
        Node theNode = null;
        String theNodeName = new String();
        Vector resourceIDs = iManifestMap.getResourceIds();
        Vector itemIDs = iManifestMap.getItemIds();
        Vector itemIdrefs = iManifestMap.getItemIdrefs();
        String itemIdref = new String();
        String resourceID = new String();
        Node organizationsNode = null;
        Vector organizationNodes = new Vector();
        int organizationIndex = 0;
        String defaultOrgID = new String();
        String tempOrgID = new String();
        Node tempOrgNode = null;
        Node organizationNode = null;
        String organizationID = new String();
        NodeList orgChildren = null;
        String identifierToReplace = new String();
        Node oldItem = null;
        Node currentOldChild = null;
        Node currentChild = null;
        Attr identifierAttr = null;
        for (int idRefCount = 0; idRefCount < itemIdrefs.size(); ++idRefCount) {
            itemIdref = (String)itemIdrefs.elementAt(idRefCount);
            if (itemIdref.equals("")) continue;
            theNode = null;
            isInResources = false;
            for (int resourceIDCount = 0; resourceIDCount < resourceIDs.size(); ++resourceIDCount) {
                resourceID = (String)resourceIDs.elementAt(resourceIDCount);
                if (!itemIdref.equals(resourceID)) continue;
                isInResources = true;
                break;
            }
            if (isInResources || (theNode = this.getNodeWithID(iManifestNode, itemIdref)) == null || !(theNodeName = theNode.getLocalName()).equals("manifest")) continue;
            organizationsNode = null;
            organizationsNode = DOMTreeUtility.getNode(theNode, "organizations");
            organizationNodes = DOMTreeUtility.getNodes(organizationsNode, "organization");
            organizationIndex = 0;
            defaultOrgID = DOMTreeUtility.getAttributeValue(organizationsNode, "default");
            for (int orgCount = 0; orgCount < organizationNodes.size(); ++orgCount) {
                tempOrgNode = (Node)organizationNodes.elementAt(orgCount);
                tempOrgID = DOMTreeUtility.getAttributeValue(tempOrgNode, "identifier");
                if (!tempOrgID.equals(defaultOrgID)) continue;
                organizationIndex = orgCount;
                break;
            }
            organizationNode = (Node)organizationNodes.elementAt(organizationIndex);
            organizationID = DOMTreeUtility.getAttributeValue(organizationNode, "identifier");
            orgChildren = organizationNode.getChildNodes();
            identifierToReplace = (String)itemIDs.elementAt(idRefCount);
            oldItem = this.getItemWithID(identifierToReplace);
            NodeList oldItemChildren = oldItem.getChildNodes();
            for (int oldChildCount = 0; oldChildCount < oldItemChildren.getLength(); ++oldChildCount) {
                currentOldChild = oldItemChildren.item(oldChildCount);
                oldItem.removeChild(currentOldChild);
            }
            int childCount = 0;
            while (childCount < orgChildren.getLength()) {
                currentChild = orgChildren.item(childCount);
                try {
                    oldItem.appendChild(currentChild);
                }
                catch (DOMException domExcep) {
                    domExcep.printStackTrace();
                }
            }
            oldItemChildren = oldItem.getChildNodes();
            identifierAttr = DOMTreeUtility.getAttribute(oldItem, "identifier");
            identifierAttr.setValue(organizationID);
            DOMTreeUtility.removeAttribute(oldItem, "identifierref");
        }
        this.mLogger.exiting("LMSImportHandler", "processManifestMap()");
    }

    public void applyXMLBase() {
        this.mLogger.entering("LMSImportHandler", "applyXMLBase()");
        Element manifest = this.mDocument.getDocumentElement();
        ManifestMap manifestMap = new ManifestMap();
        manifestMap.populateManifestMap(manifest);
        this.applyXMLBase(manifest);
        this.mLogger.exiting("LMSImportHandler", "applyXMLBase()");
    }

    public Vector getLaunchData(Document iRolledUpDocument, boolean iDefaultOrganizationOnly, boolean iRemoveAssets) {
        return this.mManifestHandler.getLaunchData(iRolledUpDocument.getDocumentElement(), iDefaultOrganizationOnly, iRemoveAssets);
    }

    public static void cleanImportDirectory(String iPath) {
        try {
            File theFile = new File(iPath);
            if (theFile.exists()) {
                File[] allFiles = theFile.listFiles();
                for (int i = 0; i < allFiles.length; ++i) {
                    if (allFiles[i].isDirectory()) {
                        LMSImportHandler.cleanImportDirectory(allFiles[i].toString());
                        allFiles[i].delete();
                        continue;
                    }
                    allFiles[i].delete();
                }
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public static String importContentPackage(String iEnVar, String iPIF) {
        String extractDir = "";
        try {
            extractDir = iEnVar + File.separator + "PackageImport" + File.separator;
            UnZipHandler uzh = new UnZipHandler(iPIF, extractDir);
            boolean mZipExtractionResult = uzh.extract();
            if (!mZipExtractionResult) {
                extractDir = "";
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        return extractDir;
    }
}

