/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server.packageimport;

import java.util.Vector;
import java.util.logging.Logger;
import org.adl.samplerte.server.packageimport.LaunchData;
import org.adl.samplerte.server.packageimport.parsers.dom.DOMTreeUtility;
import org.adl.util.decode.decodeHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestHandler {
    private Logger mLogger = Logger.getLogger("org.adl.util.debug.samplerte");
    private boolean mLaunchDataTracked = false;
    private Vector mLaunchDataList = new Vector();
    private String mEMPTY_STRING = "";

    public Vector getLaunchData(Node iRootNode, boolean iDefaultOrganizationOnly, boolean iRemoveAssets) {
        this.mLogger.entering("ManifestHandler", "getLaunchData(iRootNode)");
        if (!this.mLaunchDataTracked) {
            this.setLaunchData(iRootNode, iDefaultOrganizationOnly, iRemoveAssets);
        }
        this.mLogger.exiting("ManifestHandler", "getLaunchData");
        return this.mLaunchDataList;
    }

    private void setLaunchData(Node iRootNode, boolean iDefaultOrganizationOnly, boolean iRemoveAssets) {
        Node resources;
        this.mLogger.entering("ManifestHandler", "SetLaunchData(iRootNode)");
        Vector organizationNodes = ManifestHandler.getOrganizationNodes(iRootNode, iDefaultOrganizationOnly);
        int size = organizationNodes.size();
        for (int i = 0; i < size; ++i) {
            Node currentOrganization = (Node)organizationNodes.elementAt(i);
            String orgIdentifier = DOMTreeUtility.getAttributeValue(currentOrganization, "identifier");
            this.addItemInfo(currentOrganization, orgIdentifier);
        }
        Node xmlBaseNode = null;
        String manifestXMLBase = this.mEMPTY_STRING;
        String resourcesXMLBase = this.mEMPTY_STRING;
        NamedNodeMap attributes = iRootNode.getAttributes();
        xmlBaseNode = attributes.getNamedItem("xml:base");
        if (xmlBaseNode != null) {
            manifestXMLBase = xmlBaseNode.getNodeValue();
        }
        if ((xmlBaseNode = (attributes = (resources = DOMTreeUtility.getNode(iRootNode, "resources")).getAttributes()).getNamedItem("xml:base")) != null) {
            resourcesXMLBase = xmlBaseNode.getNodeValue();
        }
        size = this.mLaunchDataList.size();
        LaunchData currentLaunchData = null;
        for (int j = 0; j < size; ++j) {
            currentLaunchData = (LaunchData)this.mLaunchDataList.elementAt(j);
            currentLaunchData.setManifestXMLBase(manifestXMLBase);
            currentLaunchData.setResourcesXMLBase(resourcesXMLBase);
            this.mLaunchDataList.removeElementAt(j);
            this.mLaunchDataList.insertElementAt(currentLaunchData, j);
        }
        this.addResourceInfo(iRootNode, iRemoveAssets);
        this.removeDuplicateLaunchData();
        this.mLaunchDataTracked = true;
        this.mLogger.exiting("ManifestHandler", "SetLaunchData(iRootNode)");
    }

    private void removeDuplicateLaunchData() {
        this.mLogger.entering("ManifestHandler", "removeDuplicateLauchData()");
        int size = this.mLaunchDataList.size();
        for (int i = 0; i < size; ++i) {
            LaunchData ldA = (LaunchData)this.mLaunchDataList.elementAt(i);
            String ldAid = ldA.getResourceIdentifier();
            for (int j = i + 1; j < size; ++j) {
                LaunchData ldB = (LaunchData)this.mLaunchDataList.elementAt(j);
                String ldBid = ldB.getResourceIdentifier();
                if (!ldBid.equals(ldAid)) continue;
                String ldAll = ldA.getItemIdentifier();
                String ldBll = ldB.getItemIdentifier();
                if (!ldBll.equals(ldAll)) continue;
                this.mLaunchDataList.removeElementAt(j);
                --j;
                size = this.mLaunchDataList.size();
            }
        }
        this.mLogger.exiting("ManifestHandler", "removeDuplicateLauchData()");
    }

    public static Vector getOrganizationNodes(Node iRootNode, boolean iDefaultOrganizationOnly) {
        Vector<Node> result = new Vector<Node>();
        if (iDefaultOrganizationOnly) {
            result.add(ManifestHandler.getDefaultOrganizationNode(iRootNode));
        } else {
            Node organizationsNode = DOMTreeUtility.getNode(iRootNode, "organizations");
            NodeList children = organizationsNode.getChildNodes();
            if (children != null) {
                int numChildren = children.getLength();
                for (int i = 0; i < numChildren; ++i) {
                    Node currentChild = children.item(i);
                    String currentChildName = currentChild.getLocalName();
                    if (!currentChildName.equals("organization")) continue;
                    result.add(currentChild);
                }
            }
        }
        return result;
    }

    public static Node getDefaultOrganizationNode(Node iRootNode) {
        Node result = null;
        Node organizationsNode = DOMTreeUtility.getNode(iRootNode, "organizations");
        NamedNodeMap attrList = organizationsNode.getAttributes();
        String defaultIDValue = decodeHandler.processWhitespace(attrList.getNamedItem("default").getNodeValue());
        NodeList children = organizationsNode.getChildNodes();
        if (children != null) {
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                NamedNodeMap orgAttrList;
                String idValue;
                Node currentChild = children.item(i);
                String currentChildName = currentChild.getLocalName();
                if (!currentChildName.equals("organization") || !(idValue = decodeHandler.processWhitespace((orgAttrList = currentChild.getAttributes()).getNamedItem("identifier").getNodeValue())).equals(defaultIDValue)) continue;
                result = currentChild;
                break;
            }
        }
        return result;
    }

    private String getMinNormalizedMeasure(Node iNode) {
        String satisfiedByMeasureValue;
        Node primaryObjectiveNode;
        Node objectivesNode;
        Node sequencingNode;
        this.mLogger.entering("ManifestHandler", "getMinNormalizedMeasure");
        String minNormalizedMeasure = this.mEMPTY_STRING;
        String nodeName = iNode.getLocalName();
        if (nodeName.equals("item") && (sequencingNode = DOMTreeUtility.getNode(iNode, "sequencing")) != null && (objectivesNode = DOMTreeUtility.getNode(sequencingNode, "objectives")) != null && (primaryObjectiveNode = DOMTreeUtility.getNode(objectivesNode, "primaryObjective")) != null && (satisfiedByMeasureValue = DOMTreeUtility.getAttributeValue(primaryObjectiveNode, "satisfiedByMeasure")).equals("true")) {
            Node minNormalizedMeasureNode = DOMTreeUtility.getNode(primaryObjectiveNode, "minNormalizedMeasure");
            if (minNormalizedMeasureNode != null) {
                minNormalizedMeasure = DOMTreeUtility.getNodeValue(minNormalizedMeasureNode);
                if (minNormalizedMeasure.trim().equals(this.mEMPTY_STRING)) {
                    minNormalizedMeasure = "1.0";
                }
            } else {
                minNormalizedMeasure = "1.0";
            }
        }
        this.mLogger.exiting("ManifestHandler", "getMinNormalizedMeasure");
        return minNormalizedMeasure;
    }

    private String getAttemptAbsoluteDurationLimit(Node iNode) {
        Node limitConditionsNode;
        Node sequencingNode;
        this.mLogger.entering("ManifestHandler", "getAttempteAbsoluteDurationLimit()");
        String attemptAbsoluteDurationLimit = this.mEMPTY_STRING;
        String nodeName = iNode.getLocalName();
        if (nodeName.equals("item") && (sequencingNode = DOMTreeUtility.getNode(iNode, "sequencing")) != null && (limitConditionsNode = DOMTreeUtility.getNode(sequencingNode, "limitConditions")) != null) {
            attemptAbsoluteDurationLimit = DOMTreeUtility.getAttributeValue(limitConditionsNode, "attemptAbsoluteDurationLimit");
        }
        this.mLogger.exiting("ManifestHandler", "getAttempteAbsoluteDurationLimit()");
        return attemptAbsoluteDurationLimit;
    }

    private void addItemInfo(Node iNode, String iOrgID) {
        this.mLogger.entering("ManifestHandler", "addItemInfo()");
        if (iNode == null) {
            return;
        }
        short type = iNode.getNodeType();
        String orgID = iOrgID;
        switch (type) {
            case 9: {
                Element rootNode = ((Document)iNode).getDocumentElement();
                this.addItemInfo(rootNode, orgID);
                break;
            }
            case 1: {
                NodeList children;
                String nodeName = iNode.getLocalName();
                if (nodeName.equals("item")) {
                    NodeList children2;
                    Node navInterfaceNode;
                    String orgIdentifier = this.mEMPTY_STRING;
                    String identifier = this.mEMPTY_STRING;
                    String identifierref = this.mEMPTY_STRING;
                    String parameters = this.mEMPTY_STRING;
                    String title = this.mEMPTY_STRING;
                    String dataFromLMS = this.mEMPTY_STRING;
                    String timeLimitAction = this.mEMPTY_STRING;
                    String completionThreshold = this.mEMPTY_STRING;
                    String objectiveslist = this.mEMPTY_STRING;
                    boolean previous = false;
                    boolean shouldContinue = false;
                    boolean exit = false;
                    boolean exitAll = false;
                    boolean abandon = false;
                    boolean suspendAll = false;
                    orgIdentifier = iOrgID;
                    NamedNodeMap attrList = iNode.getAttributes();
                    int numAttr = attrList.getLength();
                    for (int i = 0; i < numAttr; ++i) {
                        Attr currentAttrNode = (Attr)attrList.item(i);
                        String currentNodeName = currentAttrNode.getLocalName();
                        if (currentNodeName.equalsIgnoreCase("identifier")) {
                            identifier = decodeHandler.processWhitespace(currentAttrNode.getValue());
                            continue;
                        }
                        if (currentNodeName.equalsIgnoreCase("identifierref")) {
                            identifierref = currentAttrNode.getValue();
                            continue;
                        }
                        if (!currentNodeName.equalsIgnoreCase("parameters")) continue;
                        parameters = currentAttrNode.getValue();
                    }
                    title = DOMTreeUtility.getNodeValue(DOMTreeUtility.getNode(iNode, "title"));
                    dataFromLMS = DOMTreeUtility.getNodeValue(DOMTreeUtility.getNode(iNode, "dataFromLMS"));
                    timeLimitAction = DOMTreeUtility.getNodeValue(DOMTreeUtility.getNode(iNode, "timeLimitAction"));
                    completionThreshold = this.getCompletionThreshold(DOMTreeUtility.getNode(iNode, "completionThreshold"));
                    objectiveslist = this.getObjectivesList(DOMTreeUtility.getNode(iNode, "sequencing"));
                    Node presentationNode = DOMTreeUtility.getNode(iNode, "presentation");
                    if (presentationNode != null && (navInterfaceNode = DOMTreeUtility.getNode(presentationNode, "navigationInterface")) != null && (children2 = navInterfaceNode.getChildNodes()) != null) {
                        int numChildren = children2.getLength();
                        for (int i = 0; i < numChildren; ++i) {
                            Node currentChild = children2.item(i);
                            String currentChildName = currentChild.getLocalName();
                            if (!currentChildName.equals("hideLMSUI")) continue;
                            String currentChildValue = DOMTreeUtility.getNodeValue(currentChild);
                            if (currentChildValue.equals("previous")) {
                                previous = true;
                                continue;
                            }
                            if (currentChildValue.equals("continue")) {
                                shouldContinue = true;
                                continue;
                            }
                            if (currentChildValue.equals("exit")) {
                                exit = true;
                                continue;
                            }
                            if (currentChildValue.equals("exitAll")) {
                                exitAll = true;
                                continue;
                            }
                            if (currentChildValue.equals("abandon")) {
                                abandon = true;
                                continue;
                            }
                            if (!currentChildValue.equals("suspendAll")) continue;
                            suspendAll = true;
                        }
                    }
                    if (!identifierref.equals(this.mEMPTY_STRING)) {
                        LaunchData launchData = new LaunchData();
                        launchData.setOrganizationIdentifier(orgIdentifier);
                        launchData.setItemIdentifier(identifier);
                        launchData.setResourceIdentifier(identifierref);
                        launchData.setParameters(parameters);
                        launchData.setItemTitle(title);
                        launchData.setDataFromLMS(dataFromLMS);
                        launchData.setTimeLimitAction(timeLimitAction);
                        launchData.setCompletionThreshold(completionThreshold);
                        launchData.setPrevious(previous);
                        launchData.setContinue(shouldContinue);
                        launchData.setExit(exit);
                        launchData.setExitAll(exitAll);
                        launchData.setAbandon(abandon);
                        launchData.setSuspendAll(suspendAll);
                        launchData.setMinNormalizedMeasure(this.getMinNormalizedMeasure(iNode));
                        launchData.setAttemptAbsoluteDurationLimit(this.getAttemptAbsoluteDurationLimit(iNode));
                        launchData.setObjectivesList(objectiveslist);
                        this.mLaunchDataList.add(launchData);
                    }
                }
                if ((children = iNode.getChildNodes()) == null) break;
                int numChildren = children.getLength();
                for (int z = 0; z < numChildren; ++z) {
                    Node currentChild = children.item(z);
                    this.addItemInfo(currentChild, orgID);
                }
                break;
            }
        }
        this.mLogger.exiting("ManifestHandler", "addItemInfo()");
    }

    private String getObjectivesList(Node iNode) {
        Node objNode;
        this.mLogger.entering("ManifestHandler", "getObjectivesList");
        NamedNodeMap attributesList = null;
        String result = this.mEMPTY_STRING;
        if (iNode != null && (objNode = DOMTreeUtility.getNode(iNode, "objectives")) != null) {
            int j;
            Node primaryObjNode = DOMTreeUtility.getNode(objNode, "primaryObjective");
            if (primaryObjNode != null) {
                attributesList = primaryObjNode.getAttributes();
                for (j = 0; j < attributesList.getLength(); ++j) {
                    if (!attributesList.item(j).getLocalName().equalsIgnoreCase("objectiveID")) continue;
                    result = decodeHandler.processWhitespace(attributesList.item(j).getNodeValue());
                }
            }
            Vector objNodes = DOMTreeUtility.getNodes(objNode, "objective");
            for (j = 0; j < objNodes.size(); ++j) {
                Node currNode = (Node)objNodes.elementAt(j);
                attributesList = currNode.getAttributes();
                for (int k = 0; k < attributesList.getLength(); ++k) {
                    if (!attributesList.item(k).getLocalName().equalsIgnoreCase("objectiveID")) continue;
                    result = result + "," + decodeHandler.processWhitespace(attributesList.item(k).getNodeValue());
                }
            }
        }
        this.mLogger.exiting("ManifestHandler", "getObjectivesList");
        return result;
    }

    private void addResourceInfo(Node iRootNode, boolean iRemoveAssets) {
        this.mLogger.entering("ManifestHandler", "addResourceInfo()");
        Node resourcesNode = DOMTreeUtility.getNode(iRootNode, "resources");
        String scormType = this.mEMPTY_STRING;
        String location = this.mEMPTY_STRING;
        String xmlBase = this.mEMPTY_STRING;
        int size = this.mLaunchDataList.size();
        String resourceIdentifier = this.mEMPTY_STRING;
        Node matchingResourceNode = null;
        for (int i = 0; i < size; ++i) {
            scormType = this.mEMPTY_STRING;
            location = this.mEMPTY_STRING;
            xmlBase = this.mEMPTY_STRING;
            LaunchData currentLaunchData = (LaunchData)this.mLaunchDataList.elementAt(i);
            resourceIdentifier = currentLaunchData.getResourceIdentifier();
            matchingResourceNode = this.getResourceNodeWithIdentifier(resourcesNode, resourceIdentifier);
            if (matchingResourceNode != null) {
                scormType = DOMTreeUtility.getAttributeValue(matchingResourceNode, "scormType");
                location = DOMTreeUtility.getAttributeValue(matchingResourceNode, "href");
                xmlBase = DOMTreeUtility.getAttributeValue(matchingResourceNode, "base");
            }
            currentLaunchData.setSCORMType(scormType);
            currentLaunchData.setLocation(location);
            currentLaunchData.setResourceXMLBase(xmlBase);
            try {
                this.mLaunchDataList.set(i, currentLaunchData);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                System.out.println("ArrayIndexOutOfBoundsException caught on Vector currentLaunchData.  Attempted index access is " + i + "size of Vector is " + this.mLaunchDataList.size());
            }
        }
        if (size == 0) {
            NodeList children = resourcesNode.getChildNodes();
            int childrenSize = children.getLength();
            if (children != null) {
                for (int z = 0; z < childrenSize; ++z) {
                    Node currentNode = children.item(z);
                    String currentNodeName = currentNode.getLocalName();
                    if (!currentNodeName.equals("resource")) continue;
                    LaunchData launchData = new LaunchData();
                    scormType = DOMTreeUtility.getAttributeValue(currentNode, "scormType");
                    location = DOMTreeUtility.getAttributeValue(currentNode, "href");
                    xmlBase = DOMTreeUtility.getAttributeValue(currentNode, "base");
                    resourceIdentifier = DOMTreeUtility.getAttributeValue(currentNode, "identifier");
                    launchData.setSCORMType(scormType);
                    launchData.setLocation(location);
                    launchData.setResourceXMLBase(xmlBase);
                    launchData.setResourceIdentifier(resourceIdentifier);
                    this.mLaunchDataList.add(launchData);
                }
            }
        }
        if (iRemoveAssets) {
            this.removeAssetsFromLaunchDataList();
        }
        this.mLogger.exiting("ManifestHandler", "addResourceInfo()");
    }

    private Node getResourceNodeWithIdentifier(Node iResourcesNode, String iResourceIdentifier) {
        this.mLogger.entering("ManifestHandler", "getResourceNodeWithIdentifier()");
        Node result = null;
        NodeList children = iResourcesNode.getChildNodes();
        if (children != null) {
            int numChildren = children.getLength();
            Node currentChild = null;
            String currentChildName = this.mEMPTY_STRING;
            String currentResourceIdentifier = this.mEMPTY_STRING;
            for (int i = 0; i < numChildren; ++i) {
                currentChild = children.item(i);
                currentChildName = currentChild.getLocalName();
                if (!currentChildName.equals("resource") || !(currentResourceIdentifier = DOMTreeUtility.getAttributeValue(currentChild, "identifier")).equals(iResourceIdentifier)) continue;
                result = currentChild;
                break;
            }
        }
        this.mLogger.exiting("ManifestHandler", "getResourceNodeWithIdentifier()");
        return result;
    }

    private void removeAssetsFromLaunchDataList() {
        this.mLogger.entering("ManifestHandler", "removeAssetsFromLaunchDataList");
        int size = this.mLaunchDataList.size();
        int i = 0;
        while (i < size) {
            LaunchData currentLaunchData = (LaunchData)this.mLaunchDataList.elementAt(i);
            String scormType = currentLaunchData.getSCORMType();
            if (scormType.equals("asset")) {
                this.mLaunchDataList.removeElementAt(i);
                size = this.mLaunchDataList.size();
                continue;
            }
            ++i;
        }
        this.mLogger.exiting("ManifestHandler", "removeAssetsFromLaunchDataList");
    }

    private String getCompletionThreshold(Node iNode) {
        String thresh = "";
        if (iNode != null) {
            thresh = DOMTreeUtility.getNodeValue(iNode);
            if (thresh.equals(this.mEMPTY_STRING)) {
                thresh = DOMTreeUtility.getAttributeValue(iNode, "minProgressMeasure");
            }
            if (thresh.equals(this.mEMPTY_STRING) && DOMTreeUtility.getAttributeValue(iNode, "completedByMeasure").equals("true")) {
                thresh = "1.0";
            }
        }
        return thresh;
    }
}

