/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server.packageimport;

import java.util.Vector;
import java.util.logging.Logger;
import org.adl.samplerte.server.packageimport.parsers.dom.DOMTreeUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManifestMap {
    private Logger mLogger = Logger.getLogger("org.adl.util.debug.samplerte");
    private String mManifestId = new String();
    private Vector mResourceIds = new Vector();
    private Vector mItemIds = new Vector();
    private Vector mItemIdrefs = new Vector();
    private Vector mDependencyIdrefs = new Vector();

    public String getManifestId() {
        return this.mManifestId;
    }

    public Vector getResourceIds() {
        return this.mResourceIds;
    }

    public Vector getItemIds() {
        return this.mItemIds;
    }

    public Vector getItemIdrefs() {
        return this.mItemIdrefs;
    }

    public boolean populateManifestMap(Node iNode) {
        this.mLogger.entering("ManifestMap", "populateManifestMap");
        boolean result = true;
        if (iNode == null) {
            result = false;
            return result;
        }
        short type = iNode.getNodeType();
        switch (type) {
            case 7: {
                break;
            }
            case 9: {
                Element rootNode = ((Document)iNode).getDocumentElement();
                result = this.populateManifestMap(rootNode) && result;
                break;
            }
            case 1: {
                String parentNodeName = iNode.getLocalName();
                if (parentNodeName.equalsIgnoreCase("manifest")) {
                    Node resourcesNode;
                    this.mManifestId = DOMTreeUtility.getAttributeValue(iNode, "identifier");
                    this.mLogger.finest("ManifestMap:populateManifestMap, Just stored a Manifest Id value of " + this.mManifestId);
                    Node orgsNode = DOMTreeUtility.getNode(iNode, "organizations");
                    if (orgsNode != null) {
                        Vector orgElems = DOMTreeUtility.getNodes(orgsNode, "organization");
                        this.mLogger.finest("ManifestMap:populateManifestMap, Number of <organization> elements: " + orgElems.size());
                        if (!orgElems.isEmpty()) {
                            int orgElemsSize = orgElems.size();
                            for (int i = 0; i < orgElemsSize; ++i) {
                                Vector itemElems = DOMTreeUtility.getNodes((Node)orgElems.elementAt(i), "item");
                                this.mLogger.finest("ManifestMap:populateManifestMap, Number of <item> elements: " + itemElems.size());
                                if (itemElems.isEmpty()) continue;
                                int itemElemsSize = itemElems.size();
                                for (int j = 0; j < itemElemsSize; ++j) {
                                    result = this.populateManifestMap((Node)itemElems.elementAt(j)) && result;
                                }
                            }
                        }
                    }
                    if ((resourcesNode = DOMTreeUtility.getNode(iNode, "resources")) == null) break;
                    Vector resourceElems = DOMTreeUtility.getNodes(resourcesNode, "resource");
                    this.mLogger.finest("ManifestMap:populateManifestMap, Number of <resource> elements: " + resourceElems.size());
                    int resourceElemsSize = resourceElems.size();
                    for (int k = 0; k < resourceElemsSize; ++k) {
                        result = this.populateManifestMap((Node)resourceElems.elementAt(k)) && result;
                    }
                } else if (parentNodeName.equalsIgnoreCase("item")) {
                    String itemId = DOMTreeUtility.getAttributeValue(iNode, "identifier");
                    this.mItemIds.add(itemId);
                    this.mLogger.finest("ManifestMap:populateManifestMap, Just stored an Item Id value of " + itemId);
                    String itemIdref = DOMTreeUtility.getAttributeValue(iNode, "identifierref");
                    this.mItemIdrefs.add(itemIdref);
                    this.mLogger.finest("ManifestMap:populateManifestMap, Just stored an Item Idref value of " + itemIdref);
                    Vector items = DOMTreeUtility.getNodes(iNode, "item");
                    if (items.isEmpty()) break;
                    int itemsSize = items.size();
                    for (int z = 0; z < itemsSize; ++z) {
                        result = this.populateManifestMap((Node)items.elementAt(z)) && result;
                    }
                } else {
                    if (!parentNodeName.equalsIgnoreCase("resource")) break;
                    String resourceId = DOMTreeUtility.getAttributeValue(iNode, "identifier");
                    this.mResourceIds.add(resourceId);
                    this.mLogger.finest("ManifestMap:populateManifestMap, Just stored a Resource Id value of " + resourceId);
                    Vector dependencyElems = DOMTreeUtility.getNodes(iNode, "dependency");
                    int dependencyElemsSize = dependencyElems.size();
                    for (int w = 0; w < dependencyElemsSize; ++w) {
                        Node dependencyElem = (Node)dependencyElems.elementAt(w);
                        String dependencyIdref = DOMTreeUtility.getAttributeValue(dependencyElem, "identifierref");
                        this.mDependencyIdrefs.add(dependencyIdref);
                        this.mLogger.finest("ManifestMap:populateManifestMap, Just stored a Dependency Idref value of " + this.mDependencyIdrefs);
                    }
                }
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
        }
        this.mLogger.exiting("ManifestMap", "populateManifestMap");
        return result;
    }
}

