/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server.packageimport.parsers.dom;

import java.util.Vector;
import java.util.logging.Logger;
import org.adl.util.decode.decodeHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTreeUtility {
    public static final String IMSCP_NAMESPACE = "http://www.imsglobal.org/xsd/imscp_v1p1";
    public static final String ADLCP_NAMESPACE = "http://www.adlnet.org/xsd/adlcp_v1p3";
    public static final String ADLSEQ_NAMESPACE = "http://www.adlnet.org/xsd/adlseq_v1p3";
    public static final String ADLNAV_NAMESPACE = "http://www.adlnet.org/xsd/adlnav_v1p3";
    public static final String IMSSS_NAMESPACE = "http://www.imsglobal.org/xsd/imsss";
    public static final String IEEE_LOM_NAMESPACE = "http://ltsc.ieee.org/xsd/LOM";

    public static Node getNode(Node iNode, String iNodeName) {
        NodeList children;
        Logger.getLogger("org.adl.util.debug.samplerte").entering("DOMTreeUtility", "getNode()");
        Logger.getLogger("org.adl.util.debug.samplerte").info("Parent Node: " + iNode.getLocalName());
        Logger.getLogger("org.adl.util.debug.samplerte").info("Node being searched for: " + iNodeName);
        Node result = null;
        if (iNode != null && (children = iNode.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node currentChild = children.item(i);
                String currentChildName = currentChild.getLocalName();
                Logger.getLogger("org.adl.util.debug.samplerte").info("Child #" + i + ": " + currentChildName);
                if (currentChildName == null || !currentChildName.equalsIgnoreCase(iNodeName)) continue;
                result = currentChild;
                break;
            }
        }
        return result;
    }

    public static Vector getNodes(Node iNode, String iNodeName) {
        NodeList children;
        Logger.getLogger("org.adl.util.debug.samplerte").entering("DOMTreeUtility", "getNodes()");
        Logger.getLogger("org.adl.util.debug.samplerte").info("Parent Node: " + iNode.getLocalName());
        Logger.getLogger("org.adl.util.debug.samplerte").info("Node being searched for: " + iNodeName);
        Vector<Node> result = new Vector<Node>();
        if (iNode != null && (children = iNode.getChildNodes()) != null) {
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                Node currentChild = children.item(i);
                String currentChildName = currentChild.getLocalName();
                if (currentChildName == null || !currentChildName.equalsIgnoreCase(iNodeName)) continue;
                result.add(currentChild);
            }
        }
        return result;
    }

    public static String getNodeValue(Node iNode) {
        String value = new String();
        if (iNode != null) {
            NodeList children = iNode.getChildNodes();
            int numChildren = children.getLength();
            if (children != null) {
                for (int i = 0; i < numChildren; ++i) {
                    if (children.item(i).getNodeType() != 3 && children.item(i).getNodeType() != 4) continue;
                    value = value + children.item(i).getNodeValue().trim();
                }
            }
        }
        return value;
    }

    public static Attr getAttribute(Node iNode, String iAttributeName) {
        Logger.getLogger("org.adl.util.debug.samplerte").entering("DOMTreeUtility", "getAttribute()");
        Logger.getLogger("org.adl.util.debug.samplerte").info("Parent Node: " + iNode.getLocalName());
        Logger.getLogger("org.adl.util.debug.samplerte").info("Node being searched for: " + iAttributeName);
        Attr result = null;
        if (iNode != null) {
            NamedNodeMap attrList = iNode.getAttributes();
            int numAttr = attrList.getLength();
            Attr currentAttrNode = null;
            String currentNodeName = null;
            for (int k = 0; k < numAttr; ++k) {
                currentAttrNode = (Attr)attrList.item(k);
                currentNodeName = currentAttrNode.getLocalName();
                if (!currentNodeName.equalsIgnoreCase(iAttributeName)) continue;
                result = currentAttrNode;
                if (!iAttributeName.equals("identifier") && !iAttributeName.equals("default")) break;
                result.setValue(decodeHandler.processWhitespace(result.getValue()));
                break;
            }
        }
        return result;
    }

    public static void removeAttribute(Node iNode, String iAttributeName) {
        NamedNodeMap attrList = iNode.getAttributes();
        attrList.removeNamedItem(iAttributeName);
    }

    public static String getAttributeValue(Node iNode, String iAttributeName) {
        Logger.getLogger("org.adl.util.debug.samplerte").entering("DOMTreeUtility", "getAttributeValue()");
        Logger.getLogger("org.adl.util.debug.samplerte").info("Parent Node: " + iNode.getLocalName());
        Logger.getLogger("org.adl.util.debug.samplerte").info("Node being searched for: " + iAttributeName);
        String result = "";
        Attr theAttribute = DOMTreeUtility.getAttribute(iNode, iAttributeName);
        if (theAttribute != null) {
            result = theAttribute.getValue();
            if (iAttributeName.equals("identifier") || iAttributeName.equals("default")) {
                result = decodeHandler.processWhitespace(result);
            }
        }
        return result;
    }

    public static boolean isAppropriateElement(Node iNode, String iNodeName, String iNamespace) {
        Logger.getLogger("org.adl.util.debug.samplerte").entering("DOMTreeUtility", "isAppropriateElement()");
        Logger.getLogger("org.adl.util.debug.samplerte").finest("Input Parent Node: " + iNode.getLocalName());
        Logger.getLogger("org.adl.util.debug.samplerte").finest("Input Node being searched for: " + iNodeName);
        Logger.getLogger("org.adl.util.debug.samplerte").finest("Input Namespace of node being searched for: " + iNamespace);
        boolean result = false;
        if (iNode.getNodeType() == 2) {
            if (iNode.getNamespaceURI() == null) {
                String parentsNamespace = ((Attr)iNode).getOwnerElement().getNamespaceURI();
                if (iNode.getLocalName().equals(iNodeName) && parentsNamespace.equals(iNamespace)) {
                    result = true;
                }
            } else if (iNode.getLocalName().equals(iNodeName) && iNode.getNamespaceURI().equals(iNamespace)) {
                result = true;
            }
        } else if (iNode.getLocalName().equals(iNodeName) && iNode.getNamespaceURI().equals(iNamespace)) {
            result = true;
        }
        return result;
    }

    public static boolean isSCORMAppProfileNode(Node iCurrentNode, Node iParentNode) {
        Logger.getLogger("org.adl.util.debug.samplerte").entering("DOMTreeUtility", "isSCORMAppProfileNode");
        Logger.getLogger("org.adl.util.debug.samplerte").finest("Input Current Node: " + iCurrentNode.getLocalName());
        Logger.getLogger("org.adl.util.debug.samplerte").finest("Input Parent Node: " + iParentNode.getLocalName());
        boolean result = false;
        String namespace = iCurrentNode.getNamespaceURI();
        if (namespace == null) {
            String parentsNamespace = iParentNode.getNamespaceURI();
            if (parentsNamespace.equals(ADLCP_NAMESPACE) || parentsNamespace.equals(IMSCP_NAMESPACE) || parentsNamespace.equals(ADLNAV_NAMESPACE) || parentsNamespace.equals(IEEE_LOM_NAMESPACE) || parentsNamespace.equals(ADLSEQ_NAMESPACE) || parentsNamespace.equals("http://www.w3.org/XML/1998/namespace") || parentsNamespace.equals("http://www.w3.org/2001/XMLSchema-instance") || parentsNamespace.equals("http://www.w3.org/2000/xmlns/") || parentsNamespace.equals(IMSSS_NAMESPACE)) {
                result = true;
            }
        } else if (namespace.equals(ADLCP_NAMESPACE) || namespace.equals(IMSCP_NAMESPACE) || namespace.equals(IEEE_LOM_NAMESPACE) || namespace.equals(ADLNAV_NAMESPACE) || namespace.equals(ADLSEQ_NAMESPACE) || namespace.equals("http://www.w3.org/XML/1998/namespace") || namespace.equals("http://www.w3.org/2001/XMLSchema-instance") || namespace.equals("http://www.w3.org/2000/xmlns/") || namespace.equals(IMSSS_NAMESPACE)) {
            result = true;
        }
        return result;
    }
}

