/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server.packageimport.sequencingOrderChecker;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class SequencingOrderChecker
extends PackageChecker {
    static final String IMSCP = "http://www.imsglobal.org/xsd/imscp_v1p1";
    static final String IMSSS = "http://www.imsglobal.org/xsd/imsss";
    static final Namespace XML = Namespace.getNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    static final int KILOBYTE = 1024;
    private static Document mXMLInstance;
    private SAXBuilder mBuilder = new SAXBuilder();
    private String mIMSManifestFile;
    private List mErrorMessages;

    public SequencingOrderChecker() {
        this.mBuilder.setReuseParser(false);
        this.mIMSManifestFile = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();
        this.mErrorMessages = new ArrayList();
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("SequencingOrderChecker");
    }

    @Override
    public Result check() {
        boolean success = true;
        try {
            mXMLInstance = this.parse(this.mIMSManifestFile);
            XPath seqPath = XPath.newInstance("//imsss:sequencing");
            seqPath.addNamespace("imscp", IMSCP);
            seqPath.addNamespace("imsss", IMSSS);
            Iterator seqIter = seqPath.selectNodes(mXMLInstance).iterator();
            while (seqIter.hasNext()) {
                for (Element child : ((Element)seqIter.next()).getChildren()) {
                    ArrayList<String> successors;
                    if (child.getName().equals("controlMode") && child.getNamespaceURI().equals(IMSSS)) {
                        successors = new ArrayList<String>();
                        successors.add("http://www.imsglobal.org/xsd/imsss:sequencingRules");
                        successors.add("http://www.imsglobal.org/xsd/imsss:limitConditions");
                        successors.add("http://www.imsglobal.org/xsd/imsss:auxiliaryResources");
                        successors.add("http://www.imsglobal.org/xsd/imsss:rollupRules");
                        successors.add("http://www.imsglobal.org/xsd/imsss:objectives");
                        successors.add("http://www.imsglobal.org/xsd/imsss:randomizationControls");
                        successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                        success = success && this.checkSiblings(child, successors);
                        continue;
                    }
                    if (child.getName().equals("sequencingRules") && child.getNamespaceURI().equals(IMSSS)) {
                        successors = new ArrayList();
                        successors.add("http://www.imsglobal.org/xsd/imsss:limitConditions");
                        successors.add("http://www.imsglobal.org/xsd/imsss:auxiliaryResources");
                        successors.add("http://www.imsglobal.org/xsd/imsss:rollupRules");
                        successors.add("http://www.imsglobal.org/xsd/imsss:objectives");
                        successors.add("http://www.imsglobal.org/xsd/imsss:randomizationControls");
                        successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                        success = success && this.checkSiblings(child, successors);
                        for (Element siblingChild : child.getChildren()) {
                            if (siblingChild.getName().equals("preConditionRule") && siblingChild.getNamespaceURI().equals(IMSSS)) {
                                successors = new ArrayList();
                                successors.add("http://www.imsglobal.org/xsd/imsss:exitConditionRule");
                                successors.add("http://www.imsglobal.org/xsd/imsss:postConditionRule");
                                success = success && this.checkSiblings(siblingChild, successors);
                                for (Element siblingChildChild : siblingChild.getChildren()) {
                                    if (!siblingChildChild.getName().equals("ruleConditions") || !siblingChildChild.getNamespaceURI().equals(IMSSS)) continue;
                                    successors = new ArrayList();
                                    successors.add("http://www.imsglobal.org/xsd/imsss:ruleAction");
                                    success = success && this.checkSiblings(siblingChildChild, successors);
                                }
                                continue;
                            }
                            if (siblingChild.getName().equals("exitConditionRule") && siblingChild.getNamespaceURI().equals(IMSSS)) {
                                successors = new ArrayList();
                                successors.add("http://www.imsglobal.org/xsd/imsss:postConditionRule");
                                success = success && this.checkSiblings(siblingChild, successors);
                                for (Element siblingChildChild : siblingChild.getChildren()) {
                                    if (!siblingChildChild.getName().equals("ruleConditions") || !siblingChildChild.getNamespaceURI().equals(IMSSS)) continue;
                                    successors = new ArrayList();
                                    successors.add("http://www.imsglobal.org/xsd/imsss:ruleAction");
                                    success = success && this.checkSiblings(siblingChildChild, successors);
                                }
                                continue;
                            }
                            if (!siblingChild.getName().equals("postConditionRule") || !siblingChild.getNamespaceURI().equals(IMSSS)) continue;
                            for (Element siblingChildChild : siblingChild.getChildren()) {
                                if (!siblingChildChild.getName().equals("ruleConditions") || !siblingChildChild.getNamespaceURI().equals(IMSSS)) continue;
                                successors = new ArrayList();
                                successors.add("http://www.imsglobal.org/xsd/imsss:ruleAction");
                                success = success && this.checkSiblings(siblingChildChild, successors);
                            }
                        }
                        continue;
                    }
                    if (child.getName().equals("limitConditions") && child.getNamespaceURI().equals(IMSSS)) {
                        successors = new ArrayList();
                        successors.add("http://www.imsglobal.org/xsd/imsss:auxiliaryResources");
                        successors.add("http://www.imsglobal.org/xsd/imsss:rollupRules");
                        successors.add("http://www.imsglobal.org/xsd/imsss:objectives");
                        successors.add("http://www.imsglobal.org/xsd/imsss:randomizationControls");
                        successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                        success = success && this.checkSiblings(child, successors);
                        continue;
                    }
                    if (child.getName().equals("auxiliaryResources") && child.getNamespaceURI().equals(IMSSS)) {
                        successors = new ArrayList();
                        successors.add("http://www.imsglobal.org/xsd/imsss:rollupRules");
                        successors.add("http://www.imsglobal.org/xsd/imsss:objectives");
                        successors.add("http://www.imsglobal.org/xsd/imsss:randomizationControls");
                        successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                        success = success && this.checkSiblings(child, successors);
                        continue;
                    }
                    if (child.getName().equals("rollupRules") && child.getNamespaceURI().equals(IMSSS)) {
                        successors = new ArrayList();
                        successors.add("http://www.imsglobal.org/xsd/imsss:objectives");
                        successors.add("http://www.imsglobal.org/xsd/imsss:randomizationControls");
                        successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                        success = success && this.checkSiblings(child, successors);
                        for (Element siblingChild : child.getChildren()) {
                            if (!siblingChild.getName().equals("rollupRule") || !siblingChild.getNamespaceURI().equals(IMSSS)) continue;
                            for (Element siblingChildChild : siblingChild.getChildren()) {
                                if (!siblingChildChild.getName().equals("rollupConditions") || !siblingChildChild.getNamespaceURI().equals(IMSSS)) continue;
                                successors = new ArrayList();
                                successors.add("http://www.imsglobal.org/xsd/imsss:rollupAction");
                                success = success && this.checkSiblings(siblingChildChild, successors);
                            }
                        }
                        continue;
                    }
                    if (child.getName().equals("objectives") && child.getNamespaceURI().equals(IMSSS)) {
                        successors = new ArrayList();
                        successors.add("http://www.imsglobal.org/xsd/imsss:randomizationControls");
                        successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                        success = success && this.checkSiblings(child, successors);
                        for (Element siblingChild : child.getChildren()) {
                            if (siblingChild.getName().equals("primaryObjective") && siblingChild.getNamespaceURI().equals(IMSSS)) {
                                successors = new ArrayList();
                                successors.add("http://www.imsglobal.org/xsd/imsss:objective");
                                success = success && this.checkSiblings(siblingChild, successors);
                                for (Element siblingChildChild : siblingChild.getChildren()) {
                                    if (!siblingChildChild.getName().equals("minNormalizedMeasure") || !siblingChildChild.getNamespaceURI().equals(IMSSS)) continue;
                                    successors = new ArrayList();
                                    successors.add("http://www.imsglobal.org/xsd/imsss:mapInfo");
                                    success = success && this.checkSiblings(siblingChildChild, successors);
                                }
                                continue;
                            }
                            if (!siblingChild.getName().equals("objective") || !siblingChild.getNamespaceURI().equals(IMSSS)) continue;
                            for (Element siblingChildChild : siblingChild.getChildren()) {
                                if (!siblingChildChild.getName().equals("minNormalizedMeasure") || !siblingChildChild.getNamespaceURI().equals(IMSSS)) continue;
                                successors = new ArrayList();
                                successors.add("http://www.imsglobal.org/xsd/imsss:mapInfo");
                                success = success && this.checkSiblings(siblingChildChild, successors);
                            }
                        }
                        continue;
                    }
                    if (!child.getName().equals("randomizationControls") || !child.getNamespaceURI().equals(IMSSS)) continue;
                    successors = new ArrayList();
                    successors.add("http://www.imsglobal.org/xsd/imsss:deliveryControls");
                    success = success && this.checkSiblings(child, successors);
                }
            }
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, "Testing the order of the children of the <sequencing> element"));
            if (!success) {
                this.mResult.setPackageCheckerPassed(false);
                this.mResult.addOverallStatusMessage(new ValidatorMessage(3, "The children of the <sequencing> element are not in the correct order"));
                this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, "Sequencing information is ambiguous. The children of the <sequencing> element are not in the correct order"));
            } else {
                this.mResult.setPackageCheckerPassed(true);
                this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, "The children of the <sequencing> element are in the correct order"));
                this.mResult.addOverallStatusMessage(new ValidatorMessage(2, "The children of the <sequencing> element are in the correct order"));
            }
            mXMLInstance = null;
            System.gc();
        }
        catch (JDOMException jde) {
            jde.printStackTrace();
            this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString((String)"SchematronValidationDOMParser.5", (Object[])new Object[0])));
            success = false;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString((String)"SchematronValidationDOMParser.6", (Object[])new Object[0])));
            success = false;
        }
        return this.mResult;
    }

    private boolean checkSiblings(Element iNode, List iSuccessors) {
        boolean success = true;
        try {
            XPath siblingPath = XPath.newInstance("preceding-sibling::*");
            Iterator siblingIter = siblingPath.selectNodes(iNode).iterator();
            while (siblingIter.hasNext() && success) {
                Element sibling = (Element)siblingIter.next();
                String siblingName = sibling.getNamespaceURI() + ":" + sibling.getName();
                success = success && !iSuccessors.contains(siblingName);
            }
        }
        catch (JDOMException jde) {
            jde.printStackTrace();
            success = false;
        }
        return success;
    }

    private Document parse(String iFile) {
        iFile = URIHandler.decode(iFile, "UTF-16");
        try {
            FileInputStream fis = new FileInputStream(iFile);
            return this.parse(fis);
        }
        catch (IOException ioe) {
            String msg = Messages.getString((String)"SchematronValidationDOMParser.7", (Object[])new Object[0]);
            ValidatorMessage message = new ValidatorMessage(3, msg);
            this.mErrorMessages.add(message);
            return null;
        }
    }

    private Document parse(InputStream iStream) {
        try {
            return this.mBuilder.build(iStream);
        }
        catch (IOException ioe) {
            String msg = Messages.getString((String)"SchematronValidationDOMParser.7", (Object[])new Object[0]);
            ValidatorMessage message = new ValidatorMessage(3, msg);
            this.mErrorMessages.add(message);
            return null;
        }
        catch (JDOMException jde) {
            String msg = Messages.getString((String)"SchematronValidationDOMParser.7", (Object[])new Object[0]);
            ValidatorMessage message = new ValidatorMessage(3, msg);
            this.mErrorMessages.add(message);
            return null;
        }
    }
}

