/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.adl.util.debug.DebugIndicator;

public class LMSDBHandler {
    private static boolean _Debug = DebugIndicator.ON;
    private static Connection conn = null;

    public LMSDBHandler() {
        LMSDBHandler.getConnection();
    }

    public static Connection getConnection() {
        if (conn == null) {
            try {
                if (_Debug) {
                    System.out.println("  ::--> Connecting to the Obj DB");
                }
                String driverName = "sun.jdbc.odbc.JdbcOdbcDriver";
                String connectionURL = "jdbc:odbc:SCORM4EDGlobalObjs111";
                Properties prop = new Properties();
                prop.put("charSet", "utf-8");
                Class.forName(driverName).newInstance();
                conn = DriverManager.getConnection(connectionURL, prop);
                if (_Debug) {
                    System.out.println("  ::--> Connection successful");
                }
            }
            catch (SQLException ex) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR:  Could not connect to Obj DB");
                    System.out.println("  ::-->  " + ex.getSQLState());
                }
                ex.printStackTrace();
            }
            catch (Exception e) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR:  Unexpected exception");
                }
                e.printStackTrace();
            }
        }
        return conn;
    }

    public static void closeConnection() {
        try {
            if (conn != null && !conn.isClosed()) {
                try {
                    if (_Debug) {
                        System.out.println("  ::--> Closing Obj DB connection.");
                    }
                    conn.close();
                }
                catch (SQLException ex) {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR:  Could not close Obj DB");
                        System.out.println("  ::-->  " + ex.getSQLState());
                    }
                    ex.printStackTrace();
                }
            }
            conn = null;
        }
        catch (SQLException ex) {
            if (_Debug) {
                System.out.println("  ::--> ERROR: in conn.IsClosed Obj DB ");
                System.out.println("  ::-->  " + ex.getSQLState());
            }
            ex.printStackTrace();
        }
    }
}

