/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.adl.datamodels.DMInterface;
import org.adl.datamodels.SCODataManager;
import org.adl.samplerte.util.LMSDatabaseHandler;
import org.adl.util.debug.DebugIndicator;

public class RTEFileHandler {
    private static boolean _Debug = DebugIndicator.ON;
    private String mSampleRTERoot = File.separator + "SCORM4EDSampleRTE111Files";

    public void initializeStateFile(String iNumAttempt, String iUserID, String iUserName, String iCourseID, String iItemID, String iDbID) {
        try {
            String userDir;
            File scoDataDir;
            if (_Debug) {
                System.out.println("**** IN INITIALIZESTATEFILE****");
            }
            if (!(scoDataDir = new File(userDir = this.mSampleRTERoot + File.separator + iUserID + File.separator + iCourseID)).isDirectory()) {
                if (_Debug) {
                    System.out.println("User directory does not exist");
                }
                scoDataDir.mkdirs();
            } else if (_Debug) {
                System.out.println("In RTEFileHandler user directory already exists.");
            }
            if (_Debug) {
                System.out.println("In RTEFileHandler - scoID is " + iItemID);
            }
            String scoDataPath = userDir + File.separator + iItemID + "__" + iNumAttempt;
            SCODataManager scoData = new SCODataManager();
            scoData.addDM(1);
            scoData.addDM(2);
            this.initSCOData(scoData, iUserID, iUserName, iCourseID, iDbID);
            File scoDataFile = new File(scoDataPath);
            boolean mNoFileExists = scoDataFile.createNewFile();
            if (mNoFileExists) {
                FileOutputStream fos = new FileOutputStream(scoDataFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(scoData);
                oos.close();
                fos.close();
                if (_Debug) {
                    System.out.println("RTEFileHandler created State file for: " + iItemID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteCourseFiles(String iDeleteCourseID, String iUserID) {
        try {
            String userDir = this.mSampleRTERoot + File.separator + iUserID + File.separator + iDeleteCourseID;
            if (_Debug) {
                System.out.println("path  " + userDir);
            }
            File scoDataDir = new File(userDir);
            File[] scoFiles = scoDataDir.listFiles();
            for (int i = 0; i < scoFiles.length; ++i) {
                scoFiles[i].delete();
            }
            scoDataDir.delete();
        }
        catch (Exception e) {
            System.out.println("Error deleting files during un-registration");
            e.printStackTrace();
        }
    }

    public void deleteTempUloadFiles() {
        try {
            String tempDir = this.mSampleRTERoot + File.separator + "tempUploads";
            File tempUploadDir = new File(tempDir);
            File[] tempDirs = tempUploadDir.listFiles();
            for (int i = 0; i < tempDirs.length; ++i) {
                File[] tempFiles = tempDirs[i].listFiles();
                for (int j = 0; j < tempFiles.length; ++j) {
                    tempFiles[j].delete();
                }
                tempDirs[i].delete();
            }
        }
        catch (Exception e) {
            System.out.println("Error deleting files in the tempUploads directory");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPersistedData(SCODataManager ioSCOData, String iCourseID, String iItemID, String iUserID) {
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            String sqlSelectItem = "SELECT * FROM ItemInfo WHERE CourseID = ? AND ItemIdentifier = ?";
            String sqlSelectComments = "SELECT * FROM SCOComments WHERE ActivityID = ?";
            String sqlSelectUser = "SELECT * FROM UserInfo WHERE UserID = ?";
            PreparedStatement stmtSelectItem = conn.prepareStatement(sqlSelectItem);
            PreparedStatement stmtSelectComments = conn.prepareStatement(sqlSelectComments);
            PreparedStatement stmtSelectUser = conn.prepareStatement(sqlSelectUser);
            ResultSet rsItem = null;
            ResultSet rsUser = null;
            PreparedStatement preparedStatement = stmtSelectItem;
            synchronized (preparedStatement) {
                stmtSelectItem.setString(1, iCourseID);
                stmtSelectItem.setString(2, iItemID);
                rsItem = stmtSelectItem.executeQuery();
            }
            preparedStatement = stmtSelectUser;
            synchronized (preparedStatement) {
                stmtSelectUser.setString(1, iUserID);
                rsUser = stmtSelectUser.executeQuery();
            }
            String masteryScore = new String();
            String dataFromLMS = new String();
            String maxTime = new String();
            String timeLimitAction = new String();
            String completionThreshold = new String();
            String audLev = new String();
            String audCap = new String();
            String delSpd = new String();
            String lang = new String();
            if (rsUser.next()) {
                audLev = rsUser.getString("AudioLevel");
                audCap = rsUser.getString("AudioCaptioning");
                delSpd = rsUser.getString("DeliverySpeed");
                lang = rsUser.getString("Language");
            }
            while (rsItem.next()) {
                String type = rsItem.getString("Type");
                if (!type.equals("sco") && !type.equals("asset")) continue;
                masteryScore = rsItem.getString("MinNormalizedMeasure");
                dataFromLMS = rsItem.getString("DataFromLMS");
                maxTime = rsItem.getString("AttemptAbsoluteDurationLimit");
                timeLimitAction = rsItem.getString("TimeLimitAction");
                completionThreshold = rsItem.getString("CompletionThreshold");
                int activityID = rsItem.getInt("ActivityID");
                ResultSet rsComments = null;
                PreparedStatement preparedStatement2 = stmtSelectComments;
                synchronized (preparedStatement2) {
                    stmtSelectComments.setInt(1, activityID);
                    rsComments = stmtSelectComments.executeQuery();
                }
                int idx = 0;
                while (rsComments.next()) {
                    String cmt = rsComments.getString("Comment");
                    String elem = "cmi.comments_from_lms." + idx + ".comment";
                    DMInterface.processSetValue(elem, cmt, true, ioSCOData);
                    String cmtDT = rsComments.getString("CommentDateTime");
                    elem = "cmi.comments_from_lms." + idx + ".timestamp";
                    DMInterface.processSetValue(elem, cmtDT, true, ioSCOData);
                    String cmtLoc = rsComments.getString("CommentLocation");
                    elem = "cmi.comments_from_lms." + idx + ".location";
                    DMInterface.processSetValue(elem, cmtLoc, true, ioSCOData);
                    ++idx;
                }
            }
            stmtSelectItem.close();
            stmtSelectComments.close();
            conn.close();
            String element = new String();
            element = "cmi.credit";
            DMInterface.processSetValue(element, "credit", true, ioSCOData);
            element = "cmi.mode";
            DMInterface.processSetValue(element, "normal", true, ioSCOData);
            if (dataFromLMS != null && !dataFromLMS.equals("")) {
                element = "cmi.launch_data";
                DMInterface.processSetValue(element, dataFromLMS, true, ioSCOData);
            }
            if (masteryScore != null && !masteryScore.equals("")) {
                element = "cmi.scaled_passing_score";
                DMInterface.processSetValue(element, masteryScore, true, ioSCOData);
            }
            if (timeLimitAction != null && !timeLimitAction.equals("")) {
                element = "cmi.time_limit_action";
                DMInterface.processSetValue(element, timeLimitAction, true, ioSCOData);
            }
            if (completionThreshold != null && !completionThreshold.equals("")) {
                element = "cmi.completion_threshold";
                DMInterface.processSetValue(element, completionThreshold, true, ioSCOData);
            }
            if (maxTime != null && !maxTime.equals("")) {
                element = "cmi.max_time_allowed";
                DMInterface.processSetValue(element, maxTime, true, ioSCOData);
            }
            element = "cmi.learner_preference.audio_level";
            DMInterface.processSetValue(element, audLev, true, ioSCOData);
            element = "cmi.learner_preference.audio_captioning";
            DMInterface.processSetValue(element, audCap, true, ioSCOData);
            element = "cmi.learner_preference.delivery_speed";
            DMInterface.processSetValue(element, delSpd, true, ioSCOData);
            element = "cmi.learner_preference.language";
            DMInterface.processSetValue(element, lang, true, ioSCOData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSCOData(SCODataManager ioSCOData, String iUserID, String iUserName, String iCourseID, String iItemID) {
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            String sqlSelectItem = "SELECT * FROM ItemInfo WHERE CourseID = ? AND ItemIdentifier = ?";
            String sqlSelectComments = "SELECT * FROM SCOComments WHERE ActivityID = ?";
            String sqlSelectUser = "SELECT * FROM UserInfo WHERE UserID = ?";
            PreparedStatement stmtSelectItem = conn.prepareStatement(sqlSelectItem);
            PreparedStatement stmtSelectComments = conn.prepareStatement(sqlSelectComments);
            PreparedStatement stmtSelectUser = conn.prepareStatement(sqlSelectUser);
            if (_Debug) {
                System.out.println("about to call item in RTEFile");
                System.out.println("userID: " + iUserID);
                System.out.println("courseID: " + iCourseID);
                System.out.println("scoID: " + iItemID);
            }
            ResultSet rsItem = null;
            ResultSet rsUser = null;
            PreparedStatement preparedStatement = stmtSelectItem;
            synchronized (preparedStatement) {
                stmtSelectItem.setString(1, iCourseID);
                stmtSelectItem.setString(2, iItemID);
                rsItem = stmtSelectItem.executeQuery();
            }
            preparedStatement = stmtSelectUser;
            synchronized (preparedStatement) {
                stmtSelectUser.setString(1, iUserID);
                rsUser = stmtSelectUser.executeQuery();
            }
            if (_Debug) {
                System.out.println("call to itemRS is complete");
            }
            String masteryScore = new String();
            String dataFromLMS = new String();
            String maxTime = new String();
            String timeLimitAction = new String();
            String completionThreshold = new String();
            String audLev = new String();
            String audCap = new String();
            String delSpd = new String();
            String lang = new String();
            if (rsUser.next()) {
                audLev = rsUser.getString("AudioLevel");
                audCap = rsUser.getString("AudioCaptioning");
                delSpd = rsUser.getString("DeliverySpeed");
                lang = rsUser.getString("Language");
            }
            while (rsItem.next()) {
                if (!rsItem.getString("ItemIdentifier").equals(iItemID)) continue;
                String type = rsItem.getString("Type");
                if (!type.equals("sco") && !type.equals("asset")) break;
                masteryScore = rsItem.getString("MinNormalizedMeasure");
                dataFromLMS = rsItem.getString("DataFromLMS");
                maxTime = rsItem.getString("AttemptAbsoluteDurationLimit");
                timeLimitAction = rsItem.getString("TimeLimitAction");
                completionThreshold = rsItem.getString("CompletionThreshold");
                int activityID = rsItem.getInt("ActivityID");
                ResultSet rsComments = null;
                PreparedStatement preparedStatement2 = stmtSelectComments;
                synchronized (preparedStatement2) {
                    stmtSelectComments.setInt(1, activityID);
                    rsComments = stmtSelectComments.executeQuery();
                }
                int idx = 0;
                while (rsComments.next()) {
                    String cmt = rsComments.getString("Comment");
                    String elem = "cmi.comments_from_lms." + idx + ".comment";
                    DMInterface.processSetValue(elem, cmt, true, ioSCOData);
                    String cmtDT = rsComments.getString("CommentDateTime");
                    elem = "cmi.comments_from_lms." + idx + ".timestamp";
                    DMInterface.processSetValue(elem, cmtDT, true, ioSCOData);
                    String cmtLoc = rsComments.getString("CommentLocation");
                    elem = "cmi.comments_from_lms." + idx + ".location";
                    DMInterface.processSetValue(elem, cmtLoc, true, ioSCOData);
                    ++idx;
                }
                break block11;
            }
            stmtSelectItem.close();
            conn.close();
            String element = new String();
            element = "cmi.learner_id";
            DMInterface.processSetValue(element, iUserID, true, ioSCOData);
            element = "cmi.learner_name";
            DMInterface.processSetValue(element, iUserName, true, ioSCOData);
            element = "cmi.credit";
            DMInterface.processSetValue(element, "credit", true, ioSCOData);
            element = "cmi.mode";
            DMInterface.processSetValue(element, "normal", true, ioSCOData);
            if (dataFromLMS != null && !dataFromLMS.equals("")) {
                element = "cmi.launch_data";
                DMInterface.processSetValue(element, dataFromLMS, true, ioSCOData);
            }
            if (masteryScore != null && !masteryScore.equals("")) {
                element = "cmi.scaled_passing_score";
                DMInterface.processSetValue(element, masteryScore, true, ioSCOData);
            }
            if (timeLimitAction != null && !timeLimitAction.equals("")) {
                element = "cmi.time_limit_action";
                DMInterface.processSetValue(element, timeLimitAction, true, ioSCOData);
            }
            if (completionThreshold != null && !completionThreshold.equals("")) {
                element = "cmi.completion_threshold";
                DMInterface.processSetValue(element, completionThreshold, true, ioSCOData);
            }
            if (maxTime != null && !maxTime.equals("")) {
                element = "cmi.max_time_allowed";
                DMInterface.processSetValue(element, maxTime, true, ioSCOData);
            }
            element = "cmi.learner_preference.audio_level";
            DMInterface.processSetValue(element, audLev, true, ioSCOData);
            element = "cmi.learner_preference.audio_captioning";
            DMInterface.processSetValue(element, audCap, true, ioSCOData);
            element = "cmi.learner_preference.delivery_speed";
            DMInterface.processSetValue(element, delSpd, true, ioSCOData);
            element = "cmi.learner_preference.language";
            DMInterface.processSetValue(element, lang, true, ioSCOData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

