/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import org.adl.util.debug.DebugIndicator;

public class ADLDuration
implements Serializable {
    public static final int UNKNOWN = -999;
    public static final int LT = -1;
    public static final int EQ = 0;
    public static final int GT = 1;
    public static final int FORMAT_SECONDS = 0;
    public static final int FORMAT_SCHEMA = 1;
    private static boolean _Debug = DebugIndicator.ON;
    public double mDuration = 0.0;

    public ADLDuration() {
        this.mDuration = 0.0;
    }

    /*
     * Unable to fully structure code
     */
    public ADLDuration(int iFormat, String iValue) {
        super();
        hours = null;
        min = null;
        sec = null;
        switch (iFormat) {
            case 0: {
                secs = 0.0;
                try {
                    secs = Double.parseDouble(iValue);
                }
                catch (Exception e) {
                    if (!ADLDuration._Debug) ** GOTO lbl15
                    System.out.print("  Invalid Format ::  " + iFormat + " // " + iValue);
                }
lbl15:
                // 3 sources

                this.mDuration = secs * 1000.0;
                break;
            }
            case 1: {
                locStart = iValue.indexOf(84);
                loc = 0;
                try {
                    if (locStart != -1) {
                        if ((loc = iValue.indexOf("H", ++locStart)) != -1) {
                            hours = iValue.substring(locStart, loc);
                            this.mDuration = Double.parseDouble(hours) * 3600.0;
                            locStart = loc + 1;
                        }
                        if ((loc = iValue.indexOf("M", locStart)) != -1) {
                            min = iValue.substring(locStart, loc);
                            this.mDuration += Double.parseDouble(min) * 60.0;
                            locStart = loc + 1;
                        }
                        if ((loc = iValue.indexOf("S", locStart)) == -1) break;
                        sec = iValue.substring(locStart, loc);
                        this.mDuration += Double.parseDouble(sec);
                        break;
                    }
                    if (!ADLDuration._Debug) break;
                    System.out.println(" ERROR : Invalid format  --> " + iValue);
                    break;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("ERROR");
                    nfe.printStackTrace();
                }
            }
        }
    }

    private double round(double iValue) {
        iValue *= 10.0;
        iValue = Math.rint(iValue);
        return iValue /= 10.0;
    }

    public String format(int iFormat) {
        String out = null;
        long countHours = 0L;
        long countMin = 0L;
        double countSec = 0.0;
        double temp = 0.0;
        switch (iFormat) {
            case 0: {
                double sec = this.mDuration / 1000.0;
                out = new Double(sec).toString();
                break;
            }
            case 1: {
                out = "";
                countHours = 0L;
                countMin = 0L;
                countSec = 0.0;
                temp = this.mDuration;
                if (temp >= 0.1) {
                    if ((temp = this.round(temp)) >= 3600.0) {
                        countHours = (long)(temp / 3600.0);
                        temp %= 3600.0;
                    }
                    if (temp > 60.0) {
                        countMin = (long)(temp / 60.0);
                        temp %= 60.0;
                    }
                    countSec = this.round(temp);
                }
                out = "PT";
                if (countHours > 0L) {
                    out = out + Long.toString(countHours, 10);
                    out = out + "H";
                }
                if (countMin > 0L) {
                    out = out + Long.toString(countMin, 10);
                    out = out + "M";
                }
                if (!(countSec > 0.0)) break;
                out = out + countSec;
                out = out + "S";
                break;
            }
        }
        return out;
    }

    public void add(ADLDuration iDur) {
        this.mDuration += iDur.mDuration;
    }

    public int compare(ADLDuration iDur) {
        int relation = -999;
        if (this.mDuration < iDur.mDuration) {
            relation = -1;
        } else if (this.mDuration == iDur.mDuration) {
            relation = 0;
        } else if (this.mDuration > iDur.mDuration) {
            relation = 1;
        }
        return relation;
    }
}

