/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.adl.util.debug.DebugIndicator;
import org.adl.util.decode.decodeHandler;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ADLSeqParser
extends DOMParser {
    private static boolean _Debug = DebugIndicator.ON;
    private String mFileToParse = null;
    private String mCourseID = null;
    private String mOrganizationID = null;
    private boolean mGlobalToSystem = true;
    private Node mSequencingCollection = null;
    private Document mDocument = null;

    public ADLSeqParser(String iFileName) {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - constructor");
            System.out.println("  ::--> " + iFileName);
        }
        this.mFileToParse = iFileName;
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> END   - constructor");
        }
    }

    public Node findDefaultOrganization() {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - findDefaultOrganization");
        }
        Node organization = null;
        boolean result = this.parseFile();
        if (result) {
            Element root = this.mDocument.getDocumentElement();
            this.mCourseID = this.getAttribute(root, "identifier");
            NodeList children = root.getChildNodes();
            boolean done = false;
            boolean foundFirstOrg = false;
            for (int i = 0; i < children.getLength(); ++i) {
                Node curNode = children.item(i);
                if (curNode.getNodeType() != 1) continue;
                if (curNode.getLocalName().equals("organizations")) {
                    if (_Debug) {
                        System.out.println("  ::--> Found the <organizations> element");
                    }
                    this.mOrganizationID = this.getAttribute(curNode, "default");
                    NodeList orgs = curNode.getChildNodes();
                    for (int j = 0; j < orgs.getLength() && !done; ++j) {
                        Node curOrg = orgs.item(j);
                        if (curOrg.getNodeType() != 1 || !curOrg.getLocalName().equals("organization")) continue;
                        if (_Debug) {
                            System.out.println("  ::--> Found an <organization> element");
                        }
                        String id = this.getAttribute(curOrg, "identifier");
                        if (this.mOrganizationID != null) {
                            if (id.equals(this.mOrganizationID)) {
                                String temp = this.getAttribute(curOrg, "objectivesGlobalToSystem");
                                if (temp != null) {
                                    this.mGlobalToSystem = new Boolean(temp);
                                }
                                organization = curOrg;
                                done = true;
                                continue;
                            }
                        } else if (!foundFirstOrg) {
                            this.mOrganizationID = id;
                            organization = curOrg;
                            done = true;
                            continue;
                        }
                        if (foundFirstOrg) continue;
                        foundFirstOrg = true;
                    }
                    if (organization != null) continue;
                    if (_Debug) {
                        System.out.println("  ::--> Default <organization> not found, using the first one.");
                    }
                    organization = orgs.item(0);
                    continue;
                }
                if (curNode.getLocalName().equals("resources")) {
                    if (!_Debug) continue;
                    System.out.println("  ::--> Found the <resources> element");
                    continue;
                }
                if (!curNode.getLocalName().equals("sequencingCollection")) continue;
                if (_Debug) {
                    System.out.println("  ::--> Found the <sequencingCollection> element");
                }
                this.mSequencingCollection = curNode;
            }
        } else if (_Debug) {
            System.out.println("  ::-->  ERROR: Parse failed");
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> END   - findDefaultOrganization");
        }
        return organization;
    }

    public String getCourseID() {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - getCourseID");
            System.out.println("  ::-->  " + this.mCourseID);
            System.out.println("  :: ADLSeqParser   --> END   - getCourseID");
        }
        return this.mCourseID;
    }

    public String getOrganizationID() {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - getOrganizationID");
            System.out.println("  ::-->  " + this.mOrganizationID);
            System.out.println("  :: ADLSeqParser   --> END   - getOrganizationID");
        }
        return this.mOrganizationID;
    }

    public String getScopeID() {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - getScopeID");
            System.out.println("  ::-->  " + this.mGlobalToSystem);
        }
        String scopeID = null;
        if (!this.mGlobalToSystem) {
            scopeID = this.mCourseID + "__" + this.mOrganizationID;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + scopeID);
            System.out.println("  :: ADLSeqParser   --> END   - getScopeID");
        }
        return scopeID;
    }

    public Node getSequencingCollection() {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - getSequencingCollection");
            System.out.println("  ::-->  " + this.mSequencingCollection);
            System.out.println("  :: ADLSeqParser   --> END   - getSequencingCollection");
        }
        return this.mSequencingCollection;
    }

    private boolean parseFile() {
        boolean result;
        block17: {
            if (_Debug) {
                System.out.println("  :: ADLSeqParser   --> BEGIN - parseFile");
            }
            result = false;
            InputSource instanceInputSource = this.openSourceFile();
            if (instanceInputSource != null) {
                block16: {
                    try {
                        if (_Debug) {
                            System.out.println("  ::--> Calling super.parse()");
                        }
                        super.parse(instanceInputSource);
                        if (_Debug) {
                            System.out.println("  ::--> Parse complete");
                        }
                    }
                    catch (SAXException se) {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR: SAX exception");
                            System.out.println(se);
                        }
                    }
                    catch (IOException ioe) {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR: IO exception");
                            System.out.println(ioe);
                        }
                    }
                    catch (NullPointerException npe) {
                        if (!_Debug) break block16;
                        System.out.println("  ::--> ERROR: Null pointer");
                        System.out.println(npe);
                    }
                }
                try {
                    this.mDocument = this.getDocument();
                    if (this.mDocument.hasChildNodes()) {
                        result = true;
                    } else if (_Debug) {
                        System.out.println("  ::--> The document has no children.");
                    }
                }
                catch (NullPointerException npe) {
                    if (!_Debug) break block17;
                    System.out.println("  ::--> ERROR: Null pointer -- No Doc");
                    System.out.println(npe);
                }
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: ADLSeqParser   --> END   - parseFile");
        }
        return result;
    }

    private InputSource openSourceFile() {
        InputSource input;
        block13: {
            if (_Debug) {
                System.out.println("  :: ADLSeqParser   --> BEGIN - openSourceFile");
            }
            input = null;
            if (this.mFileToParse != null) {
                try {
                    File xmlFile = new File(this.mFileToParse);
                    if (xmlFile.isFile()) {
                        String tmp = xmlFile.getAbsolutePath();
                        if (_Debug) {
                            System.out.println("  ::--> Found XML File: " + tmp);
                        }
                        FileReader fr = new FileReader(xmlFile);
                        input = new InputSource(fr);
                    }
                    break block13;
                }
                catch (NullPointerException npe) {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: Null pointer");
                        System.out.println(npe);
                    }
                    break block13;
                }
                catch (SecurityException se) {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: Security exception");
                        System.out.println(se);
                    }
                    break block13;
                }
                catch (FileNotFoundException fnfe) {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: File not found");
                        System.out.println(fnfe);
                    }
                    break block13;
                }
            }
            if (_Debug) {
                System.out.println("  ::--> ERROR: No file to parse");
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> END   - openSourceFile");
        }
        return input;
    }

    private String getAttribute(Node iNode, String iAttribute) {
        if (_Debug) {
            System.out.println("  :: ADLSeqParser   --> BEGIN - getAttribute");
            System.out.println("  ::-->  " + iAttribute);
        }
        String value = null;
        NamedNodeMap attrs = iNode.getAttributes();
        if (attrs != null) {
            for (int k = 0; k < attrs.getLength(); ++k) {
                Attr currentAttrNode = (Attr)attrs.item(k);
                String currentNodeName = currentAttrNode.getLocalName();
                if (!currentNodeName.equalsIgnoreCase(iAttribute)) continue;
                value = currentAttrNode.getNodeValue();
            }
            if (value == null && _Debug) {
                System.out.println("  ::-->  The attribute \"" + iAttribute + "\" does not exist.");
            }
        } else if (_Debug) {
            System.out.println("  ::-->  This node has no attributes.");
        }
        if (_Debug) {
            System.out.println("  ::-->  " + value);
            System.out.println("  :: ADLSeqParser   --> END - getAttribute");
        }
        if (iAttribute.equals("identifier") || iAttribute.equals("default")) {
            value = decodeHandler.processWhitespace(value);
        }
        return value;
    }
}

