/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import org.adl.samplerte.util.LMSDBHandler;
import org.adl.sequencer.ADLAuxiliaryResource;
import org.adl.sequencer.ADLTOC;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqActivityTree;
import org.adl.sequencer.SeqCondition;
import org.adl.sequencer.SeqConditionSet;
import org.adl.sequencer.SeqObjective;
import org.adl.sequencer.SeqObjectiveMap;
import org.adl.sequencer.SeqRollupRule;
import org.adl.sequencer.SeqRollupRuleset;
import org.adl.sequencer.SeqRule;
import org.adl.sequencer.SeqRuleset;
import org.adl.util.debug.DebugIndicator;
import org.adl.util.decode.decodeHandler;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLSeqUtilities {
    private static final String ADLSEQ_NS = "http://www.adlnet.org/xsd/adlseq_v1p3";
    private static final String IMSSS_NS = "http://www.imsglobal.org/xsd/imsss";
    private static boolean _Debug = DebugIndicator.ON;

    public static SeqActivityTree buildActivityTree(Node iOrg, Node iColl) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - buildActivityTree");
        }
        SeqActivityTree tree = new SeqActivityTree();
        SeqActivity root = ADLSeqUtilities.bulidActivityNode(iOrg, iColl);
        if (root != null) {
            tree.setRoot(root);
            tree.setDepths();
            tree.setTreeCount();
            if (root.getChildren(true).size() == 1 && !((SeqActivity)root.getChildren(true).firstElement()).hasChildren(true) && root.getControlModeChoice() && !root.getControlModeFlow()) {
                root.setControlModeChoice(false);
                root.setControlModeFlow(true);
            }
        } else {
            tree = null;
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - buildActivityTree");
        }
        return tree;
    }

    public static void dumpTOC(Vector iTOC) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - dumpTOC");
            if (iTOC != null) {
                System.out.println("  ::-->  " + iTOC.size());
                ADLTOC temp = null;
                for (int i = 0; i < iTOC.size(); ++i) {
                    temp = (ADLTOC)iTOC.elementAt(i);
                    temp.dumpState();
                }
            } else {
                System.out.println("  ::--> NULL");
            }
            System.out.println("  :: ADLSeqUtilities  --> END   - dumpTOC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createGlobalObjs(String iLearnerID, String iScopeID, Vector iObjList) {
        block26: {
            Connection conn;
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - createGlobalObjs");
                System.out.println("  ::-->  " + iLearnerID);
                System.out.println("  ::-->  " + iScopeID);
            }
            if ((conn = LMSDBHandler.getConnection()) != null) {
                if (iLearnerID != null) {
                    if (iObjList != null) {
                        try {
                            PreparedStatement stmtCheckRecord = null;
                            String sqlCheckRecord = "SELECT * FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtCheckRecord = conn.prepareStatement(sqlCheckRecord);
                            ResultSet objRS = null;
                            for (int i = 0; i < iObjList.size(); ++i) {
                                String objID = decodeHandler.encodeObjectiveID((String)iObjList.elementAt(i));
                                if (_Debug) {
                                    System.out.println("  ::--> Checking for objective --> " + iLearnerID + " [" + iScopeID + "]" + " // " + objID);
                                }
                                PreparedStatement preparedStatement = stmtCheckRecord;
                                synchronized (preparedStatement) {
                                    stmtCheckRecord.setString(1, objID);
                                    stmtCheckRecord.setString(2, iLearnerID);
                                    if (iScopeID == null) {
                                        stmtCheckRecord.setString(3, "");
                                    } else {
                                        stmtCheckRecord.setString(3, iScopeID);
                                    }
                                    objRS = stmtCheckRecord.executeQuery();
                                }
                                PreparedStatement stmtCreateRecord = null;
                                if (objRS.next()) continue;
                                if (_Debug) {
                                    System.out.println("  ::--> Creating objective --> " + iLearnerID + " [" + iScopeID + "]" + " // " + objID);
                                }
                                String sqlCreateRecord = "INSERT INTO Objectives (objID, learnerID, scopeID, satisfied, measure, rawscore, minscore, maxscore, completion, progressmeasure) VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?, ?)";
                                PreparedStatement preparedStatement2 = stmtCreateRecord = conn.prepareStatement(sqlCreateRecord);
                                synchronized (preparedStatement2) {
                                    stmtCreateRecord.setString(1, objID);
                                    stmtCreateRecord.setString(2, iLearnerID);
                                    if (iScopeID == null) {
                                        stmtCreateRecord.setString(3, "");
                                    } else {
                                        stmtCreateRecord.setString(3, iScopeID);
                                    }
                                    stmtCreateRecord.setString(4, "unknown");
                                    stmtCreateRecord.setString(5, "unknown");
                                    stmtCreateRecord.setString(6, "unknown");
                                    stmtCreateRecord.setString(7, "unknown");
                                    stmtCreateRecord.setString(8, "unknown");
                                    stmtCreateRecord.setString(9, "unknown");
                                    stmtCreateRecord.setString(10, "unknown");
                                    stmtCreateRecord.executeUpdate();
                                }
                                stmtCreateRecord.close();
                            }
                            objRS.close();
                            stmtCheckRecord.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR: DB Failure");
                                e.printStackTrace();
                            }
                            break block26;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL Objective List");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL StudentID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - createGlobalObjs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGlobalObjs(String iLearnerID, String iScopeID, Vector iObjList) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - deleteGlobalObjs");
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iLearnerID != null) {
                if (iObjList != null) {
                    try {
                        PreparedStatement stmtDeleteRecord = null;
                        String sqlDeleteRecord = "DELETE FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtDeleteRecord = conn.prepareStatement(sqlDeleteRecord);
                        for (int i = 0; i < iObjList.size(); ++i) {
                            String objID = decodeHandler.encodeObjectiveID((String)iObjList.elementAt(i));
                            if (_Debug) {
                                System.out.println("  ::--> Attempting to delete record for --> " + iLearnerID + " [" + iScopeID + "]" + " // " + objID);
                            }
                            PreparedStatement preparedStatement = stmtDeleteRecord;
                            synchronized (preparedStatement) {
                                stmtDeleteRecord.setString(1, objID);
                                stmtDeleteRecord.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtDeleteRecord.setString(3, "");
                                } else {
                                    stmtDeleteRecord.setString(3, iScopeID);
                                }
                                stmtDeleteRecord.executeUpdate();
                                continue;
                            }
                        }
                        stmtDeleteRecord.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL objective list");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR: NULL StudentID");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR: NULL connection");
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - deleteGlobalObjs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearGlobalObjs(String iLearnerID, String iScopeID, Vector iObjList) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - clearGlobalObjs");
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iLearnerID != null) {
                if (iObjList != null) {
                    try {
                        PreparedStatement stmtClearRecord = null;
                        String sqlClearRecord = "UPDATE Objectives SET satisfied = ?, measure = ?,  rawscore = ?, minscore = ?,  maxscore = ?, completion = ?,  progressmeasure = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtClearRecord = conn.prepareStatement(sqlClearRecord);
                        for (int i = 0; i < iObjList.size(); ++i) {
                            String objID = decodeHandler.encodeObjectiveID((String)iObjList.elementAt(i));
                            if (_Debug) {
                                System.out.println("  ::--> Attempting to clear record for --> " + iLearnerID + " [" + iScopeID + "]" + " // " + objID);
                            }
                            PreparedStatement preparedStatement = stmtClearRecord;
                            synchronized (preparedStatement) {
                                stmtClearRecord.setString(1, "unknown");
                                stmtClearRecord.setString(2, "unknown");
                                stmtClearRecord.setString(3, "unknown");
                                stmtClearRecord.setString(4, "unknown");
                                stmtClearRecord.setString(5, "unknown");
                                stmtClearRecord.setString(6, "unknown");
                                stmtClearRecord.setString(7, "unknown");
                                stmtClearRecord.setString(8, objID);
                                stmtClearRecord.setString(9, iLearnerID);
                                if (iScopeID == null) {
                                    stmtClearRecord.setString(10, "");
                                } else {
                                    stmtClearRecord.setString(10, iScopeID);
                                }
                                stmtClearRecord.executeUpdate();
                                continue;
                            }
                        }
                        stmtClearRecord.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL objectives list");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR: NULL learnerID");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR: NULL connection");
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - clearGlobalObjs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjSatisfied(String iObjID, String iLearnerID, String iScopeID) {
        String satisfiedStatus;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjSatisfied");
                System.out.println("  ::--> " + iObjID);
                System.out.println("  ::--> " + iLearnerID);
                System.out.println("  ::--> " + iScopeID);
            }
            satisfiedStatus = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iLearnerID != null) {
                    if (iObjID != null) {
                        try {
                            PreparedStatement stmtSelectSatisfied = null;
                            ResultSet objRS = null;
                            String sqlSelectSatisfied = "SELECT satisfied FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectSatisfied = conn.prepareStatement(sqlSelectSatisfied);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectSatisfied;
                            synchronized (preparedStatement) {
                                stmtSelectSatisfied.setString(1, objID);
                                stmtSelectSatisfied.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectSatisfied.setString(3, "");
                                } else {
                                    stmtSelectSatisfied.setString(3, iScopeID);
                                }
                                objRS = stmtSelectSatisfied.executeQuery();
                            }
                            if (objRS.next()) {
                                satisfiedStatus = objRS.getString("satisfied");
                            } else {
                                if (_Debug) {
                                    System.out.println("  ::--> No result set");
                                }
                                satisfiedStatus = null;
                            }
                            objRS.close();
                            stmtSelectSatisfied.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL comp ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL learnerID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + satisfiedStatus);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjSatisfied");
        }
        return satisfiedStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjSatisfied(String iObjID, String iLearnerID, String iScopeID, String iSatisfied) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjSatisfied");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iSatisfied);
        }
        boolean success = true;
        if (!(iSatisfied.equals("unknown") || iSatisfied.equals("satisfied") || iSatisfied.equals("notSatisfied"))) {
            success = false;
            if (_Debug) {
                System.out.println("  ::--> Invalid value: " + iSatisfied);
                System.out.println("  ::-->  " + success);
                System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjSatisfied");
            }
            return success;
        }
        Connection conn = LMSDBHandler.getConnection();
        if (conn != null) {
            if (iLearnerID != null) {
                if (iObjID != null) {
                    try {
                        PreparedStatement stmtUpdateSatisfied = null;
                        String sqlUpdateSatisfied = "UPDATE Objectives SET satisfied = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateSatisfied = conn.prepareStatement(sqlUpdateSatisfied);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateSatisfied;
                        synchronized (preparedStatement) {
                            stmtUpdateSatisfied.setString(1, iSatisfied);
                            stmtUpdateSatisfied.setString(2, objID);
                            stmtUpdateSatisfied.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateSatisfied.setString(4, "");
                            } else {
                                stmtUpdateSatisfied.setString(4, iScopeID);
                            }
                            stmtUpdateSatisfied.executeUpdate();
                        }
                        stmtUpdateSatisfied.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR: DB Failure");
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL objective ID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL learnerID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjSatisfied");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjMeasure(String iObjID, String iLearnerID, String iScopeID) {
        String measure;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjMeasure");
            }
            measure = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iObjID != null) {
                    if (iLearnerID != null) {
                        try {
                            PreparedStatement stmtSelectMeasure = null;
                            ResultSet objRS = null;
                            String sqlSelectMeasure = "SELECT measure FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectMeasure = conn.prepareStatement(sqlSelectMeasure);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectMeasure;
                            synchronized (preparedStatement) {
                                stmtSelectMeasure.setString(1, objID);
                                stmtSelectMeasure.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectMeasure.setString(3, "");
                                } else {
                                    stmtSelectMeasure.setString(3, iScopeID);
                                }
                                objRS = stmtSelectMeasure.executeQuery();
                            }
                            if (objRS.next()) {
                                measure = objRS.getString("measure");
                            } else if (_Debug) {
                                System.out.println("  ::--> No resultset");
                            }
                            objRS.close();
                            stmtSelectMeasure.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL student ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL objective ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + measure);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjMeasure");
        }
        return measure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjMeasure(String iObjID, String iLearnerID, String iScopeID, String iMeasure) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjMeasure");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iMeasure);
        }
        boolean goodMeasure = true;
        boolean success = true;
        if (!iMeasure.equals("unknown")) {
            try {
                Double tempMeasure = new Double(iMeasure);
                double range = tempMeasure;
                if (range < -1.0 || range > 1.0) {
                    if (_Debug) {
                        System.out.println("  ::--> Invalid range:  " + iMeasure);
                    }
                    goodMeasure = false;
                }
            }
            catch (NumberFormatException e) {
                if (_Debug) {
                    System.out.println("  ::--> Invalid value:  " + iMeasure);
                }
                goodMeasure = false;
            }
            if (!goodMeasure) {
                success = false;
                if (_Debug) {
                    System.out.println("  ::--> " + success);
                    System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjMeasure");
                }
                return success;
            }
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iObjID != null) {
                if (iLearnerID != null) {
                    try {
                        PreparedStatement stmtUpdateMeasure = null;
                        String sqlUpdateMeasure = "UPDATE Objectives SET measure = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateMeasure = conn.prepareStatement(sqlUpdateMeasure);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateMeasure;
                        synchronized (preparedStatement) {
                            stmtUpdateMeasure.setString(1, iMeasure);
                            stmtUpdateMeasure.setString(2, objID);
                            stmtUpdateMeasure.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateMeasure.setString(4, "");
                            } else {
                                stmtUpdateMeasure.setString(4, iScopeID);
                            }
                            stmtUpdateMeasure.executeUpdate();
                        }
                        stmtUpdateMeasure.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL learnerID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL obj ID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjMeasure");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjRawScore(String iObjID, String iLearnerID, String iScopeID) {
        String rawscore;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjRawScore");
            }
            rawscore = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iObjID != null) {
                    if (iLearnerID != null) {
                        try {
                            PreparedStatement stmtSelectRawScore = null;
                            ResultSet objRS = null;
                            String sqlSelectRawScore = "SELECT rawscore FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectRawScore = conn.prepareStatement(sqlSelectRawScore);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectRawScore;
                            synchronized (preparedStatement) {
                                stmtSelectRawScore.setString(1, objID);
                                stmtSelectRawScore.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectRawScore.setString(3, "");
                                } else {
                                    stmtSelectRawScore.setString(3, iScopeID);
                                }
                                objRS = stmtSelectRawScore.executeQuery();
                            }
                            if (objRS.next()) {
                                rawscore = objRS.getString("rawscore");
                            } else if (_Debug) {
                                System.out.println("  ::--> No resultset");
                            }
                            objRS.close();
                            stmtSelectRawScore.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL student ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL objective ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + rawscore);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjRawScore");
        }
        return rawscore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjRawScore(String iObjID, String iLearnerID, String iScopeID, String iRawScore) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjRawScore");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iRawScore);
        }
        boolean success = true;
        if (!iRawScore.equals("unknown")) {
            try {
                Double.parseDouble(iRawScore);
            }
            catch (NumberFormatException e) {
                if (_Debug) {
                    System.out.println("  ::--> Invalid value:  " + iRawScore);
                }
                success = false;
                if (_Debug) {
                    System.out.println("  ::--> " + success);
                    System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjRawScore");
                }
                return success;
            }
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iObjID != null) {
                if (iLearnerID != null) {
                    try {
                        PreparedStatement stmtUpdateRawScore = null;
                        String sqlUpdateRawScore = "UPDATE Objectives SET rawscore = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateRawScore = conn.prepareStatement(sqlUpdateRawScore);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateRawScore;
                        synchronized (preparedStatement) {
                            stmtUpdateRawScore.setString(1, iRawScore);
                            stmtUpdateRawScore.setString(2, objID);
                            stmtUpdateRawScore.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateRawScore.setString(4, "");
                            } else {
                                stmtUpdateRawScore.setString(4, iScopeID);
                            }
                            stmtUpdateRawScore.executeUpdate();
                        }
                        stmtUpdateRawScore.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL learnerID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL obj ID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjRawScore");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjMinScore(String iObjID, String iLearnerID, String iScopeID) {
        String minscore;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjMinScore");
            }
            minscore = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iObjID != null) {
                    if (iLearnerID != null) {
                        try {
                            PreparedStatement stmtSelectMinScore = null;
                            ResultSet objRS = null;
                            String sqlSelectMinScore = "SELECT minscore FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectMinScore = conn.prepareStatement(sqlSelectMinScore);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectMinScore;
                            synchronized (preparedStatement) {
                                stmtSelectMinScore.setString(1, objID);
                                stmtSelectMinScore.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectMinScore.setString(3, "");
                                } else {
                                    stmtSelectMinScore.setString(3, iScopeID);
                                }
                                objRS = stmtSelectMinScore.executeQuery();
                            }
                            if (objRS.next()) {
                                minscore = objRS.getString("minscore");
                            } else if (_Debug) {
                                System.out.println("  ::--> No resultset");
                            }
                            objRS.close();
                            stmtSelectMinScore.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL student ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL objective ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + minscore);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjMinScore");
        }
        return minscore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjMinScore(String iObjID, String iLearnerID, String iScopeID, String iMinScore) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjMinScore");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iMinScore);
        }
        boolean success = true;
        if (!iMinScore.equals("unknown")) {
            try {
                Double.parseDouble(iMinScore);
            }
            catch (NumberFormatException e) {
                if (_Debug) {
                    System.out.println("  ::--> Invalid value:  " + iMinScore);
                }
                success = false;
                if (_Debug) {
                    System.out.println("  ::--> " + success);
                    System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjMinScore");
                }
                return success;
            }
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iObjID != null) {
                if (iLearnerID != null) {
                    try {
                        PreparedStatement stmtUpdateMinScore = null;
                        String sqlUpdateMinScore = "UPDATE Objectives SET minscore = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateMinScore = conn.prepareStatement(sqlUpdateMinScore);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateMinScore;
                        synchronized (preparedStatement) {
                            stmtUpdateMinScore.setString(1, iMinScore);
                            stmtUpdateMinScore.setString(2, objID);
                            stmtUpdateMinScore.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateMinScore.setString(4, "");
                            } else {
                                stmtUpdateMinScore.setString(4, iScopeID);
                            }
                            stmtUpdateMinScore.executeUpdate();
                        }
                        stmtUpdateMinScore.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL learnerID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL obj ID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjMinScore");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjMaxScore(String iObjID, String iLearnerID, String iScopeID) {
        String maxscore;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjMaxScore");
            }
            maxscore = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iObjID != null) {
                    if (iLearnerID != null) {
                        try {
                            PreparedStatement stmtSelectMaxScore = null;
                            ResultSet objRS = null;
                            String sqlSelectMaxScore = "SELECT maxscore FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectMaxScore = conn.prepareStatement(sqlSelectMaxScore);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectMaxScore;
                            synchronized (preparedStatement) {
                                stmtSelectMaxScore.setString(1, objID);
                                stmtSelectMaxScore.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectMaxScore.setString(3, "");
                                } else {
                                    stmtSelectMaxScore.setString(3, iScopeID);
                                }
                                objRS = stmtSelectMaxScore.executeQuery();
                            }
                            if (objRS.next()) {
                                maxscore = objRS.getString("maxscore");
                            } else if (_Debug) {
                                System.out.println("  ::--> No resultset");
                            }
                            objRS.close();
                            stmtSelectMaxScore.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL student ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL objective ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + maxscore);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjMaxScore");
        }
        return maxscore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjMaxScore(String iObjID, String iLearnerID, String iScopeID, String iMaxScore) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjMaxScore");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iMaxScore);
        }
        boolean success = true;
        if (!iMaxScore.equals("unknown")) {
            try {
                Double.parseDouble(iMaxScore);
            }
            catch (NumberFormatException e) {
                if (_Debug) {
                    System.out.println("  ::--> Invalid value:  " + iMaxScore);
                }
                success = false;
                if (_Debug) {
                    System.out.println("  ::--> " + success);
                    System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjMaxScore");
                }
                return success;
            }
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iObjID != null) {
                if (iLearnerID != null) {
                    try {
                        PreparedStatement stmtUpdateMaxScore = null;
                        String sqlUpdateMaxScore = "UPDATE Objectives SET maxscore = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateMaxScore = conn.prepareStatement(sqlUpdateMaxScore);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateMaxScore;
                        synchronized (preparedStatement) {
                            stmtUpdateMaxScore.setString(1, iMaxScore);
                            stmtUpdateMaxScore.setString(2, objID);
                            stmtUpdateMaxScore.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateMaxScore.setString(4, "");
                            } else {
                                stmtUpdateMaxScore.setString(4, iScopeID);
                            }
                            stmtUpdateMaxScore.executeUpdate();
                        }
                        stmtUpdateMaxScore.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL learnerID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL obj ID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjMaxScore");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjCompletion(String iObjID, String iLearnerID, String iScopeID) {
        String completion;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjCompletion");
            }
            completion = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iObjID != null) {
                    if (iLearnerID != null) {
                        try {
                            PreparedStatement stmtSelectCompletion = null;
                            ResultSet objRS = null;
                            String sqlSelectCompletion = "SELECT completion FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectCompletion = conn.prepareStatement(sqlSelectCompletion);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectCompletion;
                            synchronized (preparedStatement) {
                                stmtSelectCompletion.setString(1, objID);
                                stmtSelectCompletion.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectCompletion.setString(3, "");
                                } else {
                                    stmtSelectCompletion.setString(3, iScopeID);
                                }
                                objRS = stmtSelectCompletion.executeQuery();
                            }
                            if (objRS.next()) {
                                completion = objRS.getString("completion");
                            } else if (_Debug) {
                                System.out.println("  ::--> No resultset");
                            }
                            objRS.close();
                            stmtSelectCompletion.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL student ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL objective ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + completion);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjCompletion");
        }
        return completion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjCompletion(String iObjID, String iLearnerID, String iScopeID, String iCompletion) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjCompletion");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iCompletion);
        }
        boolean success = true;
        if (!(iCompletion.equals("unknown") || iCompletion.equals("completed") || iCompletion.equals("incomplete") || iCompletion.equals("not attempted"))) {
            success = false;
            if (_Debug) {
                System.out.println("  ::--> Invalid value: " + iCompletion);
                System.out.println("  ::-->  " + success);
                System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjCompletion");
            }
            return success;
        }
        Connection conn = LMSDBHandler.getConnection();
        if (conn != null) {
            if (iLearnerID != null) {
                if (iObjID != null) {
                    try {
                        PreparedStatement stmtUpdateCompletion = null;
                        String sqlUpdateCompletion = "UPDATE Objectives SET completion = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateCompletion = conn.prepareStatement(sqlUpdateCompletion);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateCompletion;
                        synchronized (preparedStatement) {
                            stmtUpdateCompletion.setString(1, iCompletion.equals("not attempted") ? "incomplete" : iCompletion);
                            stmtUpdateCompletion.setString(2, objID);
                            stmtUpdateCompletion.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateCompletion.setString(4, "");
                            } else {
                                stmtUpdateCompletion.setString(4, iScopeID);
                            }
                            stmtUpdateCompletion.executeUpdate();
                        }
                        stmtUpdateCompletion.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR: DB Failure");
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL objective ID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL learnerID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjCompletion");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalObjProgressMeasure(String iObjID, String iLearnerID, String iScopeID) {
        String measure;
        block21: {
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - getGlobalObjProgressMeasure");
            }
            measure = null;
            Connection conn = LMSDBHandler.getConnection();
            if (conn != null) {
                if (iObjID != null) {
                    if (iLearnerID != null) {
                        try {
                            PreparedStatement stmtSelectMeasure = null;
                            ResultSet objRS = null;
                            String sqlSelectMeasure = "SELECT progressmeasure FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                            stmtSelectMeasure = conn.prepareStatement(sqlSelectMeasure);
                            String objID = decodeHandler.encodeObjectiveID(iObjID);
                            PreparedStatement preparedStatement = stmtSelectMeasure;
                            synchronized (preparedStatement) {
                                stmtSelectMeasure.setString(1, objID);
                                stmtSelectMeasure.setString(2, iLearnerID);
                                if (iScopeID == null) {
                                    stmtSelectMeasure.setString(3, "");
                                } else {
                                    stmtSelectMeasure.setString(3, iScopeID);
                                }
                                objRS = stmtSelectMeasure.executeQuery();
                            }
                            if (objRS.next()) {
                                measure = objRS.getString("progressmeasure");
                            } else if (_Debug) {
                                System.out.println("  ::--> No resultset");
                            }
                            objRS.close();
                            stmtSelectMeasure.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : NULL student ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : NULL objective ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + measure);
            System.out.println("  :: ADLSeqUtilities  --> END   - getGlobalObjProgressMeasure");
        }
        return measure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setGlobalObjProgressMeasure(String iObjID, String iLearnerID, String iScopeID, String iProgMeasure) {
        Connection conn;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setGlobalObjProgressMeasure");
            System.out.println("  ::--> " + iObjID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
            System.out.println("  ::--> " + iProgMeasure);
        }
        boolean goodMeasure = true;
        boolean success = true;
        if (!iProgMeasure.equals("unknown")) {
            try {
                double range = Double.parseDouble(iProgMeasure);
                if (range < 0.0 || range > 1.0) {
                    if (_Debug) {
                        System.out.println("  ::--> Invalid range:  " + iProgMeasure);
                    }
                    goodMeasure = false;
                }
            }
            catch (NumberFormatException e) {
                if (_Debug) {
                    System.out.println("  ::--> Invalid value:  " + iProgMeasure);
                }
                goodMeasure = false;
            }
            if (!goodMeasure) {
                success = false;
                if (_Debug) {
                    System.out.println("  ::--> " + success);
                    System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjProgressMeasure");
                }
                return success;
            }
        }
        if ((conn = LMSDBHandler.getConnection()) != null) {
            if (iObjID != null) {
                if (iLearnerID != null) {
                    try {
                        PreparedStatement stmtUpdateMeasure = null;
                        String sqlUpdateMeasure = "UPDATE Objectives SET progressmeasure = ? WHERE objID = ? AND learnerID = ? AND scopeID = ?";
                        stmtUpdateMeasure = conn.prepareStatement(sqlUpdateMeasure);
                        String objID = decodeHandler.encodeObjectiveID(iObjID);
                        PreparedStatement preparedStatement = stmtUpdateMeasure;
                        synchronized (preparedStatement) {
                            stmtUpdateMeasure.setString(1, iProgMeasure);
                            stmtUpdateMeasure.setString(2, objID);
                            stmtUpdateMeasure.setString(3, iLearnerID);
                            if (iScopeID == null) {
                                stmtUpdateMeasure.setString(4, "");
                            } else {
                                stmtUpdateMeasure.setString(4, iScopeID);
                            }
                            stmtUpdateMeasure.executeUpdate();
                        }
                        stmtUpdateMeasure.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR: DB Failure");
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL learnerID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL obj ID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setGlobalObjProgressMeasure");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCourseStatus(String iCourseID, String iLearnerID) {
        block21: {
            Connection conn;
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - createCourseStatus");
                System.out.println("  ::-->  " + iCourseID);
                System.out.println("  ::-->  " + iLearnerID);
            }
            if ((conn = LMSDBHandler.getConnection()) != null) {
                if (iLearnerID != null) {
                    if (iCourseID != null) {
                        try {
                            PreparedStatement stmtCheckRecord = null;
                            String sqlCheckRecord = "SELECT * FROM CourseStatus WHERE courseID = ? AND learnerID = ?";
                            stmtCheckRecord = conn.prepareStatement(sqlCheckRecord);
                            ResultSet objRS = null;
                            PreparedStatement preparedStatement = stmtCheckRecord;
                            synchronized (preparedStatement) {
                                stmtCheckRecord.setString(1, iCourseID);
                                stmtCheckRecord.setString(2, iLearnerID);
                                objRS = stmtCheckRecord.executeQuery();
                            }
                            PreparedStatement stmtCreateRecord = null;
                            if (!objRS.next()) {
                                if (_Debug) {
                                    System.out.println("  ::--> Creating course status --> " + iCourseID + "--> " + iLearnerID);
                                }
                                String sqlCreateRecord = "INSERT INTO CourseStatus (courseID, learnerID, satisfied, measure, completed, progmeasure) VALUES (?, ?, ? ,?, ?, ?)";
                                PreparedStatement preparedStatement2 = stmtCreateRecord = conn.prepareStatement(sqlCreateRecord);
                                synchronized (preparedStatement2) {
                                    stmtCreateRecord.setString(1, iCourseID);
                                    stmtCreateRecord.setString(2, iLearnerID);
                                    stmtCreateRecord.setString(3, "unknown");
                                    stmtCreateRecord.setString(4, "unknown");
                                    stmtCreateRecord.setString(5, "unknown");
                                    stmtCreateRecord.setString(6, "unknown");
                                    stmtCreateRecord.executeUpdate();
                                }
                                stmtCreateRecord.close();
                            }
                            objRS.close();
                            stmtCheckRecord.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR: DB Failure");
                                e.printStackTrace();
                            }
                            break block21;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL Course ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL Student ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - createCourseStatus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setCourseStatus(String iCourseID, String iLearnerID, String iSatisfied, String iMeasure, String iCompleted, String iProgMeasure) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - setCourseStatus");
            System.out.println("  ::--> " + iCourseID);
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iSatisfied);
            System.out.println("  ::--> " + iMeasure);
            System.out.println("  ::--> " + iCompleted);
            System.out.println("  ::--> " + iProgMeasure);
        }
        boolean success = true;
        if (!(iSatisfied.equals("unknown") || iSatisfied.equals("satisfied") || iSatisfied.equals("notSatisfied"))) {
            success = false;
            if (_Debug) {
                System.out.println("  ::--> Invalid value: " + iSatisfied);
                System.out.println("  ::-->  " + success);
                System.out.println("  :: ADLSeqUtilities  --> END   - setCourseStatus");
            }
            return success;
        }
        if (!(iCompleted.equals("unknown") || iCompleted.equals("completed") || iCompleted.equals("incomplete"))) {
            success = false;
            if (_Debug) {
                System.out.println("  ::--> Invalid value: " + iCompleted);
                System.out.println("  ::-->  " + success);
                System.out.println("  :: ADLSeqUtilities  --> END   - setCourseStatus");
            }
            return success;
        }
        try {
            double measure = Double.parseDouble(iMeasure);
            if (measure < -1.0 || measure > 1.0) {
                success = false;
            }
        }
        catch (Exception e) {
            success = false;
        }
        if (!success) {
            if (_Debug) {
                System.out.println("  ::--> Invalid value: " + iMeasure);
                System.out.println("  ::-->  " + success);
                System.out.println("  :: ADLSeqUtilities  --> END   - setCourseStatus");
            }
            return success;
        }
        try {
            double progmeasure = Double.parseDouble(iProgMeasure);
            if (progmeasure < 0.0 || progmeasure > 1.0) {
                success = false;
            }
        }
        catch (Exception e) {
            success = false;
        }
        if (!success) {
            if (_Debug) {
                System.out.println("  ::--> Invalid value: " + iProgMeasure);
                System.out.println("  ::-->  " + success);
                System.out.println("  :: ADLSeqUtilities  --> END   - setCourseStatus");
            }
            return success;
        }
        Connection conn = LMSDBHandler.getConnection();
        if (conn != null) {
            if (iLearnerID != null) {
                if (iCourseID != null) {
                    try {
                        PreparedStatement stmtUpdateSatisfied = null;
                        String sqlUpdateSatisfied = "UPDATE CourseStatus SET satisfied = ? ,measure = ? ,completed = ? ,progmeasure = ? WHERE courseID = ? AND learnerID = ?";
                        PreparedStatement preparedStatement = stmtUpdateSatisfied = conn.prepareStatement(sqlUpdateSatisfied);
                        synchronized (preparedStatement) {
                            stmtUpdateSatisfied.setString(1, iSatisfied);
                            stmtUpdateSatisfied.setString(2, iMeasure);
                            stmtUpdateSatisfied.setString(3, iCompleted);
                            stmtUpdateSatisfied.setString(4, iProgMeasure);
                            stmtUpdateSatisfied.setString(5, iCourseID);
                            stmtUpdateSatisfied.setString(6, iLearnerID);
                            stmtUpdateSatisfied.executeUpdate();
                        }
                        stmtUpdateSatisfied.close();
                    }
                    catch (Exception e) {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR: DB Failure");
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                        success = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL course ID");
                    }
                    success = false;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL learner ID");
                }
                success = false;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::--> " + success);
            System.out.println("  :: ADLSeqUtilities  --> END   - setCourseStatus");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCourseStatus(String iCourseID, String iLearnerID) {
        block16: {
            Connection conn;
            if (_Debug) {
                System.out.println("  :: ADLSeqUtilities  --> BEGIN - deleteCourseStatus");
            }
            if ((conn = LMSDBHandler.getConnection()) != null) {
                if (iLearnerID != null) {
                    if (iCourseID != null) {
                        try {
                            PreparedStatement stmtDeleteRecord = null;
                            String sqlDeleteRecord = "DELETE * FROM CourseStatus WHERE courseID = ? AND learnerID = ?";
                            PreparedStatement preparedStatement = stmtDeleteRecord = conn.prepareStatement(sqlDeleteRecord);
                            synchronized (preparedStatement) {
                                stmtDeleteRecord.setString(1, iCourseID);
                                stmtDeleteRecord.setString(2, iLearnerID);
                                stmtDeleteRecord.executeUpdate();
                            }
                            stmtDeleteRecord.close();
                        }
                        catch (Exception e) {
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR: DB Failure");
                                e.printStackTrace();
                            }
                            break block16;
                        }
                    }
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: NULL course ID");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR: NULL student ID");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR: NULL connection");
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - deleteCourseStatus");
        }
    }

    private static SeqActivity bulidActivityNode(Node iNode, Node iColl) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - buildActivityNode");
        }
        SeqActivity act = new SeqActivity();
        boolean error = false;
        String tempVal = null;
        act.setID(ADLSeqUtilities.getAttribute(iNode, "identifier"));
        tempVal = ADLSeqUtilities.getAttribute(iNode, "identifierref");
        if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
            act.setResourceID(tempVal);
        }
        if ((tempVal = ADLSeqUtilities.getAttribute(iNode, "isvisible")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
            act.setIsVisible(new Boolean(tempVal));
        }
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1) continue;
            if (curNode.getLocalName().equals("item")) {
                SeqActivity nestedAct;
                if (_Debug) {
                    System.out.println("  ::--> Found an <item> element");
                }
                if ((nestedAct = ADLSeqUtilities.bulidActivityNode(curNode, iColl)) != null) {
                    if (_Debug) {
                        System.out.println("  ::--> Adding child");
                    }
                    act.addChild(nestedAct);
                    continue;
                }
                error = true;
                continue;
            }
            if (curNode.getLocalName().equals("title")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <title> element");
                }
                act.setTitle(ADLSeqUtilities.getElementText(curNode, null));
                continue;
            }
            if (curNode.getLocalName().equals("completionThreshold")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <adlcp:completionThreshold> element");
                }
                ADLSeqUtilities.getCompThresholdAttributes(act, curNode);
                continue;
            }
            if (curNode.getLocalName().equals("data")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <adlcp:data> element");
                }
                ADLSeqUtilities.getDataStoreMaps(act, curNode);
                continue;
            }
            if (!curNode.getLocalName().equals("sequencing")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found the <sequencing> element");
            }
            Node seqInfo = curNode;
            tempVal = ADLSeqUtilities.getAttribute(curNode, "IDRef");
            if (tempVal != null) {
                Node seqGlobal;
                block35: {
                    String search = "imsss:sequencing[normalize-space(@ID)=normalize-space('" + tempVal + "')]";
                    if (_Debug) {
                        System.out.println("  ::--> Looking for XPATH --> " + search);
                    }
                    seqGlobal = null;
                    try {
                        seqGlobal = XPathAPI.selectSingleNode(iColl, search);
                    }
                    catch (Exception e) {
                        if (!_Debug) break block35;
                        System.out.println("  ::--> ERROR : In transform");
                        e.printStackTrace();
                    }
                }
                if (seqGlobal != null) {
                    if (_Debug) {
                        System.out.println("  ::--> FOUND");
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR: Not Found");
                    }
                    seqInfo = null;
                    error = true;
                }
                if (!error) {
                    NodeList seqChildren = seqInfo.getChildNodes();
                    NodeList seqColChildren = seqGlobal.getChildNodes();
                    boolean localExists = false;
                    for (int k = 0; k < seqColChildren.getLength(); ++k) {
                        Node scNode = seqColChildren.item(k);
                        if (scNode.getNodeType() != 1) continue;
                        if (_Debug) {
                            System.out.println("  ::--> SC definition");
                            System.out.println("  ::-->   " + k);
                            System.out.println("  ::-->  <" + scNode.getLocalName() + ">");
                        }
                        for (int l = 0; l < seqChildren.getLength(); ++l) {
                            Node localNode = seqChildren.item(l);
                            if (localNode.getNodeType() != 1) continue;
                            if (_Debug) {
                                System.out.println("  ::--> Local definition");
                                System.out.println("  ::-->   " + l);
                                System.out.println("  ::-->  <" + localNode.getLocalName() + ">");
                            }
                            if (!localNode.getNodeName().equals(scNode.getNodeName()) || !localNode.getNamespaceURI().equals(scNode.getNamespaceURI())) continue;
                            localExists = true;
                            break;
                        }
                        if (!localExists) {
                            try {
                                Node newLocal = scNode.cloneNode(true);
                                seqInfo.appendChild(newLocal);
                            }
                            catch (DOMException e) {
                                if (_Debug) {
                                    System.out.println("  ::--> ERROR: ");
                                    e.printStackTrace();
                                }
                                error = true;
                                seqInfo = null;
                            }
                        }
                        localExists = false;
                    }
                }
            }
            if (seqInfo == null) continue;
            boolean bl = error = !ADLSeqUtilities.extractSeqInfo(seqInfo, act);
            if (!_Debug) continue;
            System.out.println("  ::--> Extracted Sequencing Info");
        }
        if (act.getResourceID() == null && !act.hasChildren(true)) {
            error = true;
        }
        if (error) {
            act = null;
        }
        if (_Debug) {
            System.out.println("  ::--> error == " + error);
            System.out.println("  :: ADLSeqUtilities  --> END   - buildActivityNode");
        }
        return act;
    }

    private static void getCompThresholdAttributes(SeqActivity ioAct, Node iCurNode) {
        block8: {
            String tempval;
            block7: {
                tempval = ADLSeqUtilities.getAttribute(iCurNode, "completedByMeasure");
                if (tempval != null) {
                    ioAct.setProgressDeterminedByMeasure(Boolean.valueOf(tempval));
                }
                if ((tempval = ADLSeqUtilities.getAttribute(iCurNode, "minProgressMeasure")) != null) {
                    try {
                        ioAct.setProgressThreshold(Double.parseDouble(tempval));
                    }
                    catch (NumberFormatException nfe) {
                        if (!_Debug) break block7;
                        System.out.println("  ::--> Error - minProgressMeasure was not a number: " + tempval);
                    }
                }
            }
            if ((tempval = ADLSeqUtilities.getAttribute(iCurNode, "progressWeight")) != null) {
                try {
                    ioAct.setProgressWeight(Double.parseDouble(tempval));
                }
                catch (NumberFormatException nfe) {
                    if (!_Debug) break block8;
                    System.out.println("  ::--> Error - progressWeight was not a number: " + tempval);
                }
            }
        }
    }

    private static void getDataStoreMaps(SeqActivity ioAct, Node iCurNode) {
        NodeList children = iCurNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getLocalName().equals("map")) continue;
            String tempval = ADLSeqUtilities.getAttribute(curNode, "targetID");
            String id = tempval != null ? tempval : "";
            tempval = ADLSeqUtilities.getAttribute(curNode, "readSharedData");
            boolean readable = tempval == null || tempval.equalsIgnoreCase("true");
            tempval = ADLSeqUtilities.getAttribute(curNode, "writeSharedData");
            boolean writeable = tempval == null || tempval.equalsIgnoreCase("true");
            ioAct.addDataStore(id, readable, writeable);
        }
    }

    private static boolean extractSeqInfo(Node iNode, SeqActivity ioAct) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - extractSeqInfo");
        }
        boolean ok = true;
        String tempVal = null;
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1) continue;
            if (curNode.getLocalName().equals("controlMode")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <controlMode> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "choice")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setControlModeChoice(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "choiceExit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setControlModeChoiceExit(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "flow")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setControlModeFlow(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "forwardOnly")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setControlForwardOnly(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "useCurrentAttemptObjectiveInfo")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setUseCurObjective(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "useCurrentAttemptProgressInfo")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                ioAct.setUseCurProgress(new Boolean(tempVal));
                continue;
            }
            if (curNode.getLocalName().equals("sequencingRules")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <sequencingRules> element");
                }
                ok = ADLSeqUtilities.getSequencingRules(curNode, ioAct);
                continue;
            }
            if (curNode.getLocalName().equals("limitConditions")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <limitConditions> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "attemptLimit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setAttemptLimit(new Long(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "attemptAbsoluteDurationLimit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setAttemptAbDur(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "attemptExperiencedDurationLimit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setAttemptExDur(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "activityAbsoluteDurationLimit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setActivityAbDur(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "activityExperiencedDurationLimit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setActivityExDur(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "beginTimeLimit")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setBeginTimeLimit(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "endTimeLimit")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                ioAct.setEndTimeLimit(tempVal);
                continue;
            }
            if (curNode.getLocalName().equals("auxiliaryResources")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <auxiliaryResourcees> element");
                }
                ok = ADLSeqUtilities.getAuxResources(curNode, ioAct);
                continue;
            }
            if (curNode.getLocalName().equals("rollupRules")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <rollupRules> element");
                }
                ok = ADLSeqUtilities.getRollupRules(curNode, ioAct);
                continue;
            }
            if (curNode.getLocalName().equals("objectives")) {
                String ns = curNode.getNamespaceURI();
                if (ns == null) continue;
                if (ns.equals(IMSSS_NS)) {
                    if (_Debug) {
                        System.out.println("  ::--> Found the <imsss:objectives> element");
                    }
                    ok = ADLSeqUtilities.getIMSObjectives(curNode, ioAct);
                    continue;
                }
                if (!ns.equals(ADLSEQ_NS)) continue;
                if (_Debug) {
                    System.out.println("  ::--> Found the <adlseq:objectives> element");
                }
                ok = ADLSeqUtilities.getADLObjectives(curNode, ioAct);
                continue;
            }
            if (curNode.getLocalName().equals("randomizationControls")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <randomizationControls> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "randomizationTiming")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setRandomTiming(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "selectCount")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setSelectCount(new Integer(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "reorderChildren")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setReorderChildren(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "selectionTiming")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                ioAct.setSelectionTiming(tempVal);
                continue;
            }
            if (curNode.getLocalName().equals("deliveryControls")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <deliveryControls> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "tracked")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setIsTracked(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "completionSetByContent")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setSetCompletion(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "objectiveSetByContent")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                ioAct.setSetObjective(new Boolean(tempVal));
                continue;
            }
            if (curNode.getLocalName().equals("constrainedChoiceConsiderations")) {
                if (_Debug) {
                    System.out.println("  ::--> Found the <constrainedChoiceConsiderations> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "preventActivation")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    ioAct.setPreventActivation(new Boolean(tempVal));
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "constrainChoice")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                ioAct.setConstrainChoice(new Boolean(tempVal));
                continue;
            }
            if (!curNode.getLocalName().equals("rollupConsiderations")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found the <rollupConsiderations> element");
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "requiredForSatisfied")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                ioAct.setRequiredForSatisfied(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "requiredForNotSatisfied")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                ioAct.setRequiredForNotSatisfied(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "requiredForCompleted")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                ioAct.setRequiredForCompleted(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "requiredForIncomplete")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                ioAct.setRequiredForIncomplete(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "measureSatisfactionIfActive")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
            ioAct.setSatisfactionIfActive(new Boolean(tempVal));
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ok);
            System.out.println("  :: ADLSeqUtilities  --> END   - extractSeqInfo");
        }
        return ok;
    }

    private static boolean getADLObjectives(Node iNode, SeqActivity ioAct) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getADLObjectives");
        }
        boolean ok = true;
        String tempVal = null;
        Vector<SeqObjective> objectives = new Vector<SeqObjective>();
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Vector maps;
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getLocalName().equals("objective")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <adlseq:objective> element");
            }
            SeqObjective obj = new SeqObjective();
            tempVal = ADLSeqUtilities.getAttribute(curNode, "objectiveID");
            if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                obj.mObjID = tempVal;
            }
            if ((maps = ADLSeqUtilities.getADLObjectiveMaps(curNode)) != null) {
                obj.mMaps = maps;
            }
            objectives.add(obj);
        }
        ioAct.setObjectives(objectives);
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getObjectives");
        }
        return ok;
    }

    private static Vector getADLObjectiveMaps(Node iNode) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getADLObjectiveMaps");
        }
        String tempVal = null;
        Vector<SeqObjectiveMap> maps = new Vector<SeqObjectiveMap>();
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getLocalName().equals("mapInfo")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <mapInfo> element");
            }
            SeqObjectiveMap map = new SeqObjectiveMap();
            map.mReadMeasure = false;
            map.mReadStatus = false;
            tempVal = ADLSeqUtilities.getAttribute(curNode, "targetObjectiveID");
            if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mGlobalObjID = decodeHandler.processWhitespace(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readRawScore")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadRawScore = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readMinScore")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadMinScore = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readMaxScore")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadMaxScore = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readCompletionStatus")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadCompletionStatus = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readProgressMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadProgressMeasure = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeRawScore")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteRawScore = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeMinScore")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteMinScore = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeMaxScore")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteMaxScore = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeCompletionStatus")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteCompletionStatus = Boolean.valueOf(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeProgressMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteProgressMeasure = Boolean.valueOf(tempVal);
            }
            maps.add(map);
        }
        if (maps.size() == 0) {
            maps = null;
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getObjectiveMaps");
        }
        return maps;
    }

    private static boolean getAuxResources(Node iNode, SeqActivity ioAct) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getAuxResources");
        }
        boolean ok = true;
        String tempVal = null;
        Vector<ADLAuxiliaryResource> auxRes = new Vector<ADLAuxiliaryResource>();
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getLocalName().equals("auxiliaryResource")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <auxiliaryResource> element");
            }
            ADLAuxiliaryResource res = new ADLAuxiliaryResource();
            tempVal = ADLSeqUtilities.getAttribute(curNode, "purpose");
            if (tempVal != null) {
                res.mType = tempVal;
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "auxiliaryResourceID")) != null) {
                res.mResourceID = decodeHandler.processWhitespace(tempVal);
            }
            auxRes.add(res);
        }
        ioAct.setAuxResources(auxRes);
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getAuxResources");
        }
        return ok;
    }

    private static boolean isEmpty(String iValue) {
        return iValue.trim().length() == 0;
    }

    private static boolean getSequencingRules(Node iNode, SeqActivity ioAct) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getSequencingRules");
        }
        boolean ok = true;
        String tempVal = null;
        Vector<SeqRule> preRules = new Vector<SeqRule>();
        Vector<SeqRule> exitRules = new Vector<SeqRule>();
        Vector<SeqRule> postRules = new Vector<SeqRule>();
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curRule;
            int j;
            NodeList ruleInfo;
            SeqRule rule;
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1) continue;
            if (curNode.getLocalName().equals("preConditionRule")) {
                if (_Debug) {
                    System.out.println("  ::--> Found a <preConditionRule> element");
                }
                rule = new SeqRule();
                ruleInfo = curNode.getChildNodes();
                for (j = 0; j < ruleInfo.getLength(); ++j) {
                    curRule = ruleInfo.item(j);
                    if (curRule.getNodeType() != 1) continue;
                    if (curRule.getLocalName().equals("ruleConditions")) {
                        if (_Debug) {
                            System.out.println("  ::--> Found a <ruleConditions> element");
                        }
                        rule.mConditions = ADLSeqUtilities.extractSeqRuleConditions(curRule);
                        continue;
                    }
                    if (!curRule.getLocalName().equals("ruleAction")) continue;
                    if (_Debug) {
                        System.out.println("  ::--> Found a <ruleAction> element");
                    }
                    if ((tempVal = ADLSeqUtilities.getAttribute(curRule, "action")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                    rule.mAction = tempVal;
                }
                if (rule.mConditions != null && rule.mAction != null) {
                    preRules.add(rule);
                    continue;
                }
                if (!_Debug) continue;
                System.out.println("  ::--> ERROR : Invaild Pre SeqRule");
                continue;
            }
            if (curNode.getLocalName().equals("exitConditionRule")) {
                if (_Debug) {
                    System.out.println("  ::--> Found a <exitConditionRule> element");
                }
                rule = new SeqRule();
                ruleInfo = curNode.getChildNodes();
                for (int k = 0; k < ruleInfo.getLength(); ++k) {
                    curRule = ruleInfo.item(k);
                    if (curRule.getNodeType() != 1) continue;
                    if (curRule.getLocalName().equals("ruleConditions")) {
                        if (_Debug) {
                            System.out.println("  ::--> Found a <ruleConditions> element");
                        }
                        rule.mConditions = ADLSeqUtilities.extractSeqRuleConditions(curRule);
                        continue;
                    }
                    if (!curRule.getLocalName().equals("ruleAction")) continue;
                    if (_Debug) {
                        System.out.println("  ::--> Found a <ruleAction> element");
                    }
                    if ((tempVal = ADLSeqUtilities.getAttribute(curRule, "action")) == null) continue;
                    rule.mAction = tempVal;
                }
                if (rule.mConditions != null && rule.mAction != null) {
                    exitRules.add(rule);
                    continue;
                }
                if (!_Debug) continue;
                System.out.println("  ::--> ERROR : Invaild Exit SeqRule");
                continue;
            }
            if (!curNode.getLocalName().equals("postConditionRule")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <postConditionRule> element");
            }
            rule = new SeqRule();
            ruleInfo = curNode.getChildNodes();
            for (j = 0; j < ruleInfo.getLength(); ++j) {
                curRule = ruleInfo.item(j);
                if (curRule.getNodeType() != 1) continue;
                if (curRule.getLocalName().equals("ruleConditions")) {
                    if (_Debug) {
                        System.out.println("  ::--> Found a <ruleConditions> element");
                    }
                    rule.mConditions = ADLSeqUtilities.extractSeqRuleConditions(curRule);
                    continue;
                }
                if (!curRule.getLocalName().equals("ruleAction")) continue;
                if (_Debug) {
                    System.out.println("  ::--> Found a <ruleAction> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curRule, "action")) == null) continue;
                rule.mAction = tempVal;
            }
            if (rule.mConditions != null && rule.mAction != null) {
                postRules.add(rule);
                continue;
            }
            if (!_Debug) continue;
            System.out.println("  ::--> ERROR : Invaild Post SeqRule");
        }
        if (preRules.size() > 0) {
            SeqRuleset rules = new SeqRuleset(preRules);
            ioAct.setPreSeqRules(rules);
        }
        if (exitRules.size() > 0) {
            SeqRuleset rules = new SeqRuleset(exitRules);
            ioAct.setExitSeqRules(rules);
        }
        if (postRules.size() > 0) {
            SeqRuleset rules = new SeqRuleset(postRules);
            ioAct.setPostSeqRules(rules);
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getSequencingRules");
        }
        return ok;
    }

    private static SeqConditionSet extractSeqRuleConditions(Node iNode) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - extractSeqRuleConditions");
        }
        String tempVal = null;
        SeqConditionSet condSet = new SeqConditionSet();
        Vector<SeqCondition> conditions = new Vector<SeqCondition>();
        tempVal = ADLSeqUtilities.getAttribute(iNode, "conditionCombination");
        if (tempVal != null) {
            if (!ADLSeqUtilities.isEmpty(tempVal)) {
                condSet.mCombination = tempVal;
            }
        } else {
            condSet.mCombination = SeqConditionSet.COMBINATION_ALL;
        }
        NodeList condInfo = iNode.getChildNodes();
        for (int i = 0; i < condInfo.getLength(); ++i) {
            Node curCond = condInfo.item(i);
            if (curCond.getNodeType() != 1 || !curCond.getLocalName().equals("ruleCondition")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <Condition> element");
            }
            SeqCondition cond = new SeqCondition();
            tempVal = ADLSeqUtilities.getAttribute(curCond, "condition");
            if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                cond.mCondition = tempVal;
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curCond, "referencedObjective")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                cond.mObjID = tempVal;
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curCond, "measureThreshold")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                cond.mThreshold = new Double(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curCond, "operator")) != null) {
                cond.mNot = tempVal.equals("not");
            }
            conditions.add(cond);
        }
        if (conditions.size() > 0) {
            condSet.mConditions = conditions;
        } else {
            condSet = null;
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - extractSeqRuleConditions");
        }
        return condSet;
    }

    private static boolean getRollupRules(Node iNode, SeqActivity ioAct) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getRollupRules");
        }
        boolean ok = true;
        String tempVal = null;
        Vector<SeqRollupRule> rollupRules = new Vector<SeqRollupRule>();
        tempVal = ADLSeqUtilities.getAttribute(iNode, "rollupObjectiveSatisfied");
        if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
            ioAct.setIsObjRolledUp(new Boolean(tempVal));
        }
        if ((tempVal = ADLSeqUtilities.getAttribute(iNode, "objectiveMeasureWeight")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
            ioAct.setObjMeasureWeight(new Double(tempVal));
        }
        if ((tempVal = ADLSeqUtilities.getAttribute(iNode, "rollupProgressCompletion")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
            ioAct.setIsProgressRolledUp(new Boolean(tempVal));
        }
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getLocalName().equals("rollupRule")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <rollupRule> element");
            }
            SeqRollupRule rule = new SeqRollupRule();
            tempVal = ADLSeqUtilities.getAttribute(curNode, "childActivitySet");
            if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                rule.mChildActivitySet = tempVal;
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "minimumCount")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                rule.mMinCount = new Long(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "minimumPercent")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                rule.mMinPercent = new Double(tempVal);
            }
            rule.mConditions = new SeqConditionSet(true);
            Vector<SeqCondition> conditions = new Vector<SeqCondition>();
            NodeList ruleInfo = curNode.getChildNodes();
            for (int j = 0; j < ruleInfo.getLength(); ++j) {
                Node curRule = ruleInfo.item(j);
                if (curRule.getNodeType() != 1) continue;
                if (curRule.getLocalName().equals("rollupConditions")) {
                    if (_Debug) {
                        System.out.println("  ::--> Found a <rollupConditions> element");
                    }
                    if ((tempVal = ADLSeqUtilities.getAttribute(curRule, "conditionCombination")) != null) {
                        if (!ADLSeqUtilities.isEmpty(tempVal)) {
                            rule.mConditions.mCombination = tempVal;
                        }
                    } else {
                        rule.mConditions.mCombination = SeqConditionSet.COMBINATION_ANY;
                    }
                    NodeList conds = curRule.getChildNodes();
                    for (int k = 0; k < conds.getLength(); ++k) {
                        Node con = conds.item(k);
                        if (con.getNodeType() != 1 || !con.getLocalName().equals("rollupCondition")) continue;
                        if (_Debug) {
                            System.out.println("  ::--> Found a <rollupCondition> element");
                        }
                        SeqCondition cond = new SeqCondition();
                        tempVal = ADLSeqUtilities.getAttribute(con, "condition");
                        if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                            cond.mCondition = tempVal;
                        }
                        if ((tempVal = ADLSeqUtilities.getAttribute(con, "operator")) != null) {
                            cond.mNot = tempVal.equals("not");
                        }
                        conditions.add(cond);
                    }
                    continue;
                }
                if (!curRule.getLocalName().equals("rollupAction")) continue;
                if (_Debug) {
                    System.out.println("  ::--> Found a <rollupAction> element");
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curRule, "action")) == null || ADLSeqUtilities.isEmpty(tempVal)) continue;
                rule.setRollupAction(tempVal);
            }
            rule.mConditions.mConditions = conditions;
            rollupRules.add(rule);
        }
        if (rollupRules != null) {
            SeqRollupRuleset rules = new SeqRollupRuleset(rollupRules);
            ioAct.setRollupRules(rules);
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getRollupRules");
        }
        return ok;
    }

    private static boolean getIMSObjectives(Node iNode, SeqActivity ioAct) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getIMSObjectives");
        }
        boolean ok = true;
        String tempVal = null;
        Vector<SeqObjective> objectives = new Vector<SeqObjective>();
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Vector maps;
            SeqObjective obj;
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1) continue;
            if (curNode.getLocalName().equals("primaryObjective")) {
                if (_Debug) {
                    System.out.println("  ::--> Found a <primaryObjective> element");
                }
                obj = new SeqObjective();
                obj.mContributesToRollup = true;
                tempVal = ADLSeqUtilities.getAttribute(curNode, "objectiveID");
                if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    obj.mObjID = tempVal;
                }
                if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "satisfiedByMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    obj.mSatisfiedByMeasure = new Boolean(tempVal);
                }
                if ((tempVal = ADLSeqUtilities.getElementText(curNode, "minNormalizedMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                    obj.mMinMeasure = new Double(tempVal);
                }
                if ((maps = ADLSeqUtilities.getIMSObjectiveMaps(curNode)) != null) {
                    obj.mMaps = maps;
                }
                obj.mContributesToRollup = true;
                objectives.add(obj);
                continue;
            }
            if (!curNode.getLocalName().equals("objective")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <imsss:objective> element");
            }
            obj = new SeqObjective();
            tempVal = ADLSeqUtilities.getAttribute(curNode, "objectiveID");
            if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                obj.mObjID = tempVal;
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "satisfiedByMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                obj.mSatisfiedByMeasure = new Boolean(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getElementText(curNode, "minNormalizedMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                obj.mMinMeasure = new Double(tempVal);
            }
            if ((maps = ADLSeqUtilities.getIMSObjectiveMaps(curNode)) != null) {
                obj.mMaps = maps;
            }
            objectives.add(obj);
        }
        ioAct.setObjectives(objectives);
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getObjectives");
        }
        return ok;
    }

    private static Vector getIMSObjectiveMaps(Node iNode) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getIMSObjectiveMaps");
        }
        String tempVal = null;
        Vector<SeqObjectiveMap> maps = new Vector<SeqObjectiveMap>();
        NodeList children = iNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getLocalName().equals("mapInfo")) continue;
            if (_Debug) {
                System.out.println("  ::--> Found a <mapInfo> element");
            }
            SeqObjectiveMap map = new SeqObjectiveMap();
            tempVal = ADLSeqUtilities.getAttribute(curNode, "targetObjectiveID");
            if (tempVal != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mGlobalObjID = decodeHandler.processWhitespace(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readSatisfiedStatus")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadStatus = new Boolean(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "readNormalizedMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mReadMeasure = new Boolean(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeSatisfiedStatus")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteStatus = new Boolean(tempVal);
            }
            if ((tempVal = ADLSeqUtilities.getAttribute(curNode, "writeNormalizedMeasure")) != null && !ADLSeqUtilities.isEmpty(tempVal)) {
                map.mWriteMeasure = new Boolean(tempVal);
            }
            maps.add(map);
        }
        if (maps.size() == 0) {
            maps = null;
        }
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> END   - getObjectiveMaps");
        }
        return maps;
    }

    private static String getElementText(Node iNode, String iElement) {
        int i;
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getElementText");
            System.out.println("  ::-->  " + iElement);
        }
        String value = null;
        Node curNode = null;
        NodeList children = null;
        if (iElement != null && iNode != null) {
            children = iNode.getChildNodes();
            for (i = 0; i < children.getLength(); ++i) {
                curNode = children.item(i);
                if (curNode.getNodeType() != 1) continue;
                if (_Debug) {
                    System.out.println("  ::-->   " + i);
                    System.out.println("  ::-->  <" + curNode.getLocalName() + ">");
                }
                if (!curNode.getLocalName().equals(iElement)) continue;
                if (!_Debug) break;
                System.out.println("  ::--> Found <" + iElement + ">");
                break;
            }
            if (curNode != null) {
                String comp = curNode.getLocalName();
                if (comp != null) {
                    if (!comp.equals(iElement)) {
                        curNode = null;
                    }
                } else {
                    curNode = null;
                }
            }
        } else {
            curNode = iNode;
        }
        if (curNode != null) {
            if (_Debug) {
                System.out.println("  ::--> Looking at children");
            }
            if ((children = curNode.getChildNodes()) != null) {
                value = new String("");
                for (i = 0; i < children.getLength(); ++i) {
                    curNode = children.item(i);
                    if (curNode.getNodeType() != 3 && curNode.getNodeType() != 4) continue;
                    value = value + curNode.getNodeValue();
                }
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + value);
            System.out.println("  :: ADLSeqUtilities  --> END   - getElementText");
        }
        return value;
    }

    private static String getAttribute(Node iNode, String iAttribute) {
        if (_Debug) {
            System.out.println("  :: ADLSeqUtilities  --> BEGIN - getAttribute");
            System.out.println("  ::-->  " + iAttribute);
        }
        String value = null;
        NamedNodeMap attrs = iNode.getAttributes();
        if (attrs != null) {
            Node attr = attrs.getNamedItem(iAttribute);
            if (attr != null) {
                value = attr.getNodeValue();
            } else if (_Debug) {
                System.out.println("  ::-->  The attribute \"" + iAttribute + "\" does not exist.");
            }
        } else if (_Debug) {
            System.out.println("  ::-->  This node has no attributes.");
        }
        if (_Debug) {
            System.out.println("  ::-->  " + value);
            System.out.println("  :: ADLSeqUtilities  --> END - getAttribute");
        }
        if (iAttribute.equals("identifier") || iAttribute.equals("default") || iAttribute.equals("IDRef") || iAttribute.equals("ID") || iAttribute.equals("referencedObjective") || iAttribute.equals("objectiveID")) {
            value = decodeHandler.processWhitespace(value);
        }
        return value;
    }

    public static void deleteDataStore(boolean iDelete) {
        if (SeqActivityTree.dataStoreLoc != null) {
            String location = SeqActivityTree.dataStoreLoc;
            HashMap tempmap = SeqActivityTree.dsMap;
            File map = new File(location);
            boolean success = false;
            for (int i = 0; i < 100; ++i) {
                if (map.exists() && map.canWrite()) {
                    success = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                    map.createNewFile();
                    continue;
                }
                catch (IOException ioe) {
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (success) {
                if (iDelete) {
                    map.delete();
                } else {
                    try {
                        FileOutputStream dsfo = new FileOutputStream(map);
                        ObjectOutputStream dsoutFile = new ObjectOutputStream(dsfo);
                        dsoutFile.writeObject(tempmap);
                        dsoutFile.close();
                        dsfo.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        SeqActivityTree.dsMap = null;
    }
}

