/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.adl.sequencer.ADLAuxiliaryResource;
import org.adl.sequencer.ADLDuration;
import org.adl.sequencer.ADLLaunch;
import org.adl.sequencer.ADLSeqUtilities;
import org.adl.sequencer.ADLTOC;
import org.adl.sequencer.ADLTracking;
import org.adl.sequencer.ADLValidRequests;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqActivityTree;
import org.adl.sequencer.SeqNavigation;
import org.adl.sequencer.SeqObjective;
import org.adl.sequencer.SeqObjectiveMap;
import org.adl.sequencer.SeqReportActivityStatus;
import org.adl.sequencer.SeqRollupRuleset;
import org.adl.sequencer.SeqRule;
import org.adl.sequencer.SeqRuleset;
import org.adl.util.debug.DebugIndicator;

public class ADLSequencer
implements SeqNavigation,
SeqReportActivityStatus,
Serializable {
    private static final int FLOW_NONE = 0;
    private static final int FLOW_FORWARD = 1;
    private static final int FLOW_BACKWARD = 2;
    private static boolean _Debug = DebugIndicator.ON;
    private static String TER_EXIT = "_EXIT_";
    private static String TER_EXITALL = "_EXITALL_";
    private static String TER_SUSPENDALL = "_SUSPENDALL_";
    private static String TER_ABANDON = "_ABANDON_";
    private static String TER_ABANDONALL = "_ABANDONALL_";
    private static String SEQ_START = "_START_";
    private static String SEQ_RETRY = "_RETRY_";
    private static String SEQ_RESUMEALL = "_RESUMEALL_";
    private static String SEQ_EXIT = "_EXIT_";
    private static String SEQ_CONTINUE = "_CONTINUE_";
    private static String SEQ_PREVIOUS = "_PREVIOUS_";
    private SeqActivityTree mSeqTree = null;
    private boolean mEndSession = false;
    private boolean mExitCourse = false;
    private boolean mRetry = false;
    private boolean mExitAll = false;
    private boolean mValidTermination = true;
    private boolean mValidSequencing = true;
    private boolean mIsJump = false;

    public Vector getObjStatusSet(String iActivityID) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - getObjStatusSet");
        }
        Vector objSet = null;
        SeqActivity act = this.getActivity(iActivityID);
        if (act != null) {
            objSet = act.getObjStatusSet();
        } else if (_Debug) {
            System.out.println("  ::-->  Activity not found");
        }
        if (_Debug) {
            if (objSet == null) {
                System.out.println("  ::-->  NULL");
            } else {
                System.out.println("  ::-->  [ " + objSet.size() + " ]");
            }
            System.out.println("  :: ADLSequencer --> END   - getObjStatusSet");
        }
        return objSet;
    }

    public void getValidRequests(ADLValidRequests oValid) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - getValidRequests");
        }
        ADLValidRequests valid = null;
        if (this.mSeqTree != null && (valid = this.mSeqTree.getValidRequests()) != null) {
            this.validateRequests();
            valid = this.mSeqTree.getValidRequests();
        }
        if (valid != null) {
            oValid.mContinue = valid.mContinue;
            oValid.mContinueExit = valid.mContinueExit;
            oValid.mPrevious = valid.mPrevious;
            if (valid.mTOC != null) {
                oValid.mTOC = (Vector)valid.mTOC.clone();
            }
            if (valid.mChoice != null) {
                oValid.mChoice = (Hashtable)valid.mChoice.clone();
            }
            if (valid.mJump != null) {
                oValid.mJump = (Hashtable)valid.mJump.clone();
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR : Unable to validate requests");
            }
            oValid.mContinue = false;
            oValid.mContinueExit = false;
            oValid.mPrevious = false;
            oValid.mChoice = null;
            oValid.mTOC = null;
            oValid.mJump = null;
        }
        if (_Debug) {
            if (oValid == null) {
                System.out.println("  ::--> NULL");
            } else if (oValid.mChoice == null) {
                System.out.println("  ::--> [NULL]");
            } else {
                System.out.println("  ::--> [" + oValid.mChoice.size() + "]");
            }
            System.out.println("  :: ADLSequencer --> END   - getValidRequests");
        }
    }

    public void setActivityTree(SeqActivityTree iTree) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setActivityTree");
        }
        if (iTree != null) {
            this.mSeqTree = iTree;
            if (_Debug) {
                System.out.println("  ::--> Activity tree set.");
            }
        } else if (_Debug) {
            System.out.println("  ::--> NULL activity tree.");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setActivityTree");
        }
    }

    public SeqActivityTree getActivityTree() {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - getActivityTree");
            System.out.println("  :: ADLSequencer --> END   - getActivityTree");
        }
        return this.mSeqTree;
    }

    public SeqActivity getRoot() {
        SeqActivity rootActivity = null;
        if (this.mSeqTree != null) {
            rootActivity = this.mSeqTree.getRoot();
        }
        return rootActivity;
    }

    public void clearSeqState() {
        if (_Debug) {
            System.out.println("  ::--> Clear Session");
        }
        SeqActivity temp = null;
        this.mSeqTree.setCurrentActivity(temp);
        this.mSeqTree.setFirstCandidate(temp);
    }

    @Override
    public void reportSuspension(String iID, boolean iSuspended) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - reportSuspension");
            System.out.println("  ::--> Target activity: " + iID);
            System.out.println("  ::-->  " + iSuspended);
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setIsSuspended(iSuspended);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - reportSuspension");
        }
    }

    @Override
    public void setAttemptDuration(String iID, ADLDuration iDur) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptDuration");
            System.out.println("  ::--> " + iID);
            if (iDur != null) {
                System.out.println("  ::--> " + iDur.format(1));
            } else {
                System.out.println("  ::--> NULL");
            }
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive() && target.getIsTracked()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setCurAttemptExDur(iDur);
                    this.validateRequests();
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptDuration");
        }
    }

    @Override
    public void clearAttemptObjMeasure(String iID, String iObjID) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearAttemptObjMeasure");
            System.out.println("  ::--> Target activity: " + iID);
            System.out.println("  ::--> Objective:       " + iObjID);
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.clearObjMeasure(iObjID);
                    if (statusChange) {
                        this.validateRequests();
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearAttemptObjMeasure");
        }
    }

    @Override
    public void setAttemptObjMeasure(String iID, String iObjID, double iMeasure) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjMeasure");
            System.out.println("  ::--> Target activity: " + iID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Measure:         " + iMeasure);
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive() && target.getIsTracked()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setObjMeasure(iObjID, iMeasure);
                    this.validateRequests();
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjMeasure");
        }
    }

    @Override
    public void setAttemptObjSatisfied(String iID, String iObjID, String iStatus) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjSatisfied");
            System.out.println("  ::--> Target activity: " + iID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Status:          " + iStatus);
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive() && target.getIsTracked()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.setObjSatisfied(iObjID, iStatus);
                    if (statusChange) {
                        this.validateRequests();
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjSatisfied");
        }
    }

    @Override
    public void setAttemptProgressStatus(String iID, String iProgress) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptProgressStatus");
            System.out.println("  ::--> Target activity:    " + iID);
            System.out.println("  ::--> Completion status:  " + iProgress);
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive() && target.getIsTracked()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.setProgress(iProgress);
                    if (statusChange) {
                        this.validateRequests();
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptProgressStatus");
        }
    }

    @Override
    public ADLLaunch navigate(String iTarget, boolean iJumpRequest) {
        return iJumpRequest ? this.jump(iTarget) : this.choice(iTarget);
    }

    @Override
    public ADLLaunch navigate(int iRequest) {
        ADLLaunch launch;
        block93: {
            block92: {
                if (_Debug) {
                    System.out.println("  :: ADLSequencer --> BEGIN - navigate");
                    System.out.println("  ::--> " + iRequest);
                }
                launch = new ADLLaunch();
                if (this.mSeqTree == null) {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : No activity tree defined.");
                        System.out.println("  :: ADLSequencer --> END   - navigate");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
                    launch.mEndSession = true;
                    return launch;
                }
                boolean newSession = false;
                SeqActivity cur = this.mSeqTree.getCurrentActivity();
                if (cur == null) {
                    if (_Debug) {
                        System.out.println("  ::--> No current Activity -- New Session");
                    }
                    this.prepareClusters();
                    newSession = true;
                    this.validateRequests();
                }
                boolean process = true;
                ADLValidRequests valid = null;
                if (newSession && iRequest == 0) {
                    if (_Debug) {
                        System.out.println("  ::--> Processing a TOC request");
                    }
                } else if (newSession && (iRequest == 9 || iRequest == 6)) {
                    if (_Debug) {
                        System.out.println("  ::--> Exiting a session that hasn't started");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                    launch.mEndSession = true;
                    process = false;
                } else if (iRequest == 3 || iRequest == 4) {
                    this.validateRequests();
                    valid = this.mSeqTree.getValidRequests();
                    if (valid == null) {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR : Cannot validate request");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
                        launch.mEndSession = true;
                        process = false;
                    } else if (iRequest == 3) {
                        if (!valid.mContinue) {
                            if (_Debug) {
                                System.out.println("  ::--> Continue not valid");
                            }
                            process = false;
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                        }
                    } else if (!valid.mPrevious) {
                        if (_Debug) {
                            System.out.println("  ::--> Previous not valid");
                        }
                        process = false;
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                    }
                } else {
                    process = this.doIMSNavValidation(iRequest);
                    if (!process) {
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                    }
                }
                if (!process) break block92;
                this.mValidTermination = true;
                this.mValidSequencing = true;
                String seqReq = null;
                String delReq = null;
                switch (iRequest) {
                    case 1: {
                        delReq = this.doSequencingRequest(SEQ_START);
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 2: {
                        delReq = this.doSequencingRequest(SEQ_RESUMEALL);
                        if (this.mValidSequencing) {
                            SeqActivity act = this.getActivity(delReq);
                            if (act != null && act.hasChildren(false)) {
                                boolean bl = launch.mEndSession = this.mEndSession || this.mExitCourse;
                                if (!launch.mEndSession) {
                                    this.validateRequests();
                                    launch.mNavState = this.mSeqTree.getValidRequests();
                                }
                                launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                                break;
                            }
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 3: {
                        if (cur.getIsActive()) {
                            seqReq = this.doTerminationRequest(TER_EXIT, false);
                        }
                        if (this.mValidTermination) {
                            delReq = seqReq == null ? this.doSequencingRequest(SEQ_CONTINUE) : this.doSequencingRequest(seqReq);
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 4: {
                        if (cur.getIsActive()) {
                            seqReq = this.doTerminationRequest(TER_EXIT, false);
                        }
                        if (this.mValidTermination) {
                            delReq = seqReq == null ? this.doSequencingRequest(SEQ_PREVIOUS) : this.doSequencingRequest(seqReq);
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 5: {
                        seqReq = this.doTerminationRequest(TER_ABANDON, false);
                        if (this.mValidTermination) {
                            if (seqReq != null && _Debug) {
                                System.out.println("  ::--> ERROR : Postconditions Processed");
                            }
                            delReq = this.doSequencingRequest(SEQ_EXIT);
                            if (!this.mEndSession && !this.mExitCourse) {
                                if (_Debug) {
                                    System.out.println("  ::--> REVALIDATE");
                                }
                                this.validateRequests();
                            }
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_ABANDON;
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 6: {
                        seqReq = this.doTerminationRequest(TER_ABANDONALL, false);
                        if (this.mValidTermination) {
                            if (seqReq != null && _Debug) {
                                System.out.println("  ::--> ERROR : Postconditions Processed");
                            }
                            delReq = this.doSequencingRequest(SEQ_EXIT);
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_ABANDONALL;
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 7: {
                        seqReq = this.doTerminationRequest(TER_SUSPENDALL, false);
                        if (this.mValidTermination) {
                            if (seqReq != null && _Debug) {
                                System.out.println("  ::--> ERROR : Postconditions Processed");
                            }
                            delReq = this.doSequencingRequest(SEQ_EXIT);
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 8: {
                        seqReq = this.doTerminationRequest(TER_EXIT, false);
                        if (this.mValidTermination) {
                            delReq = seqReq == null ? this.doSequencingRequest(SEQ_EXIT) : this.doSequencingRequest(seqReq);
                            if (!this.mEndSession && !this.mExitCourse) {
                                if (_Debug) {
                                    System.out.println("  ::--> REVALIDATE");
                                }
                                this.validateRequests();
                            }
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 9: {
                        seqReq = this.doTerminationRequest(TER_EXITALL, false);
                        if (this.mValidTermination) {
                            if (seqReq != null && _Debug) {
                                System.out.println("  ::--> ERROR : Postconditions Processed");
                            }
                            delReq = this.doSequencingRequest(SEQ_EXIT);
                        } else {
                            if (_Debug) {
                                System.out.println("  ::--> Invalid Termination");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                        }
                        if (this.mValidSequencing) {
                            this.doDeliveryRequest(delReq, false, launch);
                            break;
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Invalid Sequencing");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                        break;
                    }
                    case 0: {
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_TOC;
                        launch.mNavState = this.mSeqTree.getValidRequests();
                        if (launch.mNavState.mTOC == null) {
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                            break;
                        }
                        break block93;
                    }
                    default: {
                        if (_Debug) {
                            System.out.println("  ::-->  ERROR : Invalid navigation request: " + iRequest);
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
                    }
                }
                break block93;
            }
            if (_Debug) {
                System.out.println("  ::--> INVALID NAV REQUEST");
            }
            launch.mNavState = this.mSeqTree.getValidRequests();
            if (launch.mNavState == null) {
                if (_Debug) {
                    System.out.println("  ::--> Not Validated Yet -- DO IT NOW");
                }
                this.validateRequests();
                launch.mNavState = this.mSeqTree.getValidRequests();
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - navigate");
        }
        return launch;
    }

    private ADLLaunch choice(String iTarget) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - navigate[choice]");
            System.out.println("  :: [" + iTarget + "]");
        }
        ADLLaunch launch = new ADLLaunch();
        if (this.mSeqTree == null) {
            if (_Debug) {
                System.out.println("  ::--> ERROR : No activity tree defined.");
                System.out.println("  :: ADLSequencer --> END   - navigate[choice]");
            }
            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            launch.mEndSession = true;
            return launch;
        }
        SeqActivity target = this.getActivity(iTarget);
        if (target != null) {
            boolean newSession = false;
            SeqActivity cur = this.mSeqTree.getCurrentActivity();
            if (cur == null) {
                this.prepareClusters();
                newSession = true;
            }
            boolean process = true;
            this.validateRequests();
            if (!newSession) {
                ADLValidRequests valid = this.mSeqTree.getValidRequests();
                if (valid != null) {
                    if (valid.mChoice != null) {
                        ADLTOC test = (ADLTOC)valid.mChoice.get(iTarget);
                        if (test == null) {
                            if (_Debug) {
                                System.out.println("  ::--> Target not available");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                            process = false;
                        } else if (!test.mIsSelectable) {
                            if (_Debug) {
                                System.out.println("  ::--> Target not selectable");
                            }
                            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                            process = false;
                        }
                    } else {
                        if (_Debug) {
                            System.out.println("  ::--> No 'choice' enabled");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                        process = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : Cannot validate request");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
                    launch.mEndSession = true;
                    process = false;
                }
            }
            if (process) {
                this.mValidTermination = true;
                this.mValidSequencing = true;
                String seqReq = iTarget;
                String delReq = null;
                if (!newSession && cur.getIsActive() && (seqReq = this.doTerminationRequest(TER_EXIT, false)) == null) {
                    seqReq = iTarget;
                }
                if (this.mValidTermination) {
                    delReq = this.doSequencingRequest(seqReq);
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> Invalid Termination");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                }
                if (this.mValidSequencing) {
                    this.doDeliveryRequest(delReq, false, launch);
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> Invalid Sequencing");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> Bad Request");
                }
                launch.mNavState = this.mSeqTree.getValidRequests();
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR : The target activity is not in the tree");
            }
            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            launch.mEndSession = true;
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - navigate[choice]");
        }
        return launch;
    }

    private ADLLaunch jump(String iTarget) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - navigate[jump]");
            System.out.println("  :: [" + iTarget + "]");
        }
        this.mIsJump = true;
        ADLLaunch launch = new ADLLaunch();
        if (this.mSeqTree == null) {
            if (_Debug) {
                System.out.println("  ::--> ERROR : No activity tree defined.");
                System.out.println("  :: ADLSequencer --> END   - navigate[jump]");
            }
            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            launch.mEndSession = true;
            return launch;
        }
        SeqActivity target = this.getActivity(iTarget);
        if (target != null) {
            ADLValidRequests valid;
            boolean process = true;
            SeqActivity cur = this.mSeqTree.getCurrentActivity();
            if (cur == null) {
                if (_Debug) {
                    System.out.println("  ::--> There was no current activity. Cannot issue a start via jump.");
                }
                launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                process = false;
            }
            this.validateRequests();
            if (process && (valid = this.mSeqTree.getValidRequests()) != null) {
                if (valid.mJump != null) {
                    SeqActivity test = (SeqActivity)valid.mJump.get(iTarget);
                    if (test == null) {
                        if (_Debug) {
                            System.out.println("  ::--> Target not available");
                        }
                        launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR_INVALIDNAVREQ;
                        process = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> ERROR : Cannot validate request. No valid jump targets.");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
                    launch.mEndSession = true;
                    process = false;
                }
            }
            if (process) {
                this.mValidTermination = true;
                this.mValidSequencing = true;
                String seqReq = iTarget;
                String delReq = null;
                if (cur.getIsActive() && (seqReq = this.doTerminationRequest(TER_EXIT, false)) == null) {
                    seqReq = iTarget;
                }
                if (this.mValidTermination) {
                    delReq = this.doSequencingRequest(seqReq);
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> Invalid Termination");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
                }
                if (this.mValidSequencing) {
                    this.doDeliveryRequest(delReq, false, launch);
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> Invalid Sequencing");
                    }
                    launch.mSeqNonContent = ADLLaunch.LAUNCH_SEQ_BLOCKED;
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> Bad Request");
                }
                launch.mNavState = this.mSeqTree.getValidRequests();
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> ERROR : The target activity is not in the tree");
            }
            launch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            launch.mEndSession = true;
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - navigate[jump]");
        }
        this.mIsJump = false;
        return launch;
    }

    private SeqActivity getActivity(String iActivityID) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - getActivity");
            System.out.println("  ::-->  " + iActivityID);
        }
        SeqActivity thisActivity = null;
        if (this.mSeqTree != null) {
            thisActivity = this.mSeqTree.getActivity(iActivityID);
            if (_Debug) {
                System.out.println("  ::-->  FOUND");
                System.out.println("  :: ADLSequencer --> END   - getActivity");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : No Activity Tree");
            System.out.println("  :: ADLSequencer --> END   - getActivity");
        }
        return thisActivity;
    }

    private boolean doIMSNavValidation(int iRequest) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doIMSNavValidation");
        }
        boolean ok = true;
        boolean process = true;
        boolean newSession = false;
        SeqActivity cur = this.mSeqTree.getCurrentActivity();
        SeqActivity parent = null;
        if (cur == null) {
            newSession = true;
        } else {
            parent = cur.getParent();
        }
        switch (iRequest) {
            case 1: {
                if (newSession) break;
                if (_Debug) {
                    System.out.println("  ::--> 'Start' not valid");
                }
                process = false;
                break;
            }
            case 2: {
                ok = true;
                if (!newSession) {
                    ok = false;
                } else if (this.mSeqTree.getSuspendAll() == null) {
                    ok = false;
                }
                if (ok) break;
                if (_Debug) {
                    System.out.println("  ::--> 'ResumeAll' not valid");
                }
                process = false;
                break;
            }
            case 3: {
                if (newSession) {
                    if (_Debug) {
                        System.out.println("  ::--> 'Continue' not valid");
                    }
                    process = false;
                    break;
                }
                if (parent != null && parent.getControlModeFlow()) break;
                if (_Debug) {
                    System.out.println("  ::--> 'Continue' not valid");
                }
                process = false;
                break;
            }
            case 4: {
                if (newSession) {
                    if (_Debug) {
                        System.out.println("  ::--> 'Previous' not valid");
                    }
                    process = false;
                    break;
                }
                if (parent != null) {
                    if (parent.getControlModeFlow() && !parent.getControlForwardOnly()) break;
                    if (_Debug) {
                        System.out.println("  ::--> 'Previous' not valid -- Control Mode");
                    }
                    process = false;
                    break;
                }
                if (_Debug) {
                    System.out.println("  ::--> 'Previous' not valid -- NULL Parent");
                }
                process = false;
                break;
            }
            case 5: {
                ok = true;
                if (newSession) {
                    ok = false;
                } else if (!cur.getIsActive()) {
                    ok = false;
                }
                if (ok) break;
                if (_Debug) {
                    System.out.println("  ::--> 'Abandon' not valid");
                }
                process = false;
                break;
            }
            case 6: {
                if (!newSession) break;
                if (_Debug) {
                    System.out.println("  ::--> 'AbandonAll' not valid");
                }
                process = false;
                break;
            }
            case 7: {
                if (!newSession) break;
                if (_Debug) {
                    System.out.println("  ::--> 'Abandon' not valid");
                }
                process = false;
                break;
            }
            case 8: {
                if (newSession) {
                    ok = false;
                } else if (!cur.getIsActive()) {
                    ok = false;
                }
                if (ok) break;
                if (_Debug) {
                    System.out.println("  ::--> 'Exit' not valid");
                }
                process = false;
                break;
            }
            case 9: {
                if (!newSession) break;
                if (_Debug) {
                    System.out.println("  ::--> 'ExitAll' not valid");
                }
                process = false;
                break;
            }
            default: {
                if (_Debug) {
                    System.out.println("  ::--> Invalid navigation request: " + iRequest);
                }
                process = false;
            }
        }
        if (_Debug) {
            System.out.println("  ::--> " + process);
            System.out.println("  :: ADLSequencer --> END   - doIMSNavValidation");
        }
        return process;
    }

    private void validateRequests() {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - validateRequests");
        }
        ADLValidRequests valid = this.mSeqTree.getValidRequests();
        SeqActivity cur = this.mSeqTree.getCurrentActivity();
        if (cur != null) {
            boolean test = false;
            valid = new ADLValidRequests();
            ADLLaunch tempLaunch = new ADLLaunch();
            this.mValidTermination = true;
            this.mValidSequencing = true;
            Object seqReq = null;
            boolean seqReqSuccess = false;
            String delReq = null;
            if (cur.getIsActive()) {
                valid.mSuspend = true;
            }
            if (cur.getControlModeChoiceExit() || !cur.getIsActive()) {
                valid.mTOC = this.getTOC(this.mSeqTree.getRoot());
            }
            if (valid.mTOC != null) {
                Vector newTOC = new Vector();
                valid.mChoice = this.getChoiceSet(valid.mTOC, newTOC);
                valid.mTOC = newTOC.size() > 0 ? newTOC : null;
            }
            valid.mJump = this.getJumpSet();
            if (cur.getParent() != null) {
                if (_Debug) {
                    System.out.println("  ::--> Validate 'Continue'");
                }
                if (cur.getParent().getControlModeFlow()) {
                    valid.mContinue = true;
                }
                if (_Debug) {
                    System.out.println("  ::--> Validate 'Previous'");
                }
                if (test = this.doIMSNavValidation(4)) {
                    this.mValidSequencing = true;
                    delReq = this.doSequencingRequest(SEQ_PREVIOUS);
                    if (this.mValidSequencing) {
                        valid.mPrevious = this.doDeliveryRequest(delReq, true, tempLaunch);
                    }
                }
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> No current activity");
            }
            valid = new ADLValidRequests();
            if (_Debug) {
                System.out.println("  ::--> Validate 'Start' and 'Resume'");
            }
            if (this.mSeqTree.getSuspendAll() != null) {
                valid.mResume = true;
            } else {
                Walk walk = new Walk();
                walk.at = this.mSeqTree.getRoot();
                valid.mStart = this.processFlow(1, true, walk, false);
                if (valid.mStart) {
                    boolean ok = true;
                    while (walk.at != null && ok) {
                        if (_Debug) {
                            System.out.println("  ::-->  Checking --> " + walk.at.getID());
                        }
                        boolean bl = ok = !this.checkActivity(walk.at);
                        if (ok) {
                            walk.at = walk.at.getParent();
                            continue;
                        }
                        valid.mStart = false;
                    }
                }
            }
            if (_Debug) {
                if (valid.mStart) {
                    System.out.println("  ::--> 'Start' Request is VALID");
                } else {
                    System.out.println("  ::--> 'Start' Request is INVALID");
                }
                if (valid.mResume) {
                    System.out.println("  ::--> 'Resume All' Request is VALID");
                } else {
                    System.out.println("  ::--> 'Resume All' Request is INVALID");
                }
            }
            if (_Debug) {
                System.out.println("  ::--> Validate 'Choice' requests");
            }
            valid.mTOC = this.getTOC(this.mSeqTree.getRoot());
            if (valid.mTOC != null) {
                Vector newTOC = new Vector();
                valid.mChoice = this.getChoiceSet(valid.mTOC, newTOC);
                if (newTOC.size() > 0) {
                    valid.mTOC = newTOC;
                    if (_Debug) {
                        ADLSeqUtilities.dumpTOC(newTOC);
                    }
                } else {
                    valid.mTOC = null;
                }
            }
            valid.mJump = this.getJumpSet();
        }
        if (valid != null) {
            this.mSeqTree.setValidRequests(valid);
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - validateRequests");
        }
    }

    private Hashtable getJumpSet() {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN  -  getJumpSet()");
        }
        Hashtable<String, SeqActivity> jumptargets = new Hashtable<String, SeqActivity>();
        if (this.mSeqTree != null && this.mSeqTree.getActivityMap() != null) {
            for (SeqActivity act : this.mSeqTree.getActivityMap().values()) {
                if (act.getChildren(true) == null) {
                    if (!this.checkActivity(act)) {
                        jumptargets.put(act.getID(), act);
                        if (!_Debug) continue;
                        System.out.println("  :: act " + act.getID() + " added to jumptargets");
                        continue;
                    }
                    if (!_Debug) continue;
                    System.out.println("  :: act " + act.getID() + " is disabled or has limit condition");
                    continue;
                }
                if (!_Debug) continue;
                System.out.println("  :: act " + act.getID() + " is parent.");
            }
        } else if (_Debug) {
            System.out.println("  ::--> mSeqTree or the ActivityMap was null.");
            System.out.println("  ::--> mSeqTree null?: " + (this.mSeqTree == null));
            System.out.println("  ::--> ActivityMap null?: " + (this.mSeqTree.getActivityMap() == null));
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer  -->  END   - getJumpSet()");
        }
        return jumptargets;
    }

    private void evaluateExitRules(boolean iTentative) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - evaluateExitRules");
            System.out.println("  ::--> REAL? -- " + (iTentative ? "NO" : "YES"));
        }
        this.mExitCourse = false;
        SeqActivity start = this.mSeqTree.getCurrentActivity();
        SeqActivity exitAt = null;
        String exited = null;
        Vector<SeqActivity> path = new Vector<SeqActivity>();
        if (start != null) {
            SeqActivity parent;
            for (parent = start.getParent(); parent != null; parent = parent.getParent()) {
                if (_Debug) {
                    System.out.println("  ::--> Adding :: " + parent.getID());
                }
                path.add(parent);
            }
            while (path.size() > 0 && exited == null) {
                SeqRuleset exitRules;
                parent = (SeqActivity)path.elementAt(path.size() - 1);
                path.remove(path.size() - 1);
                if (_Debug) {
                    System.out.println("  ::--> Evaluating 'Exit' at -- " + parent.getID());
                }
                if ((exitRules = parent.getExitSeqRules()) != null) {
                    exited = exitRules.evaluate(2, parent, false);
                }
                if (exited == null) continue;
                exitAt = parent;
            }
            if (exited != null) {
                if (exitAt == this.mSeqTree.getRoot()) {
                    if (_Debug) {
                        System.out.println("  ::--> ROOT   <<< Exited");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> " + exitAt.getID() + "  <<< Exited");
                }
                if (!iTentative) {
                    this.terminateDescendentAttempts(exitAt);
                    this.endAttempt(exitAt, false);
                }
                this.mSeqTree.setFirstCandidate(exitAt);
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : NULL Current Activity");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - evaluateExitRules");
        }
    }

    private String doTerminationRequest(String iRequest, boolean iTentative) {
        Vector objectives;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doTerminationRequest");
            System.out.println("  ::--> Request:  " + iRequest);
            System.out.println("  ::--> Real?     " + (iTentative ? "NO" : "YES"));
        }
        String seqReq = null;
        this.mExitAll = false;
        if (iRequest == null) {
            this.mValidTermination = false;
            if (_Debug) {
                System.out.println("  ::--> NULL request");
                System.out.println("  :: ADLSequencer --> END   - doTerminationRequest");
            }
            return seqReq;
        }
        SeqActivity cur = this.mSeqTree.getCurrentActivity();
        if (cur == null) {
            this.mValidTermination = false;
            if (_Debug) {
                System.out.println("  ::--> No current activity");
                System.out.println("  :: ADLSequencer --> END   - doTerminationRequest");
            }
            return seqReq;
        }
        this.mSeqTree.setFirstCandidate(cur);
        if (iRequest.equals(TER_EXIT)) {
            if (cur.getIsActive()) {
                this.endAttempt(cur, iTentative);
                this.evaluateExitRules(iTentative);
                if (!cur.getIsSuspended()) {
                    boolean exited = false;
                    do {
                        exited = false;
                        SeqActivity process = this.mSeqTree.getFirstCandidate();
                        if (!this.mExitCourse) {
                            SeqRuleset postRules;
                            if (_Debug) {
                                System.out.println("  ::--> Evaluating 'POST' at -- " + process.getID());
                            }
                            if ((postRules = process.getPostSeqRules()) != null && !process.getIsSuspended()) {
                                String result = null;
                                result = postRules.evaluate(3, process, false);
                                if (result != null) {
                                    if (_Debug) {
                                        System.out.println("  ::--> " + result);
                                    }
                                    if (result.equals(SeqRule.SEQ_ACTION_RETRY)) {
                                        seqReq = SEQ_RETRY;
                                        if (process != this.mSeqTree.getRoot()) continue;
                                        iRequest = TER_EXITALL;
                                        continue;
                                    }
                                    if (result.equals(SeqRule.SEQ_ACTION_CONTINUE)) {
                                        seqReq = SEQ_CONTINUE;
                                        continue;
                                    }
                                    if (result.equals(SeqRule.SEQ_ACTION_PREVIOUS)) {
                                        seqReq = SEQ_PREVIOUS;
                                        continue;
                                    }
                                    if (result.equals(SeqRule.SEQ_ACTION_EXITALL)) {
                                        iRequest = TER_EXITALL;
                                        continue;
                                    }
                                    if (result.equals(SeqRule.SEQ_ACTION_EXITPARENT)) {
                                        if ((process = process.getParent()) == null) {
                                            if (!_Debug) continue;
                                            System.out.println("  ::--> ERROR ::  No parent to exit");
                                            continue;
                                        }
                                        this.mSeqTree.setFirstCandidate(process);
                                        this.endAttempt(process, iTentative);
                                        exited = true;
                                        continue;
                                    }
                                    if (result.equals(SeqRule.SEQ_ACTION_RETRYALL)) {
                                        seqReq = SEQ_RETRY;
                                        iRequest = TER_EXITALL;
                                        continue;
                                    }
                                    if (process != this.mSeqTree.getRoot()) continue;
                                    this.mExitCourse = true;
                                    continue;
                                }
                                if (!_Debug) continue;
                                System.out.println("  ::--> NULL Evaluation");
                                continue;
                            }
                            if (process != this.mSeqTree.getRoot()) continue;
                            this.mExitCourse = true;
                            continue;
                        }
                        if (!_Debug) continue;
                        System.out.println("  --> Exited Course");
                        seqReq = SEQ_EXIT;
                    } while (exited);
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> INVALID :: activity inactive");
                }
                this.mValidTermination = false;
            }
        }
        if (!iRequest.equals(TER_EXIT)) {
            if (iRequest.equals(TER_EXITALL)) {
                if (_Debug) {
                    System.out.println("  ::--> Processing EXIT ALL");
                }
                if (!iTentative) {
                    SeqActivity process = this.mSeqTree.getFirstCandidate();
                    if (process.getIsActive()) {
                        this.endAttempt(process, false);
                    }
                    this.terminateDescendentAttempts(this.mSeqTree.getRoot());
                    this.endAttempt(this.mSeqTree.getRoot(), false);
                    if (seqReq != SEQ_RETRY) {
                        seqReq = SEQ_EXIT;
                    }
                    this.mSeqTree.setFirstCandidate(this.mSeqTree.getRoot());
                }
                this.mSeqTree.setFirstCandidate(this.mSeqTree.getRoot());
            } else if (iRequest.equals(TER_SUSPENDALL)) {
                if (!iTentative) {
                    SeqActivity process = this.mSeqTree.getFirstCandidate();
                    this.reportSuspension(process.getID(), true);
                    if (process.getIsActive()) {
                        this.invokeRollup(process, null);
                        this.mSeqTree.setSuspendAll(process);
                        if (!process.getIsSuspended()) {
                            process.incrementSCOAttempt();
                        }
                    } else if (!process.getIsSuspended()) {
                        this.mSeqTree.setSuspendAll(process.getParent());
                        if (this.mSeqTree.getSuspendAll() == null) {
                            this.mValidTermination = false;
                        }
                    }
                    if (this.mValidTermination) {
                        for (SeqActivity start = this.mSeqTree.getSuspendAll(); start != null; start = start.getParent()) {
                            start.setIsActive(false);
                            start.setIsSuspended(true);
                        }
                    }
                }
                this.mSeqTree.setFirstCandidate(this.mSeqTree.getRoot());
            } else if (iRequest.equals(TER_ABANDON)) {
                if (!iTentative) {
                    SeqActivity process = this.mSeqTree.getFirstCandidate();
                    if (_Debug) {
                        System.out.println("  --> CLEARING STATE ABANDON");
                    }
                    process.setProgress(ADLTracking.TRACK_UNKNOWN);
                    process.setObjSatisfied(null, ADLTracking.TRACK_UNKNOWN);
                    process.clearObjMeasure(null);
                    process.setIsActive(false);
                }
            } else if (iRequest.equals(TER_ABANDONALL)) {
                if (!iTentative) {
                    SeqActivity process = this.mSeqTree.getFirstCandidate();
                    if (_Debug) {
                        System.out.println("  --> CLEARING STATE ABANDONALL");
                    }
                    process.setProgress(ADLTracking.TRACK_UNKNOWN);
                    process.setObjSatisfied(null, ADLTracking.TRACK_UNKNOWN);
                    process.clearObjMeasure(null);
                    while (process != null) {
                        process.setIsActive(false);
                        process = process.getParent();
                    }
                    seqReq = SEQ_EXIT;
                    this.mSeqTree.setFirstCandidate(this.mSeqTree.getRoot());
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> INVALID :: invalid request");
                }
                this.mValidTermination = false;
            }
        }
        if (!iTentative) {
            this.mSeqTree.setCurrentActivity(this.mSeqTree.getFirstCandidate());
        }
        String tmpID = this.mSeqTree.getFirstCandidate().getID();
        if (this.mSeqTree.getCurrentActivity() == this.mSeqTree.getRoot() && seqReq == SEQ_RETRY && this.mSeqTree.getScopeID() != null && (objectives = this.mSeqTree.getGlobalObjectives()) != null) {
            ADLSeqUtilities.clearGlobalObjs(this.mSeqTree.getLearnerID(), this.mSeqTree.getScopeID(), objectives);
        }
        ADLSeqUtilities.deleteDataStore((iRequest.equals(TER_ABANDONALL) || iRequest.equals(TER_EXITALL)) && !this.getRoot().getIsSuspended() && !this.mSeqTree.dataScopedForAllAttempts());
        if (_Debug) {
            System.out.println("  ::--> SEQ REQ      :: " + seqReq);
            System.out.println("  ::--> FIRST        :: " + tmpID);
            System.out.println("  ::--> EXIT COURSE  :: " + this.mExitCourse);
            System.out.println("  :: ADLSequencer --> END   - doTerminationRequest");
        }
        return seqReq;
    }

    private void invokeRollup(SeqActivity ioTarget, Vector iWriteObjIDs) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - invokeRollup");
            System.out.println("  ::-->  Start: " + ioTarget.getID());
        }
        Hashtable<String, Integer> rollupSet = new Hashtable<String, Integer>();
        if (ioTarget == this.mSeqTree.getCurrentActivity()) {
            if (_Debug) {
                System.out.println("  ::--> CASE #1 Rollup");
            }
            for (SeqActivity walk = ioTarget; walk != null; walk = walk.getParent()) {
                if (_Debug) {
                    System.out.println("  ::--> Adding :: " + walk.getID());
                }
                rollupSet.put(walk.getID(), new Integer(walk.getDepth()));
                Vector writeObjIDs = walk.getObjIDs(null, false);
                if (writeObjIDs == null) continue;
                for (int i = 0; i < writeObjIDs.size(); ++i) {
                    String objID = (String)writeObjIDs.elementAt(i);
                    if (_Debug) {
                        System.out.println("  ::--> Rolling up Obj -- " + objID);
                    }
                    Vector acts = this.mSeqTree.getObjMap(objID);
                    if (_Debug) {
                        System.out.println("  ACTS == " + acts);
                    }
                    if (acts == null) continue;
                    for (int j = 0; j < acts.size(); ++j) {
                        SeqActivity act = this.getActivity((String)acts.elementAt(j));
                        if (_Debug) {
                            System.out.println("  *+> " + j + " <+*  :: " + act.getID());
                        }
                        if ((act = act.getParent()) == null || !act.getIsSelected()) continue;
                        do {
                            if (_Debug) {
                                System.out.println("  ::--> Adding :: " + act.getID());
                            }
                            rollupSet.put(act.getID(), new Integer(act.getDepth()));
                        } while ((act = act.getParent()) != null && act != this.mSeqTree.getRoot());
                    }
                }
            }
            rollupSet.remove(ioTarget.getID());
        }
        if (iWriteObjIDs != null) {
            if (_Debug) {
                System.out.println("  ::--> CASE #2 Rollup");
            }
            for (int i = 0; i < iWriteObjIDs.size(); ++i) {
                String objID = (String)iWriteObjIDs.elementAt(i);
                if (_Debug) {
                    System.out.println("  ::--> Rolling up Obj -- " + objID);
                }
                Vector acts = this.mSeqTree.getObjMap(objID);
                if (_Debug) {
                    System.out.println("  ACTS == " + acts);
                }
                if (acts == null) continue;
                for (int j = 0; j < acts.size(); ++j) {
                    SeqActivity act = this.getActivity((String)acts.elementAt(j));
                    if (_Debug) {
                        System.out.println("  *+> " + j + " <+*  :: " + act.getID());
                    }
                    if ((act = act.getParent()) == null || !act.getIsSelected()) continue;
                    do {
                        if (_Debug) {
                            System.out.println("  ::--> Adding :: " + act.getID());
                        }
                        rollupSet.put(act.getID(), new Integer(act.getDepth()));
                    } while ((act = act.getParent()) != null && act != this.mSeqTree.getRoot());
                }
            }
        }
        while (rollupSet.size() != 0) {
            if (_Debug) {
                System.out.println("  ::--> Rollup Set Size == " + rollupSet.size());
                Enumeration theEnum = rollupSet.keys();
                while (theEnum.hasMoreElements()) {
                    String key = (String)theEnum.nextElement();
                    int thisDepth = (Integer)rollupSet.get(key);
                    System.out.println("  ::-->  " + key + "  //  " + thisDepth);
                }
            }
            SeqActivity deepest = null;
            int depth = -1;
            Enumeration theEnum = rollupSet.keys();
            while (theEnum.hasMoreElements()) {
                String key = (String)theEnum.nextElement();
                int thisDepth = (Integer)rollupSet.get(key);
                if (depth == -1) {
                    depth = thisDepth;
                    deepest = this.getActivity(key);
                    continue;
                }
                if (thisDepth < depth) continue;
                depth = thisDepth;
                deepest = this.getActivity(key);
            }
            if (deepest != null) {
                this.doOverallRollup(deepest, rollupSet);
                if (deepest != this.mSeqTree.getRoot()) continue;
                String satisfied = "unknown";
                if (deepest.getObjStatus(false)) {
                    satisfied = deepest.getObjSatisfied(false) ? "satisfied" : "notSatisfied";
                }
                String measure = "unknown";
                if (deepest.getObjMeasureStatus(false)) {
                    measure = new Double(deepest.getObjMeasure(false)).toString();
                }
                String completed = "unknown";
                if (deepest.getProgressStatus(false)) {
                    completed = deepest.getAttemptCompleted(false) ? "completed" : "incomplete";
                }
                String progmeasure = "unknown";
                if (deepest.getProMeasureStatus(false)) {
                    progmeasure = Double.toString(deepest.getProMeasure(false));
                }
                ADLSeqUtilities.setCourseStatus(this.mSeqTree.getCourseID(), this.mSeqTree.getLearnerID(), satisfied, measure, completed, progmeasure);
                continue;
            }
            if (!_Debug) continue;
            System.out.println("  :: ERROR :: No activity found");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - invokeRollup");
        }
    }

    private void doOverallRollup(SeqActivity ioTarget, Hashtable ioRollupSet) {
        SeqRollupRuleset rollupRules;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doOverallRollup");
            System.out.println("  ::-->  Target: " + ioTarget.getID());
        }
        if ((rollupRules = ioTarget.getRollupRules()) == null) {
            rollupRules = new SeqRollupRuleset();
        }
        rollupRules.evaluate(ioTarget);
        if (_Debug) {
            boolean objMeasureStatus = ioTarget.getObjMeasureStatus(false);
            double objMeasure = ioTarget.getObjMeasure(false);
            boolean objStatus = ioTarget.getObjStatus(false);
            boolean objSatisfied = ioTarget.getObjSatisfied(false);
            boolean proStatus = ioTarget.getProgressStatus(false);
            boolean proCompleted = ioTarget.getAttemptCompleted(false);
            System.out.println("  ::--> RESULTS");
            System.out.println("  :: OBJ Measure ::   " + objMeasureStatus + "  //  " + objMeasure);
            System.out.println("  :: OBJ Status  ::   " + objStatus + "  //  " + objSatisfied);
            System.out.println("  :: Progress    ::   " + proStatus + "  //  " + proCompleted);
        }
        ioRollupSet.remove(ioTarget.getID());
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - doOverallRollup");
        }
    }

    private void prepareClusters() {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - prepareClusters");
        }
        SeqActivity walk = this.mSeqTree.getRoot();
        Vector<SeqActivity> lookAt = new Vector<SeqActivity>();
        if (walk != null) {
            while (walk != null) {
                if (walk.hasChildren(true)) {
                    if (!walk.getSelectionTiming().equals(SeqActivity.TIMING_NEVER) && !walk.getSelection()) {
                        this.doSelection(walk);
                        walk.setSelection(true);
                    }
                    if (!walk.getRandomTiming().equals(SeqActivity.TIMING_NEVER) && !walk.getRandomized()) {
                        this.doRandomize(walk);
                        walk.setRandomized(true);
                    }
                    if (walk.hasChildren(false)) {
                        lookAt.add(walk);
                    }
                }
                if ((walk = walk.getNextSibling(false)) != null || lookAt.size() == 0) continue;
                walk = (SeqActivity)lookAt.elementAt(0);
                walk = (SeqActivity)walk.getChildren(false).elementAt(0);
                lookAt.remove(0);
            }
        } else if (_Debug) {
            System.out.println("  ERROR :: NULL Activity Tree");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - prepareClusters");
        }
    }

    private void doSelection(SeqActivity ioCluster) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doSelection");
            System.out.println("  ::-->  Target: " + ioCluster.getID());
        }
        if (ioCluster.getChildren(true) != null) {
            Random gen = new Random();
            int count = ioCluster.getSelectCount();
            Vector all = ioCluster.getChildren(true);
            if (_Debug) {
                System.out.println("  ::--> Cluster has '" + all.size() + "' " + " children");
            }
            Vector children = null;
            Vector<Integer> set = null;
            boolean ok = false;
            int rand = 0;
            int num = 0;
            int lookUp = 0;
            if (count > 0) {
                if (count < all.size()) {
                    if (_Debug) {
                        System.out.println("  ::--> Selecting --> " + count);
                    }
                    children = new Vector();
                    set = new Vector<Integer>();
                    while (set.size() < count) {
                        ok = false;
                        while (!ok) {
                            rand = gen.nextInt();
                            num = Math.abs(rand % all.size());
                            lookUp = set.indexOf(new Integer(num));
                            if (lookUp != -1) continue;
                            set.add(new Integer(num));
                            ok = true;
                            if (!_Debug) continue;
                            System.out.println("  ::--> ADDED --> " + num);
                        }
                    }
                    for (int i = 0; i < all.size(); ++i) {
                        lookUp = set.indexOf(new Integer(i));
                        if (lookUp == -1) continue;
                        children.add(all.elementAt(i));
                    }
                    ioCluster.setChildren(children, false);
                } else if (_Debug) {
                    System.out.println("  ::--> All Children Selected");
                }
            } else if (_Debug) {
                System.out.println("  ::--> No Children Selected");
            }
        } else if (_Debug) {
            System.out.println("  ::--> Not A Cluster");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - doSelection");
        }
    }

    private void doRandomize(SeqActivity ioCluster) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doRandomize");
            System.out.println("  ::-->  Target: " + ioCluster.getID());
        }
        if (ioCluster.getChildren(true) != null) {
            Random gen = new Random();
            Vector all = ioCluster.getChildren(false);
            if (_Debug) {
                System.out.println("  ::--> Cluster has '" + all.size() + "' " + " children to randomize");
            }
            Vector<Integer> set = null;
            boolean ok = false;
            int rand = 0;
            int num = 0;
            int lookUp = 0;
            if (ioCluster.getReorderChildren()) {
                Vector reorder = new Vector();
                set = new Vector<Integer>();
                for (int i = 0; i < all.size(); ++i) {
                    ok = false;
                    while (!ok) {
                        rand = gen.nextInt();
                        num = Math.abs(rand % all.size());
                        lookUp = set.indexOf(new Integer(num));
                        if (lookUp != -1) continue;
                        set.add(new Integer(num));
                        reorder.add(all.elementAt(num));
                        if (_Debug) {
                            System.out.println("  ::--> PLACED --> " + num);
                        }
                        ok = true;
                    }
                }
                ioCluster.setChildren(reorder, false);
            } else if (_Debug) {
                System.out.println("  ::--> Don't Reorder");
            }
        } else if (_Debug) {
            System.out.println("  ::--> Not A Cluster");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - doRandomize");
        }
    }

    private String doSequencingRequest(String iRequest) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doSequencingRequest");
            System.out.println("  ::-->  " + iRequest);
        }
        String delReq = null;
        this.mEndSession = false;
        SeqActivity from = this.mSeqTree.getFirstCandidate();
        if (iRequest.equals(SEQ_START)) {
            if (_Debug) {
                System.out.println("  ::--> Process 'Start' request.");
            }
            if (from == null) {
                Walk walk = new Walk();
                walk.at = this.mSeqTree.getRoot();
                boolean success = this.processFlow(1, true, walk, false);
                if (success) {
                    delReq = walk.at.getID();
                }
            } else if (_Debug) {
                System.out.println("  ::--> Session already begun");
            }
        } else if (iRequest.equals(SEQ_RESUMEALL)) {
            if (_Debug) {
                System.out.println("  ::--> Process 'Resume All' request.");
            }
            if (from == null) {
                SeqActivity resume = this.mSeqTree.getSuspendAll();
                if (resume != null) {
                    delReq = resume.getID();
                } else if (_Debug) {
                    System.out.println("  ::--> No suspended activity");
                }
            } else if (_Debug) {
                System.out.println("  ::--> Session already begun");
            }
        } else if (iRequest.equals(SEQ_CONTINUE)) {
            if (_Debug) {
                System.out.println("  ::--> Process 'Continue' request.");
            }
            if (from != null) {
                SeqActivity parent = from.getParent();
                if (parent == null || parent.getControlModeFlow()) {
                    Walk walk = new Walk();
                    walk.at = from;
                    boolean success = this.processFlow(1, false, walk, false);
                    if (success) {
                        delReq = walk.at.getID();
                    } else {
                        if (_Debug) {
                            System.out.println("  :+: CONTINUE FAILED :+:  --> " + walk.at.getID());
                        }
                        if (_Debug) {
                            System.out.println("  ::--> Walked Off the Tree");
                        }
                        this.terminateDescendentAttempts(this.mSeqTree.getRoot());
                        this.endAttempt(this.mSeqTree.getRoot(), false);
                        this.mSeqTree.setFirstCandidate(this.mSeqTree.getRoot());
                        this.mEndSession = true;
                    }
                }
            } else if (_Debug) {
                System.out.println("  ::--> Session hasn't begun");
            }
        } else if (iRequest.equals(SEQ_EXIT)) {
            if (_Debug) {
                System.out.println("  ::--> Process 'Exit' request.");
            }
            if (from != null) {
                if (!from.getIsActive()) {
                    SeqActivity parent = from.getParent();
                    if (parent == null) {
                        this.mEndSession = true;
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> Activity is still active");
                }
            } else if (_Debug) {
                System.out.println("  ::--> Session hasn't begun");
            }
        } else if (iRequest.equals(SEQ_PREVIOUS)) {
            if (_Debug) {
                System.out.println("  ::--> Process 'Previous' request.");
            }
            if (from != null) {
                SeqActivity parent = from.getParent();
                if (parent == null || parent.getControlModeFlow()) {
                    Walk walk = new Walk();
                    walk.at = from;
                    boolean success = this.processFlow(2, false, walk, false);
                    if (success) {
                        delReq = walk.at.getID();
                    }
                }
            } else if (_Debug) {
                System.out.println("  ::--> Session hasn't begun");
            }
        } else if (iRequest.equals(SEQ_RETRY)) {
            if (_Debug) {
                System.out.println("  ::--> Process 'Retry' request.");
            }
            if (from != null) {
                if (this.mExitAll || !from.getIsActive() && !from.getIsSuspended()) {
                    if (from.getChildren(false) != null) {
                        Walk walk = new Walk();
                        walk.at = from;
                        this.setRetry(true);
                        boolean success = this.processFlow(1, true, walk, false);
                        this.setRetry(false);
                        if (success) {
                            delReq = walk.at.getID();
                        }
                    } else {
                        delReq = from.getID();
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> Activity is active or suspended");
                }
            } else if (_Debug) {
                System.out.println("  ::--> Session hasn't begun");
            }
        } else if (this.mIsJump) {
            SeqActivity target = this.getActivity(iRequest);
            if (target != null) {
                delReq = target.getID();
            } else if (_Debug) {
                System.out.println("  ::--> target wan't in tree");
            }
        } else {
            SeqActivity target;
            if (_Debug) {
                System.out.println("  ::--> Process 'Choice' request.");
            }
            if ((target = this.getActivity(iRequest)) != null) {
                boolean process = true;
                SeqActivity parent = target.getParent();
                if (!target.getIsSelected()) {
                    process = false;
                    if (_Debug) {
                        System.out.println("  ::--> Activity not in parent's set of avaliable children");
                    }
                }
                if (process) {
                    SeqActivity walk = target;
                    while (walk != null) {
                        SeqRuleset hideRules = walk.getPreSeqRules();
                        String result = null;
                        if (hideRules != null) {
                            result = hideRules.evaluate(6, walk, false);
                        }
                        if (result != null) {
                            walk = null;
                            process = false;
                            if (!_Debug) continue;
                            System.out.println("  ::--> Activity hidden");
                            continue;
                        }
                        walk = walk.getParent();
                    }
                }
                if (process && parent != null && !parent.getControlModeChoice()) {
                    process = false;
                    if (_Debug) {
                        System.out.println("  ::--> Invalid control mode");
                    }
                }
                SeqActivity common = this.mSeqTree.getRoot();
                if (process) {
                    SeqActivity walk;
                    SeqActivity walk2;
                    if (from != null) {
                        common = this.findCommonAncestor(from, target);
                        if (common == null) {
                            process = false;
                            if (_Debug) {
                                System.out.println("  ::-->  ERROR : Invalid ancestor");
                            }
                        }
                    } else {
                        from = common;
                    }
                    if (_Debug) {
                        System.out.println("  :: CHOICE PROCESS ::");
                        if (from != null) {
                            System.out.println("  ::  F : " + from.getID());
                        } else {
                            System.out.println("  ::  F : NULL");
                        }
                        if (target != null) {
                            System.out.println("  ::  T : " + target.getID());
                        } else {
                            System.out.println("  ::  T : NULL");
                        }
                        if (common != null) {
                            System.out.println("  ::  C : " + common.getID());
                        } else {
                            System.out.println("  ::  C : NULL");
                        }
                    }
                    if (from == target) {
                        if (_Debug) {
                            System.out.println("  ::-->  Choice Case #1");
                        }
                    } else if (from.getParent() == target.getParent()) {
                        if (_Debug) {
                            System.out.println("  ::-->  Choice Case #2");
                        }
                        int dir = 1;
                        if (target.getActiveOrder() < from.getActiveOrder()) {
                            dir = 2;
                        }
                        walk2 = from;
                        while (walk2 != target && process) {
                            process = this.evaluateChoiceTraversal(dir, walk2);
                            if (dir == 1) {
                                walk2 = walk2.getNextSibling(false);
                                continue;
                            }
                            walk2 = walk2.getPrevSibling(false);
                        }
                    } else if (from == common) {
                        if (_Debug) {
                            System.out.println("  ::-->  Choice Case #3");
                        }
                        walk = target.getParent();
                        while (walk != from && process) {
                            process = this.evaluateChoiceTraversal(1, walk);
                            if (process && !walk.getIsActive() && walk.getPreventActivation()) {
                                process = false;
                                continue;
                            }
                            walk = walk.getParent();
                        }
                        if (process) {
                            process = this.evaluateChoiceTraversal(1, walk);
                        }
                    } else if (target == common) {
                        if (_Debug) {
                            System.out.println("  ::-->  Choice Case #4");
                        }
                        for (walk = from.getParent(); walk != target && process; walk = walk.getParent()) {
                            process = walk.getControlModeChoiceExit();
                        }
                    } else {
                        if (_Debug) {
                            System.out.println("  ::-->  Choice Case #5");
                        }
                        SeqActivity con = null;
                        for (walk2 = from.getParent(); walk2 != common && process; walk2 = walk2.getParent()) {
                            process = walk2.getControlModeChoiceExit();
                            if (!process || con != null || !walk2.getConstrainChoice()) continue;
                            con = walk2;
                        }
                        if (process && con != null) {
                            Walk walkCon = new Walk();
                            walkCon.at = con;
                            if (target.getCount() > con.getCount()) {
                                this.processFlow(1, false, walkCon, true);
                            } else {
                                this.processFlow(2, false, walkCon, true);
                            }
                            if (_Debug) {
                                System.out.println("  ::-->  Constrained Choice Eval");
                                System.out.println("  ::-->  Stopped at --> " + walkCon.at.getID());
                            }
                            if (target.getParent() != walkCon.at && target != walkCon.at) {
                                process = false;
                            }
                        }
                        walk2 = target.getParent();
                        while (walk2 != common && process) {
                            process = this.evaluateChoiceTraversal(1, walk2);
                            if (process && !walk2.getIsActive() && walk2.getPreventActivation()) {
                                process = false;
                                continue;
                            }
                            walk2 = walk2.getParent();
                        }
                        if (process) {
                            process = this.evaluateChoiceTraversal(1, walk2);
                        }
                    }
                    if (process) {
                        if (target.getChildren(false) != null) {
                            Walk walk3 = new Walk();
                            walk3.at = target;
                            boolean success = this.processFlow(1, true, walk3, false);
                            if (success) {
                                delReq = walk3.at.getID();
                            } else {
                                if (_Debug) {
                                    System.out.println("  ::--> Failed to find leaf");
                                    System.out.println("  ::--> Moving Current Activity");
                                    if (common == null) {
                                        System.out.println("  ::--> NULL");
                                    } else {
                                        System.out.println("  ::--> " + common.getID());
                                    }
                                }
                                if (this.mSeqTree.getCurrentActivity() != null && common != null) {
                                    this.terminateDescendentAttempts(common);
                                    this.endAttempt(common, false);
                                    this.mSeqTree.setCurrentActivity(target);
                                    this.mSeqTree.setFirstCandidate(target);
                                }
                            }
                        } else {
                            delReq = target.getID();
                        }
                    }
                }
            } else if (_Debug) {
                System.out.println("  ::-->  Target does not exist in the tree");
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + delReq);
            System.out.println("  ::-->  " + (this.mEndSession || this.mExitCourse));
            System.out.println("  :: ADLSequencer --> END   - doSequencingRequest");
        }
        return delReq;
    }

    private SeqActivity findCommonAncestor(SeqActivity iFrom, SeqActivity iTo) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - findCommonAncestor");
        }
        SeqActivity ancestor = null;
        boolean done = false;
        SeqActivity stepFrom = null;
        if (iFrom == null || iTo == null) {
            done = true;
        } else {
            stepFrom = !iFrom.hasChildren(false) ? iFrom.getParent() : iFrom;
            if (!iTo.hasChildren(false)) {
                iTo = iTo.getParent();
            }
        }
        while (!done) {
            boolean success = this.isDescendent(stepFrom, iTo);
            if (success) {
                ancestor = stepFrom;
                done = true;
                continue;
            }
            if (done) continue;
            stepFrom = stepFrom.getParent();
        }
        if (_Debug) {
            if (ancestor != null) {
                System.out.println("  ::-->  " + ancestor.getID());
            } else {
                System.out.println("  ::-->  NULL");
            }
            System.out.println("  :: ADLSequencer --> END   - findCommonAncestor");
        }
        return ancestor;
    }

    private boolean isDescendent(SeqActivity iRoot, SeqActivity iTarget) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - isDescendent");
            if (iRoot != null) {
                System.out.println("  ::-->  Root --> " + iRoot.getID());
            } else {
                System.out.println("  ::-->  Root --> NULL");
            }
            if (iTarget != null) {
                System.out.println("  ::-->  Target  --> " + iTarget.getID());
            } else {
                System.out.println("  ::-->  Target  --> NULL");
            }
        }
        boolean found = false;
        if (iRoot == null) {
            if (_Debug) {
                System.out.println("  ::-->  ERROR : NULL Root");
            }
        } else if (iRoot == this.mSeqTree.getRoot()) {
            found = true;
        } else if (iRoot != null && iTarget != null) {
            while (iTarget != null && !found) {
                if (iTarget == iRoot) {
                    found = true;
                }
                iTarget = iTarget.getParent();
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + found);
            System.out.println("  :: ADLSequencer --> END   - isDescendent");
        }
        return found;
    }

    private Walk walkTree(int iDirection, int iPrevDirection, boolean iEnter, SeqActivity iFrom, boolean iControl) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - walkTree");
            System.out.println("  Dir  ::-->  " + (iDirection == 2 ? "Backward" : "Forward"));
            if (iPrevDirection == 0) {
                System.out.println("  Prev ::-->  None");
            } else {
                System.out.println("  Prev ::-->  " + (iPrevDirection == 2 ? "Backward" : "Forward"));
            }
            System.out.println("  ::-->  " + (iEnter ? "Enter" : "Don't Enter"));
            System.out.println("  ::--> Control?  " + (iControl ? "Yes" : "No"));
            if (iFrom != null) {
                System.out.println("  ::-->  " + iFrom.getID());
            } else {
                System.out.println("  ::--> NULL");
            }
        }
        SeqActivity next = null;
        SeqActivity parent = null;
        int direction = iDirection;
        boolean reversed = false;
        boolean done = false;
        boolean endSession = false;
        if (iFrom == null) {
            if (_Debug) {
                System.out.println("  ::--> Walked off the Activity Tree");
            }
            endSession = true;
            done = true;
        } else {
            parent = iFrom.getParent();
        }
        if (!done && parent != null && iPrevDirection == 2 && iFrom.getNextSibling(false) == null) {
            direction = 2;
            iFrom = (SeqActivity)parent.getChildren(false).elementAt(0);
            reversed = true;
            if (_Debug) {
                System.out.println("  ::  REVERSING DIRECTION ::   " + iFrom.getID());
            }
        }
        if (!done && direction == 1) {
            if (iFrom.getID().equals(this.mSeqTree.getLastLeaf())) {
                done = true;
                endSession = true;
                if (_Debug) {
                    System.out.println("  ::-->  Last Leaf");
                }
            }
            if (!done) {
                if (!iFrom.hasChildren(false) || !iEnter) {
                    next = iFrom.getNextSibling(false);
                    if (next == null) {
                        if (_Debug) {
                            System.out.println("  ::-->  FORWARD RECURSION  <--::");
                        }
                        Walk walk = this.walkTree(direction, 0, false, parent, iControl);
                        next = walk.at;
                        endSession = walk.endSession;
                    }
                } else {
                    next = (SeqActivity)iFrom.getChildren(false).elementAt(0);
                }
            }
        } else if (!done && direction == 2) {
            if (parent != null) {
                if (!iFrom.hasChildren(false) || !iEnter) {
                    if (iControl && !reversed && parent.getControlForwardOnly()) {
                        if (_Debug) {
                            System.out.println("  ::--> Forward Only Control Mode violation at -->  " + iFrom.getID());
                            System.out.println("  :: ADLSequencer --> END   - walkTree");
                        }
                        done = true;
                    }
                    if (!done && (next = iFrom.getPrevSibling(false)) == null) {
                        if (_Debug) {
                            System.out.println("  ::-->  BACKWARD RECURSION  <--::");
                        }
                        Walk walk = this.walkTree(direction, 0, false, parent, iControl);
                        next = walk.at;
                        endSession = walk.endSession;
                    }
                } else if (iFrom.getControlForwardOnly()) {
                    next = (SeqActivity)iFrom.getChildren(false).elementAt(0);
                    direction = 1;
                } else {
                    int size = iFrom.getChildren(false).size();
                    next = (SeqActivity)iFrom.getChildren(false).elementAt(size - 1);
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Walked off the root");
            }
        } else if (!done && _Debug) {
            System.out.println("  ::--> ERROR : Invalid direction");
        }
        if (_Debug) {
            if (next != null) {
                System.out.println("  ::-->  " + next.getID());
            } else {
                System.out.println("  ::-->  NULL");
            }
            System.out.println("  ::-->  End Session?  " + (endSession ? "YES" : "NO"));
            System.out.println("  ::--> MOVING ---> " + (direction == 1 ? "Forward" : "Backward"));
            System.out.println("  :: ADLSequencer --> END   - walkTree");
        }
        Walk walk = new Walk();
        walk.at = next;
        walk.direction = direction;
        walk.endSession = endSession;
        return walk;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean walkActivity(int iDirection, int iPrevDirection, Walk ioFrom) {
        boolean deliver;
        block25: {
            block26: {
                block27: {
                    if (_Debug) {
                        System.out.println("  :: ADLSequencer --> BEGIN - walkActivity");
                        System.out.println("  Dir  ::-->  " + (iDirection == 2 ? "Backward" : "Forward"));
                        if (iPrevDirection == 0) {
                            System.out.println("  Prev ::-->  None");
                        } else {
                            System.out.println("  Prev ::-->  " + (iPrevDirection == 2 ? "Backward" : "Forward"));
                        }
                        if (ioFrom.at != null) {
                            System.out.println("  ::-->  " + ioFrom.at.getID());
                        } else {
                            System.out.println("  ::--> ERROR : NULL starting point");
                        }
                    }
                    deliver = true;
                    SeqActivity parent = ioFrom.at.getParent();
                    if (parent != null) {
                        if (!parent.getControlModeFlow()) {
                            if (_Debug) {
                                System.out.println("  ::--> Control Mode violated");
                            }
                            deliver = false;
                        }
                    } else {
                        if (_Debug) {
                            System.out.println("  ::--> ERROR : Cannot have null parent");
                        }
                        deliver = false;
                    }
                    if (!deliver) break block25;
                    String result = null;
                    SeqRuleset skippedRules = ioFrom.at.getPreSeqRules();
                    if (skippedRules != null) {
                        result = skippedRules.evaluate(4, ioFrom.at, this.mRetry);
                    }
                    if (result != null) {
                        Walk walk = this.walkTree(iDirection, iPrevDirection, false, ioFrom.at, true);
                        if (walk.at == null) {
                            deliver = false;
                            break block25;
                        } else {
                            if (_Debug) {
                                System.out.println("  ::-->  RECURSION  <--::");
                            }
                            ioFrom.at = walk.at;
                            if (iPrevDirection == 2 && walk.direction == 2) {
                                return this.walkActivity(2, 0, ioFrom);
                            }
                            return this.walkActivity(iDirection, iPrevDirection, ioFrom);
                        }
                    }
                    if (this.checkActivity(ioFrom.at)) break block26;
                    if (!ioFrom.at.hasChildren(false)) break block27;
                    Walk walk = this.walkTree(iDirection, 0, true, ioFrom.at, true);
                    if (walk.at != null) {
                        ioFrom.at = walk.at;
                        if (iDirection == 2 && walk.direction == 1) {
                            if (_Debug) {
                                System.out.println("  ::--> REVERSING");
                            }
                            deliver = this.walkActivity(1, 2, ioFrom);
                            break block25;
                        } else {
                            deliver = this.walkActivity(iDirection, 0, ioFrom);
                        }
                        break block25;
                    } else {
                        deliver = false;
                    }
                    break block25;
                }
                if (_Debug) {
                    System.out.println("  ::--> Found a leaf");
                }
                break block25;
            }
            deliver = false;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + deliver);
            if (ioFrom.at != null) {
                System.out.println("  ::-->  " + ioFrom.at.getID());
            } else {
                System.out.println("  ::-->  NULL");
            }
            System.out.println("  :: ADLSequencer --> END   - walkActivity");
        }
        return deliver;
    }

    private boolean processFlow(int iDirection, boolean iEnter, Walk ioFrom, boolean iConChoice) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - processFlow");
            System.out.println("  ::-->  " + iDirection);
            System.out.println("  ::-->  " + iConChoice);
            System.out.println("  ::--> Con Choice?  " + (iConChoice ? "Yes" : "No"));
            if (ioFrom.at != null) {
                System.out.println("  ::-->  " + ioFrom.at.getID());
            } else {
                System.out.println("  ::-->  ERROR : NULL starting point");
            }
        }
        boolean success = true;
        SeqActivity candidate = ioFrom.at;
        if (candidate != null) {
            Walk walk = this.walkTree(iDirection, 0, iEnter, candidate, !iConChoice);
            if (!iConChoice && walk.at != null) {
                ioFrom.at = walk.at;
                success = this.walkActivity(iDirection, 0, ioFrom);
            } else {
                if (iConChoice) {
                    ioFrom.at = walk.at;
                    if (_Debug) {
                        System.out.println("  ::--> Constrained Choice test");
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> No 'next' activity");
                }
                success = false;
            }
            if (walk.at == null && walk.endSession) {
                if (_Debug) {
                    System.out.println("  ::--> ENDING SESSION");
                }
                this.terminateDescendentAttempts(this.mSeqTree.getRoot());
                this.mEndSession = true;
                success = false;
            }
        } else {
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + success);
            if (ioFrom.at != null) {
                System.out.println("  ::-->  " + ioFrom.at.getID());
            } else {
                System.out.println("  ::-->  NULL");
            }
            System.out.println("  :: ADLSequencer --> END   - processFlow");
        }
        return success;
    }

    private boolean evaluateChoiceTraversal(int iDirection, SeqActivity iAt) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - evaluateChoiceTraversal");
            System.out.println("  ::-->  " + iDirection);
            if (iAt != null) {
                System.out.println("  ::-->  " + iAt.getID());
            } else {
                System.out.println("  ::-->  ERROR : NULL starting point");
            }
        }
        boolean success = true;
        if (iAt != null) {
            if (iDirection == 1) {
                SeqRuleset stopTrav = iAt.getPreSeqRules();
                String result = null;
                if (stopTrav != null) {
                    result = stopTrav.evaluate(7, iAt, false);
                }
                if (result != null) {
                    success = false;
                }
            } else if (iDirection == 2) {
                SeqActivity parent = iAt.getParent();
                if (parent != null) {
                    success = !parent.getControlForwardOnly();
                }
            } else {
                if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid direction");
                }
                success = false;
            }
        } else {
            success = false;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + success);
            System.out.println("  :: ADLSequencer --> END   - evaluateChoiceTraversal");
        }
        return success;
    }

    private boolean doDeliveryRequest(String iTarget, boolean iTentative, ADLLaunch oLaunch) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - doDeliveryRequest");
            System.out.println("  ::-->         " + iTarget);
            System.out.println("  ::-->  REAL?  " + (iTentative ? "NO" : "YES"));
        }
        boolean deliveryOK = true;
        SeqActivity act = this.getActivity(iTarget);
        if (act == null) {
            deliveryOK = false;
            if (_Debug) {
                System.out.println("  ::--> No Delivery Request");
            }
            if (!iTentative) {
                oLaunch.mSeqNonContent = this.mExitCourse ? ADLLaunch.LAUNCH_COURSECOMPLETE : (this.mEndSession ? ADLLaunch.LAUNCH_EXITSESSION : ADLLaunch.LAUNCH_SEQ_BLOCKED);
            }
        }
        if (deliveryOK && act.hasChildren(false)) {
            deliveryOK = false;
            oLaunch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            oLaunch.mEndSession = this.mEndSession;
            if (_Debug) {
                System.out.println("  ::-->  Activity is not a leaf");
            }
        } else if (deliveryOK) {
            boolean ok = true;
            while (act != null && ok) {
                if (_Debug) {
                    System.out.println("  ::-->  Validating --> " + act.getID());
                }
                if (!(ok = !this.checkActivity(act))) continue;
                act = act.getParent();
            }
            if (!ok) {
                if (_Debug) {
                    System.out.println("  ::-->  Some activity did not validate");
                }
                deliveryOK = false;
                oLaunch.mSeqNonContent = ADLLaunch.LAUNCH_NOTHING;
            }
        }
        if (!iTentative) {
            if (deliveryOK) {
                this.contentDelivery(iTarget, oLaunch);
                this.validateRequests();
            } else {
                boolean bl = oLaunch.mEndSession = this.mEndSession || this.mExitCourse;
                if (!oLaunch.mEndSession) {
                    this.validateRequests();
                    oLaunch.mNavState = this.mSeqTree.getValidRequests();
                }
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + deliveryOK);
            System.out.println("  :: ADLSequencer --> END   - doDeliveryRequest");
        }
        return deliveryOK;
    }

    private void contentDelivery(String iTarget, ADLLaunch oLaunch) {
        SeqActivity cur;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - contentDelivery");
            System.out.println("  ::-->  " + iTarget);
        }
        SeqActivity target = this.getActivity(iTarget);
        boolean done = false;
        if (target == null) {
            if (_Debug) {
                System.out.println("  ::--> ERROR : Invalid target");
            }
            oLaunch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            oLaunch.mEndSession = this.mEndSession;
            done = true;
        }
        if ((cur = this.mSeqTree.getFirstCandidate()) != null && !done && cur.getIsActive()) {
            if (_Debug) {
                System.out.println("  ::--> ERROR : Current activity still active.");
            }
            oLaunch.mSeqNonContent = ADLLaunch.LAUNCH_ERROR;
            oLaunch.mEndSession = this.mEndSession;
            done = true;
        }
        if (!done) {
            SeqActivity walk;
            this.clearSuspendedActivity(target);
            this.terminateDescendentAttempts(target);
            Vector<SeqActivity> begin = new Vector<SeqActivity>();
            for (walk = target; walk != null; walk = walk.getParent()) {
                begin.add(walk);
            }
            if (begin.size() > 0) {
                for (int i = begin.size() - 1; i >= 0; --i) {
                    walk = (SeqActivity)begin.elementAt(i);
                    if (_Debug) {
                        System.out.println("  ::--> BEGIN >> " + walk.getID());
                    }
                    if (walk.getIsActive()) continue;
                    if (walk.getIsTracked()) {
                        if (walk.getIsSuspended()) {
                            walk.setIsSuspended(false);
                        } else {
                            walk.incrementAttempt();
                        }
                    }
                    walk.setIsActive(true);
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Empty begin vector");
            }
            this.mSeqTree.setCurrentActivity(target);
            this.mSeqTree.setFirstCandidate(target);
            oLaunch.mEndSession = this.mEndSession;
            oLaunch.mActivityID = iTarget;
            oLaunch.mResourceID = target.getResourceID();
            oLaunch.mStateID = target.getStateID();
            if (oLaunch.mStateID == null) {
                oLaunch.mStateID = iTarget;
            }
            oLaunch.mNumAttempt = target.getNumAttempt() + target.getNumSCOAttempt();
            oLaunch.mMaxTime = target.getAttemptAbDur();
            Hashtable<String, ADLAuxiliaryResource> services = new Hashtable<String, ADLAuxiliaryResource>();
            ADLAuxiliaryResource test = null;
            for (walk = target; walk != null; walk = walk.getParent()) {
                Vector curSet = walk.getAuxResources();
                if (curSet == null) continue;
                for (int i = 0; i < curSet.size(); ++i) {
                    ADLAuxiliaryResource res = null;
                    res = (ADLAuxiliaryResource)curSet.elementAt(i);
                    test = (ADLAuxiliaryResource)services.get(res.mType);
                    if (test != null) continue;
                    services.put(res.mType, res);
                }
            }
            if (services.size() > 0) {
                oLaunch.mServices = services;
            }
        }
        if (_Debug) {
            System.out.println("  ::--> Content Delivery Valididation");
        }
        this.validateRequests();
        oLaunch.mNavState = this.mSeqTree.getValidRequests();
        if (oLaunch.mSeqNonContent != null) {
            oLaunch.mNavState.mContinueExit = false;
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - contentDelivery");
        }
    }

    private void clearSuspendedActivity(SeqActivity iTarget) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearSuspendedActivity");
        }
        SeqActivity act = this.mSeqTree.getSuspendAll();
        if (iTarget == null) {
            if (_Debug) {
                System.out.println("  ::--> Nothing to deliver");
            }
            act = null;
        }
        if (act != null) {
            if (iTarget != act) {
                SeqActivity common = this.findCommonAncestor(iTarget, act);
                while (act != common) {
                    act.setIsSuspended(false);
                    Vector children = act.getChildren(false);
                    if (children != null) {
                        boolean done = false;
                        for (int i = 0; i < children.size() && !done; ++i) {
                            SeqActivity lookAt = (SeqActivity)children.elementAt(i);
                            if (!lookAt.getIsSuspended()) continue;
                            act.setIsSuspended(true);
                            done = true;
                        }
                    }
                    act = act.getParent();
                }
            } else if (_Debug) {
                System.out.println("  ::--> Target is the Suspended Act");
            }
            SeqActivity temp = null;
            this.mSeqTree.setSuspendAll(temp);
        } else if (_Debug) {
            System.out.println("  ::-->  Nothing to clear");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearSuspendedActivity");
        }
    }

    private boolean evaluateLimitConditions(SeqActivity iTarget) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - evaluateLimitConditions");
            System.out.println("  ::-->  Target: " + iTarget.getID());
        }
        boolean disabled = false;
        if (!iTarget.getIsActive() && !iTarget.getIsSuspended() && iTarget.getAttemptLimitControl()) {
            boolean bl = disabled = iTarget.getNumAttempt() >= iTarget.getAttemptLimit();
        }
        if (_Debug) {
            System.out.println("  ::-->  " + disabled);
            System.out.println("  :: ADLSequencer --> END   - evaluateLimitConditions");
        }
        return disabled;
    }

    private void terminateDescendentAttempts(SeqActivity iTarget) {
        SeqActivity cur;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - terminateDescendentAttempts");
            if (iTarget != null) {
                System.out.println("  ::-->  Target: " + iTarget.getID());
            } else {
                System.out.println("  ::--> ERROR : NULL Activity");
            }
        }
        if ((cur = this.mSeqTree.getFirstCandidate()) != null) {
            SeqActivity common = this.findCommonAncestor(cur, iTarget);
            for (SeqActivity walk = cur; walk != common; walk = walk.getParent()) {
                this.endAttempt(walk, false);
            }
        } else if (_Debug) {
            System.out.println("  ::--> No current activity");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   -  terminateDescendentAttempts");
        }
    }

    private void endAttempt(SeqActivity iTarget, boolean iTentative) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - endAttempt");
            if (iTarget != null) {
                System.out.println("  ::--> Target : " + iTarget.getID());
            } else {
                System.out.println("  ::--> ERROR : NULL Activity");
            }
            System.out.println("  ::--> REAL?    -- " + (iTentative ? "NO" : "YES"));
        }
        if (iTarget != null) {
            Vector children = iTarget.getChildren(false);
            if (children == null && iTarget.getIsTracked()) {
                if (!iTarget.getIsSuspended()) {
                    if (!(iTarget.getSetCompletion() || iTarget.getProgressStatus(false) || iTarget.isPrimaryProgressSetBySCO())) {
                        iTarget.setProgress(ADLTracking.TRACK_COMPLETED);
                    }
                    if (!iTarget.getSetObjective()) {
                        if (!iTarget.getObjStatus(false, true) && !iTarget.isPrimaryStatusSetBySCO()) {
                            iTarget.setObjSatisfied(ADLTracking.TRACK_SATISFIED);
                        } else if (iTarget.getObjSatValue().equals(ADLTracking.TRACK_UNKNOWN)) {
                            iTarget.clearObjStatus();
                        }
                    }
                }
            } else if (children != null && !iTentative) {
                iTarget.setIsSuspended(false);
                for (int i = 0; i < children.size(); ++i) {
                    SeqActivity act = (SeqActivity)children.elementAt(i);
                    if (!act.getIsSuspended()) continue;
                    iTarget.setIsSuspended(true);
                    break;
                }
                if (!iTarget.getIsSuspended()) {
                    if (iTarget.getSelectionTiming().equals(SeqActivity.TIMING_EACHNEW)) {
                        this.doSelection(iTarget);
                        iTarget.setSelection(true);
                    }
                    if (iTarget.getRandomTiming().equals(SeqActivity.TIMING_EACHNEW)) {
                        this.doRandomize(iTarget);
                        iTarget.setRandomized(true);
                    }
                }
            }
            if (!iTentative) {
                iTarget.setIsActive(false);
                if (iTarget.getIsTracked()) {
                    iTarget.triggerObjMeasure();
                }
                this.invokeRollup(iTarget, this.getGlobalObjs(iTarget));
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - endAttempt");
        }
    }

    private Vector getGlobalObjs(SeqActivity iTarget) {
        Vector objs = iTarget.getObjectives();
        Vector<String> writeMaps = new Vector<String>();
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                SeqObjective s = (SeqObjective)objs.get(i);
                if (s.mMaps == null) continue;
                for (int m = 0; m < s.mMaps.size(); ++m) {
                    SeqObjectiveMap map = (SeqObjectiveMap)s.mMaps.elementAt(m);
                    if (!map.hasWriteMaps()) continue;
                    writeMaps.add(map.mGlobalObjID);
                }
            }
        }
        return writeMaps;
    }

    private boolean checkActivity(SeqActivity iTarget) {
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - checkActivity");
            System.out.println("  ::-->  Target: " + iTarget.getID());
        }
        boolean disabled = false;
        String result = null;
        SeqRuleset disabledRules = iTarget.getPreSeqRules();
        if (disabledRules != null) {
            result = disabledRules.evaluate(5, iTarget, this.mRetry);
        }
        if (result != null) {
            disabled = true;
        }
        if (!disabled) {
            disabled = this.evaluateLimitConditions(iTarget);
        }
        if (_Debug) {
            System.out.println("  ::-->  " + disabled);
            System.out.println("  :: ADLSequencer --> END   - checkActivity");
        }
        return disabled;
    }

    private void setRetry(boolean iRetry) {
        this.mRetry = false;
        if (_Debug) {
            System.out.println("  ::--> RETRY == " + this.mRetry);
        }
    }

    private Hashtable getChoiceSet(Vector iOldTOC, Vector oNewTOC) {
        ADLTOC temp;
        if (_Debug) {
            System.out.println("  :: ADLSequencer  --> BEGIN - getChoiceSet");
            if (iOldTOC != null) {
                System.out.println("  ::--> " + iOldTOC.size());
            } else {
                System.out.println("  ::--> NULL");
            }
        }
        Hashtable<String, ADLTOC> set = null;
        String lastLeaf = null;
        if (iOldTOC != null) {
            temp = null;
            set = new Hashtable<String, ADLTOC>();
            for (int i = iOldTOC.size() - 1; i >= 0; --i) {
                temp = (ADLTOC)iOldTOC.elementAt(i);
                if (!temp.mIsVisible) {
                    if (_Debug) {
                        System.out.println("  ::--> Remove :: " + temp.mID);
                    }
                    if (temp.mIsSelectable) {
                        if (_Debug) {
                            System.out.println("  ::--> Invisible :: " + temp.mID);
                        }
                        set.put(temp.mID, temp);
                    }
                } else if (temp.mIsVisible) {
                    set.put(temp.mID, temp);
                    oNewTOC.add(temp);
                }
                if (lastLeaf != null || !temp.mLeaf || !temp.mIsEnabled) continue;
                lastLeaf = temp.mID;
            }
        }
        if (lastLeaf != null) {
            if (_Debug) {
                System.out.println("  ::--> Setting last leaf --> " + lastLeaf);
            }
            this.mSeqTree.setLastLeaf(lastLeaf);
        }
        if (set.size() == 0) {
            set = null;
        }
        if (oNewTOC.size() == 1) {
            temp = (ADLTOC)oNewTOC.elementAt(0);
            if (!temp.mIsEnabled) {
                if (_Debug) {
                    System.out.println("  ::--> Clearing single non-enabled  activity");
                }
                oNewTOC.remove(0);
            } else if (!temp.mLeaf) {
                if (_Debug) {
                    System.out.println("  ::--> Clearing root activity");
                }
                oNewTOC.remove(0);
            }
        }
        if (_Debug) {
            if (set != null) {
                System.out.println("  ::--> " + set.size() + "  //  " + oNewTOC.size());
                for (int i = 0; i < oNewTOC.size(); ++i) {
                    ADLTOC temp2 = (ADLTOC)oNewTOC.elementAt(i);
                    temp2.dumpState();
                }
            } else {
                System.out.println("  ::--> NULL");
            }
            System.out.println("  :: ADLSequencer  --> END   - getChoiceSet");
        }
        return set;
    }

    protected Vector getTOC(SeqActivity iStart) {
        int i;
        int i2;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - getTOC");
        }
        Vector<ADLTOC> toc = new Vector<ADLTOC>();
        ADLTOC temp = null;
        boolean done = false;
        if (this.mSeqTree == null) {
            if (_Debug) {
                System.out.println("  ::-->  No Activity Tree");
            }
            done = true;
        }
        SeqActivity walk = iStart;
        int depth = 0;
        int parentTOC = -1;
        Vector<SeqActivity> lookAt = new Vector<SeqActivity>();
        Vector<SeqActivity> flatTOC = new Vector<SeqActivity>();
        boolean nextsibling = false;
        boolean include = false;
        boolean collapse = false;
        boolean select = false;
        boolean choosable = false;
        if (walk == null) {
            walk = this.mSeqTree.getRoot();
        }
        if (!done && _Debug) {
            System.out.println("  ::--> Building TOC from this node:  " + walk.getID());
        }
        SeqActivity cur = this.mSeqTree.getFirstCandidate();
        int curIdx = -1;
        if (cur == null) {
            cur = this.mSeqTree.getCurrentActivity();
        }
        while (!done) {
            include = true;
            select = false;
            choosable = false;
            collapse = false;
            nextsibling = false;
            if (walk.getParent() != null) {
                if (walk.getParent().getControlModeChoice()) {
                    select = true;
                    choosable = true;
                }
            } else {
                select = true;
                choosable = true;
            }
            if (include) {
                SeqRuleset hiddenRules = walk.getPreSeqRules();
                String result = null;
                if (hiddenRules != null) {
                    result = hiddenRules.evaluate(6, walk, false);
                }
                if (result != null) {
                    if (_Debug) {
                        System.out.println("  ::--> HIDDEN");
                    }
                    include = false;
                    collapse = true;
                } else if (walk.getPreventActivation() && !walk.getIsActive() && walk.hasChildren(true)) {
                    if (cur != null) {
                        if (walk != cur && cur.getParent() != walk) {
                            if (_Debug) {
                                System.out.println("  ::--> PREVENTED !!");
                                System.out.println(" " + walk.getID() + " != " + cur.getParent().getID());
                            }
                            include = true;
                            select = true;
                        }
                    } else if (walk.hasChildren(true)) {
                        if (_Debug) {
                            System.out.println("  ::--> PREVENTED -- no cur");
                        }
                        include = true;
                        select = true;
                    }
                }
            }
            if (include) {
                SeqActivity parent = walk.getParent();
                temp = new ADLTOC();
                temp.mCount = walk.getCount();
                temp.mTitle = walk.getTitle();
                temp.mDepth = depth;
                temp.mIsVisible = walk.getIsVisible();
                temp.mIsEnabled = !this.checkActivity(walk);
                temp.mInChoice = choosable;
                temp.mIsSelectable = select;
                if (temp.mIsEnabled && walk.getAttemptLimitControl() && walk.getAttemptLimit() == 0L) {
                    temp.mIsSelectable = false;
                }
                temp.mID = walk.getID();
                if (cur != null && temp.mID.equals(cur.getID())) {
                    temp.mIsCurrent = true;
                    curIdx = toc.size();
                }
                temp.mLeaf = !walk.hasChildren(false);
                temp.mParent = parentTOC;
                if (_Debug) {
                    System.out.println("  :: Added :: " + temp.mID + "  [[ " + temp.mDepth + " ]] (" + temp.mParent + ")   //  " + temp.mIsSelectable + "  [E] " + temp.mIsEnabled);
                }
                toc.add(temp);
            } else {
                temp = new ADLTOC();
                temp.mCount = walk.getCount();
                temp.mTitle = walk.getTitle();
                temp.mIsVisible = walk.getIsVisible();
                temp.mIsEnabled = !this.checkActivity(walk);
                temp.mInChoice = choosable;
                temp.mDepth = depth;
                temp.mID = walk.getID();
                temp.mIsSelectable = false;
                temp.mLeaf = walk.getChildren(false) == null;
                temp.mParent = parentTOC;
                if (collapse) {
                    temp.mIsVisible = false;
                }
                if (_Debug) {
                    System.out.println("  :: Added not-included :: " + temp.mID + "  [[ " + temp.mDepth + " ]] (" + temp.mParent + ")   //  " + temp.mIsSelectable + "  [E] " + temp.mIsEnabled);
                }
                toc.add(temp);
            }
            flatTOC.add(walk);
            if (walk.hasChildren(false)) {
                if (walk.getParent() != null) {
                    lookAt.add(walk);
                }
                walk = (SeqActivity)walk.getChildren(false).elementAt(0);
                parentTOC = toc.size() - 1;
                ++depth;
                nextsibling = true;
            }
            if (nextsibling) continue;
            walk = walk.getNextSibling(false);
            temp = (ADLTOC)toc.elementAt(toc.size() - 1);
            parentTOC = temp.mParent;
            while (walk == null && !done) {
                if (lookAt.size() > 0) {
                    walk = (SeqActivity)lookAt.elementAt(lookAt.size() - 1);
                    lookAt.remove(lookAt.size() - 1);
                    --depth;
                    temp = (ADLTOC)toc.elementAt(parentTOC);
                    while (!temp.mID.equals(walk.getID())) {
                        parentTOC = temp.mParent;
                        temp = (ADLTOC)toc.elementAt(parentTOC);
                    }
                    walk = walk.getNextSibling(false);
                    continue;
                }
                done = true;
            }
            if (walk == null) continue;
            parentTOC = temp.mParent;
        }
        if (_Debug) {
            System.out.println("  ::--> Completed first pass");
        }
        int hiddenDepth = -1;
        int prevented = -1;
        for (int i3 = 0; i3 < toc.size(); ++i3) {
            SeqActivity tempAct = (SeqActivity)flatTOC.elementAt(i3);
            ADLTOC tempTOC = (ADLTOC)toc.elementAt(i3);
            int checkDepth = tempTOC.mDepth;
            if (hiddenDepth != -1) {
                if (checkDepth <= hiddenDepth) {
                    hiddenDepth = -1;
                } else {
                    tempTOC.mIsSelectable = false;
                    tempTOC.mIsVisible = false;
                }
            }
            if (hiddenDepth != -1) continue;
            SeqRuleset hiddenRules = tempAct.getPreSeqRules();
            String result = null;
            if (hiddenRules != null) {
                result = hiddenRules.evaluate(6, tempAct, false);
            }
            if (result != null) {
                if (_Debug) {
                    System.out.println("  ::--> Hidden --> ");
                }
                hiddenDepth = tempTOC.mDepth;
                prevented = -1;
                continue;
            }
            if (_Debug) {
                System.out.println("  ::--> Prevented ??" + prevented);
            }
            if (prevented != -1) {
                if (checkDepth <= prevented) {
                    prevented = -1;
                    continue;
                }
                if (tempTOC.mDepth == prevented) continue;
                tempTOC.mIsSelectable = false;
                continue;
            }
            if (!tempAct.getPreventActivation() || tempAct.getIsActive() || !tempAct.hasChildren(true)) continue;
            if (cur != null) {
                if (tempAct == cur || cur.getParent() == tempAct) continue;
                prevented = tempTOC.mDepth;
                continue;
            }
            prevented = tempTOC.mDepth;
        }
        if (_Debug) {
            System.out.println("  ::--> Completed post-1 pass");
        }
        SeqActivity noExit = null;
        for (walk = this.mSeqTree.getFirstCandidate() != null ? this.mSeqTree.getFirstCandidate().getParent() : null; walk != null && noExit == null; walk = walk.getParent()) {
            if (walk.getParent() == null || walk.getControlModeChoiceExit()) continue;
            noExit = walk;
        }
        if (noExit != null) {
            depth = -1;
            if (_Debug) {
                System.out.println("  ::--> Found NoExit Cluster -- " + noExit.getID());
            }
            for (int i4 = 0; i4 < toc.size(); ++i4) {
                temp = (ADLTOC)toc.elementAt(i4);
                if (temp.mID.equals(noExit.getID())) {
                    depth = temp.mDepth;
                    temp.mIsSelectable = false;
                    continue;
                }
                if (depth == -1) {
                    temp.mIsSelectable = false;
                    continue;
                }
                if (temp.mDepth > depth) continue;
                depth = -1;
                temp.mIsSelectable = false;
            }
        }
        temp = (ADLTOC)toc.elementAt(0);
        SeqActivity root = this.mSeqTree.getRoot();
        if (!root.getControlModeChoiceExit()) {
            temp.mIsSelectable = false;
        }
        if (_Debug) {
            System.out.println("  ::--> Completed second pass");
        }
        SeqActivity con = null;
        if (this.mSeqTree.getFirstCandidate() != null) {
            walk = this.mSeqTree.getFirstCandidate().getParent();
            if (walk.getID().equals(this.mSeqTree.getRoot().getID())) {
                walk = null;
            }
        } else {
            walk = null;
        }
        while (walk != null && con == null) {
            if (walk.getConstrainChoice()) {
                con = walk;
            }
            walk = walk.getParent();
        }
        if (con != null) {
            int idx;
            int j;
            if (_Debug) {
                System.out.println("  ::-->  Constrained Choice Activity Found");
                System.out.println("  ::-->  Stopped at --> " + con.getID());
            }
            int forwardAct = -1;
            int backwardAct = -1;
            Vector list = null;
            Walk walkCon = new Walk();
            walkCon.at = con;
            this.processFlow(1, false, walkCon, true);
            if (walkCon.at == null) {
                if (_Debug) {
                    System.out.println("  ::--> Walked forward off the tree");
                }
                walkCon.at = con;
            }
            String lookFor = "";
            list = walkCon.at.getChildren(false);
            if (list != null) {
                int size = list.size();
                lookFor = ((SeqActivity)list.elementAt(size - 1)).getID();
            } else {
                lookFor = walkCon.at.getID();
            }
            for (j = 0; j < toc.size(); ++j) {
                temp = (ADLTOC)toc.elementAt(j);
                if (!temp.mID.equals(lookFor)) continue;
                forwardAct = j;
                break;
            }
            walkCon.at = con;
            this.processFlow(2, false, walkCon, true);
            if (walkCon.at == null) {
                if (_Debug) {
                    System.out.println("  ::--> Walked backward off the tree");
                }
                walkCon.at = con;
            }
            lookFor = walkCon.at.getID();
            for (j = 0; j < toc.size(); ++j) {
                temp = (ADLTOC)toc.elementAt(j);
                if (!temp.mID.equals(lookFor)) continue;
                backwardAct = j;
                break;
            }
            temp = (ADLTOC)toc.elementAt(forwardAct);
            if (!temp.mLeaf) {
                idx = forwardAct;
                boolean foundLeaf = false;
                block9: while (!foundLeaf) {
                    for (int i5 = toc.size() - 1; i5 > idx; --i5) {
                        temp = (ADLTOC)toc.elementAt(i5);
                        if (temp.mParent != idx) continue;
                        idx = i5;
                        foundLeaf = temp.mLeaf;
                        continue block9;
                    }
                }
                if (idx != toc.size()) {
                    forwardAct = idx;
                }
            }
            idx = ((ADLTOC)toc.elementAt((int)backwardAct)).mParent;
            String childID = ((ADLTOC)toc.elementAt((int)backwardAct)).mID;
            int avalParent = -1;
            while (idx != -1) {
                SeqActivity check;
                temp = (ADLTOC)toc.elementAt(idx);
                if (!temp.mIsSelectable || !temp.mIsEnabled || !(check = this.mSeqTree.getActivity(temp.mID)).getControlModeFlow() || !((SeqActivity)check.getChildren(false).elementAt(0)).getID().equals(childID)) break;
                childID = ((ADLTOC)toc.elementAt((int)idx)).mID;
                avalParent = idx;
                idx = ((ADLTOC)toc.elementAt((int)avalParent)).mParent;
            }
            if (avalParent != -1 && avalParent < backwardAct) {
                backwardAct = avalParent;
            }
            if (_Debug) {
                System.out.println("  ::--> Constrained Range == [ " + backwardAct + " , " + forwardAct + " ]");
            }
            for (int i6 = 0; i6 < toc.size(); ++i6) {
                temp = (ADLTOC)toc.elementAt(i6);
                if (i6 >= backwardAct && i6 <= forwardAct) continue;
                temp.mIsSelectable = false;
                if (!_Debug) continue;
                System.out.println("  ::--> Turn off -- " + temp.mID);
            }
        }
        if (_Debug) {
            System.out.println("  ::--> Completed third pass");
        }
        if (toc != null) {
            depth = -1;
            for (i2 = 0; i2 < toc.size(); ++i2) {
                temp = (ADLTOC)toc.elementAt(i2);
                if (depth != -1) {
                    if (depth >= temp.mDepth) {
                        depth = -1;
                    } else {
                        temp.mIsEnabled = false;
                        temp.mIsSelectable = false;
                    }
                }
                if (temp.mIsEnabled || depth != -1) continue;
                depth = temp.mDepth;
                if (!_Debug) continue;
                System.out.println("  ::--> [" + i2 + "]  " + "Found Disabled -->  " + temp.mID + "  <<" + temp.mDepth + ">>");
            }
        }
        if (toc != null && curIdx != -1) {
            if (_Debug) {
                System.out.println("  ::--> Checking Current Activity Siblings");
            }
            int par = ((ADLTOC)toc.elementAt((int)curIdx)).mParent;
            if (cur.getParent() != null && cur.getParent().getControlForwardOnly()) {
                int idx = curIdx - 1;
                temp = (ADLTOC)toc.elementAt(idx);
                while (temp.mParent == par) {
                    temp.mIsSelectable = false;
                    temp = (ADLTOC)toc.elementAt(--idx);
                }
            }
            boolean blocked = false;
            for (int idx = curIdx; idx < toc.size(); ++idx) {
                temp = (ADLTOC)toc.elementAt(idx);
                if (temp.mParent != par) continue;
                if (!blocked) {
                    SeqRuleset stopTrav = this.getActivity(temp.mID).getPreSeqRules();
                    String result = null;
                    if (stopTrav != null) {
                        result = stopTrav.evaluate(7, this.getActivity(temp.mID), false);
                    }
                    blocked = result != null;
                    continue;
                }
                temp.mIsSelectable = false;
            }
        }
        if (_Debug) {
            System.out.println("  ::--> Completed fourth pass");
        }
        if (toc != null && curIdx != -1) {
            if (_Debug) {
                System.out.println("  ::--> Checking Stop Forward Traversal");
            }
            int curParent = ((ADLTOC)toc.elementAt((int)curIdx)).mParent;
            int idx = toc.size() - 1;
            temp = (ADLTOC)toc.elementAt(idx);
            while (temp.mParent != -1 && temp.mParent != curParent) {
                temp = (ADLTOC)toc.elementAt(temp.mParent);
                SeqRuleset stopTrav = this.getActivity(temp.mID).getPreSeqRules();
                String result = null;
                if (stopTrav != null) {
                    result = stopTrav.evaluate(7, this.getActivity(temp.mID), false);
                }
                if (result != null) {
                    if (_Debug) {
                        System.out.println("  ::--> BLOCKED SOURCE --> " + temp.mID + " [" + temp.mDepth + "]");
                    }
                    int blocked = temp.mDepth;
                    for (int i7 = idx; i7 < toc.size(); ++i7) {
                        ADLTOC tempTOC = (ADLTOC)toc.elementAt(i7);
                        int checkDepth = tempTOC.mDepth;
                        if (checkDepth <= blocked) break;
                        tempTOC.mIsSelectable = false;
                    }
                }
                temp = (ADLTOC)toc.elementAt(--idx);
            }
        }
        if (_Debug) {
            System.out.println("  ::--> Completed fifth pass");
        }
        for (i2 = 0; i2 < toc.size(); ++i2) {
            SeqActivity from;
            temp = (ADLTOC)toc.elementAt(i2);
            if (temp.mLeaf) continue;
            if (_Debug) {
                System.out.println("  ::--> Process 'Continue' request from " + temp.mID);
            }
            if ((from = this.getActivity(temp.mID)).getControlModeFlow()) {
                Walk treeWalk = new Walk();
                treeWalk.at = from;
                boolean success = this.processFlow(1, true, treeWalk, false);
                if (success) continue;
                temp.mIsSelectable = false;
                if (!_Debug) continue;
                System.out.println("  :+: CONTINUE FAILED :+:  --> " + treeWalk.at.getID());
                continue;
            }
            temp.mIsSelectable = false;
        }
        if (_Debug) {
            System.out.println("  ::--> Completed sixth pass");
        }
        for (i2 = 0; i2 < toc.size(); ++i2) {
            temp = (ADLTOC)toc.elementAt(i2);
            if (temp.mIsVisible) continue;
            Vector<Integer> parents = new Vector<Integer>();
            for (int j = i2 + 1; j < toc.size(); ++j) {
                int idx;
                temp = (ADLTOC)toc.elementAt(j);
                if (temp.mParent == i2) {
                    --temp.mDepth;
                    parents.add(new Integer(j));
                    continue;
                }
                if (!temp.mIsVisible || (idx = parents.indexOf(new Integer(temp.mParent))) == -1) continue;
                --temp.mDepth;
                parents.add(new Integer(j));
            }
        }
        for (i2 = 0; i2 < toc.size(); ++i2) {
            temp = (ADLTOC)toc.elementAt(i2);
            if (!temp.mIsCurrent || temp.mIsVisible) continue;
            int parent = temp.mParent;
            while (parent != -1) {
                temp.mIsCurrent = false;
                temp = (ADLTOC)toc.elementAt(parent);
                if (!temp.mIsVisible) {
                    parent = temp.mParent;
                    continue;
                }
                parent = -1;
            }
            temp.mIsCurrent = true;
            break;
        }
        boolean somethingIsSelectable = false;
        for (i = 0; i < toc.size(); ++i) {
            temp = (ADLTOC)toc.elementAt(i);
            if (!temp.mIsSelectable || !temp.mIsVisible || temp.mDepth <= 0) continue;
            somethingIsSelectable = true;
            break;
        }
        if (!somethingIsSelectable) {
            for (i = 0; i < toc.size(); ++i) {
                temp = (ADLTOC)toc.elementAt(i);
                temp.mIsVisible = false;
            }
        }
        if (_Debug) {
            System.out.println("  ::--> Completed TOC walk up");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - getTOC");
        }
        return toc;
    }

    public void clearAttemptObjCompletionStatus(String iActivityID, String iObjID) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearAttemptObjCompletionStatus");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.clearObjCompletionStatus(iObjID);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearAttemptObjCompletionStatus");
        }
    }

    public void setAttemptObjCompletionStatus(String iActivityID, String iObjID, String iCompletion) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjCompletionStatus");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Measure:         " + iCompletion);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setObjCompletionStatus(iObjID, iCompletion);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjCompletionStatus");
        }
    }

    public void clearAttemptObjProgressMeasure(String iActivityID, String iObjID) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearAttemptObjProgressMeasure");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.clearObjProgressMeasure(iObjID);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearAttemptObjProgressMeasure");
        }
    }

    public void setAttemptObjProgressMeasure(String iActivityID, String iObjID, double iProgressMeasure) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjProgressMeasure");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Measure:         " + iProgressMeasure);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setObjProgressMeasure(iObjID, iProgressMeasure);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjProgressMeasure");
        }
    }

    public void clearAttemptObjMaxScore(String iActivityID, String iObjID) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearAttemptObjMaxScore");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.clearObjMaxScore(iObjID);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearAttemptObjMaxScore");
        }
    }

    public void setAttemptObjMaxScore(String iActivityID, String iObjID, double iMaxScore) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjMaxScore");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Measure:         " + iMaxScore);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setObjMaxScore(iObjID, iMaxScore);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjMaxScore");
        }
    }

    public void clearAttemptObjMinScore(String iActivityID, String iObjID) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearAttemptObjMinScore");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.clearObjMinScore(iObjID);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearAttemptObjMinScore");
        }
    }

    public void setAttemptObjMinScore(String iActivityID, String iObjID, double iMinScore) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjMinScore");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Measure:         " + iMinScore);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setObjMinScore(iObjID, iMinScore);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjMinScore");
        }
    }

    public void clearAttemptObjRawScore(String iActivityID, String iObjID) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - clearAttemptObjRawScore");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.clearObjRawScore(iObjID);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - clearAttemptObjRawScore");
        }
    }

    public void setAttemptObjRawScore(String iActivityID, String iObjID, double iRawScore) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptObjRawScore");
            System.out.println("  ::--> Target activity: " + iActivityID);
            System.out.println("  ::--> Objective:       " + iObjID);
            System.out.println("  ::--> Measure:         " + iRawScore);
        }
        if ((target = this.getActivity(iActivityID)) != null) {
            if (target.getIsActive()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    target.setObjRawScore(iObjID, iRawScore);
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptObjRawScore");
        }
    }

    public void setAttemptProgressMeasure(String iID, String iProMeasure) {
        SeqActivity target;
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> BEGIN - setAttemptProgressMeasure");
            System.out.println("  ::--> Target activity:    " + iID);
            System.out.println("  ::--> Progress measure:  " + iProMeasure);
        }
        if ((target = this.getActivity(iID)) != null) {
            if (target.getIsActive() && target.getIsTracked()) {
                if (!target.hasChildren(false) && this.mSeqTree.getCurrentActivity() == target) {
                    boolean statusChange = target.setProgressMeasure(iProMeasure);
                    if (statusChange) {
                        this.validateRequests();
                    }
                } else if (_Debug) {
                    System.out.println("  ::--> ERROR : Invalid target");
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : Target not active");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Activity does not exist");
        }
        if (_Debug) {
            System.out.println("  :: ADLSequencer --> END   - setAttemptProgressMeasure");
        }
    }

    private class Walk {
        public SeqActivity at = null;
        public int direction = 0;
        public boolean endSession = false;
    }
}

