/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.sequencer.ADLDuration;
import org.adl.sequencer.SeqObjective;
import org.adl.sequencer.SeqObjectiveTracking;
import org.adl.util.debug.DebugIndicator;

public class ADLTracking
implements Serializable {
    public static String TRACK_UNKNOWN = "unknown";
    public static String TRACK_SATISFIED = "satisfied";
    public static String TRACK_NOTSATISFIED = "notSatisfied";
    public static String TRACK_COMPLETED = "completed";
    public static String TRACK_INCOMPLETE = "incomplete";
    private static boolean _Debug = DebugIndicator.ON;
    public boolean mDirtyPro = false;
    public Hashtable mObjectives = null;
    public String mPrimaryObj = "_primary_";
    private boolean mProgressDeterminedByMeasure = false;
    private double mProgressThreshold = 1.0;
    private double mProgressWeight = 1.0;
    public ADLDuration mAttemptAbDur = null;
    public ADLDuration mAttemptExDur = null;
    public long mAttempt = 0L;

    ADLTracking(Vector iObjs, String iLearnerID, String iScopeID) {
        if (iObjs != null) {
            for (int i = 0; i < iObjs.size(); ++i) {
                SeqObjective obj = (SeqObjective)iObjs.elementAt(i);
                if (_Debug) {
                    System.out.println("  ::--> Building Objective  :: " + obj.mObjID);
                }
                SeqObjectiveTracking objTrack = new SeqObjectiveTracking(obj, iLearnerID, iScopeID);
                if (this.mObjectives == null) {
                    this.mObjectives = new Hashtable();
                }
                this.mObjectives.put(obj.mObjID, objTrack);
                if (!obj.mContributesToRollup) continue;
                this.mPrimaryObj = obj.mObjID;
            }
        } else {
            if (_Debug) {
                System.out.println("  ::--> Making default Obj");
            }
            SeqObjective def = new SeqObjective();
            def.mContributesToRollup = true;
            SeqObjectiveTracking objTrack = new SeqObjectiveTracking(def, iLearnerID, iScopeID);
            if (this.mObjectives == null) {
                this.mObjectives = new Hashtable();
            }
            this.mObjectives.put(def.mObjID, objTrack);
            this.mPrimaryObj = def.mObjID;
        }
    }

    ADLTracking(Vector iObjs, String iLearnerID, String iScopeID, double iThreshold, double iWeight) {
        this(iObjs, iLearnerID, iScopeID);
        this.mProgressDeterminedByMeasure = true;
        this.mProgressThreshold = iThreshold;
        this.mProgressWeight = iWeight;
    }

    public void dumpState() {
        if (_Debug) {
            System.out.println("  :: ADLTracking   --> BEGIN - dumpState");
            System.out.println("\t  ::--> Attempt #:   " + this.mAttempt);
            System.out.println("\t  ::--> Dirty Pro:   " + this.mDirtyPro);
            if (this.mObjectives == null) {
                System.out.println("\t  ::--> Objectives :       NULL");
            } else {
                System.out.println("\t  ::--> Objectives :       [" + this.mObjectives.size() + "]");
                Enumeration theEnum = this.mObjectives.keys();
                while (theEnum.hasMoreElements()) {
                    String key = (String)theEnum.nextElement();
                    System.out.println("\t\t  :: " + key + " ::");
                    SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(key);
                    System.out.println("\t\t  ::--> " + obj.getObjStatus(false));
                    System.out.println("\t\t  ::--> " + obj.getObjMeasure(false));
                }
            }
            System.out.println("\t  ::--> Primary:       " + this.mPrimaryObj);
            System.out.println("\t  ::--> ProgByMeasure: " + this.mProgressDeterminedByMeasure);
            System.out.println("\t  ::--> ProgThresh:    " + this.mProgressThreshold);
            System.out.println("\t  ::--> ProgWeight:    " + this.mProgressWeight);
            System.out.println("  :: ADLTracking   --> END   - dumpState");
        }
    }

    void setDirtyObj() {
        if (_Debug) {
            System.out.println("  :: ADLTracking     --> BEGIN - setDirtyObj");
        }
        if (this.mObjectives != null) {
            Enumeration theEnum = this.mObjectives.keys();
            while (theEnum.hasMoreElements()) {
                String key = (String)theEnum.nextElement();
                SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(key);
                obj.setDirtyObj();
            }
        }
        if (_Debug) {
            System.out.println("  :: ADLTracking     --> END   - setDirtyObj");
        }
    }

    void setCompletionStatus(String iCompleted) {
        if (_Debug) {
            System.out.println("  :: ADLTracking   --> BEGIN - setCompletionStatus");
            System.out.println("  ::-->  " + iCompleted);
        }
        if (this.mProgressDeterminedByMeasure) {
            if (_Debug) {
                System.out.println("  ::--> Cannot set: Completion satisfied by measure");
            }
        } else {
            SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(this.mPrimaryObj);
            obj.setObjCompletionStatus(iCompleted);
        }
        if (_Debug) {
            System.out.println("  :: ADLTracking   --> END   - setCompletionStatus");
        }
    }

    String getCompletionStatus(boolean iUseCurrent) {
        boolean isDirty = iUseCurrent ? false : this.mDirtyPro;
        String status = TRACK_UNKNOWN;
        SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(this.mPrimaryObj);
        status = this.mProgressDeterminedByMeasure ? obj.getObjProgressMeasure(isDirty) : obj.getObjCompletionStatus(isDirty);
        return status;
    }

    void setProgressMeasure(double iProMeasure) {
        if (_Debug) {
            System.out.println("  :: ADLTracking   --> BEGIN - setProgressMeasure");
            System.out.println("  ::-->  " + iProMeasure);
        }
        SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(this.mPrimaryObj);
        obj.setObjProgressMeasure(iProMeasure);
        if (this.mProgressDeterminedByMeasure && iProMeasure >= 0.0 && iProMeasure <= 1.0) {
            String completion = TRACK_UNKNOWN;
            completion = iProMeasure >= this.mProgressThreshold ? TRACK_COMPLETED : TRACK_INCOMPLETE;
            obj.setObjCompletionStatus(completion);
        }
        if (_Debug) {
            System.out.println("  :: ADLTracking   --> END - setProMeasure");
        }
    }

    double getProgressMeasure() {
        SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(this.mPrimaryObj);
        double progress = Double.parseDouble(obj.getObjProgressMeasure(this.mDirtyPro));
        return progress;
    }

    boolean getProgressDeterminedByMeasure() {
        return this.mProgressDeterminedByMeasure;
    }

    double getProgressMeasureWeight() {
        return this.mProgressWeight;
    }

    void setProgressMeasureWeight(double iWeight) {
        if (iWeight >= 0.0 && iWeight <= 1.0) {
            this.mProgressWeight = iWeight;
        }
    }

    void setProgressMeasureThreshold(double iThresh) {
        if (iThresh >= 0.0 && iThresh <= 1.0) {
            this.mProgressThreshold = iThresh;
        }
    }

    boolean hasProgressMeasure() {
        boolean ret = false;
        SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(this.mPrimaryObj);
        String progress = obj.getObjProgressMeasure(this.mDirtyPro);
        if (!progress.equals(TRACK_UNKNOWN)) {
            ret = true;
        }
        return ret;
    }

    void clearProMeasure() {
        SeqObjectiveTracking obj = (SeqObjectiveTracking)this.mObjectives.get(this.mPrimaryObj);
        obj.clearObjProgressMeasure();
    }

    public double getProgressThreshold() {
        return this.mProgressThreshold;
    }
}

