/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.sequencer.ADLValidRequests;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqObjective;
import org.adl.sequencer.SeqObjectiveMap;
import org.adl.util.debug.DebugIndicator;

public class SeqActivityTree
implements Serializable {
    private static boolean _Debug = DebugIndicator.ON;
    public static String dataStoreLoc;
    public static HashMap dsMap;
    private SeqActivity mRoot = null;
    private ADLValidRequests mValidReq = null;
    private String mLastLeaf = null;
    private String mScopeID = null;
    private String mCourseID = null;
    private String mLearnerID = null;
    private SeqActivity mCurActivity = null;
    private SeqActivity mFirstCandidate = null;
    private SeqActivity mSuspendAll = null;
    private Hashtable mActivityMap = null;
    private Vector mObjSet = null;
    private Hashtable mObjMap = null;
    private boolean mObjScan = false;
    private boolean mDataScopedForAllAttempts = true;

    public SeqActivityTree() {
    }

    public SeqActivityTree(String iCourseID, String iLearnerID, String iScopeID, SeqActivity iRoot) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - constructor");
            System.out.println("  ::--> Course ID     : " + iCourseID);
            System.out.println("  ::--> Student ID    : " + iLearnerID);
            System.out.println("  ::--> Scope ID      : " + iScopeID);
        }
        this.mCourseID = iCourseID;
        this.mLearnerID = iLearnerID;
        this.mScopeID = iScopeID;
        this.mRoot = iRoot;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - constructor");
        }
    }

    public void setLearnerID(String iLearnerID) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setLearnerID");
            System.out.println("  ::--> Learner ID    : " + iLearnerID);
        }
        this.mLearnerID = iLearnerID;
        this.buildActivityMap();
        if (this.mActivityMap != null && iLearnerID != null) {
            Enumeration theEnum = this.mActivityMap.elements();
            while (theEnum.hasMoreElements()) {
                SeqActivity act = (SeqActivity)theEnum.nextElement();
                act.setLearnerID(iLearnerID);
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setLearnerID");
        }
    }

    public String getLearnerID() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getLearnerID");
            System.out.println("  ::--> Learner ID    : " + this.mLearnerID);
            System.out.println("  :: SeqActivityTree  --> END   - getLearnerID");
        }
        return this.mLearnerID;
    }

    public void setCourseID(String iCourseID) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setCourseID");
            System.out.println("  ::--> Course ID     : " + iCourseID);
        }
        this.mCourseID = iCourseID;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setCourseID");
        }
    }

    public String getCourseID() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getCourseID");
            System.out.println("  ::--> Student ID    : " + this.mCourseID);
            System.out.println("  :: SeqActivityTree  --> END   - getCourseID");
        }
        return this.mCourseID;
    }

    public void setScopeID(String iScopeID) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setScopeID");
            System.out.println("  ::-->  " + iScopeID);
        }
        this.mScopeID = iScopeID;
        if (this.mScopeID != null) {
            this.buildActivityMap();
            if (this.mActivityMap != null) {
                Enumeration theEnum = this.mActivityMap.elements();
                while (theEnum.hasMoreElements()) {
                    SeqActivity act = (SeqActivity)theEnum.nextElement();
                    act.setScopeID(this.mScopeID);
                }
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setScopeID");
        }
    }

    public String getScopeID() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getScopeID");
            System.out.println("  ::--> " + this.mScopeID);
            System.out.println("  :: SeqActivityTree  --> END   - getScopeID");
        }
        return this.mScopeID;
    }

    public void dumpState() {
        if (_Debug) {
            System.out.println("  :: SeqActivtyTree   --> BEGIN - dumpState");
            System.out.println("  ::--> Course ID:       " + this.mCourseID);
            System.out.println("  ::--> Student ID:      " + this.mLearnerID);
            System.out.println("  ::--> Scope ID  :      " + this.mScopeID);
            System.out.println("  ::--> Last Leaf:       " + this.mLastLeaf);
            if (this.mObjSet == null) {
                System.out.println("  ::--> Global Obj Set:       NULL");
            } else {
                System.out.println("  ::--> Global Obj Set:       [" + this.mObjSet.size() + "]");
                for (int i = 0; i < this.mObjSet.size(); ++i) {
                    System.out.println("\t" + (String)this.mObjSet.elementAt(i));
                }
            }
            if (this.mSuspendAll == null) {
                System.out.println("  ::--> SuspendAll:           NULL");
            } else {
                System.out.println("  ::--> SuspendAll:           " + this.mSuspendAll.getID());
            }
            if (this.mCurActivity == null) {
                System.out.println("  ::--> Current Activity:     NULL");
            } else {
                System.out.println("  ::--> Current Activity:     " + this.mCurActivity.getID());
            }
            if (this.mFirstCandidate == null) {
                System.out.println("  ::--> First Candidate:      NULL");
            } else {
                System.out.println("  ::--> First Candidate:      " + this.mFirstCandidate.getID());
            }
            if (this.mRoot == null) {
                System.out.println("  ::--> Root:                 NULL");
            } else {
                System.out.println("  ::--> Activity Tree ::");
                SeqActivity walk = this.mRoot;
                long depth = 0L;
                Vector<SeqActivity> lookAt = new Vector<SeqActivity>();
                Vector<Long> depthTrack = new Vector<Long>();
                while (walk != null) {
                    walk.dumpState();
                    if (walk.hasChildren(true)) {
                        lookAt.add(walk);
                        depthTrack.add(new Long(depth + 1L));
                    }
                    if ((walk = walk.getNextSibling(true)) != null) continue;
                    if (lookAt.size() != 0) {
                        walk = (SeqActivity)lookAt.elementAt(0);
                        lookAt.remove(0);
                        walk = (SeqActivity)walk.getChildren(true).elementAt(0);
                        depth = (Long)depthTrack.elementAt(0);
                        depthTrack.remove(0);
                        continue;
                    }
                    walk = null;
                }
            }
            System.out.println("  :: SeqActivityTree   --> END   - dumpState");
        }
    }

    void setRoot(SeqActivity iRoot) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setRoot");
            if (iRoot != null) {
                System.out.println("  ::-->  " + iRoot.getID());
            } else {
                System.out.println("  ::-->  NULL root.");
            }
        }
        this.mRoot = iRoot;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setRoot");
        }
    }

    SeqActivity getRoot() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getRoot");
            if (this.mRoot != null) {
                System.out.println("  ::-->  " + this.mRoot.getID());
            } else {
                System.out.println("  ::-->  NULL Root");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getRoot");
        }
        return this.mRoot;
    }

    void setLastLeaf(String iLastLeaf) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setLastLeaf");
            System.out.println("  ::-->  " + iLastLeaf);
        }
        this.mLastLeaf = iLastLeaf;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setLastLeaf");
        }
    }

    String getLastLeaf() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getLastLeaf");
            System.out.println("  ::-->  " + this.mLastLeaf);
            System.out.println("  :: SeqActivityTree  --> END   - GetLastLeaf");
        }
        return this.mLastLeaf;
    }

    void setValidRequests(ADLValidRequests iValidRequests) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setValidRequests");
            if (iValidRequests == null) {
                System.out.println("  ::-->  NULL set");
            }
        }
        this.mValidReq = iValidRequests;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setValidRequests");
        }
    }

    ADLValidRequests getValidRequests() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getValidRequests");
            if (this.mValidReq == null) {
                System.out.println("  ::-->  NULL Set");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getValidRequests");
        }
        return this.mValidReq;
    }

    SeqActivity getCurrentActivity() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getCurrentActivity");
        }
        if (_Debug) {
            if (this.mCurActivity != null) {
                System.out.println("  ::-->  " + this.mCurActivity.getID());
            } else {
                System.out.println("  ::-->  NULL current activity");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getCurrentActivity");
        }
        return this.mCurActivity;
    }

    public void setCurrentActivity(SeqActivity iCurrent) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setCurrentActivity");
            if (iCurrent != null) {
                System.out.println("  ::-->  " + iCurrent.getID());
            } else {
                System.out.println("  ::-->  NULL current activity.");
            }
        }
        this.mCurActivity = iCurrent;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setCurrentActivity");
        }
    }

    SeqActivity getFirstCandidate() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getFirstCandidate");
        }
        if (_Debug) {
            if (this.mFirstCandidate != null) {
                System.out.println("  ::-->  " + this.mFirstCandidate.getID());
            } else if (this.mCurActivity != null) {
                System.out.println("  ::--> [Cur] " + this.mCurActivity.getID());
            } else {
                System.out.println("  ::-->  NULL first candidate");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getFirstCandidate");
        }
        if (this.mFirstCandidate == null) {
            return this.mCurActivity;
        }
        return this.mFirstCandidate;
    }

    public void setFirstCandidate(SeqActivity iFirst) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setFirstCandidate");
            if (iFirst != null) {
                System.out.println("  ::-->  " + iFirst.getID());
            } else {
                System.out.println("  ::-->  NULL current activity.");
            }
        }
        this.mFirstCandidate = iFirst;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setFirstCandidate");
        }
    }

    void setSuspendAll(SeqActivity iSuspendTarget) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setSuspendAll");
            if (iSuspendTarget != null) {
                System.out.println("  ::-->  " + iSuspendTarget.getID());
            } else {
                System.out.println("  ::-->  NULL suspend target.");
            }
        }
        this.mSuspendAll = iSuspendTarget;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setSuspendAll");
        }
    }

    public SeqActivity getSuspendAll() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getSuspendAll");
            if (this.mSuspendAll != null) {
                System.out.println("  ::-->  " + this.mSuspendAll.getID());
            } else {
                System.out.println("  ::-->  NULL suspend all activity.");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getSuspendAll");
        }
        return this.mSuspendAll;
    }

    public SeqActivity getActivity(String iActivityID) {
        if (this.mActivityMap == null) {
            this.buildActivityMap();
        }
        SeqActivity temp = null;
        if (iActivityID != null) {
            temp = (SeqActivity)this.mActivityMap.get(iActivityID);
        }
        return temp;
    }

    public Vector getObjMap(String iObjID) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getObjMap");
        }
        Vector actSet = null;
        if (!this.mObjScan) {
            this.scanObjectives();
            if (this.mObjMap != null && this.mObjMap.size() == 0) {
                this.mObjMap = null;
            }
        }
        if (this.mObjMap != null) {
            actSet = (Vector)this.mObjMap.get(iObjID);
        }
        if (_Debug) {
            if (actSet == null) {
                System.out.println("  ::-->  NULL");
            } else {
                System.out.println("  ::--> [" + actSet.size() + "]");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getObjMap");
        }
        return actSet;
    }

    public Vector getGlobalObjectives() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - getGlobalObjectives");
        }
        if (!this.mObjScan) {
            this.scanObjectives();
        }
        if (_Debug) {
            if (this.mObjSet == null) {
                System.out.println("  ::-->  NULL");
            } else {
                System.out.println("  ::--> [" + this.mObjSet.size() + "]");
            }
            System.out.println("  :: SeqActivityTree  --> END   - getGlobalObjectives");
        }
        if (this.mObjSet != null && this.mObjSet.size() == 0) {
            this.mObjSet = null;
        }
        return this.mObjSet;
    }

    public void clearSessionState() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - clearSessionState");
        }
        this.mActivityMap = null;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - clearSessionState");
        }
    }

    public void setDepths() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setDepths");
        }
        if (this.mRoot != null) {
            SeqActivity walk = this.mRoot;
            int depth = 0;
            Vector<SeqActivity> lookAt = new Vector<SeqActivity>();
            Vector<Integer> depths = new Vector<Integer>();
            while (walk != null) {
                if (walk.hasChildren(true)) {
                    lookAt.add(walk);
                    depths.add(new Integer(depth + 1));
                }
                walk.setDepth(depth);
                if ((walk = walk.getNextSibling(true)) != null || lookAt.size() == 0) continue;
                walk = (SeqActivity)lookAt.elementAt(0);
                lookAt.remove(0);
                depth = (Integer)depths.elementAt(0);
                depths.remove(0);
                walk = (SeqActivity)walk.getChildren(true).elementAt(0);
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setDepths");
        }
    }

    public void setTreeCount() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - setTreeCount");
        }
        if (this.mRoot != null) {
            SeqActivity walk = this.mRoot;
            int count = 0;
            Vector<SeqActivity> lookAt = new Vector<SeqActivity>();
            while (walk != null) {
                walk.setCount(++count);
                if (walk.hasChildren(true)) {
                    lookAt.add(walk);
                    walk = (SeqActivity)walk.getChildren(true).elementAt(0);
                } else {
                    walk = walk.getNextSibling(true);
                }
                while (lookAt.size() != 0 && walk == null) {
                    walk = (SeqActivity)lookAt.elementAt(0);
                    lookAt.remove(0);
                    walk = walk.getNextSibling(true);
                }
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - setTreeCount");
        }
    }

    private void buildActivityMap() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - buildActivityMap");
        }
        if (this.mActivityMap != null) {
            this.mActivityMap.clear();
        } else {
            this.mActivityMap = new Hashtable();
        }
        if (this.mRoot != null) {
            this.addChildActivitiestoMap(this.mRoot);
        }
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - buildActivityMap");
        }
    }

    private void addChildActivitiestoMap(SeqActivity iNode) {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - addChildActivitiestoMap");
        }
        if (iNode != null) {
            Vector children = iNode.getChildren(true);
            int i = 0;
            if (_Debug) {
                System.out.println("  ::--> Adding node : " + iNode.getID());
            }
            this.mActivityMap.put(iNode.getID(), iNode);
            if (children != null) {
                for (i = 0; i < children.size(); ++i) {
                    this.addChildActivitiestoMap((SeqActivity)children.elementAt(i));
                }
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - addChildActivitiestoMap");
        }
    }

    private void scanObjectives() {
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> BEGIN - scanObjectives");
        }
        SeqActivity walk = this.mRoot;
        Vector<SeqActivity> lookAt = new Vector<SeqActivity>();
        while (walk != null) {
            Vector objs;
            if (walk.hasChildren(true)) {
                lookAt.add(walk);
            }
            if ((objs = walk.getObjectives()) != null) {
                for (int i = 0; i < objs.size(); ++i) {
                    SeqObjective obj = (SeqObjective)objs.elementAt(i);
                    if (obj.mMaps == null) continue;
                    for (int j = 0; j < obj.mMaps.size(); ++j) {
                        Vector<String> actList;
                        SeqObjectiveMap map = (SeqObjectiveMap)obj.mMaps.elementAt(j);
                        String target = map.mGlobalObjID;
                        if (this.mObjSet == null) {
                            this.mObjSet = new Vector();
                            this.mObjSet.add(target);
                        } else {
                            boolean found = false;
                            for (int k = 0; k < this.mObjSet.size() && !found; ++k) {
                                String id = (String)this.mObjSet.elementAt(k);
                                found = id.equals(target);
                            }
                            if (!found) {
                                this.mObjSet.add(target);
                            }
                        }
                        if (!map.mReadStatus && !map.mReadMeasure && !map.mReadCompletionStatus && !map.mReadProgressMeasure || !obj.mContributesToRollup) continue;
                        if (this.mObjMap == null) {
                            this.mObjMap = new Hashtable();
                        }
                        if ((actList = (Vector<String>)this.mObjMap.get(target)) == null) {
                            actList = new Vector<String>();
                        }
                        actList.add(walk.getID());
                        this.mObjMap.put(target, actList);
                    }
                }
            }
            if ((walk = walk.getNextSibling(true)) != null || lookAt.size() == 0) continue;
            walk = (SeqActivity)lookAt.elementAt(0);
            lookAt.remove(0);
            walk = (SeqActivity)walk.getChildren(true).elementAt(0);
        }
        this.mObjScan = true;
        if (_Debug) {
            System.out.println("  :: SeqActivityTree  --> END   - scanObjectives");
        }
    }

    public void setDataScopedForAllAttempts(boolean iAttributeValue) {
        this.mDataScopedForAllAttempts = iAttributeValue;
    }

    public boolean dataScopedForAllAttempts() {
        return this.mDataScopedForAllAttempts;
    }

    Hashtable getActivityMap() {
        if (this.mActivityMap == null) {
            this.buildActivityMap();
        }
        return this.mActivityMap;
    }

    static {
        dsMap = new HashMap();
    }
}

