/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Vector;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqCondition;
import org.adl.util.debug.DebugIndicator;

public class SeqConditionSet
implements Serializable {
    public static final int EVALUATE_UNKNOWN = 0;
    public static final int EVALUATE_TRUE = 1;
    public static final int EVALUATE_FALSE = -1;
    public static String COMBINATION_ALL = "all";
    public static String COMBINATION_ANY = "any";
    private static boolean _Debug = DebugIndicator.ON;
    public String mCombination = null;
    public Vector mConditions = null;
    private boolean mRetry = false;
    private boolean mRollup = false;

    public SeqConditionSet() {
    }

    public SeqConditionSet(boolean iRollup) {
        this.mRollup = iRollup;
    }

    public void dumpState() {
        if (_Debug) {
            System.out.println("  :: SeqConditionSet  --> BEGIN - dumpState");
            System.out.println("  ::--> Set : " + this.mCombination);
            if (this.mConditions != null) {
                System.out.println("  ::-->   [" + this.mConditions.size() + "]");
                System.out.println("  ::----------------::");
                for (int i = 0; i < this.mConditions.size(); ++i) {
                    SeqCondition cond = (SeqCondition)this.mConditions.elementAt(i);
                    cond.dumpState();
                }
            } else {
                System.out.println("         NULL");
                System.out.println("  ::----------------::");
            }
            System.out.println("  :: SeqConditionSet --> END   - dumpState");
        }
    }

    int evaluate(SeqActivity iThisActivity, boolean iIsRetry) {
        this.mRetry = iIsRetry;
        return this.evaluate(iThisActivity);
    }

    int evaluate(SeqActivity iThisActivity) {
        if (_Debug) {
            System.out.println("  :: SeqConditionSet --> BEGIN - evaluate");
            System.out.println("  :: --> RETRY == " + this.mRetry);
        }
        int result = 0;
        if (iThisActivity != null) {
            if (_Debug) {
                System.out.println("  ::-->  Set - " + this.mCombination);
                if (this.mConditions != null) {
                    System.out.println("  ::-->  [" + this.mConditions.size() + "]");
                } else {
                    System.out.println("  ::-->  NULL");
                }
            }
            if (this.mConditions != null) {
                if (this.mCombination.equals(COMBINATION_ALL)) {
                    result = 1;
                    for (int i = 0; i < this.mConditions.size(); ++i) {
                        int thisEval = this.evaluateCondition(i, iThisActivity);
                        if (thisEval == 1) continue;
                        result = thisEval;
                        break;
                    }
                } else if (this.mCombination.equals(COMBINATION_ANY)) {
                    result = -1;
                    for (int i = 0; i < this.mConditions.size(); ++i) {
                        int thisEval = this.evaluateCondition(i, iThisActivity);
                        if (thisEval == 1) {
                            result = 1;
                            break;
                        }
                        if (thisEval != 0) continue;
                        result = 0;
                    }
                }
            }
        }
        this.mRetry = false;
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: SeqConditionSet --> END   - evaluate");
        }
        return result;
    }

    private int evaluateCondition(int iIndex, SeqActivity iTarget) {
        if (_Debug) {
            System.out.println("  :: SeqConditionSet --> BEGIN - evaluateCondition");
            System.out.println("  ::-->  " + iTarget.getID());
            System.out.println("  ::-->  " + iIndex);
        }
        int result = 0;
        if (iIndex < this.mConditions.size()) {
            SeqCondition cond = (SeqCondition)this.mConditions.elementAt(iIndex);
            if (_Debug) {
                System.out.println("  ::--> Evaluate :: " + cond.mCondition);
            }
            if (cond.mCondition.equals(SeqCondition.ALWAYS)) {
                result = 1;
            } else if (cond.mCondition.equals(SeqCondition.NEVER)) {
                result = -1;
            } else if (cond.mCondition.equals(SeqCondition.SATISFIED)) {
                result = iTarget.getObjStatus(cond.mObjID, this.mRollup) ? (iTarget.getObjSatisfied(cond.mObjID, this.mRollup) ? 1 : -1) : 0;
            } else if (cond.mCondition.equals(SeqCondition.OBJSTATUSKNOWN)) {
                result = iTarget.getObjStatus(cond.mObjID, this.mRollup) ? 1 : -1;
            } else if (cond.mCondition.equals(SeqCondition.OBJMEASUREKNOWN)) {
                result = iTarget.getObjMeasureStatus(cond.mObjID, this.mRollup) ? 1 : -1;
            } else if (cond.mCondition.equals(SeqCondition.OBJMEASUREGRTHAN)) {
                result = iTarget.getObjMeasureStatus(cond.mObjID, this.mRollup) ? (iTarget.getObjMeasure(cond.mObjID, this.mRollup) > cond.mThreshold ? 1 : -1) : 0;
            } else if (cond.mCondition.equals(SeqCondition.OBJMEASURELSTHAN)) {
                result = iTarget.getObjMeasureStatus(cond.mObjID, this.mRollup) ? (iTarget.getObjMeasure(cond.mObjID, this.mRollup) < cond.mThreshold ? 1 : -1) : 0;
            } else if (cond.mCondition.equals(SeqCondition.COMPLETED)) {
                result = iTarget.getProgressStatus(cond.mObjID, this.mRollup) ? (iTarget.getAttemptCompleted(cond.mObjID, this.mRollup) ? 1 : -1) : 0;
            } else if (cond.mCondition.equals(SeqCondition.PROGRESSKNOWN)) {
                result = iTarget.getProgressStatus(cond.mObjID, this.mRollup) ? 1 : -1;
            } else if (cond.mCondition.equals(SeqCondition.ATTEMPTED)) {
                result = iTarget.getActivityAttempted() ? 1 : -1;
            } else if (cond.mCondition.equals(SeqCondition.ATTEMPTSEXCEEDED)) {
                long maxAttempt;
                if (iTarget.getAttemptLimitControl() && (maxAttempt = iTarget.getAttemptLimit()) >= 0L) {
                    result = iTarget.getNumAttempt() >= maxAttempt ? 1 : -1;
                }
            } else if (cond.mCondition.equals(SeqCondition.TIMELIMITEXCEEDED) || cond.mCondition.equals(SeqCondition.OUTSIDETIME)) {
                // empty if block
            }
            if (cond.mNot && result != 0) {
                if (_Debug) {
                    System.out.println("  ::--> Negate Result");
                }
                int n = result = result == -1 ? 1 : -1;
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + (result == 1 ? "True" : "False"));
            System.out.println("  :: SeqConditionSet --> END   - evaluateCondition");
        }
        return result;
    }
}

