/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Vector;
import org.adl.sequencer.SeqObjectiveMap;
import org.adl.util.debug.DebugIndicator;

public class SeqObjective
implements Serializable {
    private static boolean _Debug = DebugIndicator.ON;
    public String mObjID = "_primary_";
    public boolean mSatisfiedByMeasure = false;
    public boolean mActiveMeasure = true;
    public double mMinMeasure = 1.0;
    public boolean mContributesToRollup = false;
    public Vector mMaps = null;

    public void dumpState() {
        if (_Debug) {
            System.out.println("  :: ADLObjective  --> BEGIN - dumpState");
            System.out.println("  ::--> ID:                 " + this.mObjID);
            System.out.println("  ::--> Satisfy by Measure: " + this.mSatisfiedByMeasure);
            System.out.println("  ::--> Active Measure:     " + this.mActiveMeasure);
            System.out.println("  ::--> Min Measure:        " + this.mMinMeasure);
            System.out.println("  ::--> Contrib to Rollup:  " + this.mContributesToRollup);
            System.out.println("  ::--> ------------------- <--::");
            if (this.mMaps != null) {
                for (int i = 0; i < this.mMaps.size(); ++i) {
                    SeqObjectiveMap map = (SeqObjectiveMap)this.mMaps.elementAt(i);
                    map.dumpState();
                }
            }
            System.out.println("  :: ADLObjective --> END   - dumpState");
        }
    }

    public boolean equals(Object iToCompare) {
        if (iToCompare instanceof SeqObjective) {
            SeqObjective other = (SeqObjective)iToCompare;
            return this.mObjID.equals(other.mObjID);
        }
        return false;
    }

    public int hashCode() {
        return this.mObjID != null ? this.mObjID.hashCode() : 0;
    }

    public void merge(SeqObjective toadd) {
        if (toadd.equals(this)) {
            if (this.mMaps != null) {
                for (int i = 0; i < toadd.mMaps.size(); ++i) {
                    SeqObjectiveMap candidate = (SeqObjectiveMap)toadd.mMaps.get(i);
                    if (this.mMaps.contains(candidate)) {
                        ((SeqObjectiveMap)this.mMaps.get(this.mMaps.indexOf(candidate))).merge(candidate);
                        continue;
                    }
                    this.mMaps.add(candidate);
                }
            } else {
                this.mMaps = toadd.mMaps;
            }
        }
    }
}

