/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import org.adl.util.debug.DebugIndicator;

public class SeqObjectiveMap
implements Serializable {
    private static boolean _Debug = DebugIndicator.ON;
    public String mGlobalObjID = null;
    public boolean mReadStatus = true;
    public boolean mReadMeasure = true;
    public boolean mReadRawScore = true;
    public boolean mReadMinScore = true;
    public boolean mReadMaxScore = true;
    public boolean mReadCompletionStatus = true;
    public boolean mReadProgressMeasure = true;
    public boolean mWriteStatus = false;
    public boolean mWriteMeasure = false;
    public boolean mWriteRawScore = false;
    public boolean mWriteMinScore = false;
    public boolean mWriteMaxScore = false;
    public boolean mWriteCompletionStatus = false;
    public boolean mWriteProgressMeasure = false;

    public boolean hasWriteMaps() {
        return this.mWriteCompletionStatus || this.mWriteMaxScore || this.mWriteMeasure || this.mWriteMinScore || this.mWriteProgressMeasure || this.mWriteRawScore || this.mWriteStatus;
    }

    public boolean hasReadMaps() {
        return this.mReadCompletionStatus || this.mReadMaxScore || this.mReadMeasure || this.mReadMinScore || this.mReadProgressMeasure || this.mReadRawScore || this.mReadStatus;
    }

    public void dumpState() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveMap   --> BEGIN - dumpState");
            System.out.println("  ::--> Global ID: " + this.mGlobalObjID);
            System.out.println("  ::--> Read Satisfied Status?: " + this.mReadStatus);
            System.out.println("  ::--> Read Measure?: " + this.mReadMeasure);
            System.out.println("  ::--> Read Raw Score?: " + this.mReadRawScore);
            System.out.println("  ::--> Read Min Score?: " + this.mReadMinScore);
            System.out.println("  ::--> Read Max Score?: " + this.mReadMaxScore);
            System.out.println("  ::--> Read Completion Status?: " + this.mReadCompletionStatus);
            System.out.println("  ::--> Read Progress Measure?: " + this.mReadProgressMeasure);
            System.out.println("  ::--> Write Satisfied Status?: " + this.mWriteStatus);
            System.out.println("  ::--> Write Measure?: " + this.mWriteMeasure);
            System.out.println("  ::--> Write Raw Score?: " + this.mWriteRawScore);
            System.out.println("  ::--> Write Min Score?: " + this.mWriteMinScore);
            System.out.println("  ::--> Write Max Score?: " + this.mWriteMaxScore);
            System.out.println("  ::--> Write Completion Status?: " + this.mWriteCompletionStatus);
            System.out.println("  ::--> Write Progress Measure?: " + this.mWriteProgressMeasure);
            System.out.println("  :: SeqObjectiveMap   --> END   - dumpState");
        }
    }

    public boolean equals(Object iToCompare) {
        if (iToCompare instanceof SeqObjectiveMap) {
            SeqObjectiveMap other = (SeqObjectiveMap)iToCompare;
            return this.mGlobalObjID.equals(other.mGlobalObjID);
        }
        return false;
    }

    public int hashCode() {
        return this.mGlobalObjID != null ? this.mGlobalObjID.hashCode() : 0;
    }

    public void merge(SeqObjectiveMap candidate) {
        if (this.mGlobalObjID.equals(candidate.mGlobalObjID)) {
            this.mReadStatus = this.mReadStatus || candidate.mReadStatus;
            this.mReadMeasure = this.mReadMeasure || candidate.mReadMeasure;
            this.mReadRawScore = this.mReadRawScore || candidate.mReadRawScore;
            this.mReadMinScore = this.mReadMinScore || candidate.mReadMinScore;
            this.mReadMaxScore = this.mReadMaxScore || candidate.mReadMaxScore;
            this.mReadCompletionStatus = this.mReadCompletionStatus || candidate.mReadCompletionStatus;
            this.mReadProgressMeasure = this.mReadProgressMeasure || candidate.mReadProgressMeasure;
            this.mWriteStatus = this.mWriteStatus || candidate.mWriteStatus;
            this.mWriteMeasure = this.mWriteMeasure || candidate.mWriteMeasure;
            this.mWriteRawScore = this.mWriteRawScore || candidate.mWriteRawScore;
            this.mWriteMinScore = this.mWriteMinScore || candidate.mWriteMinScore;
            this.mWriteMaxScore = this.mWriteMaxScore || candidate.mWriteMaxScore;
            this.mWriteCompletionStatus = this.mWriteCompletionStatus || candidate.mWriteCompletionStatus;
            this.mWriteProgressMeasure = this.mWriteProgressMeasure || candidate.mWriteProgressMeasure;
        }
    }
}

