/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Vector;
import org.adl.sequencer.ADLSeqUtilities;
import org.adl.sequencer.ADLTracking;
import org.adl.sequencer.SeqObjective;
import org.adl.sequencer.SeqObjectiveMap;
import org.adl.util.debug.DebugIndicator;

public class SeqObjectiveTracking
implements Serializable {
    private static boolean _Debug = DebugIndicator.ON;
    private String mLearnerID = null;
    private String mScopeID = null;
    private SeqObjective mObj = null;
    private boolean mDirtyObj = false;
    private boolean mSetOK = false;
    private boolean mHasSatisfied = false;
    private boolean mSatisfied = false;
    private boolean mHasMeasure = false;
    private double mMeasure = 0.0;
    private boolean mHasRawScore = false;
    private double mRawScore = 0.0;
    private boolean mHasMinScore = false;
    private double mMinScore = 0.0;
    private boolean mHasMaxScore = false;
    private double mMaxScore = 0.0;
    private boolean mHasProgressMeasure = false;
    private double mProgressMeasure = 0.0;
    private boolean mHasCompletionStatus = false;
    private String mCompletionStatus = "unknown";
    private String mReadStatus = null;
    private String mReadMeasure = null;
    private String mReadRawScore = null;
    private String mReadMinScore = null;
    private String mReadMaxScore = null;
    private String mReadCompletionStatus = null;
    private String mReadProgressMeasure = null;
    private Vector mWriteStatus = null;
    private Vector mWriteMeasure = null;
    private Vector mWriteRawScore = null;
    private Vector mWriteMinScore = null;
    private Vector mWriteMaxScore = null;
    private Vector mWriteCompletionStatus = null;
    private Vector mWriteProgressMeasure = null;

    public SeqObjectiveTracking(SeqObjective iObj, String iLearnerID, String iScopeID) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking --> BEGIN -  constructor");
            System.out.println("  ::--> " + iLearnerID);
            System.out.println("  ::--> " + iScopeID);
        }
        if (iObj != null) {
            if (_Debug) {
                System.out.println("  ::--> Objective ID : " + iObj.mObjID);
            }
            this.mObj = iObj;
            this.mLearnerID = iLearnerID;
            this.mScopeID = iScopeID;
            if (iObj.mMaps != null) {
                if (_Debug) {
                    System.out.println("  ::--> Setting up obj maps");
                }
                for (int i = 0; i < this.mObj.mMaps.size(); ++i) {
                    SeqObjectiveMap map = (SeqObjectiveMap)this.mObj.mMaps.elementAt(i);
                    if (map.mReadStatus) {
                        this.mReadStatus = map.mGlobalObjID;
                    }
                    if (map.mReadMeasure) {
                        this.mReadMeasure = map.mGlobalObjID;
                    }
                    if (map.mReadRawScore) {
                        this.mReadRawScore = map.mGlobalObjID;
                    }
                    if (map.mReadMinScore) {
                        this.mReadMinScore = map.mGlobalObjID;
                    }
                    if (map.mReadMaxScore) {
                        this.mReadMaxScore = map.mGlobalObjID;
                    }
                    if (map.mReadCompletionStatus) {
                        this.mReadCompletionStatus = map.mGlobalObjID;
                    }
                    if (map.mReadProgressMeasure) {
                        this.mReadProgressMeasure = map.mGlobalObjID;
                    }
                    if (map.mWriteStatus) {
                        if (this.mWriteStatus == null) {
                            this.mWriteStatus = new Vector();
                        }
                        this.mWriteStatus.add(map.mGlobalObjID);
                    }
                    if (map.mWriteMeasure) {
                        if (this.mWriteMeasure == null) {
                            this.mWriteMeasure = new Vector();
                        }
                        this.mWriteMeasure.add(map.mGlobalObjID);
                    }
                    if (map.mWriteRawScore) {
                        if (this.mWriteRawScore == null) {
                            this.mWriteRawScore = new Vector();
                        }
                        this.mWriteRawScore.add(map.mGlobalObjID);
                    }
                    if (map.mWriteMinScore) {
                        if (this.mWriteMinScore == null) {
                            this.mWriteMinScore = new Vector();
                        }
                        this.mWriteMinScore.add(map.mGlobalObjID);
                    }
                    if (map.mWriteMaxScore) {
                        if (this.mWriteMaxScore == null) {
                            this.mWriteMaxScore = new Vector();
                        }
                        this.mWriteMaxScore.add(map.mGlobalObjID);
                    }
                    if (map.mWriteCompletionStatus) {
                        if (this.mWriteCompletionStatus == null) {
                            this.mWriteCompletionStatus = new Vector();
                        }
                        this.mWriteCompletionStatus.add(map.mGlobalObjID);
                    }
                    if (!map.mWriteProgressMeasure) continue;
                    if (this.mWriteProgressMeasure == null) {
                        this.mWriteProgressMeasure = new Vector();
                    }
                    this.mWriteProgressMeasure.add(map.mGlobalObjID);
                }
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : No associated objective");
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking --> END   -  constructor");
        }
    }

    String getObjID() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - getObjID");
            System.out.println("  ::-->  " + this.mObj.mObjID);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjID");
        }
        return this.mObj.mObjID;
    }

    SeqObjective getObj() {
        return this.mObj;
    }

    void forceObjStatus(String iSatisfied) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - forceObjStatus");
            System.out.println("  ::-->  " + iSatisfied);
        }
        if (iSatisfied.equals(ADLTracking.TRACK_UNKNOWN)) {
            this.clearObjStatus();
        } else {
            if (this.mWriteStatus != null) {
                for (int i = 0; i < this.mWriteStatus.size(); ++i) {
                    String objID = (String)this.mWriteStatus.elementAt(i);
                    ADLSeqUtilities.setGlobalObjSatisfied(objID, this.mLearnerID, this.mScopeID, iSatisfied);
                }
            }
            this.mHasSatisfied = true;
            this.mSatisfied = iSatisfied.equals(ADLTracking.TRACK_SATISFIED);
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END   - forceObjStatus");
        }
    }

    void setObjStatus(String iSatisfied) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjStatus");
            System.out.println("  ::-->  " + this.mObj.mObjID);
            System.out.println("  ::-->  " + iSatisfied);
        }
        if (this.mObj.mSatisfiedByMeasure && !this.mSetOK) {
            if (_Debug) {
                System.out.println("  ::--> Cannot set: Objective satisfied by measure");
            }
        } else if (iSatisfied.equals(ADLTracking.TRACK_UNKNOWN)) {
            this.clearObjStatus();
        } else {
            if (this.mWriteStatus != null) {
                for (int i = 0; i < this.mWriteStatus.size(); ++i) {
                    String objID = (String)this.mWriteStatus.elementAt(i);
                    ADLSeqUtilities.setGlobalObjSatisfied(objID, this.mLearnerID, this.mScopeID, iSatisfied);
                }
            }
            this.mHasSatisfied = true;
            this.mSatisfied = iSatisfied.equals(ADLTracking.TRACK_SATISFIED);
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END   - setObjStatus");
        }
    }

    boolean clearObjStatus() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjStatus");
        }
        boolean statusChange = false;
        if (this.mHasSatisfied) {
            if (this.mObj.mSatisfiedByMeasure) {
                if (_Debug) {
                    System.out.println("  ::--> Cannot clear: Objective satisfied by measure");
                }
            } else {
                if (this.mWriteStatus != null) {
                    for (int i = 0; i < this.mWriteStatus.size(); ++i) {
                        String objID = (String)this.mWriteStatus.elementAt(i);
                        ADLSeqUtilities.setGlobalObjSatisfied(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                    }
                }
                this.mHasSatisfied = false;
                statusChange = true;
            }
        }
        if (_Debug) {
            System.out.println("  :: has satisfied --> " + this.mHasSatisfied);
            System.out.println("  :: status change --> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjStatus");
        }
        return statusChange;
    }

    boolean clearObjMeasure(boolean iAffectSatisfaction) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjMeasure");
            System.out.println("  ::--> " + iAffectSatisfaction);
        }
        boolean statusChange = false;
        if (this.mHasMeasure) {
            if (this.mWriteMeasure != null) {
                for (int i = 0; i < this.mWriteMeasure.size(); ++i) {
                    String objID = (String)this.mWriteMeasure.elementAt(i);
                    ADLSeqUtilities.setGlobalObjMeasure(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                }
            }
            this.mHasMeasure = false;
            if (iAffectSatisfaction) {
                this.forceObjStatus(ADLTracking.TRACK_UNKNOWN);
            }
        }
        if (_Debug) {
            System.out.println("  ::--> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjMeasure");
        }
        return statusChange;
    }

    boolean clearObjRawScore() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjRawScore");
        }
        boolean statusChange = false;
        if (this.mHasRawScore) {
            if (this.mWriteRawScore != null) {
                for (int i = 0; i < this.mWriteRawScore.size(); ++i) {
                    String objID = (String)this.mWriteRawScore.elementAt(i);
                    ADLSeqUtilities.setGlobalObjRawScore(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                }
            }
            this.mHasRawScore = false;
            statusChange = true;
        }
        if (_Debug) {
            System.out.println("  ::--> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjRawScore");
        }
        return statusChange;
    }

    boolean clearObjMinScore() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjMinScore");
        }
        boolean statusChange = false;
        if (this.mHasMinScore) {
            if (this.mWriteMinScore != null) {
                for (int i = 0; i < this.mWriteMinScore.size(); ++i) {
                    String objID = (String)this.mWriteMinScore.elementAt(i);
                    ADLSeqUtilities.setGlobalObjMinScore(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                }
            }
            this.mHasMinScore = false;
            statusChange = true;
        }
        if (_Debug) {
            System.out.println("  ::--> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjMinScore");
        }
        return statusChange;
    }

    boolean clearObjMaxScore() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjMaxScore");
        }
        boolean statusChange = false;
        if (this.mHasMaxScore) {
            if (this.mWriteMaxScore != null) {
                for (int i = 0; i < this.mWriteMaxScore.size(); ++i) {
                    String objID = (String)this.mWriteMaxScore.elementAt(i);
                    ADLSeqUtilities.setGlobalObjMaxScore(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                }
            }
            this.mHasMaxScore = false;
            statusChange = true;
        }
        if (_Debug) {
            System.out.println("  ::--> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjMaxScore");
        }
        return statusChange;
    }

    boolean clearObjProgressMeasure() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjProgressMeasure");
        }
        boolean statusChange = false;
        if (this.mHasProgressMeasure) {
            if (this.mWriteProgressMeasure != null) {
                for (int i = 0; i < this.mWriteProgressMeasure.size(); ++i) {
                    String objID = (String)this.mWriteProgressMeasure.elementAt(i);
                    ADLSeqUtilities.setGlobalObjProgressMeasure(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                }
            }
            this.mHasProgressMeasure = false;
            statusChange = true;
        }
        if (_Debug) {
            System.out.println("  ::--> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjProgressMeasure");
        }
        return statusChange;
    }

    boolean clearObjCompletionStatus() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - clearObjCompletionStatus");
        }
        boolean statusChange = false;
        if (this.mHasCompletionStatus) {
            if (this.mWriteCompletionStatus != null) {
                for (int i = 0; i < this.mWriteCompletionStatus.size(); ++i) {
                    String objID = (String)this.mWriteCompletionStatus.elementAt(i);
                    ADLSeqUtilities.setGlobalObjCompletion(objID, this.mLearnerID, this.mScopeID, ADLTracking.TRACK_UNKNOWN);
                }
            }
            this.mHasCompletionStatus = false;
            statusChange = true;
        }
        if (_Debug) {
            System.out.println("  ::--> " + statusChange);
            System.out.println("  :: SeqObjectiveTracking   --> END   - clearObjCompletionStatus");
        }
        return statusChange;
    }

    void setObjMeasure(double iMeasure, boolean iAffectSatisfaction) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjMeasure");
            System.out.println("  ::-->  " + iMeasure);
            System.out.println("  ::-->  " + iAffectSatisfaction);
        }
        if (iMeasure < -1.0 || iMeasure > 1.0) {
            if (_Debug) {
                System.out.println("  ::--> Invalid Measure: " + iMeasure);
                System.out.println("  ::--> Assume 'Unknown'");
            }
            this.clearObjMeasure(iAffectSatisfaction);
        } else {
            this.mHasMeasure = true;
            this.mMeasure = iMeasure;
            if (this.mWriteMeasure != null) {
                for (int i = 0; i < this.mWriteMeasure.size(); ++i) {
                    String objID = (String)this.mWriteMeasure.elementAt(i);
                    ADLSeqUtilities.setGlobalObjMeasure(objID, this.mLearnerID, this.mScopeID, new Double(iMeasure).toString());
                }
            }
            if (iAffectSatisfaction) {
                if (this.mMeasure >= this.mObj.mMinMeasure) {
                    this.forceObjStatus(ADLTracking.TRACK_SATISFIED);
                } else {
                    this.forceObjStatus(ADLTracking.TRACK_NOTSATISFIED);
                }
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END - setObjMeasure");
        }
    }

    String getObjStatus(boolean iIsRetry) {
        return this.getObjStatus(iIsRetry, false);
    }

    String getObjStatus(boolean iIsRetry, boolean iUseLocal) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - getObjStatus");
            System.out.println("  ::  LOCAL --> " + iUseLocal);
        }
        String ret = ADLTracking.TRACK_UNKNOWN;
        boolean done = false;
        if (this.mObj.mSatisfiedByMeasure) {
            double val;
            block21: {
                if (_Debug) {
                    System.out.println("  ::--> Only using Measure +---><---+  ");
                }
                done = true;
                String measure = null;
                if (this.mReadMeasure != null) {
                    if (_Debug) {
                        System.out.println("  ::-->  Looking at shared measure");
                    }
                    measure = ADLSeqUtilities.getGlobalObjMeasure(this.mReadMeasure, this.mLearnerID, this.mScopeID);
                }
                if (this.mHasMeasure && measure == null) {
                    if (_Debug) {
                        System.out.println("  ::--> Using local measure");
                    }
                    if (!(!this.mHasMeasure || iIsRetry && this.mDirtyObj)) {
                        measure = new Double(this.mMeasure).toString();
                    }
                }
                val = -999.0;
                try {
                    val = new Double(measure);
                }
                catch (Exception e) {
                    if (!_Debug) break block21;
                    System.out.println("  ::--> ERROR: Bad measure value");
                }
            }
            if (val < -1.0 || val > 1.0) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR :  Invalid Measure: " + val);
                }
            } else {
                ret = val >= this.mObj.mMinMeasure ? ADLTracking.TRACK_SATISFIED : ADLTracking.TRACK_NOTSATISFIED;
            }
        }
        if (!done) {
            boolean globalvalexists = false;
            if (this.mReadStatus != null) {
                String status;
                if (_Debug) {
                    System.out.println("  ::--> Using shared status");
                }
                if ((status = ADLSeqUtilities.getGlobalObjSatisfied(this.mReadStatus, this.mLearnerID, this.mScopeID)) != null) {
                    ret = status;
                    done = true;
                    globalvalexists = true;
                }
            }
            if (!globalvalexists && this.mHasSatisfied && (!done || iUseLocal)) {
                if (_Debug) {
                    System.out.println("  ::--> Using local objective status");
                }
                if (!(!this.mHasSatisfied || iIsRetry && this.mDirtyObj)) {
                    ret = this.mSatisfied ? ADLTracking.TRACK_SATISFIED : ADLTracking.TRACK_NOTSATISFIED;
                }
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjStatus");
        }
        return ret;
    }

    String getObjMeasure(boolean iIsRetry) {
        return this.getObjMeasure(iIsRetry, false);
    }

    String getObjMeasure(boolean iIsRetry, boolean iUseLocal) {
        String ret = ADLTracking.TRACK_UNKNOWN;
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN   - getObjMeasure");
            System.out.println("  ::  LOCAL --> " + iUseLocal);
        }
        boolean done = false;
        boolean globalvalexists = false;
        if (this.mReadMeasure != null) {
            String measure;
            if (_Debug) {
                System.out.println("  ::-->  Looking at shared measure");
            }
            if ((measure = ADLSeqUtilities.getGlobalObjMeasure(this.mReadMeasure, this.mLearnerID, this.mScopeID)) != null) {
                ret = measure;
                done = true;
                globalvalexists = true;
            }
        }
        if (!globalvalexists && this.mHasMeasure && (!done || iUseLocal)) {
            if (_Debug) {
                System.out.println("  ::--> Using local measure");
            }
            if (!(!this.mHasMeasure || iIsRetry && this.mDirtyObj)) {
                ret = new Double(this.mMeasure).toString();
            }
        }
        if (!(ret.equals(ADLTracking.TRACK_UNKNOWN) || !this.mObj.mSatisfiedByMeasure || iIsRetry && this.mDirtyObj)) {
            double val;
            block16: {
                val = -999.0;
                try {
                    val = new Double(ret);
                }
                catch (Exception e) {
                    if (!_Debug) break block16;
                    System.out.println("  ::--> ERROR: Bad measure value");
                }
            }
            if (val < -1.0 || val > 1.0) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR :  Invalid Measure: " + val);
                }
            } else {
                this.mSetOK = true;
                if (val >= this.mObj.mMinMeasure) {
                    this.setObjStatus(ADLTracking.TRACK_SATISFIED);
                } else {
                    this.setObjStatus(ADLTracking.TRACK_NOTSATISFIED);
                }
                this.mSetOK = false;
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjMeasure");
        }
        return ret;
    }

    boolean getByMeasure() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - getByMeasure");
        }
        boolean byMeasure = false;
        if (this.mObj != null) {
            byMeasure = this.mObj.mSatisfiedByMeasure;
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END   - getByMeasure");
        }
        return byMeasure;
    }

    void setDirtyObj() {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking     --> BEGIN - setDirtyObj");
        }
        this.mDirtyObj = true;
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking     --> END   - setDirtyObj");
        }
    }

    String getObjRawScore(boolean iIsRetry) {
        String ret = ADLTracking.TRACK_UNKNOWN;
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN   - getObjRawScore");
            System.out.println("  ::  LOCAL --> false");
        }
        boolean done = false;
        boolean globalvalexists = false;
        if (this.mReadRawScore != null) {
            String rawscore;
            if (_Debug) {
                System.out.println("  ::-->  Looking at shared raw score");
            }
            if ((rawscore = ADLSeqUtilities.getGlobalObjRawScore(this.mReadRawScore, this.mLearnerID, this.mScopeID)) != null) {
                ret = rawscore;
                done = true;
                globalvalexists = true;
            }
        }
        if (!globalvalexists && this.mHasRawScore && !done) {
            if (_Debug) {
                System.out.println("  ::--> Using local raw score");
            }
            if (!(!this.mHasRawScore || iIsRetry && this.mDirtyObj)) {
                ret = Double.toString(this.mRawScore);
            }
        }
        if (!(ret.equals(ADLTracking.TRACK_UNKNOWN) || iIsRetry && this.mDirtyObj)) {
            try {
                Double.parseDouble(ret);
            }
            catch (Exception e) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: Bad raw score value");
                    System.out.println("  ::-->  " + ret);
                    System.out.println("  :: Returning " + ADLTracking.TRACK_UNKNOWN);
                    System.out.println("  :: SeqObjectiveTracking   --> END   - getObjRawScore");
                }
                return ADLTracking.TRACK_UNKNOWN;
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjRawScore");
        }
        return ret;
    }

    void setObjRawScore(double iRawScore) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjRawScore");
            System.out.println("  ::-->  " + iRawScore);
        }
        this.mHasRawScore = true;
        this.mRawScore = iRawScore;
        if (this.mWriteRawScore != null) {
            for (int i = 0; i < this.mWriteRawScore.size(); ++i) {
                String objID = (String)this.mWriteRawScore.elementAt(i);
                ADLSeqUtilities.setGlobalObjRawScore(objID, this.mLearnerID, this.mScopeID, Double.toString(iRawScore));
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END - setObjRawScore");
        }
    }

    String getObjMinScore(boolean iIsRetry) {
        String ret = ADLTracking.TRACK_UNKNOWN;
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN   - getObjMinScore");
            System.out.println("  ::  LOCAL --> false");
        }
        boolean done = false;
        boolean globalvalexists = false;
        if (this.mReadMinScore != null) {
            String minscore;
            if (_Debug) {
                System.out.println("  ::-->  Looking at shared min score");
            }
            if ((minscore = ADLSeqUtilities.getGlobalObjMinScore(this.mReadMinScore, this.mLearnerID, this.mScopeID)) != null) {
                ret = minscore;
                done = true;
                globalvalexists = true;
            }
        }
        if (!globalvalexists && this.mHasMinScore && !done) {
            if (_Debug) {
                System.out.println("  ::--> Using local min score");
            }
            if (!(!this.mHasMinScore || iIsRetry && this.mDirtyObj)) {
                ret = Double.toString(this.mMinScore);
            }
        }
        if (!(ret.equals(ADLTracking.TRACK_UNKNOWN) || iIsRetry && this.mDirtyObj)) {
            try {
                Double.parseDouble(ret);
            }
            catch (Exception e) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: Bad min score value");
                    System.out.println("  ::-->  " + ret);
                    System.out.println("  :: Returning " + ADLTracking.TRACK_UNKNOWN);
                    System.out.println("  :: SeqObjectiveTracking   --> END   - getObjMinScore");
                }
                return ADLTracking.TRACK_UNKNOWN;
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjMinScore");
        }
        return ret;
    }

    void setObjMinScore(double iMinScore) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjMinScore");
            System.out.println("  ::-->  " + iMinScore);
        }
        this.mHasMinScore = true;
        this.mMinScore = iMinScore;
        if (this.mWriteMinScore != null) {
            for (int i = 0; i < this.mWriteMinScore.size(); ++i) {
                String objID = (String)this.mWriteMinScore.elementAt(i);
                ADLSeqUtilities.setGlobalObjMinScore(objID, this.mLearnerID, this.mScopeID, Double.toString(iMinScore));
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END - setObjMinScore");
        }
    }

    String getObjMaxScore(boolean iIsRetry) {
        String ret = ADLTracking.TRACK_UNKNOWN;
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN   - getObjMaxScore");
            System.out.println("  ::  LOCAL --> false");
        }
        boolean done = false;
        boolean globalvalexists = false;
        if (this.mReadMaxScore != null) {
            String maxscore;
            if (_Debug) {
                System.out.println("  ::-->  Looking at shared max score");
            }
            if ((maxscore = ADLSeqUtilities.getGlobalObjMaxScore(this.mReadMaxScore, this.mLearnerID, this.mScopeID)) != null) {
                ret = maxscore;
                done = true;
                globalvalexists = true;
            }
        }
        if (!globalvalexists && this.mHasMaxScore && !done) {
            if (_Debug) {
                System.out.println("  ::--> Using local max score");
            }
            if (!(!this.mHasMaxScore || iIsRetry && this.mDirtyObj)) {
                ret = Double.toString(this.mMaxScore);
            }
        }
        if (!(ret.equals(ADLTracking.TRACK_UNKNOWN) || iIsRetry && this.mDirtyObj)) {
            try {
                Double.parseDouble(ret);
            }
            catch (Exception e) {
                if (_Debug) {
                    System.out.println("  ::--> ERROR: Bad max score value");
                    System.out.println("  ::-->  " + ret);
                    System.out.println("  :: Returning " + ADLTracking.TRACK_UNKNOWN);
                    System.out.println("  :: SeqObjectiveTracking   --> END   - getObjMaxScore");
                }
                return ADLTracking.TRACK_UNKNOWN;
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjMaxScore");
        }
        return ret;
    }

    void setObjMaxScore(double iMaxScore) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjMaxScore");
            System.out.println("  ::-->  " + iMaxScore);
        }
        this.mHasMaxScore = true;
        this.mMaxScore = iMaxScore;
        if (this.mWriteMaxScore != null) {
            for (int i = 0; i < this.mWriteMaxScore.size(); ++i) {
                String objID = (String)this.mWriteMaxScore.elementAt(i);
                ADLSeqUtilities.setGlobalObjMaxScore(objID, this.mLearnerID, this.mScopeID, Double.toString(iMaxScore));
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END - setObjMaxScore");
        }
    }

    String getObjProgressMeasure(boolean iDirtyProgress) {
        String ret = ADLTracking.TRACK_UNKNOWN;
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN   - getObjProgressMeasure");
            System.out.println("  ::  LOCAL --> false");
        }
        boolean done = false;
        boolean globalvalexists = false;
        if (this.mReadProgressMeasure != null) {
            String progress;
            if (_Debug) {
                System.out.println("  ::-->  Looking at shared progress measure");
                System.out.println("  ::-->  " + this.mReadProgressMeasure);
            }
            if ((progress = ADLSeqUtilities.getGlobalObjProgressMeasure(this.mReadProgressMeasure, this.mLearnerID, this.mScopeID)) != null && !progress.equals(ADLTracking.TRACK_UNKNOWN)) {
                ret = progress;
                done = true;
                globalvalexists = true;
            }
        }
        if (!globalvalexists && this.mHasProgressMeasure && !done) {
            if (_Debug) {
                System.out.println("  ::--> Using local progress measure");
            }
            if (this.mHasProgressMeasure && !iDirtyProgress) {
                ret = Double.toString(this.mProgressMeasure);
            }
        }
        if (!(ret.equals(ADLTracking.TRACK_UNKNOWN) || iDirtyProgress && this.mDirtyObj)) {
            double val;
            boolean valid;
            block13: {
                valid = true;
                val = -999.0;
                try {
                    val = Double.parseDouble(ret);
                }
                catch (Exception e) {
                    valid = false;
                    if (!_Debug) break block13;
                    System.out.println("  ::--> ERROR: Bad progress measure value");
                }
            }
            if (!valid || val < 0.0 || val > 1.0) {
                ret = ADLTracking.TRACK_UNKNOWN;
                if (_Debug) {
                    System.out.println("  ::--> ERROR :  Invalid Progress Measure " + val);
                }
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjProgressMeasure");
        }
        return ret;
    }

    void setObjProgressMeasure(double iProgressMeasure) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjProgressMeasure");
            System.out.println("  ::-->  " + iProgressMeasure);
        }
        if (iProgressMeasure < 0.0 || iProgressMeasure > 1.0) {
            if (_Debug) {
                System.out.println("  ::--> Invalid Measure: " + iProgressMeasure);
                System.out.println("  ::--> Assume 'Unknown'");
            }
            this.clearObjProgressMeasure();
        } else {
            this.mHasProgressMeasure = true;
            this.mProgressMeasure = iProgressMeasure;
            if (this.mWriteProgressMeasure != null) {
                for (int i = 0; i < this.mWriteProgressMeasure.size(); ++i) {
                    String objID = (String)this.mWriteProgressMeasure.elementAt(i);
                    ADLSeqUtilities.setGlobalObjProgressMeasure(objID, this.mLearnerID, this.mScopeID, Double.toString(iProgressMeasure));
                }
            }
        }
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> END - setObjProgressMeasure");
        }
    }

    String getObjCompletionStatus(boolean iDirtyProgress) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - getObjCompletionStatus");
            System.out.println("  ::  LOCAL --> false");
        }
        String ret = ADLTracking.TRACK_UNKNOWN;
        boolean done = false;
        boolean globalvalexists = false;
        if (this.mReadCompletionStatus != null) {
            String status;
            if (_Debug) {
                System.out.println("  ::--> Using shared status");
            }
            if ((status = ADLSeqUtilities.getGlobalObjCompletion(this.mReadCompletionStatus, this.mLearnerID, this.mScopeID)) != null && !status.equals(ADLTracking.TRACK_UNKNOWN)) {
                ret = status;
                done = true;
                globalvalexists = true;
            }
        }
        if (!globalvalexists && this.mHasCompletionStatus && !done) {
            if (_Debug) {
                System.out.println("  ::--> Using local objective status");
            }
            if (this.mHasCompletionStatus && !iDirtyProgress) {
                ret = this.mCompletionStatus;
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + ret);
            System.out.println("  :: SeqObjectiveTracking   --> END   - getObjCompletionStatus");
        }
        return ret;
    }

    void setObjCompletionStatus(String iCompletionStatus) {
        if (_Debug) {
            System.out.println("  :: SeqObjectiveTracking   --> BEGIN - setObjCompletionStatus");
            System.out.println("  ::-->  " + this.mObj.mObjID);
            System.out.println("  ::-->  " + iCompletionStatus);
        }
        this.mCompletionStatus = iCompletionStatus;
        this.mHasCompletionStatus = true;
        if (this.mWriteCompletionStatus != null) {
            for (int i = 0; i < this.mWriteCompletionStatus.size(); ++i) {
                String objID = (String)this.mWriteCompletionStatus.elementAt(i);
                ADLSeqUtilities.setGlobalObjCompletion(objID, this.mLearnerID, this.mScopeID, iCompletionStatus);
            }
        }
    }
}

