/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Vector;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqConditionSet;
import org.adl.sequencer.SeqRuleset;
import org.adl.util.debug.DebugIndicator;

public class SeqRollupRule
implements Serializable {
    public static final int ROLLUP_ACTION_NOCHANGE = 0;
    public static final int ROLLUP_ACTION_SATISFIED = 1;
    public static final int ROLLUP_ACTION_NOTSATISFIED = 2;
    public static final int ROLLUP_ACTION_COMPLETED = 3;
    public static final int ROLLUP_ACTION_INCOMPLETE = 4;
    public static String ROLLUP_CONSIDER_ALWAYS = "always";
    public static String ROLLUP_CONSIDER_ATTEMPTED = "ifAttempted";
    public static String ROLLUP_CONSIDER_NOTSKIPPED = "ifNotSkipped";
    public static String ROLLUP_CONSIDER_NOTSUSPENDED = "ifNotSuspended";
    public static String ROLLUP_SET_ALL = "all";
    public static String ROLLUP_SET_ANY = "any";
    public static String ROLLUP_SET_NONE = "none";
    public static String ROLLUP_SET_ATLEASTCOUNT = "atLeastCount";
    public static String ROLLUP_SET_ATLEASTPERCENT = "atLeastPercent";
    private static boolean _Debug = DebugIndicator.ON;
    public int mAction = 1;
    public String mChildActivitySet = ROLLUP_SET_ALL;
    public long mMinCount = 0L;
    public double mMinPercent = 0.0;
    public SeqConditionSet mConditions = null;

    public void setRollupAction(String iAction) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - setRollupAction");
            System.out.println("  :: " + iAction);
        }
        if (iAction.equals("satisfied")) {
            this.mAction = 1;
        } else if (iAction.equals("notSatisfied")) {
            this.mAction = 2;
        } else if (iAction.equals("completed")) {
            this.mAction = 3;
        } else if (iAction.equals("incomplete")) {
            this.mAction = 4;
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Invalid Action");
        }
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> END   - setRollupAction");
        }
    }

    public void dumpState() {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - dumpState");
            System.out.println("  ::--> Action      : " + this.mAction);
            System.out.println("  ::--> Set         : " + this.mChildActivitySet);
            System.out.println("  ::--> minCount    : " + this.mMinCount);
            System.out.println("  ::--> minPercent  : " + this.mMinPercent);
            System.out.println("  ------------------- ");
            if (this.mConditions != null) {
                this.mConditions.dumpState();
            } else {
                System.out.println("  ::--> NULL conditions");
            }
            System.out.println("  :: SeqRollupRule  --> END   - dumpState");
        }
    }

    public int evaluate(Vector iChildren) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - evaluate");
        }
        boolean result = false;
        if (this.mChildActivitySet.equals(ROLLUP_SET_ALL)) {
            result = this.evaluateAll(iChildren);
        } else if (this.mChildActivitySet.equals(ROLLUP_SET_ANY)) {
            result = this.evaluateAny(iChildren);
        } else if (this.mChildActivitySet.equals(ROLLUP_SET_NONE)) {
            result = this.evaluateNone(iChildren);
        } else if (this.mChildActivitySet.equals(ROLLUP_SET_ATLEASTCOUNT)) {
            result = this.evaluateMinCount(iChildren);
        } else if (this.mChildActivitySet.equals(ROLLUP_SET_ATLEASTPERCENT)) {
            result = this.evaluateMinPercent(iChildren);
        }
        int action = 0;
        if (result) {
            action = this.mAction;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + action);
            System.out.println("  :: SeqRollupRule  --> END - evaluate");
        }
        return action;
    }

    private boolean isIncluded(SeqActivity iActivity) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - isIncluded");
            System.out.println("  ::-->  " + iActivity.getID());
        }
        boolean include = true;
        if (iActivity.getIsTracked()) {
            if (iActivity.getDeliveryMode().equals("normal")) {
                if (this.mAction == 1 || this.mAction == 2) {
                    include = iActivity.getIsObjRolledUp();
                } else if (this.mAction == 3 || this.mAction == 4) {
                    include = iActivity.getIsProgressRolledUp();
                }
            } else {
                include = false;
            }
        } else {
            include = false;
        }
        if (include) {
            String consider = null;
            switch (this.mAction) {
                case 1: {
                    consider = iActivity.getRequiredForSatisfied();
                    break;
                }
                case 2: {
                    consider = iActivity.getRequiredForNotSatisfied();
                    break;
                }
                case 3: {
                    consider = iActivity.getRequiredForCompleted();
                    break;
                }
                case 4: {
                    consider = iActivity.getRequiredForIncomplete();
                    break;
                }
                default: {
                    include = false;
                    if (!_Debug) break;
                    System.out.println("  ::--> ERROR :: Invalid rollup action");
                }
            }
            if (consider != null) {
                if (consider.equals(ROLLUP_CONSIDER_NOTSUSPENDED)) {
                    if (_Debug) {
                        System.out.println("  ::--> Looking At Not Suspended");
                    }
                    if (iActivity.getActivityAttempted() && iActivity.getIsSuspended()) {
                        include = false;
                    }
                } else if (consider.equals(ROLLUP_CONSIDER_ATTEMPTED)) {
                    if (_Debug) {
                        System.out.println("  ::--> Looking At Attempted");
                    }
                    include = iActivity.getActivityAttempted();
                } else if (consider.equals(ROLLUP_CONSIDER_NOTSKIPPED)) {
                    if (_Debug) {
                        System.out.println("  ::--> Looking At Not Skipped");
                    }
                    SeqRuleset skippedRules = iActivity.getPreSeqRules();
                    String result = null;
                    if (skippedRules != null) {
                        result = skippedRules.evaluate(4, iActivity, false);
                    }
                    if (result != null) {
                        include = false;
                    }
                } else {
                    if (_Debug) {
                        System.out.println("  ::--> Looking At Always");
                    }
                    include = true;
                }
            }
        }
        if (_Debug) {
            System.out.println("  ::-->  " + include);
            System.out.println("  :: SeqRollupRule  --> END   - isIncluded");
        }
        return include;
    }

    private boolean evaluateAll(Vector iChildren) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - evaluateAll");
        }
        boolean result = true;
        boolean emptySet = true;
        boolean considered = false;
        SeqActivity tempActivity = null;
        for (int i = 0; result && i < iChildren.size(); ++i) {
            tempActivity = (SeqActivity)iChildren.elementAt(i);
            if (!this.isIncluded(tempActivity)) continue;
            considered = true;
            int eval = this.mConditions.evaluate(tempActivity);
            result = result && eval == 1;
            emptySet = emptySet && eval == 0;
        }
        if (considered && emptySet) {
            result = false;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: SeqRollupRule  --> END   - evaluateAll");
        }
        return result;
    }

    private boolean evaluateAny(Vector iChildren) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - evaluateAny");
        }
        boolean result = false;
        SeqActivity tempActivity = null;
        for (int i = 0; !result && i < iChildren.size(); ++i) {
            tempActivity = (SeqActivity)iChildren.elementAt(i);
            if (!this.isIncluded(tempActivity)) continue;
            int eval = this.mConditions.evaluate(tempActivity);
            result = result || eval == 1;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: SeqRollupRule  --> END   - evaluateAny");
        }
        return result;
    }

    private boolean evaluateNone(Vector iChildren) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - evaluateNone");
        }
        boolean result = true;
        SeqActivity tempActivity = null;
        for (int i = 0; result && i < iChildren.size(); ++i) {
            tempActivity = (SeqActivity)iChildren.elementAt(i);
            if (!this.isIncluded(tempActivity)) continue;
            int eval = this.mConditions.evaluate(tempActivity);
            result = result && eval != 1 && eval != 0;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: SeqRollupRule  --> END   - evaluateNone");
        }
        return result;
    }

    private boolean evaluateMinCount(Vector iChildren) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - evaluateMinSize");
        }
        long count = 0L;
        boolean emptySet = true;
        SeqActivity tempActivity = null;
        for (int i = 0; count < this.mMinCount && i < iChildren.size(); ++i) {
            tempActivity = (SeqActivity)iChildren.elementAt(i);
            if (!this.isIncluded(tempActivity)) continue;
            int eval = this.mConditions.evaluate(tempActivity);
            if (eval == 1) {
                ++count;
            }
            emptySet = emptySet && eval == 0;
        }
        boolean result = false;
        if (!emptySet) {
            boolean bl = result = count >= this.mMinCount;
        }
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: SeqRollupRule  --> END   - evaluateMinSize");
        }
        return result;
    }

    private boolean evaluateMinPercent(Vector iChildren) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRule  --> BEGIN - evaluateMinPercent");
        }
        long countAll = 0L;
        long count = 0L;
        boolean emptySet = true;
        SeqActivity tempActivity = null;
        for (int i = 0; i < iChildren.size(); ++i) {
            tempActivity = (SeqActivity)iChildren.elementAt(i);
            if (!this.isIncluded(tempActivity)) continue;
            ++countAll;
            int eval = this.mConditions.evaluate(tempActivity);
            if (eval == 1) {
                ++count;
            }
            emptySet = emptySet && eval == 0;
        }
        boolean result = false;
        if (!emptySet) {
            boolean bl = result = count >= (long)(this.mMinPercent * (double)countAll + 0.5);
        }
        if (_Debug) {
            System.out.println("  ::-->  " + result);
            System.out.println("  :: SeqRollupRule  --> END   - evaluateMinPercent");
        }
        return result;
    }
}

