/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Vector;
import org.adl.sequencer.ADLTracking;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqCondition;
import org.adl.sequencer.SeqConditionSet;
import org.adl.sequencer.SeqRollupRule;
import org.adl.util.debug.DebugIndicator;

public class SeqRollupRuleset
implements Serializable {
    private static boolean _Debug = DebugIndicator.ON;
    private Vector mRollupRules = null;
    private boolean mIsSatisfied = false;
    private boolean mIsNotSatisfied = false;
    private boolean mIsCompleted = false;
    private boolean mIsIncomplete = false;

    public SeqRollupRuleset() {
    }

    public SeqRollupRuleset(Vector iRules) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> BEGIN - constructor");
            if (iRules == null) {
                System.out.println("  ::--> Default Rules");
            } else {
                for (int i = 0; i < iRules.size(); ++i) {
                    SeqRollupRule temp = (SeqRollupRule)iRules.elementAt(i);
                    temp.dumpState();
                }
            }
        }
        this.mRollupRules = iRules;
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> END   - constructor");
        }
    }

    public void evaluate(SeqActivity ioThisActivity) {
        this.mIsCompleted = false;
        this.mIsIncomplete = false;
        this.mIsSatisfied = false;
        this.mIsNotSatisfied = false;
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> BEGIN - evaluate");
            if (this.mRollupRules != null) {
                System.out.println("  ::-->  " + this.mRollupRules.size());
            } else {
                System.out.println("  ::-->  NULL");
            }
        }
        if (ioThisActivity != null) {
            if (ioThisActivity.getChildren(false) != null) {
                SeqRollupRule rule;
                SeqCondition cond;
                SeqRollupRule rule2;
                int i;
                this.applyMeasureRollup(ioThisActivity);
                this.applyProgressMeasureRollup(ioThisActivity);
                boolean satisfiedRule = false;
                boolean completedRule = false;
                if (this.mRollupRules != null) {
                    for (i = 0; i < this.mRollupRules.size(); ++i) {
                        rule2 = (SeqRollupRule)this.mRollupRules.elementAt(i);
                        if (rule2.mAction == 1 || rule2.mAction == 2) {
                            satisfiedRule = true;
                        }
                        if (rule2.mAction != 3 && rule2.mAction != 4) continue;
                        completedRule = true;
                    }
                }
                if (!satisfiedRule) {
                    if (_Debug) {
                        System.out.println("  ::--> Creating default satisfied rules");
                    }
                    if (this.mRollupRules == null) {
                        this.mRollupRules = new Vector();
                    }
                    SeqConditionSet set = new SeqConditionSet(true);
                    cond = new SeqCondition();
                    rule = new SeqRollupRule();
                    set.mCombination = SeqConditionSet.COMBINATION_ANY;
                    set.mConditions = new Vector();
                    cond.mCondition = SeqCondition.OBJSTATUSKNOWN;
                    set.mConditions.add(cond);
                    set.mConditions.add(cond);
                    rule.mAction = 2;
                    rule.mConditions = set;
                    this.mRollupRules.add(rule);
                    rule = new SeqRollupRule();
                    set = new SeqConditionSet(true);
                    cond = new SeqCondition();
                    set.mCombination = SeqConditionSet.COMBINATION_ALL;
                    cond.mCondition = SeqCondition.SATISFIED;
                    set.mConditions = new Vector();
                    set.mConditions.add(cond);
                    rule.mAction = 1;
                    rule.mConditions = set;
                    this.mRollupRules.add(rule);
                }
                if (!completedRule) {
                    if (_Debug) {
                        System.out.println("  ::--> Creating default completion rules");
                    }
                    if (this.mRollupRules == null) {
                        this.mRollupRules = new Vector();
                    }
                    SeqConditionSet set = new SeqConditionSet(true);
                    cond = new SeqCondition();
                    rule = new SeqRollupRule();
                    set.mCombination = SeqConditionSet.COMBINATION_ANY;
                    set.mConditions = new Vector();
                    cond.mCondition = SeqCondition.PROGRESSKNOWN;
                    set.mConditions.add(cond);
                    set.mConditions.add(cond);
                    rule.mAction = 4;
                    rule.mConditions = set;
                    this.mRollupRules.add(rule);
                    rule = new SeqRollupRule();
                    set = new SeqConditionSet(true);
                    cond = new SeqCondition();
                    set.mCombination = SeqConditionSet.COMBINATION_ALL;
                    cond.mCondition = SeqCondition.COMPLETED;
                    set.mConditions = new Vector();
                    set.mConditions.add(cond);
                    rule = new SeqRollupRule();
                    rule.mAction = 3;
                    rule.mConditions = set;
                    this.mRollupRules.add(rule);
                }
                if (_Debug) {
                    System.out.println("  ::--> Size == " + this.mRollupRules.size());
                }
                block14: for (i = 0; i < this.mRollupRules.size(); ++i) {
                    rule2 = (SeqRollupRule)this.mRollupRules.elementAt(i);
                    if (_Debug) {
                        System.out.print("  :: EVALUATE ::-->  ");
                        switch (rule2.mAction) {
                            case 1: {
                                System.out.println("satisified");
                                break;
                            }
                            case 2: {
                                System.out.println("notSatisified");
                                break;
                            }
                            case 3: {
                                System.out.println("completed");
                                break;
                            }
                            case 4: {
                                System.out.println("incomplete");
                                break;
                            }
                            default: {
                                System.out.println("ERROR");
                            }
                        }
                    }
                    int result = rule2.evaluate(ioThisActivity.getChildren(false));
                    switch (result) {
                        case 0: {
                            if (!_Debug) continue block14;
                            System.out.println("  :+ NO STATUS CHANGE +: CHANGE");
                            continue block14;
                        }
                        case 1: {
                            if (_Debug) {
                                System.out.println("  :+ SATISFIED +: CHANGE");
                            }
                            this.mIsSatisfied = true;
                            continue block14;
                        }
                        case 2: {
                            if (_Debug) {
                                System.out.println("  :+ NOT SATISFIED +: CHANGE");
                            }
                            this.mIsNotSatisfied = true;
                            continue block14;
                        }
                        case 3: {
                            if (_Debug) {
                                System.out.println("  :+ COMPLETED +: CHANGE");
                            }
                            this.mIsCompleted = true;
                            continue block14;
                        }
                        case 4: {
                            if (_Debug) {
                                System.out.println("  :+ INCOMPLETE +: CHANGE");
                            }
                            this.mIsIncomplete = true;
                            continue block14;
                        }
                    }
                }
                if (!ioThisActivity.getObjSatisfiedByMeasure()) {
                    if (_Debug) {
                        System.out.println("  ::--> Objective rollup using rules");
                    }
                    if (this.mIsSatisfied) {
                        ioThisActivity.setObjSatisfied(ADLTracking.TRACK_SATISFIED);
                    } else if (this.mIsNotSatisfied) {
                        if (ioThisActivity.isPrimaryStatusSetBySCO() && ioThisActivity.getObjSatValue().equals(ADLTracking.TRACK_UNKNOWN)) {
                            if (_Debug) {
                                System.out.println("  ::--> Ignoring not satisfied value");
                            }
                        } else {
                            ioThisActivity.setObjSatisfied(ADLTracking.TRACK_NOTSATISFIED);
                        }
                    }
                }
                if (!ioThisActivity.getCompletedByMeasure()) {
                    if (_Debug) {
                        System.out.println("  ::--> Completion rollup using rules");
                    }
                    if (this.mIsCompleted) {
                        ioThisActivity.setProgress(ADLTracking.TRACK_COMPLETED);
                    } else if (this.mIsIncomplete) {
                        if (ioThisActivity.isPrimaryProgressSetBySCO() && ioThisActivity.getProgressValue().equals(ADLTracking.TRACK_UNKNOWN)) {
                            if (_Debug) {
                                System.out.println("  ::--> Ignoring not satisfied value");
                            }
                        } else {
                            ioThisActivity.setProgress(ADLTracking.TRACK_INCOMPLETE);
                        }
                    }
                }
            } else if (_Debug) {
                System.out.println("  ::--> ERROR : No Children");
            }
        } else if (_Debug) {
            System.out.println("  ::--> ERROR : Invalid rollup rules");
        }
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> END - evaluate");
        }
    }

    private void applyMeasureRollup(SeqActivity ioThisActivity) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> BEGIN - applyMeasureRollup");
        }
        double total = 0.0;
        double countedMeasure = 0.0;
        Vector children = ioThisActivity.getChildren(false);
        for (int i = 0; i < children.size(); ++i) {
            SeqActivity child = (SeqActivity)children.elementAt(i);
            if (_Debug) {
                System.out.println("  ::--> Look At :: " + child.getID());
            }
            if (!child.getIsTracked() || !(child.getObjMeasureWeight() > 0.0)) continue;
            countedMeasure += child.getObjMeasureWeight();
            if (!child.getObjMeasureStatus(false)) continue;
            total += child.getObjMeasureWeight() * child.getObjMeasure(false);
        }
        if (countedMeasure > 0.0) {
            if (_Debug) {
                System.out.println("  ::--> Counted         --> " + countedMeasure);
                System.out.println("  ::--> Setting Measure --> " + total / countedMeasure);
            }
            ioThisActivity.setObjMeasure(total / countedMeasure);
        } else {
            if (_Debug) {
                System.out.println("  ::--> Setting Measure --> UNKNOWN");
            }
            ioThisActivity.clearObjMeasure();
        }
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> END   - applyMeasureRollup");
        }
    }

    private void applyProgressMeasureRollup(SeqActivity ioThisActivity) {
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> BEGIN - applyProgressMeasureRollup");
        }
        double total = 0.0;
        double countedMeasure = 0.0;
        Vector children = ioThisActivity.getChildren(false);
        for (int i = 0; i < children.size(); ++i) {
            SeqActivity child = (SeqActivity)children.elementAt(i);
            if (_Debug) {
                System.out.println("  ::--> Look At :: " + child.getID());
            }
            if (child.getIsTracked()) {
                if (child.getProMeasureWeight() > 0.0) {
                    countedMeasure += child.getProMeasureWeight();
                    if (child.getProMeasureStatus(false)) {
                        double pretotal = total;
                        total += child.getProMeasureWeight() * child.getProMeasure(false);
                        if (!_Debug) continue;
                        System.out.println("  ::--> Pro Measure eval for " + child.getID());
                        System.out.println("\t  ::--> Pro Measure weight: " + child.getProMeasureWeight());
                        System.out.println("\t  ::--> Pro Measure: " + child.getProMeasure(false));
                        System.out.println("\t  ::--> Pro weight * measure: " + child.getProMeasureWeight() * child.getProMeasure(false));
                        System.out.println("\t  ::--> pretotal: " + pretotal);
                        System.out.println("\t  ::--> new total: " + total);
                        continue;
                    }
                    if (!_Debug) continue;
                    System.out.println("Progress Measure Status not defined");
                    continue;
                }
                if (!_Debug) continue;
                System.out.println("Progress Measure Weight is 0");
                continue;
            }
            if (!_Debug) continue;
            System.out.println("NOT TRACKED");
        }
        if (countedMeasure > 0.0) {
            if (_Debug) {
                System.out.println("  ::--> Counted         --> " + countedMeasure);
                System.out.println("  ::--> Setting Progress Measure --> " + total / countedMeasure);
            }
            ioThisActivity.setProMeasure(total / countedMeasure);
        } else {
            if (_Debug) {
                System.out.println("  ::--> Setting Progress Measure --> UNKNOWN");
            }
            ioThisActivity.clearProMeasure();
        }
        if (_Debug) {
            System.out.println("  :: SeqRollupRuleset  --> END   - applyProgressMeasureRollup");
        }
    }

    public int size() {
        if (this.mRollupRules != null) {
            return this.mRollupRules.size();
        }
        return 0;
    }
}

