/*
 * Decompiled with CFR 0.152.
 */
package org.adl.sequencer;

import java.io.Serializable;
import java.util.Vector;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqRule;
import org.adl.util.debug.DebugIndicator;

public class SeqRuleset
implements Serializable {
    static final int RULE_TYPE_ANY = 1;
    static final int RULE_TYPE_EXIT = 2;
    static final int RULE_TYPE_POST = 3;
    static final int RULE_TYPE_SKIPPED = 4;
    static final int RULE_TYPE_DISABLED = 5;
    static final int RULE_TYPE_HIDDEN = 6;
    static final int RULE_TYPE_FORWARDBLOCK = 7;
    private static boolean _Debug = DebugIndicator.ON;
    private Vector mRules = null;

    public SeqRuleset(Vector iRules) {
        if (_Debug) {
            System.out.println("  :: SeqRuleset  --> BEGIN - constructor");
            for (int i = 0; i < iRules.size(); ++i) {
                SeqRule temp = (SeqRule)iRules.elementAt(i);
                temp.dumpState();
            }
        }
        this.mRules = iRules;
        if (_Debug) {
            System.out.println("  :: SeqRuleset  --> END   - constructor");
        }
    }

    public String evaluate(int iType, SeqActivity iThisActivity, boolean iRetry) {
        if (_Debug) {
            System.out.println("  :: SeqRuleset   --> BEGIN - evaluate");
            System.out.println("  ::-->  " + iType);
        }
        String action = null;
        if (this.mRules != null) {
            boolean cont = true;
            for (int i = 0; i < this.mRules.size() && cont; ++i) {
                SeqRule rule = (SeqRule)this.mRules.elementAt(i);
                String result = rule.evaluate(iType, iThisActivity, iRetry);
                if (result.equals(SeqRule.SEQ_ACTION_NOACTION)) continue;
                cont = false;
                action = result;
            }
        }
        if (_Debug) {
            System.out.println("  ::--> " + action);
            System.out.println("  :: SeqRuleset   --> END   - evaluate");
        }
        return action;
    }

    public int size() {
        if (this.mRules != null) {
            return this.mRules.size();
        }
        return 0;
    }
}

