/*
 * Decompiled with CFR 0.152.
 */
package org.adl.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import org.adl.util.LogMessage;

public class MessageCollection {
    private static LinkedList mAllMessages;
    private static MessageCollection mInstance;
    private boolean mAccept = true;
    private boolean mDetailedLogWriterIsWaiting = false;
    private Vector mMessages = new Vector();
    private Vector mMessageTypeProperties;

    private MessageCollection() {
        mAllMessages = new LinkedList();
    }

    public static MessageCollection getInstance() {
        return mInstance;
    }

    public synchronized boolean add(Collection iMessages) {
        boolean result = false;
        if (this.mAccept) {
            result = true;
            Vector<LogMessage> messages = new Vector<LogMessage>(iMessages);
            int messagesSize = messages.size();
            int messageTypePropertiesSize = this.mMessageTypeProperties.size();
            block0: for (int i = 0; i < messagesSize; ++i) {
                LogMessage currentMessage = (LogMessage)messages.get(i);
                int currentMessageType = currentMessage.getMessageType();
                for (int j = 0; j < messageTypePropertiesSize; ++j) {
                    int messageType = (Integer)this.mMessageTypeProperties.get(j);
                    if (currentMessageType != messageType) continue;
                    result = messages.add(currentMessage) && result;
                    continue block0;
                }
            }
        }
        return result;
    }

    public synchronized void add(LogMessage iMessage) {
        this.mMessages.add(iMessage);
    }

    public synchronized void addMessage(LogMessage iMessage) {
        mAllMessages.add(iMessage);
        if (this.mDetailedLogWriterIsWaiting) {
            this.notify();
            this.mDetailedLogWriterIsWaiting = false;
        }
    }

    public void clear() {
        this.mAccept = true;
        this.mMessages.clear();
    }

    public LogMessage get(int iIndex) {
        return (LogMessage)this.mMessages.get(iIndex);
    }

    public Collection getByType() {
        Vector<LogMessage> resultMessages = new Vector<LogMessage>();
        int messagesSize = this.mMessages.size();
        int messageTypePropertiesSize = this.mMessageTypeProperties.size();
        boolean result = true;
        block0: for (int i = 0; i < messagesSize; ++i) {
            LogMessage currentMessage = (LogMessage)this.mMessages.get(i);
            int currentMessageType = currentMessage.getMessageType();
            for (int j = 0; j < messageTypePropertiesSize; ++j) {
                int messageType = (Integer)this.mMessageTypeProperties.get(j);
                if (currentMessageType != messageType) continue;
                result = resultMessages.add(currentMessage) && result;
                continue block0;
            }
        }
        if (result) {
            this.clearMessageTypeProperties();
        }
        return resultMessages;
    }

    public synchronized LogMessage getMessage() {
        return (LogMessage)mAllMessages.removeFirst();
    }

    public synchronized boolean hasMessages() {
        if (mAllMessages.size() <= 0) {
            try {
                this.mDetailedLogWriterIsWaiting = true;
                this.wait();
            }
            catch (InterruptedException ie) {
                System.out.println("InterruptedException in MessageCollection.hasMessages(): " + ie);
            }
            catch (Exception e) {
                System.out.println("Exception in MessageCollection.hasMessages():" + e);
            }
        }
        return mAllMessages.size() > 0;
    }

    public boolean isEmpty() {
        return this.mMessages.isEmpty();
    }

    public void pause(boolean iPause) {
        this.mAccept = !iPause;
    }

    public boolean setMessageTypeProperties(int iMessageType) {
        return this.mMessageTypeProperties.add(new Integer(iMessageType));
    }

    public int size() {
        return this.mMessages.size();
    }

    private void clearMessageTypeProperties() {
        this.mMessageTypeProperties.clear();
    }

    static {
        mInstance = new MessageCollection();
    }
}

