/*
 * Decompiled with CFR 0.152.
 */
package org.adl.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.adl.validator.util.Messages;

public class Resources {
    private static final Integer MAX_LENGTH = 1000;
    private static final Resources resources = Resources.getResources(Resources.class);
    private static Class mClass;
    private ResourceBundle bundle;

    public static <T> Resources getResources(Class<T> forClass) {
        mClass = forClass;
        return Resources.getResources(Resources.getResourceName(forClass));
    }

    public static <T> String getResourceName(Class<T> forClass) {
        return forClass.getPackage().getName() + ".resources." + forClass.getSimpleName();
    }

    public static Resources getResources(String name) {
        return new Resources(ResourceBundle.getBundle(name));
    }

    public Resources(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String iKey, Object ... args) {
        try {
            String preFormat = this.bundle.getString(iKey);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof String && ((String)args[i]).length() >= MAX_LENGTH && mClass != Messages.class) {
                    args[i] = resources.getString("truncated", new Object[0]);
                    continue;
                }
                if (args[i] != null) continue;
                return "";
            }
            String postFormat = String.format(preFormat, args);
            return postFormat;
        }
        catch (MissingResourceException e) {
            return iKey;
        }
    }
}

