/*
 * Decompiled with CFR 0.152.
 */
package org.adl.util.decode;

import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

public class decodeHandler {
    private Logger mLogger;
    private String mEncodedFileName;
    private String mDecodedFileName;
    private String mEncoding;

    public decodeHandler(String iEncodedFileName, String iEncoding) {
        this.setFileName(iEncodedFileName);
        this.setEncoding(iEncoding);
    }

    public decodeHandler() {
        this.setFileName("");
        this.setEncoding("");
    }

    private void setFileName(String iEncodedFileName) {
        try {
            this.mEncodedFileName = iEncodedFileName;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    private void setEncoding(String iFileNameEncoding) {
        try {
            this.mEncoding = iFileNameEncoding;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public String getDecodedFileName() {
        return this.mDecodedFileName;
    }

    public String decode(String iFileName, String iEncoding) {
        this.setFileName(iFileName);
        this.setEncoding(iEncoding);
        this.decodeName();
        return this.getDecodedFileName();
    }

    public void decodeName() {
        int index = -1;
        String charCode = "";
        String sectionOne = "";
        String sectionTwo = "";
        String decodedString = "";
        String encodedFileName = new String(this.mEncodedFileName);
        String encoding = new String(this.mEncoding);
        index = this.mEncodedFileName.indexOf("%");
        int nameLength = encodedFileName.length();
        if (index > -1) {
            for (int i = 0; i < nameLength; ++i) {
                if (encodedFileName.charAt(i) != '%') continue;
                sectionOne = encodedFileName.substring(0, i);
                sectionTwo = encodedFileName.substring(i + 3, encodedFileName.length());
                charCode = encodedFileName.substring(i + 1, i + 3);
                charCode = charCode.toLowerCase();
                int intCode = Integer.parseInt(charCode, 16);
                char decodedCharacter = (char)intCode;
                decodedString = new Character(decodedCharacter).toString();
                encodedFileName = sectionOne + decodedString + sectionTwo;
                nameLength -= 2;
            }
        }
        try {
            byte[] byteString = new String(encodedFileName).getBytes(encoding);
            encodedFileName = new String(byteString, encoding);
            this.mDecodedFileName = new String(encodedFileName);
        }
        catch (UnsupportedEncodingException uee) {
            this.mLogger.severe("UnsupportedEncodingException thrown while decoding the file path.");
            uee.printStackTrace();
        }
    }

    public static String processWhitespace(String iVal) {
        if (iVal == null) {
            return iVal;
        }
        String processedString = iVal.replaceAll("%20", " ");
        processedString = processedString.trim();
        while (processedString.indexOf("  ") != -1) {
            processedString = processedString.replaceAll("  ", " ");
        }
        return processedString;
    }

    public static String encodeObjectiveID(String iID) {
        String escapedID = "";
        for (int i = 0; i < iID.length(); ++i) {
            char val = iID.charAt(i);
            escapedID = Character.isUpperCase(val) ? escapedID + "U" : (Character.isLowerCase(val) ? escapedID + "L" : escapedID + "O");
        }
        return escapedID + "~" + iID;
    }

    public static String decodeObjectiveID(String iID) {
        String code = iID.substring(0, iID.indexOf("~"));
        String val = iID.substring(iID.indexOf("~") + 1, iID.length());
        String decodedVal = "";
        if (code.length() != val.length()) {
            return "";
        }
        for (int i = 0; i < code.length(); ++i) {
            char codeChar = code.charAt(i);
            String valChar = val.substring(i, i + 1);
            decodedVal = codeChar == 'U' ? decodedVal + valChar.toUpperCase() : (codeChar == 'L' ? decodedVal + valChar.toLowerCase() : decodedVal + valChar);
        }
        return decodedVal;
    }
}

