/*
 * Decompiled with CFR 0.152.
 */
package org.adl.util.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.adl.util.debug.DebugIndicator;

public class ServletWriter {
    private static boolean _Debug = DebugIndicator.ON;

    public static ObjectInputStream postObjects(URL iServlet, Serializable[] iObjs) throws Exception {
        ObjectInputStream in;
        if (_Debug) {
            System.out.println("In ServletWriter::postObjects()");
        }
        URLConnection con = null;
        try {
            if (_Debug) {
                System.out.println("Opening HTTP URL connection to servlet.");
            }
            con = iServlet.openConnection();
        }
        catch (Exception e) {
            System.out.println("e = 1");
            if (_Debug) {
                System.out.println("Exception caught in ServletWriter::postObjects()");
                e.printStackTrace();
            }
            System.out.println(e.getMessage());
            throw e;
        }
        if (_Debug) {
            System.out.println("HTTP connection to servlet is open");
            System.out.println("configuring HTTP connection properties");
        }
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "text/plain");
        con.setAllowUserInteraction(false);
        ObjectOutputStream out = null;
        try {
            if (_Debug) {
                System.out.println("Creating new http output stream");
            }
            out = new ObjectOutputStream(con.getOutputStream());
            if (_Debug) {
                System.out.println("Created new http output stream.");
                System.out.println("Writing command and data to servlet...");
            }
            int numObjects = iObjs.length;
            if (_Debug) {
                System.out.println("Num objects: " + numObjects);
            }
            for (int i = 0; i < numObjects; ++i) {
                out.writeObject(iObjs[i]);
                if (!_Debug) continue;
                System.out.println("Just wrote a serialized object on output stream... " + iObjs[i].getClass().getName());
            }
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Exception caught in ServletWriter::postObjects()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            throw e;
        }
        try {
            if (_Debug) {
                System.out.println("Flushing Object Output Stream.");
            }
            out.flush();
        }
        catch (IOException ioe) {
            if (_Debug) {
                System.out.println("Caught IOException when calling out.flush()");
                System.out.println(ioe.getMessage());
            }
            ioe.printStackTrace();
            throw ioe;
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Caught Exception when calling out.flush()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            throw e;
        }
        try {
            if (_Debug) {
                System.out.println("Closing object output stream.");
            }
            out.close();
        }
        catch (IOException ioe) {
            if (_Debug) {
                System.out.println("Caught IOException when calling out.close()");
                System.out.println(ioe.getMessage());
            }
            ioe.printStackTrace();
            throw ioe;
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Caught Exception when calling out.close()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            throw e;
        }
        try {
            if (_Debug) {
                System.out.println("Creating new http input stream.");
            }
            in = new ObjectInputStream(con.getInputStream());
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Exception caught in ServletWriter::postObjects()");
                System.out.println(e.getMessage());
            }
            e.printStackTrace();
            throw e;
        }
        return in;
    }
}

