/*
 * Decompiled with CFR 0.152.
 */
package org.adl.util.support;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.adl.util.EnvironmentVariable;
import org.adl.util.MessageBox;

public class SupportVerifier {
    private static final int FIRST_SUPPORTED_JRE5_SUB = 10;
    private static final int FIRST_SUPPORTED_JRE5_MINOR = 0;
    private static final int FIRST_SUPPORTED_JRE14_SUB = 13;
    private static final int FIRST_SUPPORTED_JRE14_MINOR = 2;
    private static final String[] mNonSupportedOS = new String[]{"Windows 95", "Windows 98", "Windows NT"};

    public void verifyEnvironmentVariable(String iKey) {
        String value = EnvironmentVariable.getValue(iKey);
        if ("".equals(value)) {
            String title = "Environment Error";
            String messageText = "The \"" + iKey + "\" Environment Variable could " + "not be detected.  This Environment\n Variable " + "must be set correctly for successful " + "operation of this software.";
            MessageBox.showMessage(0, messageText, title);
        }
    }

    public boolean verifyJRESupportBoolean() {
        return this.verifyJRESupportBoolean(null);
    }

    public boolean verifyJRESupportBoolean(String iVersion) {
        String jreVersion = "";
        jreVersion = iVersion == null || iVersion.equals("") ? System.getProperty("java.version") : iVersion;
        boolean jreSupported = false;
        String[] jreTokens = this.parseToArray(jreVersion, '.');
        if (jreTokens.length == 1) {
            return Integer.parseInt(jreTokens[0]) > 1;
        }
        if (Integer.parseInt(jreTokens[0]) < 1) {
            jreSupported = false;
        } else if (Integer.parseInt(jreTokens[0]) > 1) {
            jreSupported = true;
        } else if (!jreTokens.equals("")) {
            switch (Integer.parseInt(jreTokens[1])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    jreSupported = false;
                    break;
                }
                case 4: {
                    jreSupported = this.verifyMinorVersion(jreTokens, 2, 13);
                    break;
                }
                case 5: {
                    jreSupported = this.verifyMinorVersion(jreTokens, 0, 10);
                    break;
                }
                default: {
                    jreSupported = true;
                }
            }
        }
        return jreSupported;
    }

    private boolean verifyMinorVersion(String[] iTokens, int iFirstSupportedMinor, int iFirstSupportedSub) {
        boolean jreOK = false;
        if (iTokens.length > 2) {
            int testThis;
            jreOK = iTokens[2].indexOf(95) > -1 ? ((testThis = Integer.parseInt(iTokens[2].split("_")[0])) == iFirstSupportedMinor ? Integer.parseInt(iTokens[2].split("_")[1]) >= iFirstSupportedSub : testThis > iFirstSupportedMinor) : Integer.parseInt(iTokens[2]) > iFirstSupportedMinor;
        }
        return jreOK;
    }

    public boolean verifyOSSupportBoolean() {
        String osName = System.getProperty("os.name");
        boolean osSupported = true;
        int arrayLength = mNonSupportedOS.length;
        for (int i = 0; i < arrayLength; ++i) {
            if (!osName.equalsIgnoreCase(mNonSupportedOS[i])) continue;
            osSupported = false;
            break;
        }
        return osSupported;
    }

    public String getCurrentOS() {
        String osName = System.getProperty("os.name");
        PrivilegedGetSP psp = new PrivilegedGetSP("sun.os.patch.level");
        String patch = AccessController.doPrivileged(psp).toString();
        String abbreviatedPatch = patch.replaceAll("Service Pack", "SP");
        String os = osName + " - " + abbreviatedPatch;
        return os;
    }

    public String getCurrentJRE() {
        String jreVersion = System.getProperty("java.version");
        return jreVersion;
    }

    private String[] parseToArray(String iString, char iCharOnWhichToParse) {
        int arraySize = 1;
        String countingStr = iString;
        while (countingStr.indexOf(iCharOnWhichToParse) != -1) {
            countingStr = countingStr.substring(countingStr.indexOf(iCharOnWhichToParse) + 1, countingStr.length());
            ++arraySize;
        }
        String[] elementTokens = new String[arraySize];
        int idx = 0;
        while (!iString.equals("")) {
            if (iString.indexOf(iCharOnWhichToParse) != -1) {
                elementTokens[idx++] = iString.substring(0, iString.indexOf(iCharOnWhichToParse));
                iString = iString.substring(iString.indexOf(iCharOnWhichToParse) + 1, iString.length());
                continue;
            }
            elementTokens[idx++] = iString;
            iString = "";
        }
        return elementTokens;
    }

    private class PrivilegedGetSP
    implements PrivilegedAction {
        String mSPKey;
        Object mSPValue;

        PrivilegedGetSP(String iSPKey) {
            this.mSPKey = iSPKey;
        }

        public Object run() {
            try {
                this.mSPValue = System.getProperty(this.mSPKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.mSPValue;
        }
    }
}

