/*
 * Decompiled with CFR 0.152.
 */
package org.adl.util.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.adl.util.debug.DebugIndicator;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class UnZipHandler {
    public static final int BUFFER_SIZE = 16384;
    private File mZipFile;
    private String mExtractToDir;

    public UnZipHandler(String iZipFileName, String iTargetDirName) {
        this.setFile(iZipFileName);
        this.setTargetDirectory(iTargetDirName);
    }

    private void setFile(String iFileName) {
        try {
            this.mZipFile = new File(iFileName);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    private void setTargetDirectory(String iTargetDirPath) {
        try {
            this.mExtractToDir = iTargetDirPath;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public String getTargetDirectory() {
        return this.mExtractToDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extract() {
        boolean result = true;
        String fileName = new String();
        String destFileName = new String();
        InputStream in = null;
        OutputStream out = null;
        byte[] buffer = new byte[16384];
        try {
            ZipFile archive;
            try {
                archive = new ZipFile(this.mZipFile, "CP437");
            }
            catch (ZipException ZE) {
                archive = new ZipFile(this.mZipFile);
            }
            Enumeration e = archive.getEntries();
            while (e.hasMoreElements()) {
                int count;
                File parentFile;
                ZipEntry entry = (ZipEntry)e.nextElement();
                if (entry.isDirectory()) continue;
                fileName = entry.getName();
                fileName = fileName.replace('/', File.separatorChar);
                destFileName = this.mExtractToDir + fileName;
                File destFile = new File(destFileName);
                String parent = destFile.getParent();
                if (parent != null && !(parentFile = new File(parent)).exists()) {
                    parentFile.mkdirs();
                }
                in = archive.getInputStream(entry);
                out = new FileOutputStream(destFileName);
                while ((count = in.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                in.close();
                out.close();
            }
            archive.close();
        }
        catch (ZipException ze) {
            result = false;
            if (DebugIndicator.ON) {
                ze.printStackTrace();
            }
        }
        catch (NullPointerException npe) {
            result = false;
            if (DebugIndicator.ON) {
                npe.printStackTrace();
            }
        }
        catch (IOException ioe) {
            result = false;
            if (DebugIndicator.ON) {
                ioe.printStackTrace();
            }
        }
        catch (SecurityException se) {
            result = false;
            if (DebugIndicator.ON) {
                se.printStackTrace();
            }
        }
        catch (Exception e) {
            result = false;
            if (DebugIndicator.ON) {
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void clearDir(File iDir) {
        if (iDir.exists()) {
            File[] allFiles = iDir.listFiles();
            for (int i = 0; i < allFiles.length; ++i) {
                if (allFiles[i].isDirectory()) {
                    UnZipHandler.clearDir(allFiles[i]);
                    continue;
                }
                allFiles[i].delete();
            }
        }
        iDir.delete();
    }
}

