/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ResultCollection;
import org.adl.validator.util.ValidatorMessage;

public class PackageCheckerInvoker {
    private static final String BUNDLE_NAME = "org.adl.validator.properties.packageCheckers";
    private static final String STOP = "STOP";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.adl.validator.properties.packageCheckers");
    private ResultCollection mResults;
    private String mValidatorType = "ADLChecker";

    public PackageCheckerInvoker(ResultCollection resultCollection) {
        this.mResults = resultCollection;
    }

    public ResultCollection performPackageChecks() {
        Result result = new Result();
        List list = new ArrayList();
        String string = "";
        list = (ArrayList)CheckerStateData.getInstance().getObjectValue("checkerList");
        if (list.size() <= 0 || list == null) {
            list = this.createCheckerList();
        }
        Iterator iterator = list.iterator();
        try {
            while (iterator.hasNext()) {
                Class<?> clazz;
                Object e = iterator.next();
                if (e instanceof String) {
                    string = e.toString();
                    clazz = Class.forName(string);
                } else {
                    clazz = (Class<?>)e;
                }
                PackageChecker packageChecker = (PackageChecker)clazz.newInstance();
                result = packageChecker.check();
                if (result == null) {
                    result = new Result();
                    result.setPackageCheckerName(string);
                    result.setPackageCheckerPassed(false);
                    result.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("PackageCheckerInvoker.0")));
                    this.mResults.addPackageResult(result);
                    continue;
                }
                if (result.isTestStopped()) {
                    this.mResults.addPackageResult(result);
                    return this.mResults;
                }
                if (result.isCheckerSkipped()) continue;
                this.mResults.addPackageResult(result);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(Messages.getString("PackageCheckerInvoker.1"));
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(Messages.getString("PackageCheckerInvoker.2"));
        }
        catch (InstantiationException instantiationException) {
            System.out.println(Messages.getString("PackageCheckerInvoker.3"));
        }
        return this.mResults;
    }

    private List createCheckerList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        int n = 0;
        while (!string.equals(STOP)) {
            string = this.getString(this.mValidatorType + n);
            if (!string.equals(STOP)) {
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList;
    }

    private String getString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return STOP;
        }
    }
}

