/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.packagechecker.parsers.SchematronValidationDOMParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;

public class ApplicationProfileChecker
extends PackageChecker {
    private static final String CONTENT_AGGREGATION = "contentaggregation";
    private static final String RESOURCE = "resource";
    private List mErrorMessages = new ArrayList();
    private InputStream mAppProfileSchematronFile;
    private String mFilename;
    private String mPackageType;
    private SchematronValidationDOMParser mParser = new SchematronValidationDOMParser(false);

    public ApplicationProfileChecker() {
        this.mFilename = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();
        String string = "";
        this.mPackageType = CheckerStateData.getInstance().getObjectValue("appProfileType").toString();
        if (this.mPackageType.equals(CONTENT_AGGREGATION)) {
            string = "/org/adl/validator/packagechecker/parsers/schematron/ContentAggregationSchematron.xml";
        } else if (this.mPackageType.equals(RESOURCE)) {
            string = "/org/adl/validator/packagechecker/parsers/schematron/ResourceSchematron.xml";
        } else {
            String string2 = Messages.getString("ApplicationProfileChecker.0");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string2);
            this.mErrorMessages.add(validatorMessage);
        }
        this.mAppProfileSchematronFile = this.getClass().getResourceAsStream(string);
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("APPLICATION_PROFILE");
    }

    public Result check() {
        Object object;
        this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, Messages.getString("ApplicationProfileChecker.1")));
        this.mResult.setCheckerSkipped(false);
        boolean bl = true;
        if (this.mFilename == null || this.mPackageType == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ApplicationProfileChecker.2")));
            this.mResult.setPackageCheckerPassed(false);
            return this.mResult;
        }
        try {
            bl = bl && this.validate(this.mAppProfileSchematronFile, this.mFilename);
            this.mAppProfileSchematronFile.close();
        }
        catch (IOException iOException) {
            object = Messages.getString("ApplicationProfileChecker.3");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, (String)object);
            this.mErrorMessages.add(validatorMessage);
            bl = false;
        }
        Iterator iterator = this.mErrorMessages.iterator();
        while (iterator.hasNext()) {
            object = (ValidatorMessage)iterator.next();
            if (((ValidatorMessage)object).getMessageType() == 3) {
                bl = false;
            }
            this.mResult.addPackageCheckerMessage((ValidatorMessage)object);
        }
        if (!bl) {
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ApplicationProfileChecker.4")));
        } else {
            this.mResult.setPackageCheckerPassed(true);
            this.mResult.addOverallStatusMessage(new ValidatorMessage(2, Messages.getString("ApplicationProfileChecker.5")));
        }
        return this.mResult;
    }

    private boolean validate(InputStream inputStream, String string) {
        this.mParser = new SchematronValidationDOMParser(false);
        boolean bl = this.mParser.performParse(inputStream, string);
        this.mErrorMessages.addAll(this.mParser.getErrorMessages());
        return bl;
    }
}

