/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.packagechecker.parsers.ExcessBaggageSaxParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;

public class ExcessBaggageChecker
extends PackageChecker {
    private Set mResourceFiles;
    private Set mPackageFiles;
    private String mRootDirectory;

    public ExcessBaggageChecker() {
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("EXCESS_BAGGAGE");
        this.mRootDirectory = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString();
    }

    public Result check() {
        if (this.mRootDirectory == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ExcessBaggageChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            return this.mResult;
        }
        if (CheckerStateData.getInstance().getObjectValue("manifestOnly") != null && CheckerStateData.getInstance().getObjectValue("manifestOnly").toString().equals("true")) {
            this.mResult.setCheckerSkipped(true);
            return this.mResult;
        }
        this.mResourceFiles = this.getResourceFiles();
        HashSet<String> hashSet = new HashSet<String>();
        URIHandler uRIHandler = new URIHandler();
        if (this.mResourceFiles == null) {
            return this.mResult;
        }
        Iterator iterator = this.mResourceFiles.iterator();
        String string = "";
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            string = URIHandler.decode(string, "UTF-16");
            string = uRIHandler.escapeDirectories(string);
            string = string.replaceAll("/", File.separator + File.separator);
            hashSet.add(string);
        }
        if (hashSet == null) {
            return this.mResult;
        }
        this.mPackageFiles = this.getPackageFiles(URIHandler.decode(this.mRootDirectory, "UTF-16"));
        this.mResult.setCheckerSkipped(false);
        this.mResult.setPackageCheckerPassed(true);
        this.mPackageFiles.removeAll(hashSet);
        Iterator iterator2 = this.mPackageFiles.iterator();
        String string2 = this.mRootDirectory.replaceAll(File.separator + File.separator, File.separator + File.separator + File.separator + File.separator);
        String string3 = "";
        while (iterator2.hasNext()) {
            string3 = iterator2.next().toString();
            string3 = string3.replaceAll(string2, "");
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(1, Messages.getString("ExcessBaggageChecker.1", string3)));
        }
        return this.mResult;
    }

    private Set getResourceFiles() {
        Set set = new LinkedHashSet();
        ExcessBaggageSaxParser excessBaggageSaxParser = new ExcessBaggageSaxParser();
        String string = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();
        if (string == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ExcessBaggageChecker.2")));
            this.mResult.setPackageCheckerPassed(false);
            return set;
        }
        boolean bl = excessBaggageSaxParser.performParse(string);
        if (!bl) {
            this.mResult.setPackageCheckerPassed(false);
            Iterator iterator = excessBaggageSaxParser.getParseMessages().iterator();
            while (iterator.hasNext()) {
                ValidatorMessage validatorMessage = (ValidatorMessage)iterator.next();
                this.mResult.addPackageCheckerMessage(validatorMessage);
            }
            set = null;
            return set;
        }
        set = excessBaggageSaxParser.getFileHrefs();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = "";
            string2 = this.mRootDirectory + iterator.next().toString();
            string2 = string2.replaceAll("/", File.separator + File.separator);
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    private Set getPackageFiles(String string) {
        File file = new File(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + File.separator + stringArray[i]);
                if (file2.isFile() && file2.getName().indexOf(".xsd") < 0 && file2.getName().indexOf(".dtd") < 0 && CheckerStateData.getInstance().getObjectValue("xmlFileName") != null && !file2.getName().equals(CheckerStateData.getInstance().getObjectValue("xmlFileName"))) {
                    linkedHashSet.add(file2.getAbsolutePath());
                    continue;
                }
                linkedHashSet.addAll(this.getPackageFiles(file2.getAbsolutePath()));
            }
        }
        return linkedHashSet;
    }
}

