/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.File;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;

public class IMSManifestAtRootChecker
extends PackageChecker {
    private String mIMSManifestFile;
    private String mFileName;

    public IMSManifestAtRootChecker() {
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("MANIFEST_AT_ROOT");
        this.mIMSManifestFile = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + "imsmanifest.xml";
        this.mIMSManifestFile = URIHandler.decode(this.mIMSManifestFile, "UTF-16");
        this.mFileName = CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();
    }

    public Result check() {
        if (this.mIMSManifestFile == null || this.mFileName == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("IMSManifestAtRootChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.setTestStopped(true);
            return this.mResult;
        }
        String string = "";
        File file = new File(this.mIMSManifestFile);
        this.mResult.setCheckerSkipped(false);
        if (!this.mFileName.equals("imsmanifest.xml") && this.mFileName.toLowerCase().indexOf(".zip") == -1) {
            string = Messages.getString("IMSManifestAtRootChecker.1");
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(1, string));
        }
        if (file.exists()) {
            this.mResult.setPackageCheckerPassed(true);
            this.mResult.setTestStopped(false);
        } else {
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.setTestStopped(true);
            string = Messages.getString("IMSManifestAtRootChecker.2");
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, string));
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, string));
        }
        return this.mResult;
    }
}

