/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.FileInputStream;
import java.io.IOException;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ManifestRootElementChecker
extends PackageChecker {
    private String mIMSManifestFile = URIHandler.decode(this.mIMSManifestFile, "UTF-16");
    private SAXBuilder mBuilder = new SAXBuilder();

    public ManifestRootElementChecker() {
        this.mBuilder.setReuseParser(false);
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("MANIFEST_ROOT_ELEMENT");
    }

    public Result check() {
        if (this.mIMSManifestFile == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ManifestRootElementChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.setTestStopped(true);
            return this.mResult;
        }
        Document document = this.parseDocument(this.mIMSManifestFile);
        CheckerStateData.getInstance().setObject("manifestDOM", document);
        CheckerStateData.getInstance().addReservedKey("manifestDOM");
        Element element = document.getRootElement();
        if (element.getName().equals("manifest") && element.getNamespaceURI().equals("http://www.imsglobal.org/xsd/imscp_v1p1")) {
            this.mResult.setPackageCheckerPassed(true);
        } else {
            this.mResult.setTestStopped(true);
            this.mResult.setPackageCheckerPassed(false);
            String string = "";
            string = Messages.getString("ManifestRootElementChecker.1", element.getName(), element.getNamespaceURI());
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mResult.addPackageCheckerMessage(validatorMessage);
            string = Messages.getString("ManifestRootElementChecker.2");
            validatorMessage = new ValidatorMessage(3, string);
            this.mResult.addPackageCheckerMessage(validatorMessage);
            this.mResult.addOverallStatusMessage(validatorMessage);
        }
        return this.mResult;
    }

    private Document parseDocument(String string) {
        try {
            return this.mBuilder.build(new FileInputStream(string));
        }
        catch (IOException iOException) {
            ValidatorMessage validatorMessage = new ValidatorMessage(3, Messages.getString("ManifestRootElementChecker.3"));
            this.mResult.addPackageCheckerMessage(validatorMessage);
            return null;
        }
        catch (JDOMException jDOMException) {
            ValidatorMessage validatorMessage = new ValidatorMessage(3, Messages.getString("ManifestRootElementChecker.4"));
            this.mResult.addPackageCheckerMessage(validatorMessage);
            return null;
        }
    }
}

