/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.SchemaHandler;
import org.adl.validator.util.processor.URIHandler;

public class RequiredFilesChecker
extends PackageChecker {
    private String mIMSManifestFile;
    private String mRootDirectory = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString();
    private SchemaHandler mHandler;

    public RequiredFilesChecker() {
        this.mIMSManifestFile = this.mRootDirectory + CheckerStateData.getInstance().getObjectValue("xmlFileName");
        this.mHandler = new SchemaHandler(this.mIMSManifestFile);
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("REQUIRED_FILES_AT_ROOT");
    }

    public Result check() {
        String[] stringArray;
        Object object;
        this.mResult.setCheckerSkipped(false);
        if (this.mIMSManifestFile == null || this.mRootDirectory == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.setTestStopped(true);
            return this.mResult;
        }
        boolean bl = true;
        String string = this.mHandler.createRequiredFilesList();
        List list = this.mHandler.getErrorMessages();
        this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, Messages.getString("RequiredFilesChecker.1")));
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                stringArray = (String[])object.next();
                if (stringArray.getMessageType() == 3) {
                    bl = false;
                }
                this.mResult.addPackageCheckerMessage((ValidatorMessage)stringArray);
            }
        }
        CheckerStateData.getInstance().setObject("controllingSchemas", string);
        CheckerStateData.getInstance().addReservedKey("controllingSchemas");
        if (!string.equals("")) {
            object = "";
            stringArray = string.split(" ");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2 = object = stringArray[i];
                int n = ((String)(object2 = ((String)object2).replaceAll("/", File.separator + File.separator))).lastIndexOf(File.separator);
                if (n >= ((String)object2).length() - 2) {
                    bl = false;
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.2")));
                    continue;
                }
                object2 = ((String)object2).substring(n + 1);
                String string2 = this.mRootDirectory + (String)object2;
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                    if (this.fileExists(string2)) {
                        this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, Messages.getString("RequiredFilesChecker.3", (String)object2)));
                    } else {
                        bl = false;
                        this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.4", (String)object2)));
                    }
                }
                if (string2.equals(object = URIHandler.isURL(stringArray[i]) ? stringArray[i] : this.mRootDirectory + stringArray[i])) continue;
                if (this.fileExists((String)object)) {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, Messages.getString("RequiredFilesChecker.5", stringArray[i])));
                    continue;
                }
                bl = false;
                this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.6", stringArray[i])));
            }
        }
        if (bl) {
            this.mResult.setPackageCheckerPassed(true);
            this.mResult.addOverallStatusMessage(new ValidatorMessage(2, Messages.getString("RequiredFilesChecker.7")));
            this.mResult.setTestStopped(false);
        } else {
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.8")));
            this.mResult.setTestStopped(true);
        }
        object = this.mHandler.isExtensionsFound() ? Messages.getString("RequiredFilesChecker.9") : Messages.getString("RequiredFilesChecker.10");
        this.mResult.addOverallStatusMessage(new ValidatorMessage(2, (String)object));
        return this.mResult;
    }

    private boolean fileExists(String string) {
        boolean bl = true;
        try {
            if (URIHandler.isURL(string)) {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, Messages.getString("RequiredFilesChecker.11", string)));
                    bl = true;
                } else {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.12", string)));
                    bl = false;
                }
            } else {
                URIHandler uRIHandler = new URIHandler();
                string = URIHandler.decode(string, "UTF-16");
                string = uRIHandler.escapeDirectories(string);
                string = string.replaceAll("/", File.separator + File.separator);
                File file = new File(string);
                bl = file.exists();
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.13", string)));
            bl = false;
        }
        catch (IOException iOException) {
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("RequiredFilesChecker.14", string)));
            bl = false;
        }
        return bl;
    }
}

