/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.packagechecker.parsers.ResourceHrefSaxParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;

public class ResourceHrefChecker
extends PackageChecker {
    private static final int BASE_LENGTH = 3;
    private static final int FTP_LENGTH = 4;
    private static final int HTTP_LENGTH = 5;
    private static final int FTPS_LENGTH = 5;
    private static final int HTTPS_LENGTH = 6;
    private String mIMSManifestFile;
    private String mRootDirectory = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString();

    public ResourceHrefChecker() {
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("RESOURCE_HREF");
    }

    public Result check() {
        if (this.mRootDirectory == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            return this.mResult;
        }
        this.mIMSManifestFile = this.mRootDirectory + "imsmanifest.xml";
        if (CheckerStateData.getInstance().getObjectValue("manifestOnly") != null && CheckerStateData.getInstance().getObjectValue("manifestOnly").toString().equals("true")) {
            this.mResult.setCheckerSkipped(true);
            return this.mResult;
        }
        String string = "";
        this.mResult.setCheckerSkipped(false);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        URIHandler uRIHandler = new URIHandler();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        ResourceHrefSaxParser resourceHrefSaxParser = new ResourceHrefSaxParser();
        this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, Messages.getString("ResourceHrefChecker.1")));
        boolean bl4 = resourceHrefSaxParser.performParse(this.mIMSManifestFile);
        if (!bl4) {
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.2")));
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.3")));
        } else {
            Object object;
            Object object2;
            Object object3;
            Set set = resourceHrefSaxParser.getFileHrefs();
            Set set2 = this.getPackageFiles(URIHandler.decode(this.mRootDirectory, "UTF-16"));
            CheckerStateData.getInstance().setObject("resourceFileList", set);
            CheckerStateData.getInstance().addReservedKey("resourceFileList");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                bl2 = true;
                string4 = string2 = iterator.next().toString();
                if ((string2 = URIHandler.decode(string2, "UTF-16")) == null) {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.8", string4)));
                    string2 = string4;
                }
                string3 = uRIHandler.escapeDirectories(string2);
                int n = uRIHandler.wasRootExceeded();
                if (n > 0) {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.9", string2, n)));
                }
                if (string3.length() > 4 && string3.substring(0, 5).equals("http:") || string3.length() > 5 && string3.substring(0, 6).equals("https:") || string3.length() > 3 && string3.substring(0, 4).equals("ftp:") || string3.length() > 4 && string3.substring(0, 5).equals("ftps:")) {
                    try {
                        object3 = new URL(string3);
                        object2 = ((URL)object3).openConnection();
                        object = (HttpURLConnection)object2;
                        int n2 = ((HttpURLConnection)object).getResponseCode();
                        if (n2 == 200) {
                            this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, Messages.getString("ResourceHrefChecker.10", string2)));
                            continue;
                        }
                        this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.11", string2)));
                        bl = false;
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.12", string2)));
                        bl = false;
                    }
                    catch (IOException iOException) {
                        this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.13", string2)));
                        bl = false;
                    }
                    continue;
                }
                object3 = new File(URIHandler.decode(this.mRootDirectory, "UTF-16") + string3);
                if (((File)object3).exists() && n == 0) {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, Messages.getString("ResourceHrefChecker.14", string2)));
                    if (!set2.contains((URIHandler.decode(this.mRootDirectory, "UTF-16") + string3).replaceAll("/", File.separator + File.separator))) {
                        this.mResult.addPackageCheckerMessage(new ValidatorMessage(1, Messages.getString("ResourceHrefChecker.15", string2)));
                    }
                } else {
                    bl = false;
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.16", string2)));
                }
                n = 0;
            }
            Set set3 = resourceHrefSaxParser.getResourceFileHrefs();
            object3 = set3.iterator();
            object2 = "";
            object = "";
            while (object3.hasNext()) {
                object = object2 = object3.next().toString();
                if ((object2 = URIHandler.decode((String)object2, "UTF-16")) == null) {
                    this.mResult.addPackageCheckerMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.17", (String)object)));
                    object2 = object;
                }
                if (!((string3 = uRIHandler.escapeDirectories((String)object2)).length() > 4 && string3.substring(0, 5).equals("http:") || string3.length() > 5 && string3.substring(0, 6).equals("https:") || string3.length() > 3 && string3.substring(0, 4).equals("ftp:")) && (string3.length() <= 4 || !string3.substring(0, 5).equals("ftps:"))) continue;
                this.mResult.addPackageCheckerMessage(new ValidatorMessage(1, Messages.getString("ResourceHrefChecker.18", (String)object)));
                bl3 = true;
            }
            if (!bl2) {
                string = Messages.getString("ResourceHrefChecker.4");
                this.mResult.addOverallStatusMessage(new ValidatorMessage(2, string));
                this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, string));
            } else if (!bl) {
                this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("ResourceHrefChecker.5")));
            } else if (bl3) {
                string = Messages.getString("ResourceHrefChecker.6");
                this.mResult.addOverallStatusMessage(new ValidatorMessage(1, string));
                this.mResult.setTestStopped(true);
            } else if (bl) {
                this.mResult.addOverallStatusMessage(new ValidatorMessage(2, Messages.getString("ResourceHrefChecker.7")));
            }
            this.mResult.setPackageCheckerPassed(bl);
        }
        return this.mResult;
    }

    private Set getPackageFiles(String string) {
        File file = new File(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + File.separator + stringArray[i]);
                if (file2.isDirectory()) {
                    linkedHashSet.addAll(this.getPackageFiles(file2.getAbsolutePath()));
                    continue;
                }
                if (file2.getName().indexOf(".xsd") >= 0 || file2.getName().indexOf(".dtd") >= 0 || CheckerStateData.getInstance().getObjectValue("xmlFileName") == null || file2.getName().equals(CheckerStateData.getInstance().getObjectValue("xmlFileName"))) continue;
                linkedHashSet.add(file2.getAbsolutePath());
            }
        }
        return linkedHashSet;
    }
}

