/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.util.Iterator;
import java.util.List;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.packagechecker.parsers.SchemaValidationDOMParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.SchemaHandler;

public class SchemaValidationChecker
extends PackageChecker {
    private String mIMSManifestFile = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();

    public SchemaValidationChecker() {
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("SCHEMA_VALIDATION");
    }

    public Result check() {
        String string = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString();
        if (this.mIMSManifestFile == null || string == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("SchemaValidationChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            return this.mResult;
        }
        this.mResult.setCheckerSkipped(false);
        SchemaHandler schemaHandler = new SchemaHandler(this.mIMSManifestFile);
        SchemaValidationDOMParser schemaValidationDOMParser = new SchemaValidationDOMParser(schemaHandler.createSchemaLocationList(), string);
        this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, Messages.getString("SchemaValidationChecker.1")));
        this.mResult.setPackageCheckerPassed(schemaValidationDOMParser.performParse(this.mIMSManifestFile));
        if (!this.mResult.isPackageCheckerPassed()) {
            List list = schemaValidationDOMParser.getParseMessages();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.mResult.addPackageCheckerMessage((ValidatorMessage)iterator.next());
            }
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("SchemaValidationChecker.2")));
        } else {
            String string2 = Messages.getString("SchemaValidationChecker.3");
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, string2));
            this.mResult.addOverallStatusMessage(new ValidatorMessage(2, string2));
        }
        return this.mResult;
    }
}

