/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.packagechecker.parsers.SchematronValidationDOMParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;

public class SubmanifestChecker
extends PackageChecker {
    private List mErrorMessages = new ArrayList();
    private InputStream submanifestSchematronFile;
    private String mFilename;
    private SchematronValidationDOMParser mParser = new SchematronValidationDOMParser(false);

    public SubmanifestChecker() {
        this.mFilename = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();
        String string = "/org/adl/validator/packagechecker/parsers/schematron/SubmanifestSchematron.xml";
        this.submanifestSchematronFile = this.getClass().getResourceAsStream(string);
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("SUBMANIFEST");
    }

    public Result check() {
        Object object;
        this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, Messages.getString("SubmanifestChecker.0")));
        this.mResult.setCheckerSkipped(false);
        boolean bl = true;
        if (this.mFilename == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("SubmanifestChecker.1")));
            this.mResult.setPackageCheckerPassed(false);
            return this.mResult;
        }
        try {
            this.mParser = new SchematronValidationDOMParser(true);
            bl = this.mParser.performParse(this.submanifestSchematronFile, this.mFilename);
            this.mErrorMessages.addAll(this.mParser.getErrorMessages());
            this.submanifestSchematronFile.close();
        }
        catch (IOException iOException) {
            object = Messages.getString("SubmanifestChecker.2");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, (String)object);
            this.mErrorMessages.add(validatorMessage);
            bl = false;
        }
        Iterator iterator = this.mErrorMessages.iterator();
        while (iterator.hasNext()) {
            object = (ValidatorMessage)iterator.next();
            if (((ValidatorMessage)object).getMessageType() == 1) {
                bl = false;
            }
            this.mResult.addPackageCheckerMessage((ValidatorMessage)object);
        }
        if (this.mParser.isSubmanifestPresent()) {
            if (bl) {
                this.mResult.addPackageCheckerMessage(new ValidatorMessage(1, Messages.getString("SubmanifestChecker.3")));
            }
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(1, Messages.getString("SubmanifestChecker.7")));
        }
        if (!bl) {
            this.mResult.setTestStopped(true);
            this.mResult.setPackageCheckerPassed(true);
            this.mResult.addOverallStatusMessage(new ValidatorMessage(1, Messages.getString("SubmanifestChecker.4")));
        } else {
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, Messages.getString("SubmanifestChecker.5")));
            this.mResult.setPackageCheckerPassed(true);
            this.mResult.addOverallStatusMessage(new ValidatorMessage(2, Messages.getString("SubmanifestChecker.6")));
        }
        return this.mResult;
    }
}

