/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.checks;

import java.util.Iterator;
import java.util.List;
import org.adl.validator.packagechecker.PackageChecker;
import org.adl.validator.packagechecker.parsers.WellformednessSaxParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;

public class WellformednessChecker
extends PackageChecker {
    private String mIMSManifestFile = CheckerStateData.getInstance().getObjectValue("rootDirectory").toString() + CheckerStateData.getInstance().getObjectValue("xmlFileName").toString();

    public WellformednessChecker() {
        this.mResult = new Result();
        this.mResult.setPackageCheckerName("WELLFORMEDNESS");
    }

    public Result check() {
        String string = "";
        this.mResult.setCheckerSkipped(false);
        if (this.mIMSManifestFile == null) {
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("WellformednessChecker.0")));
            this.mResult.setPackageCheckerPassed(false);
            this.mResult.setTestStopped(true);
            return this.mResult;
        }
        WellformednessSaxParser wellformednessSaxParser = new WellformednessSaxParser();
        this.mResult.setPackageCheckerPassed(wellformednessSaxParser.performParse(this.mIMSManifestFile));
        this.mResult.addPackageCheckerMessage(new ValidatorMessage(0, Messages.getString("WellformednessChecker.1")));
        if (!this.mResult.isPackageCheckerPassed()) {
            this.mResult.setTestStopped(true);
            List list = wellformednessSaxParser.getParseMessages();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.mResult.addPackageCheckerMessage((ValidatorMessage)iterator.next());
            }
            this.mResult.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("WellformednessChecker.2")));
        } else {
            this.mResult.setTestStopped(false);
            string = Messages.getString("WellformednessChecker.3");
            this.mResult.addOverallStatusMessage(new ValidatorMessage(2, string));
            this.mResult.addPackageCheckerMessage(new ValidatorMessage(2, string));
        }
        return this.mResult;
    }
}

