/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.parsers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.adl.validator.packagechecker.parsers.ValidatorSaxParser;
import org.xml.sax.Attributes;

public class RequiredFilesSaxParser
extends ValidatorSaxParser {
    protected String mCurrentElement;
    protected String mCurrentElementNS;
    private String mCharData;
    private Set mNamespaceURIs;
    private int mManifestCount;
    private Set mMetadataFiles;
    private String mSchemaLocation;
    private String mNoSchemaLocation;
    private String[] mXMLBase;
    private List mElementList;

    public RequiredFilesSaxParser() {
        this.mParseSuccess = true;
        this.mParseMessages = new ArrayList();
        this.mMetadataFiles = new HashSet();
        this.configureParser();
        this.mXMLBase = new String[3];
        this.mXMLBase[0] = "";
        this.mXMLBase[1] = "";
        this.mXMLBase[2] = "";
        this.mElementList = new ArrayList();
        this.mNamespaceURIs = new HashSet();
        this.mSchemaLocation = new String();
        this.mNoSchemaLocation = new String();
        this.mCharData = new String();
    }

    public Set getNamespaceURIs() {
        return this.mNamespaceURIs;
    }

    public String getNoSchemaLocation() {
        return this.mNoSchemaLocation.replaceAll("\\b\\s{2,}\\b", " ").trim();
    }

    public String getSchemaLocation() {
        return this.mSchemaLocation.replaceAll("\\b\\s{2,}\\b", " ").trim();
    }

    public Set getMetadataFiles() {
        return this.mMetadataFiles;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.mElementList.add(string3);
        this.mCurrentElement = string3;
        this.mCurrentElementNS = string;
        if (string2.equals(MANIFEST) && string.equals(IMSCP)) {
            ++this.mManifestCount;
        }
        String string4 = "";
        if (!string.equals("") && !string.equals(XSI)) {
            this.mNamespaceURIs.add(string);
        }
        if (string2.equals(RESOURCE) && string.equals(IMSCP) && this.mManifestCount <= 1) {
            this.mXMLBase[2] = "";
        }
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (attributes.getLocalName(i).equals("base") && attributes.getURI(i).equals(XML)) {
                    string4 = attributes.getValue(i);
                    if (string2.equals(MANIFEST) && string.equals(IMSCP) && this.mManifestCount <= 1) {
                        this.mXMLBase[0] = string4;
                    } else if (string2.equals(RESOURCES) && string.equals(IMSCP) && this.mManifestCount <= 1) {
                        this.mXMLBase[1] = string4;
                    } else if (string2.equals(RESOURCE) && string.equals(IMSCP) && this.mManifestCount <= 1) {
                        this.mXMLBase[2] = string4;
                    }
                    string4 = "";
                }
                if (attributes.getLocalName(i).equals("schemaLocation") && attributes.getURI(i).equals(XSI)) {
                    this.mSchemaLocation = this.mSchemaLocation + attributes.getValue(i) + " ";
                }
                if (attributes.getLocalName(i).equals("noSchemaLocation") && attributes.getURI(i).equals(XSI)) {
                    this.mNoSchemaLocation = this.mNoSchemaLocation + attributes.getValue(i) + " ";
                }
                if (attributes.getURI(i).equals("") || attributes.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance") || attributes.getURI(i).equals("http://www.w3.org/XML/1998/namespace")) continue;
                this.mNamespaceURIs.add(attributes.getURI(i));
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.mElementList.remove(this.mElementList.size() - 1);
        this.mCurrentElement = "";
        if (!this.mCharData.equals("")) {
            this.mCharData = this.mXMLBase[0] + this.mXMLBase[1] + this.mXMLBase[2] + this.mCharData;
            this.mMetadataFiles.add(this.mCharData);
            this.mCharData = "";
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.mManifestCount <= 1 && (this.mCurrentElement.equals("adlcp:location") || this.mCurrentElement.equals(LOCATION) && this.mCurrentElementNS.equals(ADLCP)) && this.mElementList.size() > 1 && this.mElementList.get(this.mElementList.size() - 2).toString().equals("metadata")) {
            this.mCharData = this.mCharData + new String(cArray, n, n2);
        }
    }
}

