/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.parsers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.adl.validator.util.Messages;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.FileHandler;
import org.adl.validator.util.processor.URIHandler;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidationDOMParser
implements ErrorHandler {
    private static final int TWO = 2;
    private static final String BLANK = " ";
    private DOMParser mParser;
    private String mSchemaLocation;
    private String mRootDirectory;
    private URIHandler mURIHandler = new URIHandler();
    private List mParseMessages;
    private boolean mParseSuccess = true;

    public SchemaValidationDOMParser(String string, String string2) {
        this.mSchemaLocation = string;
        this.mParseMessages = new ArrayList();
        this.mRootDirectory = string2;
        this.configureParser();
    }

    private void configureParser() {
        this.mParser = new DOMParser();
        if (this.mParser != null) {
            if (!this.mSchemaLocation.equals("")) {
                String string = "";
                String[] stringArray = this.mSchemaLocation.split(BLANK);
                String string2 = "";
                String string3 = "";
                for (int i = 0; i < stringArray.length; i += 2) {
                    string2 = stringArray[i];
                    if (URIHandler.isURL(stringArray[i + 1])) {
                        string3 = stringArray[i + 1];
                    } else {
                        string3 = "file:" + File.separator + this.mRootDirectory + stringArray[i + 1];
                        string3 = this.mURIHandler.escapeDirectories(string3);
                        string3 = string3.replaceAll(BLANK, "%20");
                        string3 = string3.replaceAll("/", File.separator + File.separator);
                    }
                    string = string + string2 + BLANK + string3 + BLANK;
                }
                this.mSchemaLocation = string = string.trim();
                try {
                    this.mParser.setFeature("http://xml.org/sax/features/validation", true);
                    this.mParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                    this.mParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    this.mParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                    this.mParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", this.mSchemaLocation);
                    this.mParser.setErrorHandler(this);
                }
                catch (SAXException sAXException) {
                    this.mParseSuccess = false;
                }
            } else {
                this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.0")));
                this.mParseSuccess = false;
            }
        } else {
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.1")));
            this.mParseSuccess = false;
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.mParseMessages.add(new ValidatorMessage(3, this.getErrorString(sAXParseException)));
        this.mParseSuccess = false;
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.mParseMessages.add(new ValidatorMessage(3, this.getErrorString(sAXParseException)));
        this.mParseSuccess = false;
    }

    private String getErrorString(SAXParseException sAXParseException) {
        String string = new String();
        string = Messages.getString("SchemaValidationDOMParser.7", sAXParseException.getMessage(), Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()));
        return string;
    }

    public List getParseMessages() {
        return this.mParseMessages;
    }

    public boolean performParse(String string) {
        try {
            String string2 = URIHandler.decode(string, "UTF-16");
            this.mParser.parse(this.setUpInputSource(string2));
        }
        catch (SAXException sAXException) {
            this.mParseSuccess = false;
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.2")));
        }
        catch (IOException iOException) {
            this.mParseSuccess = false;
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.3")));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            this.mParseSuccess = false;
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.4")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.mParseSuccess = false;
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.5")));
        }
        return this.mParseSuccess;
    }

    private InputSource setUpInputSource(String string) {
        InputSource inputSource = new InputSource();
        FileHandler fileHandler = new FileHandler();
        inputSource = fileHandler.setupFileSource(string);
        if (fileHandler.getErrorMessages().size() > 0) {
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("SchemaValidationDOMParser.6")));
        }
        return inputSource;
    }

    public void warning(SAXParseException sAXParseException) {
        this.mParseMessages.add(new ValidatorMessage(3, this.getErrorString(sAXParseException)));
        this.mParseSuccess = false;
    }
}

