/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.adl.validator.packagechecker.parsers.SchematronResultContentHandler;
import org.adl.validator.packagechecker.parsers.UniqueIDSaxParser;
import org.adl.validator.packagechecker.parsers.ValidatorSaxParser;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.ParameterHandler;
import org.adl.validator.util.processor.URIHandler;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.jdom.xpath.XPath;

public class SchematronValidationDOMParser {
    static final String IMSCP = "http://www.imsglobal.org/xsd/imscp_v1p1";
    static final String IMSSS = "http://www.imsglobal.org/xsd/imsss";
    static final Namespace XML = Namespace.getNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    static final int KILOBYTE = 1024;
    private static Document mXMLInstance;
    private static List mResourceList;
    private static URIHandler mURIHandler;
    private static List mIdentiferList;
    private static List mIDList;
    private static List mReferencedObjectiveMessages;
    private List mErrorMessages;
    private SAXBuilder mBuilder;
    private Document mTransform;
    private boolean mValidateSubmanifest;
    private boolean mDoesSubmanifestExist;
    private InputStream mSchematronSchema = this.getClass().getResourceAsStream("/org/adl/validator/packagechecker/parsers/xsd/iso_svrl.xsl");
    private InputStream mSchematronSkeletonSchema = this.getClass().getResourceAsStream("/org/adl/validator/packagechecker/parsers/xsd/iso_schematron_skeleton.xsl");

    public SchematronValidationDOMParser(boolean bl) {
        this.mBuilder = new SAXBuilder();
        this.mBuilder.setReuseParser(false);
        this.mErrorMessages = new ArrayList();
        this.mValidateSubmanifest = bl;
        this.mDoesSubmanifestExist = false;
        mReferencedObjectiveMessages = new ArrayList();
    }

    public boolean performParse(InputStream inputStream, String string) {
        try {
            Object object;
            Object object2;
            boolean bl = true;
            mIdentiferList = (List)CheckerStateData.getInstance().getObjectValue("identifierList");
            mIDList = (List)CheckerStateData.getInstance().getObjectValue("IDList");
            if ((mIdentiferList == null || mIDList == null) && (bl = ((ValidatorSaxParser)(object2 = new UniqueIDSaxParser())).performParse(string))) {
                mIdentiferList = ((UniqueIDSaxParser)object2).getIdentiferList();
                mIDList = ((UniqueIDSaxParser)object2).getIDList();
                CheckerStateData.getInstance().setObject("identifierList", mIdentiferList);
                CheckerStateData.getInstance().addReservedKey("identifierList");
                CheckerStateData.getInstance().setObject("IDList", mIDList);
                CheckerStateData.getInstance().addReservedKey("IDList");
            }
            object2 = this.parse(this.mSchematronSchema);
            object2 = this.fixImports((Document)object2, this.mSchematronSkeletonSchema);
            this.mTransform = this.transform(inputStream, (Document)object2);
            object2 = null;
            System.gc();
            mXMLInstance = (Document)CheckerStateData.getInstance().getObjectValue("xmlDOM");
            if (mXMLInstance == null) {
                mXMLInstance = this.parse(string);
                CheckerStateData.getInstance().setObject("xmlDOM", mXMLInstance);
                CheckerStateData.getInstance().addReservedKey("xmlDOM");
            }
            XPath xPath = XPath.newInstance("imscp:manifest/imscp:manifest");
            xPath.addNamespace("imscp", IMSCP);
            int n = xPath.selectNodes(mXMLInstance).size();
            if (n > 0) {
                this.mDoesSubmanifestExist = true;
            }
            if (!this.mValidateSubmanifest && this.mDoesSubmanifestExist) {
                object = Namespace.getNamespace(IMSCP);
                mXMLInstance.getRootElement().removeChildren("manifest", (Namespace)object);
            }
            object = this.transform(mXMLInstance, this.mTransform);
            mXMLInstance = null;
            this.mTransform = null;
            System.gc();
            this.mErrorMessages.addAll(object);
            this.mErrorMessages.addAll(mReferencedObjectiveMessages);
            return bl;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchematronValidationDOMParser.5")));
            return false;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchematronValidationDOMParser.6")));
            return false;
        }
    }

    private Document parse(String string) {
        string = URIHandler.decode(string, "UTF-16");
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return this.parse(fileInputStream);
        }
        catch (IOException iOException) {
            String string2 = Messages.getString("SchematronValidationDOMParser.7");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string2);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
    }

    private Document parse(InputStream inputStream) {
        try {
            return this.mBuilder.build(inputStream);
        }
        catch (IOException iOException) {
            String string = Messages.getString("SchematronValidationDOMParser.7");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
        catch (JDOMException jDOMException) {
            String string = Messages.getString("SchematronValidationDOMParser.7");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
    }

    private Document transform(InputStream inputStream, Document document) {
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            JDOMSource jDOMSource = new JDOMSource(document);
            JDOMResult jDOMResult = new JDOMResult();
            TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
            Transformer transformer = transformerFactoryImpl.newTransformer(jDOMSource);
            transformer.transform(streamSource, jDOMResult);
            return jDOMResult.getDocument();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = Messages.getString("SchematronValidationDOMParser.8");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
        catch (TransformerException transformerException) {
            String string = Messages.getString("SchematronValidationDOMParser.8");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
    }

    private List transform(Document document, Document document2) {
        try {
            JDOMSource jDOMSource = new JDOMSource(document2);
            JDOMSource jDOMSource2 = new JDOMSource(document);
            TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
            Transformer transformer = transformerFactoryImpl.newTransformer(jDOMSource);
            SchematronResultContentHandler schematronResultContentHandler = new SchematronResultContentHandler();
            SAXResult sAXResult = new SAXResult(schematronResultContentHandler);
            transformer.transform(jDOMSource2, sAXResult);
            return schematronResultContentHandler.getResultMessages();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = Messages.getString("SchematronValidationDOMParser.8");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
        catch (TransformerException transformerException) {
            String string = Messages.getString("SchematronValidationDOMParser.8");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
    }

    private String createLocalCopy(InputStream inputStream) {
        try {
            int n;
            InputStream inputStream2 = inputStream;
            File file = File.createTempFile("iso_schematron_skeleton", ".xsl");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream2.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            inputStream2.close();
            fileOutputStream.close();
            return "file:///" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8");
        }
        catch (IOException iOException) {
            String string = Messages.getString("SchematronValidationDOMParser.7");
            ValidatorMessage validatorMessage = new ValidatorMessage(3, string);
            this.mErrorMessages.add(validatorMessage);
            return null;
        }
    }

    public List getErrorMessages() {
        return this.mErrorMessages;
    }

    public boolean isSubmanifestPresent() {
        return this.mDoesSubmanifestExist;
    }

    protected Document fixImports(Document document, InputStream inputStream) {
        List list;
        Object object;
        try {
            object = XPath.newInstance("xsl:stylesheet/xsl:import");
            ((XPath)object).addNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
            list = ((XPath)object).selectNodes(document);
        }
        catch (JDOMException jDOMException) {
            return document;
        }
        object = list.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            Element element = (Element)e;
            Attribute attribute = element.getAttribute("href");
            String string = this.createLocalCopy(inputStream);
            attribute.setValue(string);
        }
        return document;
    }

    public static String checkHref(String string) {
        if (string == null) {
            return "false";
        }
        mResourceList = new ArrayList();
        try {
            XPath xPath = XPath.newInstance("imscp:manifest/imscp:resources/imscp:resource[normalize-space(@identifier)='" + string.trim() + "']");
            xPath.addNamespace("imscp", IMSCP);
            List list = xPath.selectNodes(mXMLInstance);
            if (list.size() > 1) {
                return "null";
            }
            Element element = (Element)list.get(0);
            String string2 = element.getAttributeValue("href");
            String string3 = element.getAttributeValue("base", XML);
            if (string3 == null) {
                string3 = "";
            }
            string2 = mURIHandler.escapeDirectories(string3 + string2);
            if (SchematronValidationDOMParser.checkResource(string, string2 = ParameterHandler.removeParameters(string2))) {
                return "true";
            }
            return "false";
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            return "false";
        }
    }

    public static boolean checkResource(String string, String string2) {
        try {
            Object object;
            Serializable serializable;
            if (mResourceList.contains(string)) {
                return false;
            }
            mResourceList.add(string);
            XPath xPath = XPath.newInstance("imscp:manifest/imscp:resources/imscp:resource[normalize-space(@identifier)='" + string.trim() + "']");
            xPath.addNamespace("imscp", IMSCP);
            List list = xPath.selectNodes(mXMLInstance);
            boolean bl = false;
            if (list.size() > 1) {
                return false;
            }
            Element element = (Element)list.get(0);
            String string3 = element.getAttributeValue("base", XML);
            if (string3 == null) {
                string3 = "";
            }
            XPath xPath2 = XPath.newInstance("imscp:file[@href]");
            xPath2.addNamespace("imscp", IMSCP);
            List list2 = xPath2.selectNodes(element);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext() && !bl) {
                serializable = (Element)iterator.next();
                object = mURIHandler.escapeDirectories(string3 + ((Element)serializable).getAttributeValue("href"));
                if (!((String)object).equals(string2)) continue;
                bl = true;
            }
            if (!bl) {
                String string4;
                serializable = XPath.newInstance("imscp:dependency");
                ((XPath)serializable).addNamespace("imscp", IMSCP);
                object = ((XPath)serializable).selectNodes(element);
                if (object.size() < 1) {
                    return false;
                }
                Iterator iterator2 = object.iterator();
                boolean bl2 = false;
                while (iterator2.hasNext() && !(bl2 = SchematronValidationDOMParser.checkResource(string4 = ((Element)iterator2.next()).getAttributeValue("identifierref"), string2))) {
                }
                return bl2;
            }
            return bl;
        }
        catch (JDOMException jDOMException) {
            return false;
        }
    }

    public static boolean isIdentifierUnique(String string) {
        if (string != null) {
            return !mIdentiferList.contains(string);
        }
        return false;
    }

    public static boolean isIDUnique(String string) {
        if (string != null) {
            return !mIDList.contains(string);
        }
        return false;
    }

    public static boolean isSQReferencedObjectiveValid(String string, String string2) {
        try {
            String string3 = URIHandler.processWhitespace(string);
            XPath xPath = XPath.newInstance("imscp:manifest/imscp:organizations/imscp:organization//imsss:sequencing[normalize-space(@IDRef)=normalize-space('" + string2 + "')]");
            xPath.addNamespace("imscp", IMSCP);
            xPath.addNamespace("imsss", IMSSS);
            List list = xPath.selectNodes(mXMLInstance);
            boolean bl = true;
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Element element = (Element)iterator.next();
                    XPath xPath2 = XPath.newInstance("imsss:objectives/imsss:primaryObjective[@objectiveID] | imsss:objectives/imsss:objective[@objectiveID]");
                    xPath2.addNamespace("imscp", IMSCP);
                    xPath2.addNamespace("imsss", IMSSS);
                    List list2 = xPath2.selectNodes(element);
                    Iterator iterator2 = list2.iterator();
                    boolean bl2 = false;
                    while (!bl2 && iterator2.hasNext()) {
                        object4 = (Element)iterator2.next();
                        object3 = URIHandler.processWhitespace(((Element)object4).getAttributeValue("objectiveID"));
                        if (!((String)object3).equals(string3)) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        object4 = Messages.getString("SchematronValidationDOMParser.0", string, element.getParentElement().getAttributeValue("identifier"));
                        object3 = new ValidatorMessage(2, (String)object4);
                        mReferencedObjectiveMessages.add(object3);
                        continue;
                    }
                    if (list2.size() > 0) {
                        object4 = Messages.getString("SchematronValidationDOMParser.1", string, element.getParentElement().getAttributeValue("identifier"));
                        object3 = new ValidatorMessage(3, (String)object4);
                        mReferencedObjectiveMessages.add(object3);
                        bl = false;
                        continue;
                    }
                    object4 = XPath.newInstance("imscp:manifest/imsss:sequencingCollection/imsss:sequencing[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:objective[@objectiveID] | " + "imscp:manifest/imsss:sequencingCollection/imsss:sequencing" + "[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:primaryObjective[@objectiveID]");
                    ((XPath)object4).addNamespace("imscp", IMSCP);
                    ((XPath)object4).addNamespace("imsss", IMSSS);
                    object3 = ((XPath)object4).selectNodes(mXMLInstance);
                    Iterator iterator3 = object3.iterator();
                    boolean bl3 = false;
                    while (!bl3 && iterator3.hasNext()) {
                        object2 = (Element)iterator3.next();
                        object = URIHandler.processWhitespace(((Element)object2).getAttributeValue("objectiveID"));
                        if (!((String)object).equals(string3)) continue;
                        bl3 = true;
                    }
                    if (bl3) {
                        object2 = Messages.getString("SchematronValidationDOMParser.2", string, string2);
                        object = new ValidatorMessage(2, (String)object2);
                        mReferencedObjectiveMessages.add(object);
                        continue;
                    }
                    object2 = Messages.getString("SchematronValidationDOMParser.1", string, element.getParentElement().getAttributeValue("identifier"));
                    object = new ValidatorMessage(3, (String)object2);
                    mReferencedObjectiveMessages.add(object);
                    bl = false;
                }
            } else {
                Object object;
                Object object5;
                XPath xPath3 = XPath.newInstance("imscp:manifest/imsss:sequencingCollection/imsss:sequencing[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:objective[@objectiveID] | " + "imscp:manifest/imsss:sequencingCollection/imsss:sequencing" + "[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:primaryObjective[@objectiveID]");
                xPath3.addNamespace("imscp", IMSCP);
                xPath3.addNamespace("imsss", IMSSS);
                List list3 = xPath3.selectNodes(mXMLInstance);
                Iterator iterator = list3.iterator();
                boolean bl4 = false;
                while (!bl4 && iterator.hasNext()) {
                    object5 = (Element)iterator.next();
                    object = URIHandler.processWhitespace(((Element)object5).getAttributeValue("objectiveID"));
                    if (!((String)object).equals(string3)) continue;
                    bl4 = true;
                }
                if (bl4) {
                    object5 = Messages.getString("SchematronValidationDOMParser.2", string, string2);
                    object = new ValidatorMessage(2, (String)object5);
                    mReferencedObjectiveMessages.add(object);
                } else {
                    object5 = Messages.getString("SchematronValidationDOMParser.1", string, string2);
                    object = new ValidatorMessage(3, (String)object5);
                    mReferencedObjectiveMessages.add(object);
                    bl = false;
                }
            }
            return bl;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            return false;
        }
    }

    public static boolean isSCObjectiveIDValid(String string, String string2) {
        try {
            String string3 = URIHandler.processWhitespace(string);
            XPath xPath = XPath.newInstance("imscp:manifest/imscp:organizations/imscp:organization//imsss:sequencing[normalize-space(@IDRef)=normalize-space('" + string2 + "')]");
            xPath.addNamespace("imscp", IMSCP);
            xPath.addNamespace("imsss", IMSSS);
            List list = xPath.selectNodes(mXMLInstance);
            boolean bl = true;
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Element element = (Element)iterator.next();
                    XPath xPath2 = XPath.newInstance("imsss:objectives/imsss:primaryObjective[@objectiveID] | imsss:objectives/imsss:objective[@objectiveID]");
                    xPath2.addNamespace("imscp", IMSCP);
                    xPath2.addNamespace("imsss", IMSSS);
                    List list2 = xPath2.selectNodes(element);
                    Iterator iterator2 = list2.iterator();
                    boolean bl2 = false;
                    while (!bl2 && iterator2.hasNext()) {
                        object4 = (Element)iterator2.next();
                        object3 = URIHandler.processWhitespace(((Element)object4).getAttributeValue("objectiveID"));
                        if (!((String)object3).equals(string3)) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        object4 = Messages.getString("SchematronValidationDOMParser.3", string3);
                        object3 = new ValidatorMessage(2, (String)object4);
                        mReferencedObjectiveMessages.add(object3);
                        continue;
                    }
                    if (list2.size() > 0) {
                        object4 = Messages.getString("SchematronValidationDOMParser.4", string3);
                        object3 = new ValidatorMessage(3, (String)object4);
                        mReferencedObjectiveMessages.add(object3);
                        bl = false;
                        continue;
                    }
                    object4 = XPath.newInstance("imscp:manifest/imsss:sequencingCollection/imsss:sequencing[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:objective[@objectiveID] | " + "imscp:manifest/imsss:sequencingCollection/imsss:sequencing" + "[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:primaryObjective[@objectiveID]");
                    ((XPath)object4).addNamespace("imscp", IMSCP);
                    ((XPath)object4).addNamespace("imsss", IMSSS);
                    object3 = ((XPath)object4).selectNodes(mXMLInstance);
                    Iterator iterator3 = object3.iterator();
                    boolean bl3 = false;
                    while (!bl3 && iterator3.hasNext()) {
                        object2 = (Element)iterator3.next();
                        object = URIHandler.processWhitespace(((Element)object2).getAttributeValue("objectiveID"));
                        if (!((String)object).equals(string3)) continue;
                        bl3 = true;
                    }
                    if (bl3) {
                        object2 = Messages.getString("SchematronValidationDOMParser.3", string3);
                        object = new ValidatorMessage(2, (String)object2);
                        mReferencedObjectiveMessages.add(object);
                        continue;
                    }
                    object2 = Messages.getString("SchematronValidationDOMParser.4", string3);
                    object = new ValidatorMessage(3, (String)object2);
                    mReferencedObjectiveMessages.add(object);
                    bl = false;
                }
            } else {
                Object object;
                Object object5;
                XPath xPath3 = XPath.newInstance("imscp:manifest/imsss:sequencingCollection/imsss:sequencing[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:objective[@objectiveID] | " + "imscp:manifest/imsss:sequencingCollection/imsss:sequencing" + "[normalize-space(@ID)=normalize-space('" + string2 + "')]/imsss:objectives/imsss:primaryObjective[@objectiveID]");
                xPath3.addNamespace("imscp", IMSCP);
                xPath3.addNamespace("imsss", IMSSS);
                List list3 = xPath3.selectNodes(mXMLInstance);
                Iterator iterator = list3.iterator();
                boolean bl4 = false;
                while (!bl4 && iterator.hasNext()) {
                    object5 = (Element)iterator.next();
                    object = URIHandler.processWhitespace(((Element)object5).getAttributeValue("objectiveID"));
                    if (!((String)object).equals(string3)) continue;
                    bl4 = true;
                }
                if (bl4) {
                    object5 = Messages.getString("SchematronValidationDOMParser.3", string3);
                    object = new ValidatorMessage(2, (String)object5);
                    mReferencedObjectiveMessages.add(object);
                } else {
                    object5 = Messages.getString("SchematronValidationDOMParser.4", string3);
                    object = new ValidatorMessage(3, (String)object5);
                    mReferencedObjectiveMessages.add(object);
                    bl = false;
                }
            }
            return bl;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            return false;
        }
    }

    static {
        mURIHandler = new URIHandler();
    }
}

