/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagechecker.parsers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.adl.validator.util.Messages;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.FileHandler;
import org.adl.validator.util.processor.URIHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ValidatorSaxParser
extends DefaultHandler {
    protected static final int BASE_ONE = 0;
    protected static final int BASE_TWO = 1;
    protected static final int BASE_THREE = 2;
    protected static final int BASE_SIZE = 3;
    protected static String MANIFEST = "manifest";
    protected static String RESOURCES = "resources";
    protected static String RESOURCE = "resource";
    protected static String LOCATION = "location";
    protected static String FILE = "file";
    protected static String HREF = "href";
    protected static String IMSCP = "http://www.imsglobal.org/xsd/imscp_v1p1";
    protected static String ADLCP = "http://www.adlnet.org/xsd/adlcp_v1p3";
    protected static String ADLSEQ = "http://www.adlnet.org/xsd/adlseq_v1p3";
    protected static String IMSSS = "http://www.imsglobal.org/xsd/imsss";
    protected static String ADLNAV = "http://www.adlnet.org/xsd/adlnav_v1p3";
    protected static String XML = "http://www.w3.org/XML/1998/namespace";
    protected static String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    protected String mXMLFile;
    protected String mFileName;
    protected List mParseMessages;
    protected boolean mParseSuccess = true;
    protected SAXParserFactory mParserFactory;
    protected SAXParser mParser;

    protected void configureParser() {
        this.mParseMessages = new ArrayList();
        try {
            this.mParserFactory = SAXParserFactory.newInstance();
            this.mParserFactory.setNamespaceAware(true);
            this.mParser = this.mParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.mParseSuccess = false;
        }
        catch (SAXException sAXException) {
            this.mParseSuccess = false;
        }
    }

    public boolean performParse(String string) {
        this.mFileName = string;
        String string2 = string.replaceAll(" ", "%20");
        string2 = string2.replaceAll("/", File.separator + File.separator);
        try {
            String string3 = URIHandler.decode(string, "UTF-16");
            this.mParser.parse(this.setUpInputSource(string3), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            this.mParseSuccess = false;
        }
        catch (IOException iOException) {
            this.mParseSuccess = false;
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("ValidatorSaxParser.0")));
        }
        return this.mParseSuccess;
    }

    public List getParseMessages() {
        return this.mParseMessages;
    }

    public void warning(SAXParseException sAXParseException) {
        this.mParseMessages.add(new ValidatorMessage(1, this.getErrorString(sAXParseException)));
        this.mParseSuccess = false;
    }

    public void error(SAXParseException sAXParseException) {
        this.mParseMessages.add(new ValidatorMessage(3, this.getErrorString(sAXParseException)));
        this.mParseSuccess = false;
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.mParseMessages.add(new ValidatorMessage(3, this.getErrorString(sAXParseException)));
        this.mParseSuccess = false;
    }

    private String getErrorString(SAXParseException sAXParseException) {
        String string = new String();
        string = Messages.getString("ValidatorSaxParser.2", sAXParseException.getMessage(), Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()));
        return string;
    }

    private InputSource setUpInputSource(String string) {
        InputSource inputSource = new InputSource();
        FileHandler fileHandler = new FileHandler();
        inputSource = fileHandler.setupFileSource(string);
        if (fileHandler.getErrorMessages().size() > 0) {
            this.mParseMessages.add(new ValidatorMessage(3, Messages.getString("ValidatorSaxParser.1")));
        }
        return inputSource;
    }
}

