/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagevalidator;

import java.io.File;
import java.util.StringTokenizer;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Messages;
import org.adl.validator.util.Result;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;
import org.adl.validator.util.processor.UnZipHandler;

public class PackageProcessor {
    public Result processPackage() {
        String string = (String)CheckerStateData.getInstance().getObjectValue("fileName");
        Result result = new Result();
        if (string == null) {
            result.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("PackageProcessor.0")));
            result.setPackageCheckerPassed(false);
            result.setTestStopped(true);
            return result;
        }
        result.setPackageCheckerName("PACKAGE_PROCESSOR");
        String string2 = string;
        if (string2.toLowerCase().endsWith(".zip")) {
            UnZipHandler unZipHandler = new UnZipHandler(string);
            Result result2 = unZipHandler.extractZipFile();
            if (result2 == null) {
                String string3 = unZipHandler.getTargetDirectory();
                CheckerStateData.getInstance().setObject("rootDirectory", string3);
                CheckerStateData.getInstance().setObject("xmlFileName", "imsmanifest.xml");
                CheckerStateData.getInstance().addReservedKey("xmlFileName");
            } else {
                result.setTestStopped(true);
                result.setPackageCheckerPassed(false);
                String string4 = Messages.getString("PackageProcessor.1");
                result.addPackageCheckerMessage(new ValidatorMessage(3, string4));
                result.addOverallStatusMessage(new ValidatorMessage(3, string4));
                for (int i = 0; i < result2.getPackageCheckerMessages().size(); ++i) {
                    result.addPackageCheckerMessage(new ValidatorMessage(3, ((ValidatorMessage)result2.getPackageCheckerMessages().get(i)).getMessageText()));
                }
            }
        } else {
            CheckerStateData.getInstance().setObject("rootDirectory", URIHandler.escapeSpecialCharacters(this.getPathOfFile(string)));
            String string5 = "";
            string5 = (String)CheckerStateData.getInstance().getObjectValue("fileName");
            if (string5 == null) {
                result.addOverallStatusMessage(new ValidatorMessage(3, Messages.getString("PackageProcessor.0")));
                result.setPackageCheckerPassed(false);
                result.setTestStopped(true);
                return result;
            }
            String[] stringArray = string5.split(File.separator + File.separator);
            string5 = stringArray[stringArray.length - 1];
            CheckerStateData.getInstance().setObject("xmlFileName", string5);
            CheckerStateData.getInstance().addReservedKey("xmlFileName");
        }
        return result;
    }

    private String getPathOfFile(String string) {
        String string2 = "";
        String string3 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator, true);
            int n = stringTokenizer.countTokens();
            --n;
            for (int i = 0; i < n; ++i) {
                string3 = stringTokenizer.nextToken();
                string2 = string2 + string3;
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return string2;
    }
}

