/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.packagevalidator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.adl.validator.packagechecker.PackageCheckerInvoker;
import org.adl.validator.packagevalidator.PackageProcessor;
import org.adl.validator.util.CheckerStateData;
import org.adl.validator.util.Result;
import org.adl.validator.util.ResultCollection;
import org.adl.validator.util.processor.UnZipHandler;

public class PackageValidator {
    private ResultCollection mResultCollection;
    private Result mResult;
    private File mTempDir = new File(System.getProperty("java.io.tmpdir") + "tempZipFolder" + File.separator);

    public PackageValidator(String string, String string2, boolean bl, ResultCollection resultCollection) {
        CheckerStateData.getInstance().clearCollection();
        CheckerStateData.getInstance().setObject("fileName", string);
        CheckerStateData.getInstance().setObject("appProfileType", string2);
        CheckerStateData.getInstance().setObject("manifestOnly", new Boolean(bl));
        CheckerStateData.getInstance().setObject("checkerList", new ArrayList());
        CheckerStateData.getInstance().addReservedKey("fileName");
        CheckerStateData.getInstance().addReservedKey("appProfileType");
        CheckerStateData.getInstance().addReservedKey("manifestOnly");
        this.mResultCollection = resultCollection;
        UnZipHandler unZipHandler = new UnZipHandler();
        unZipHandler.clearTempDir(this.mTempDir);
        PackageProcessor packageProcessor = new PackageProcessor();
        this.mResult = packageProcessor.processPackage();
    }

    public ResultCollection executePackageCheckers() {
        Object object;
        if (this.mResult.isTestStopped()) {
            this.mResultCollection.addPackageResult(this.mResult);
        } else {
            object = new PackageCheckerInvoker(this.mResultCollection);
            this.mResultCollection = ((PackageCheckerInvoker)object).performPackageChecks();
        }
        object = new UnZipHandler();
        ((UnZipHandler)object).clearTempDir(this.mTempDir);
        CheckerStateData.getInstance().clearCollection();
        return this.mResultCollection;
    }

    public void setCheckerList(List list) {
        CheckerStateData.getInstance().setObject("checkerList", list);
    }
}

