/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.util.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.adl.validator.packagechecker.parsers.RequiredFilesSaxParser;
import org.adl.validator.util.Messages;
import org.adl.validator.util.ValidatorMessage;
import org.adl.validator.util.processor.URIHandler;

public class SchemaHandler {
    private static final int TWO = 2;
    private static final String STOP = "STOP";
    private static final String BUNDLE_NAME = "org.adl.validator.properties.knownSchemas";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.adl.validator.properties.knownSchemas");
    private static final String NS_BUNDLE_NAME = "org.adl.validator.properties.knownNamespaces";
    private static final ResourceBundle NS_RESOURCE_BUNDLE = ResourceBundle.getBundle("org.adl.validator.properties.knownNamespaces");
    private static final String SPACE = " ";
    private RequiredFilesSaxParser mParser;
    private String mFileName;
    private List mErrorMessages;
    private URIHandler mUriHandler;
    private boolean mIsExtensionsFound;

    public SchemaHandler(String string) {
        this.mFileName = string;
        this.mUriHandler = new URIHandler();
        this.mErrorMessages = new ArrayList();
        this.mIsExtensionsFound = false;
    }

    public String createSchemaLocationList() {
        Object object;
        String string;
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        Set set = new HashSet();
        String string2 = "";
        Set set2 = new HashSet();
        String string3 = new File(this.mFileName).getParent();
        this.mParser = new RequiredFilesSaxParser();
        boolean bl = this.mParser.performParse(this.mFileName);
        if (!bl) {
            this.mErrorMessages.add(new ValidatorMessage(3, "An error occurred during imsmanifest.xml parsing"));
            this.mErrorMessages.addAll(this.mParser.getParseMessages());
            return this.setToString(hashSet);
        }
        set = this.mParser.getNamespaceURIs();
        string2 = this.mParser.getSchemaLocation();
        set2 = this.mParser.getMetadataFiles();
        if (!this.mParser.getNoSchemaLocation().equals("")) {
            string2 = string2 + SPACE + this.mParser.getNoSchemaLocation();
        }
        if ((stringArray = this.assembleValidationList(string = this.mFileName.split(File.separator + File.separator)[this.mFileName.split(File.separator + File.separator).length - 1], this.setToString(set), string2).split(SPACE)).length >= 2) {
            object = "";
            for (int i = 0; i < stringArray.length; i += 2) {
                object = stringArray[i + 1];
                object = this.mUriHandler.escapeDirectories((String)object);
                int n = this.mUriHandler.wasRootExceeded();
                if (n > 0) {
                    this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.1", (String)object)));
                }
                hashSet.add(stringArray[i] + SPACE + (String)object);
            }
        }
        this.mIsExtensionsFound = this.findExtensions(hashSet);
        if (set2 != null) {
            object = set2.iterator();
            RequiredFilesSaxParser requiredFilesSaxParser = new RequiredFilesSaxParser();
            while (object.hasNext()) {
                Object object2;
                requiredFilesSaxParser = new RequiredFilesSaxParser();
                Set set3 = new HashSet();
                String string4 = "";
                String string5 = object.next().toString();
                String string6 = new File(string5).getParent();
                string6 = string6 == null ? "" : string6 + "/";
                this.mUriHandler = new URIHandler();
                String string7 = string3 + File.separator + string5;
                string7 = this.mUriHandler.escapeDirectories(string7);
                string7 = URIHandler.decode(string7, "UTF-16");
                boolean bl2 = this.mUriHandler.wasRootExceeded() > 0;
                File file = new File(string7);
                boolean bl3 = file.exists();
                boolean bl4 = true;
                if (bl2 || !bl3) {
                    bl4 = false;
                    if (string5 == null || string5.trim().equals("")) {
                        this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.2", string5)));
                        continue;
                    }
                    this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.3", string5, string5)));
                    continue;
                }
                string7 = string3 + File.separator + string5;
                bl4 = requiredFilesSaxParser.performParse(string7 = this.mUriHandler.escapeDirectories(string7));
                if (bl4) {
                    String[] stringArray2;
                    set3 = requiredFilesSaxParser.getNamespaceURIs();
                    string4 = requiredFilesSaxParser.getSchemaLocation();
                    if (!requiredFilesSaxParser.getNoSchemaLocation().equals("")) {
                        string4 = string4 + SPACE + requiredFilesSaxParser.getNoSchemaLocation();
                    }
                    if ((stringArray2 = ((String)(object2 = this.assembleValidationList(string5, this.setToString(set3), string4))).split(SPACE)).length < 2) continue;
                    String string8 = "";
                    for (int i = 0; i < stringArray2.length; i += 2) {
                        if (URIHandler.isURL(stringArray2[i + 1])) {
                            string8 = stringArray2[i + 1];
                        } else {
                            string8 = string6 + stringArray2[i + 1];
                            URIHandler uRIHandler = new URIHandler();
                            string8 = uRIHandler.escapeDirectories(string8);
                            int n = uRIHandler.wasRootExceeded();
                            if (n > 0) {
                                this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.1", string8)));
                            }
                        }
                        hashSet.add(stringArray2[i] + SPACE + string8);
                    }
                    continue;
                }
                this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.4", string5)));
                object2 = requiredFilesSaxParser.getParseMessages().iterator();
                while (object2.hasNext()) {
                    this.mErrorMessages.add(object2.next());
                }
            }
        }
        return this.setToString(hashSet);
    }

    private String setToString(Set set) {
        Iterator iterator = set.iterator();
        String string = "";
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                string = string + SPACE;
            }
            bl = false;
            string = string + iterator.next().toString();
        }
        return string;
    }

    private String assembleValidationList(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = "";
        String[] stringArray = string2.split(SPACE);
        String[] stringArray2 = string3.split(SPACE);
        if (!string3.equals("") && stringArray2.length % 2 != 0) {
            this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.0")));
        }
        if (stringArray2.length <= 1) {
            this.mErrorMessages.add(new ValidatorMessage(1, Messages.getString("SchemaHandler.5", string)));
            bl = false;
        }
        if (stringArray.length > 0) {
            int n;
            String[][] stringArray3 = new String[stringArray.length][2];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray3[i][0] = stringArray[i];
            }
            if (bl) {
                if (stringArray2.length % 2 > 0) {
                    return "";
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (n = 0; n < stringArray2.length; n += 2) {
                    hashSet.add(stringArray2[n] + SPACE + stringArray2[n + 1]);
                }
                for (n = 0; n < stringArray3.length; ++n) {
                    if (stringArray3[n][1] != null) continue;
                    Iterator iterator = hashSet.iterator();
                    boolean bl2 = false;
                    while (iterator.hasNext() && !bl2) {
                        String[] stringArray4 = iterator.next().toString().split(SPACE);
                        if (!stringArray3[n][0].equals(stringArray4[0]) || stringArray3[n][1] != null) continue;
                        stringArray3[n][1] = stringArray4[1];
                        bl2 = true;
                    }
                }
            }
            String[] stringArray5 = this.getKnownSchemaLocations().split(SPACE);
            block4: for (n = 0; n < stringArray3.length; ++n) {
                if (stringArray3[n][1] != null) continue;
                if (bl) {
                    this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.6", stringArray3[n][0])));
                }
                for (int i = 0; i < stringArray5.length; i += 2) {
                    if (!stringArray3[n][0].equals(stringArray5[i])) continue;
                    stringArray3[n][1] = stringArray5[i + 1];
                    continue block4;
                }
            }
            for (n = 0; n < stringArray3.length; ++n) {
                if (stringArray3[n][1] != null) {
                    if (n > 0) {
                        string4 = string4 + SPACE;
                    }
                    string4 = string4 + stringArray3[n][0] + SPACE + stringArray3[n][1];
                    continue;
                }
                this.mErrorMessages.add(new ValidatorMessage(3, Messages.getString("SchemaHandler.7", stringArray3[n][0])));
            }
        }
        return string4.trim();
    }

    private String getKnownSchemaLocations() {
        String string = "";
        String string2 = "";
        int n = 0;
        while (!string2.equals(STOP)) {
            string2 = SchemaHandler.getString("knownSchema" + Integer.toString(n));
            if (!string2.equals(STOP)) {
                string = string + SPACE + string2;
            }
            ++n;
        }
        return string.trim();
    }

    private static String getKnownNamespaces() {
        String string = "";
        String string2 = "";
        int n = 0;
        while (!string2.equals(STOP)) {
            string2 = SchemaHandler.getNSString("knownNamespace" + Integer.toString(n));
            if (!string2.equals(STOP)) {
                string = string + SPACE + string2;
            }
            ++n;
        }
        return string.trim();
    }

    private static String getString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return STOP;
        }
    }

    private static String getNSString(String string) {
        try {
            return NS_RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return STOP;
        }
    }

    public String createRequiredFilesList() {
        String string = "";
        String string2 = this.createSchemaLocationList();
        String[] stringArray = string2.split(SPACE);
        for (int i = 1; i < stringArray.length; i += 2) {
            if (i > 1) {
                string = string + SPACE;
            }
            string = string + stringArray[i];
        }
        return string;
    }

    public String createSchemaValidationList() {
        String[] stringArray = this.getKnownSchemaLocations().split(SPACE);
        String[] stringArray2 = this.createSchemaLocationList().split(SPACE);
        String string = "";
        block0: for (int i = 0; i < stringArray2.length; i += 2) {
            for (int j = 0; j < stringArray.length; j += 2) {
                if (!stringArray2[i].equals(stringArray[j]) || !stringArray2[i + 1].equals(stringArray[j + 1])) continue;
                string = string + SPACE + stringArray2[i] + SPACE + stringArray2[i + 1];
                continue block0;
            }
        }
        return string.trim();
    }

    public boolean findExtensions(Set set) {
        String[] stringArray = this.setToString(set).split(SPACE);
        String[] stringArray2 = SchemaHandler.getKnownNamespaces().split(SPACE);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; i += 2) {
            boolean bl2 = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isExtensionsFound() {
        return this.mIsExtensionsFound;
    }

    public List getErrorMessages() {
        return this.mErrorMessages;
    }

    public static boolean isKnownNamespace(String string) {
        String string2 = SchemaHandler.getKnownNamespaces();
        return string2.indexOf(string) != -1;
    }
}

