/*
 * Decompiled with CFR 0.152.
 */
package org.adl.validator.util.processor;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;

public class URIHandler {
    public static final String ENCODING = "UTF-16";
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final int SIXTEEN = 16;
    private static final int BASIC_LATIN = 127;
    private int mBeyondRoot = 0;

    public static String encode(String string, String string2) {
        String string3 = new String(string);
        String string4 = new String(string2);
        String string5 = "";
        int n = string3.length();
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c2 = string3.charAt(i);
            c = c2;
            string5 = c > '\u007f' ? string5 + "%" + Integer.toString(c, 16) : string5 + c2;
        }
        try {
            byte[] byArray = new String(string5).getBytes(string4);
            String string6 = new String(byArray, string4);
            string5 = new String(string6);
            return string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String decode(String string, String string2) {
        int n = -1;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = new String(string);
        String string9 = new String(string2);
        n = string.indexOf("%");
        int n2 = string8.length();
        if (n > -1) {
            for (int i = 0; i < n2; ++i) {
                if (string8.charAt(i) != '%') continue;
                string4 = string8.substring(0, i);
                string5 = string8.substring(i + 3, string8.length());
                string3 = string8.substring(i + 1, i + 3);
                string3 = string3.toLowerCase();
                try {
                    int n3 = Integer.parseInt(string3, 16);
                    char c = (char)n3;
                    string6 = new Character(c).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                string8 = string4 + string6 + string5;
                n2 -= 2;
            }
        }
        try {
            byte[] byArray = new String(string8).getBytes(string9);
            string8 = new String(byArray, string9);
            string7 = new String(string8);
            return string7;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String escapeDirectories(String string) {
        int n;
        this.mBeyondRoot = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        string = string.replace(File.separatorChar, '/');
        String[] stringArray = string.split("/");
        for (n = 0; n < stringArray.length; ++n) {
            linkedList.add(stringArray[n]);
        }
        for (n = 0; n < linkedList.size(); ++n) {
            if (!linkedList.get(n).toString().equals("..")) continue;
            linkedList.remove(n);
            if (n > 0) {
                linkedList.remove(n - 1);
                n -= 2;
                continue;
            }
            ++this.mBeyondRoot;
            --n;
        }
        if (this.mBeyondRoot > 0) {
            return string;
        }
        Iterator iterator = linkedList.iterator();
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        while (iterator.hasNext()) {
            string3 = iterator.next().toString();
            if (n2 > 0) {
                string2 = string2 + "/";
            }
            string2 = string2 + string3;
            ++n2;
        }
        return string2;
    }

    public int wasRootExceeded() {
        return this.mBeyondRoot;
    }

    public static boolean isURL(String string) {
        if (string != null) {
            return string.length() > 4 && string.substring(0, 5).equals("http:") || string.length() > 5 && string.substring(0, 6).equals("https:") || string.length() > 3 && string.substring(0, 4).equals("ftp:") || string.length() > 4 && string.substring(0, 5).equals("ftps:");
        }
        return false;
    }

    public static boolean containsSpecialCharacters(String string) {
        return string.indexOf("{") != -1 || string.indexOf("}") != -1 || string.indexOf("^") != -1 || string.indexOf("%") != -1 || string.indexOf("&") != -1 || string.indexOf("`") != -1 || string.indexOf("#") != -1;
    }

    public static String escapeSpecialCharacters(String string) {
        string = string.replaceAll("%", "%25");
        string = string.replaceAll("[{]", "%7B");
        string = string.replaceAll("[}]", "%7D");
        string = string.replaceAll("\\^", "%5E");
        string = string.replaceAll("&", "%26");
        string = string.replaceAll("`", "%60");
        string = string.replaceAll("#", "%23");
        return string;
    }

    public static String processWhitespace(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll("%20", " ");
        string2 = string2.trim();
        while (string2.indexOf("  ") != -1) {
            string2 = string2.replaceAll("  ", " ");
        }
        return string2;
    }

    public static boolean isValidExtension(String string) {
        String string2 = (string = string.replaceAll("\\\\", "/")).indexOf("/") != -1 ? string.split("/")[string.split("/").length - 1] : string;
        String string3 = string2.indexOf(".") == -1 ? "" : string2.substring(string2.lastIndexOf(".") + 1, string2.length());
        return !string3.equals("");
    }
}

