/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public class LoadResource
extends Task {
    private Resource src;
    private boolean failOnError = true;
    private boolean quiet = false;
    private String encoding = null;
    private String property = null;
    private final Vector filterChains = new Vector();

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final void setProperty(String property) {
        this.property = property;
    }

    public final void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
        if (quiet) {
            this.failOnError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute() throws BuildException {
        block18: {
            if (this.src == null) {
                throw new BuildException("source resource not defined");
            }
            if (this.property == null) {
                throw new BuildException("output property not defined");
            }
            if (this.quiet && this.failOnError) {
                throw new BuildException("quiet and failonerror cannot both be set to true");
            }
            if (!this.src.isExists()) {
                String message = this.src + " doesn't exist";
                if (this.failOnError) {
                    throw new BuildException(message);
                }
                this.log(message, this.quiet ? 1 : 0);
                return;
            }
            InputStream is = null;
            BufferedInputStream bis = null;
            Reader instream = null;
            this.log("loading " + this.src + " into property " + this.property, 3);
            try {
                long len = this.src.getSize();
                this.log("resource size = " + (len != -1L ? String.valueOf(len) : "unknown"), 4);
                int size = (int)len;
                is = this.src.getInputStream();
                bis = new BufferedInputStream(is);
                instream = this.encoding == null ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, this.encoding);
                String text = "";
                if (size != 0) {
                    ChainReaderHelper crh = new ChainReaderHelper();
                    if (len != -1L) {
                        crh.setBufferSize(size);
                    }
                    crh.setPrimaryReader(instream);
                    crh.setFilterChains(this.filterChains);
                    crh.setProject(this.getProject());
                    instream = crh.getAssembledReader();
                    text = crh.readFully(instream);
                } else {
                    this.log("Do not set property " + this.property + " as its length is 0.");
                }
                if (text != null && text.length() > 0) {
                    this.getProject().setNewProperty(this.property, text);
                    this.log("loaded " + text.length() + " characters", 3);
                    this.log(this.property + " := " + text, 4);
                }
                FileUtils.close((InputStream)is);
            }
            catch (IOException ioe) {
                String message = "Unable to load resource: " + ioe.toString();
                if (this.failOnError) {
                    throw new BuildException(message, ioe, this.getLocation());
                }
                this.log(message, this.quiet ? 3 : 0);
            }
            catch (BuildException be) {
                if (this.failOnError) {
                    throw be;
                }
                this.log(be.getMessage(), this.quiet ? 3 : 0);
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtils.close(is);
            }
        }
    }

    public final void addFilterChain(FilterChain filter) {
        this.filterChains.addElement(filter);
    }

    public void addConfigured(ResourceCollection a) {
        if (a.size() != 1) {
            throw new BuildException("only single argument resource collections are supported");
        }
        this.src = (Resource)a.iterator().next();
    }
}

