/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public abstract class CompressedResource
extends Resource {
    private static final int BUFFER_SIZE = 8192;
    private Resource resource;

    public CompressedResource() {
    }

    public CompressedResource(ResourceCollection other) {
        this.addConfigured(other);
    }

    public void addConfigured(ResourceCollection a) {
        this.checkChildrenAllowed();
        if (this.resource != null) {
            throw new BuildException("you must not specify more than one resource");
        }
        if (a.size() != 1) {
            throw new BuildException("only single argument resource collections are supported");
        }
        this.resource = (Resource)a.iterator().next();
    }

    public String getName() {
        return this.getResource().getName();
    }

    public void setName(String name) throws BuildException {
        throw new BuildException("you can't change the name of a compressed resource");
    }

    public boolean isExists() {
        return this.getResource().isExists();
    }

    public void setExists(boolean exists) {
        throw new BuildException("you can't change the exists state of a  compressed resource");
    }

    public long getLastModified() {
        return this.getResource().getLastModified();
    }

    public void setLastModified(long lastmodified) throws BuildException {
        throw new BuildException("you can't change the timestamp of a  compressed resource");
    }

    public boolean isDirectory() {
        return this.getResource().isDirectory();
    }

    public void setDirectory(boolean directory) throws BuildException {
        throw new BuildException("you can't change the directory state of a  compressed resource");
    }

    public long getSize() {
        if (this.isExists()) {
            long l;
            InputStream in = null;
            try {
                int readNow;
                in = this.getInputStream();
                byte[] buf = new byte[8192];
                int size = 0;
                while ((readNow = in.read(buf, 0, buf.length)) > 0) {
                    size += readNow;
                }
                l = size;
                Object var8_7 = null;
            }
            catch (IOException ex) {
                try {
                    throw new BuildException("caught exception while reading " + this.getName(), ex);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    FileUtils.close((InputStream)in);
                    throw throwable;
                }
            }
            FileUtils.close((InputStream)in);
            return l;
        }
        return 0L;
    }

    public void setSize(long size) throws BuildException {
        throw new BuildException("you can't change the size of a  compressed resource");
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof CompressedResource) {
            return this.getResource().compareTo(((CompressedResource)other).getResource());
        }
        return this.getResource().compareTo(other);
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = this.getResource().getInputStream();
        if (in != null) {
            in = this.wrapStream(in);
        }
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream out = this.getResource().getOutputStream();
        if (out != null) {
            out = this.wrapStream(out);
        }
        return out;
    }

    public boolean isFilesystemOnly() {
        return false;
    }

    public String toString() {
        return this.getCompressionName() + " compressed " + this.getResource().toString();
    }

    public void setRefid(Reference r) {
        if (this.resource != null) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(r);
    }

    protected abstract InputStream wrapStream(InputStream var1) throws IOException;

    protected abstract OutputStream wrapStream(OutputStream var1) throws IOException;

    protected abstract String getCompressionName();

    private Resource getResource() {
        if (this.isReference()) {
            return (Resource)this.getCheckedRef();
        }
        if (this.resource == null) {
            throw new BuildException("no resource specified");
        }
        return this.resource;
    }
}

