/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarResource
extends ArchiveResource {
    private String userName = "";
    private String groupName = "";
    private int uid;
    private int gid;

    public TarResource() {
    }

    public TarResource(File a, TarEntry e) {
        super(a, true);
        this.setEntry(e);
    }

    public TarResource(Resource a, TarEntry e) {
        super(a, true);
        this.setEntry(e);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        Resource archive = this.getArchive();
        TarInputStream i = new TarInputStream(archive.getInputStream());
        TarEntry te = null;
        while ((te = i.getNextEntry()) != null) {
            if (!te.getName().equals(this.getName())) continue;
            return i;
        }
        FileUtils.close((InputStream)i);
        throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the tar task for tar output.");
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUserName();
        }
        return this.userName;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGroup();
        }
        return this.groupName;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUid();
        }
        return this.uid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGid();
        }
        return this.uid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchEntry() {
        TarInputStream i;
        block8: {
            block7: {
                Resource archive = this.getArchive();
                i = null;
                try {
                    try {
                        i = new TarInputStream(archive.getInputStream());
                        TarEntry te = null;
                        while ((te = i.getNextEntry()) != null) {
                            if (!te.getName().equals(this.getName())) continue;
                            this.setEntry(te);
                            Object var5_5 = null;
                            if (i == null) return;
                            break block7;
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        this.log(e.getMessage(), 4);
                        throw new BuildException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (i != null) {
                        FileUtils.close((InputStream)i);
                    }
                    throw throwable;
                }
            }
            FileUtils.close((InputStream)i);
            return;
        }
        Object var5_6 = null;
        if (i != null) {
            FileUtils.close((InputStream)i);
        }
        this.setEntry(null);
    }

    private void setEntry(TarEntry e) {
        if (e == null) {
            this.setExists(false);
            return;
        }
        this.setName(e.getName());
        this.setExists(true);
        this.setLastModified(e.getModTime().getTime());
        this.setDirectory(e.isDirectory());
        this.setSize(e.getSize());
        this.setMode(e.getMode());
        this.userName = e.getUserName();
        this.groupName = e.getGroupName();
        this.uid = e.getUserId();
        this.gid = e.getGroupId();
    }
}

