/*
 * Decompiled with CFR 0.152.
 */
package org.castor.anttask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.util.XMLInstance2Schema;
import org.xml.sax.SAXException;

public final class XMLInstance2SchemaTask
extends MatchingTask {
    private static final String NO_XML_DOCUMENT_MSG = "At least one XML document instance must be provided.";
    private File _xmlInstanceFile;
    private File _xmlInstanceDir;
    private Vector _xmlInstanceFileSets = new Vector();
    private String _xmlSchemaFileName;
    private boolean _defaultGroupingAsAll;

    public void setFile(File file) {
        this._xmlInstanceFile = file;
    }

    public void setDir(File dir) {
        this._xmlInstanceDir = dir;
    }

    public void addFileset(FileSet set) {
        this._xmlInstanceFileSets.addElement(set);
    }

    public void setXmlSchemaFileName(String ddlFileName) {
        this._xmlSchemaFileName = ddlFileName;
    }

    public void setDefaultGrouping(String defaultGroupingAsAll) {
        this._defaultGroupingAsAll = true;
    }

    private void config() {
    }

    private void processFile(String filePath, String outputFilePath) {
        this.log("Processing " + filePath);
        try {
            XMLInstance2Schema schemaGenerator = new XMLInstance2Schema();
            if (this._defaultGroupingAsAll) {
                schemaGenerator.setDefaultGroupingAsAll();
            }
            Schema schema = schemaGenerator.createSchema(filePath);
            String outputFileName = outputFilePath;
            if (outputFileName == null) {
                outputFileName = this.deriveOutputFilePath(filePath);
            }
            FileWriter dstWriter = new FileWriter(outputFileName);
            schemaGenerator.serializeSchema(dstWriter, schema);
        }
        catch (IOException e) {
            throw new BuildException("Problem writing to the given putput sink " + this._xmlInstanceFile.getAbsolutePath(), e);
        }
        catch (SAXException e) {
            throw new BuildException("Problem streaming the generated XML schema instance to the given file.", e);
        }
    }

    private String deriveOutputFilePath(String outputFileName) {
        return outputFileName + ".xsd";
    }

    public void execute() {
        if (this._xmlInstanceFile == null && this._xmlInstanceDir == null && this._xmlInstanceFileSets.size() == 0) {
            throw new BuildException(NO_XML_DOCUMENT_MSG);
        }
        this.config();
        if (this._xmlInstanceFile != null) {
            this.processFile(this._xmlInstanceFile.getAbsolutePath(), this._xmlSchemaFileName);
        }
        if (this._xmlInstanceDir != null && this._xmlInstanceDir.exists() && this._xmlInstanceDir.isDirectory()) {
            this.log("Given XML schema file name will be ignored.");
            DirectoryScanner ds = this.getDirectoryScanner(this._xmlInstanceDir);
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String filePath = this._xmlInstanceDir.getAbsolutePath() + File.separator + files[i];
                this.processFile(filePath, null);
            }
        }
        for (int i = 0; i < this._xmlInstanceFileSets.size(); ++i) {
            this.log("Given XML schema file name will be ignored.");
            FileSet fs = (FileSet)this._xmlInstanceFileSets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File subdir = fs.getDir(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                String filePath = subdir.getAbsolutePath() + File.separator + files[j];
                this.processFile(filePath, null);
            }
        }
    }
}

