/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.hashbelt.container.Container;
import org.castor.cache.hashbelt.container.MapContainer;
import org.castor.cache.hashbelt.reaper.AbstractReaper;
import org.castor.cache.hashbelt.reaper.NullReaper;
import org.castor.core.util.concurrent.ReadWriteLock;
import org.castor.core.util.concurrent.WriterPreferenceReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHashbelt
extends AbstractBaseCache {
    private static final Log LOG = LogFactory.getLog(AbstractHashbelt.class);
    public static final String PARAM_CONTAINERS = "containers";
    public static final String PARAM_CONTAINER_CLASS = "container-class";
    public static final String PARAM_REAPER_CLASS = "reaper-class";
    public static final String PARAM_CAPACITY = "capacity";
    public static final String PARAM_TTL = "ttl";
    public static final String PARAM_MONITOR = "monitor";
    public static final int DEFAULT_CONTAINERS = 10;
    public static final Class<? extends Container> DEFAULT_CONTAINER_CLASS = MapContainer.class;
    public static final Class<? extends AbstractReaper> DEFAULT_REAPER_CLASS = NullReaper.class;
    public static final int DEFAULT_CAPACITY = 0;
    public static final int DEFAULT_TTL = 60;
    public static final int DEFAULT_MONITOR = 0;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private final ReadWriteLock _lock = new WriterPreferenceReadWriteLock();
    private Container[] _cache = new Container[0];
    private Container[] _pool;
    private int _poolCount;
    private int _cacheCapacity;
    private int _cacheSize = 0;
    private int _containerTarget;
    private int _containerCount = 0;
    private int _containerCapacity;
    private int _ttl;
    private AbstractReaper _reaper;
    private int _monitor;
    private Timer _expirationTimer;
    private Timer _monitoringTimer;

    @Override
    public final void initialize(Properties params) throws CacheAcquireException {
        Class<Object> cls;
        String param;
        super.initialize(params);
        try {
            param = params.getProperty(PARAM_CONTAINERS);
            if (param != null) {
                this._containerTarget = Integer.parseInt(param);
            }
            if (this._containerTarget <= 0) {
                this._containerTarget = 10;
            }
        }
        catch (NumberFormatException ex) {
            this._containerTarget = 10;
        }
        try {
            cls = DEFAULT_CONTAINER_CLASS;
            param = params.getProperty(PARAM_CONTAINER_CLASS);
            if (param != null && !"".equals(param)) {
                cls = Class.forName(param);
            }
            this._poolCount = 2 * this._containerTarget;
            this._pool = new Container[this._poolCount];
            for (int i = 0; i < this._poolCount; ++i) {
                this._pool[i] = cls.newInstance();
            }
        }
        catch (Exception ex) {
            String msg = "Failed to instantiate hashbelt container.";
            throw new CacheAcquireException(msg, ex);
        }
        try {
            cls = DEFAULT_REAPER_CLASS;
            param = params.getProperty(PARAM_REAPER_CLASS);
            if (param != null && !"".equals(param)) {
                cls = Class.forName(param);
            }
            this._reaper = (AbstractReaper)cls.newInstance();
            this._reaper.setCache(this);
        }
        catch (Exception ex) {
            String msg = "Failed to instantiate hashbelt reaper.";
            throw new CacheAcquireException(msg, ex);
        }
        try {
            param = params.getProperty(PARAM_CAPACITY);
            if (param != null) {
                this._cacheCapacity = Integer.parseInt(param);
            }
            if (this._cacheCapacity < 0) {
                this._cacheCapacity = 0;
            }
        }
        catch (NumberFormatException ex) {
            this._cacheCapacity = 0;
        }
        int minCapacity = 2 * this._containerTarget;
        if (this._cacheCapacity > 0 && this._cacheCapacity < minCapacity) {
            this._cacheCapacity = minCapacity;
        }
        this._containerCapacity = this._cacheCapacity / this._containerTarget;
        try {
            param = params.getProperty(PARAM_TTL);
            if (param != null) {
                this._ttl = Integer.parseInt(param);
            }
            if (this._ttl < 0) {
                this._ttl = 60;
            }
        }
        catch (NumberFormatException ex) {
            this._ttl = 60;
        }
        if (this._ttl > 0) {
            long periode = (long)this._ttl * 1000L / (long)this._containerTarget;
            this._expirationTimer = new Timer(true);
            this._expirationTimer.schedule((TimerTask)new ExpirationTask(this), periode, periode);
        }
        try {
            param = params.getProperty(PARAM_MONITOR);
            if (param != null) {
                this._monitor = Integer.parseInt(param);
            }
            if (this._monitor < 0) {
                this._monitor = 0;
            }
        }
        catch (NumberFormatException ex) {
            this._monitor = 0;
        }
        if (this._monitor > 0) {
            long periode = (long)this._monitor * 60000L;
            this._monitoringTimer = new Timer(true);
            this._monitoringTimer.schedule((TimerTask)new MonitoringTask(this), periode, periode);
        }
    }

    @Override
    public final void close() {
        if (this._monitoringTimer != null) {
            this._monitoringTimer.cancel();
            this._monitoringTimer = null;
        }
        this._monitor = 0;
        if (this._expirationTimer != null) {
            this._expirationTimer.cancel();
            this._expirationTimer = null;
        }
        this._ttl = 0;
        this.clear();
        this._containerCapacity = 0;
        this._cacheCapacity = 0;
        this._reaper = null;
        this._poolCount = 0;
        this._pool = null;
        this._containerTarget = 0;
        super.close();
    }

    public final int getCapacity() {
        return this._cacheCapacity;
    }

    public final int getTTL() {
        return this._ttl;
    }

    @Override
    public final int size() {
        try {
            this._lock.readLock().acquire();
            int size = this._cacheSize;
            this._lock.readLock().release();
            return size;
        }
        catch (InterruptedException ex) {
            return 0;
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        boolean found = false;
        try {
            this._lock.readLock().acquire();
        }
        catch (InterruptedException ex) {
            return false;
        }
        try {
            for (int i = 0; i < this._containerCount && !found; ++i) {
                if (!this._cache[i].containsKey(key)) continue;
                found = true;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this._lock.readLock().release();
        }
        return found;
    }

    @Override
    public final boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        boolean found = false;
        try {
            this._lock.readLock().acquire();
        }
        catch (InterruptedException ex) {
            return false;
        }
        try {
            for (int i = 0; i < this._containerCount && !found; ++i) {
                if (!this._cache[i].containsValue(value)) continue;
                found = true;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this._lock.readLock().release();
        }
        return found;
    }

    @Override
    public final void clear() {
        try {
            this._lock.writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return;
        }
        try {
            while (this._containerCount > 0) {
                this.expireCacheContainer();
            }
            this._cacheSize = 0;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this._lock.writeLock().release();
        }
    }

    @Override
    public final Set<Object> keySet() {
        HashSet<Object> set = new HashSet<Object>(this.size());
        try {
            this._lock.readLock().acquire();
        }
        catch (InterruptedException ex) {
            return set;
        }
        try {
            for (int i = 0; i < this._containerCount; ++i) {
                set.addAll(this._cache[i].keySet());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this._lock.readLock().release();
        }
        return set;
    }

    @Override
    public final Collection<Object> values() {
        ArrayList<Object> col = new ArrayList<Object>(this.size());
        try {
            this._lock.readLock().acquire();
        }
        catch (InterruptedException ex) {
            return col;
        }
        try {
            for (int i = 0; i < this._containerCount; ++i) {
                col.addAll(this._cache[i].values());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this._lock.readLock().release();
        }
        return col;
    }

    @Override
    public final Set<Map.Entry<Object, Object>> entrySet() {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>(this.size());
        try {
            this._lock.readLock().acquire();
        }
        catch (InterruptedException ex) {
            return map.entrySet();
        }
        try {
            for (int i = 0; i < this._containerCount; ++i) {
                map.putAll(this._cache[i]);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this._lock.readLock().release();
        }
        return map.entrySet();
    }

    protected final ReadWriteLock lock() {
        return this._lock;
    }

    protected final Object getObjectFromCache(Object key) {
        for (int i = 0; i < this._containerCount; ++i) {
            Object result = this._cache[i].get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected final Object putObjectIntoCache(Object key, Object value) {
        Object result;
        if (this._containerCount == 0 || this._cacheCapacity > 0 && this._cache[0].size() >= this._containerCapacity) {
            this.addCacheContainer();
        }
        if ((result = this._cache[0].put(key, value)) != null) {
            return result;
        }
        for (int i = 1; i < this._containerCount && result == null; ++i) {
            result = this._cache[i].remove(key);
        }
        if (result != null) {
            return null;
        }
        ++this._cacheSize;
        if (this._cacheCapacity > 0) {
            while (this._cacheCapacity < this._cacheSize) {
                this.expireCacheContainer();
            }
        }
        return result;
    }

    protected final Object removeObjectFromCache(Object key) {
        for (int i = 0; i < this._containerCount; ++i) {
            Object result = this._cache[i].remove(key);
            if (result == null) continue;
            --this._cacheSize;
            return result;
        }
        return null;
    }

    private void recalcCacheSize() {
        int size = 0;
        for (int i = 0; i < this._containerCount; ++i) {
            size += this._cache[i].size();
        }
        this._cacheSize = size;
    }

    private void addCacheContainer() {
        Container[] temp = new Container[++this._containerCount];
        System.arraycopy(this._cache, 0, temp, 1, this._cache.length);
        temp[0] = this._pool[--this._poolCount];
        temp[0].updateTimestamp();
        this._cache = temp;
    }

    private void expireCacheContainer() {
        Container expired = this._cache[--this._containerCount];
        Container[] temp = new Container[this._containerCount];
        System.arraycopy(this._cache, 0, temp, 0, this._containerCount);
        this._cache = temp;
        this._cacheSize -= expired.size();
        this._reaper.handleExpiredContainer(expired);
        expired.clear();
        this._pool[this._poolCount++] = expired;
    }

    private void timeoutCacheContainers() {
        long timeout = System.currentTimeMillis() - (long)this._ttl;
        while (this._containerCount > 0 && this._cache[this._containerCount - 1].getTimestamp() <= timeout) {
            this.expireCacheContainer();
        }
    }

    private static class MonitoringTask
    extends TimerTask {
        private AbstractHashbelt _owner;

        public MonitoringTask(AbstractHashbelt owner) {
            this._owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._owner._lock.readLock().acquire();
                LOG.info((Object)("Cache '" + this._owner.getName() + "' " + "currently holds " + this._owner._containerCount + " containers " + "with " + this._owner._cacheSize + " objects."));
            }
            catch (ThreadDeath t) {
                LOG.debug((Object)("Stopping monitoring thread: " + this._owner.getName()));
                throw t;
            }
            catch (Throwable t) {
                LOG.error((Object)("Caught exception during monitoring: " + this._owner.getName()), t);
                if (t instanceof VirtualMachineError) {
                    throw (VirtualMachineError)t;
                }
            }
            finally {
                this._owner._lock.readLock().release();
            }
        }
    }

    private static class ExpirationTask
    extends TimerTask {
        private AbstractHashbelt _owner;

        public ExpirationTask(AbstractHashbelt owner) {
            this._owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._owner._lock.writeLock().acquire();
                this._owner.timeoutCacheContainers();
                this._owner.addCacheContainer();
                this._owner.recalcCacheSize();
            }
            catch (ThreadDeath t) {
                LOG.debug((Object)("Stopping expiration thread: " + this._owner.getName()));
                throw t;
            }
            catch (Throwable t) {
                LOG.error((Object)("Caught exception during expiration: " + this._owner.getName()), t);
                if (t instanceof VirtualMachineError) {
                    throw (VirtualMachineError)t;
                }
            }
            finally {
                this._owner._lock.writeLock().release();
            }
        }
    }
}

