/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt;

import java.util.Iterator;
import java.util.Map;
import org.castor.cache.hashbelt.AbstractHashbelt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LRUHashbelt
extends AbstractHashbelt {
    public static final String TYPE = "lru";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Object result = null;
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return null;
        }
        try {
            result = this.removeObjectFromCache(key);
            if (result != null) {
                this.putObjectIntoCache(key, result);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
        return result;
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Object result = null;
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return null;
        }
        try {
            result = this.putObjectIntoCache(key, value);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Object result = null;
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return null;
        }
        try {
            result = this.removeObjectFromCache(key);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        if (map.containsKey(null)) {
            throw new NullPointerException("key");
        }
        if (map.containsValue(null)) {
            throw new NullPointerException("value");
        }
        Iterator<Map.Entry<? extends Object, ? extends Object>> iter = map.entrySet().iterator();
        try {
            this.lock().writeLock().acquire();
        }
        catch (InterruptedException ex) {
            return;
        }
        try {
            while (iter.hasNext()) {
                Map.Entry<? extends Object, ? extends Object> entry = iter.next();
                this.putObjectIntoCache(entry.getKey(), entry.getValue());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.lock().writeLock().release();
        }
    }
}

